/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2.framing;

import java.io.Serializable;
import java.nio.ByteOrder;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.ByteFlag$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$ContinuationFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$DataFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$GoAwayFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$HeadersFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$PingFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$PriorityFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$PushPromiseFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$RstStreamFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$Setting$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$SettingsFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$WindowUpdateFrame$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$Flags$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$CONTINUATION$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$DATA$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$GOAWAY$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$HEADERS$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$PING$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$PRIORITY$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$PUSH_PROMISE$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$RST_STREAM$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$SETTINGS$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$WINDOW_UPDATE$;
import org.apache.pekko.http.impl.engine.http2.framing.FrameRenderer;
import org.apache.pekko.http.impl.engine.http2.framing.FrameRenderer$Frame$;
import org.apache.pekko.util.ByteString;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class FrameRenderer$
implements Serializable {
    private static final ByteOrder byteOrder;
    private static final FrameRenderer$Frame$ Frame;
    public static final FrameRenderer$ MODULE$;

    private FrameRenderer$() {
    }

    static {
        MODULE$ = new FrameRenderer$();
        byteOrder = ByteOrder.BIG_ENDIAN;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FrameRenderer$.class);
    }

    public ByteOrder byteOrder() {
        return byteOrder;
    }

    public ByteString render(FrameEvent frame) {
        FrameEvent frameEvent = frame;
        if (frameEvent instanceof FrameEvent.GoAwayFrame) {
            FrameEvent.GoAwayFrame goAwayFrame = FrameEvent$GoAwayFrame$.MODULE$.unapply((FrameEvent.GoAwayFrame)frameEvent);
            int n = goAwayFrame._1();
            Http2Protocol.ErrorCode errorCode = goAwayFrame._2();
            ByteString byteString = goAwayFrame._3();
            int lastStreamId = n;
            Http2Protocol.ErrorCode errorCode2 = errorCode;
            ByteString debug = byteString;
            return FrameRenderer$Frame$.MODULE$.apply(8 + debug.length(), Http2Protocol$FrameType$GOAWAY$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), 0).putInt32(lastStreamId).putInt32(errorCode2.id()).put(debug).build();
        }
        if (frameEvent instanceof FrameEvent.DataFrame) {
            FrameEvent.DataFrame dataFrame = FrameEvent$DataFrame$.MODULE$.unapply((FrameEvent.DataFrame)frameEvent);
            int n = dataFrame._1();
            boolean bl = dataFrame._2();
            ByteString byteString = dataFrame._3();
            int streamId = n;
            boolean endStream = bl;
            ByteString payload = byteString;
            return FrameRenderer$Frame$.MODULE$.apply(payload.length(), Http2Protocol$FrameType$DATA$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), endStream), streamId).put(payload).build();
        }
        if (frameEvent instanceof FrameEvent.HeadersFrame) {
            FrameEvent.HeadersFrame headersFrame = FrameEvent$HeadersFrame$.MODULE$.unapply((FrameEvent.HeadersFrame)frameEvent);
            int n = headersFrame._1();
            boolean bl = headersFrame._2();
            boolean bl2 = headersFrame._3();
            ByteString byteString = headersFrame._4();
            Option<FrameEvent.PriorityFrame> option = headersFrame._5();
            int streamId = n;
            boolean endStream = bl;
            boolean endHeaders = bl2;
            ByteString headerBlockFragment = byteString;
            Option<FrameEvent.PriorityFrame> prioInfo = option;
            return FrameRenderer$Frame$.MODULE$.apply((prioInfo.isDefined() ? 5 : 0) + headerBlockFragment.length(), Http2Protocol$FrameType$HEADERS$.MODULE$, ByteFlag$.MODULE$.$bar$extension(ByteFlag$.MODULE$.$bar$extension(ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), endStream), ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders)), ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.PRIORITY(), prioInfo.isDefined())), streamId).putPriorityInfo(prioInfo).put(headerBlockFragment).build();
        }
        if (frameEvent instanceof FrameEvent.WindowUpdateFrame) {
            FrameEvent.WindowUpdateFrame windowUpdateFrame = FrameEvent$WindowUpdateFrame$.MODULE$.unapply((FrameEvent.WindowUpdateFrame)frameEvent);
            int n = windowUpdateFrame._1();
            int n2 = windowUpdateFrame._2();
            int streamId = n;
            int windowSizeIncrement = n2;
            return FrameRenderer$Frame$.MODULE$.apply(4, Http2Protocol$FrameType$WINDOW_UPDATE$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), streamId).putInt32(windowSizeIncrement).build();
        }
        if (frameEvent instanceof FrameEvent.ContinuationFrame) {
            FrameEvent.ContinuationFrame continuationFrame = FrameEvent$ContinuationFrame$.MODULE$.unapply((FrameEvent.ContinuationFrame)frameEvent);
            int n = continuationFrame._1();
            boolean bl = continuationFrame._2();
            ByteString byteString = continuationFrame._3();
            int streamId = n;
            boolean endHeaders = bl;
            ByteString payload = byteString;
            return FrameRenderer$Frame$.MODULE$.apply(payload.length(), Http2Protocol$FrameType$CONTINUATION$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders), streamId).put(payload).build();
        }
        if (frameEvent instanceof FrameEvent.SettingsFrame) {
            Seq<FrameEvent.Setting> seq;
            FrameEvent.SettingsFrame settingsFrame = FrameEvent$SettingsFrame$.MODULE$.unapply((FrameEvent.SettingsFrame)frameEvent);
            Seq<FrameEvent.Setting> settings = seq = settingsFrame._1();
            FrameRenderer.Frame b = FrameRenderer$Frame$.MODULE$.apply(settings.length() * 6, Http2Protocol$FrameType$SETTINGS$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), 0);
            this.renderNext$1(b, settings);
            return b.build();
        }
        if (frameEvent instanceof FrameEvent.SettingsAckFrame) {
            return FrameRenderer$Frame$.MODULE$.apply(0, Http2Protocol$FrameType$SETTINGS$.MODULE$, Http2Protocol$Flags$.MODULE$.ACK(), 0).build();
        }
        if (frameEvent instanceof FrameEvent.PingFrame) {
            FrameEvent.PingFrame pingFrame = FrameEvent$PingFrame$.MODULE$.unapply((FrameEvent.PingFrame)frameEvent);
            boolean bl = pingFrame._1();
            ByteString byteString = pingFrame._2();
            boolean ack = bl;
            ByteString data = byteString;
            return FrameRenderer$Frame$.MODULE$.apply(data.length(), Http2Protocol$FrameType$PING$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.ACK(), ack), 0).put(data).build();
        }
        if (frameEvent instanceof FrameEvent.RstStreamFrame) {
            FrameEvent.RstStreamFrame rstStreamFrame = FrameEvent$RstStreamFrame$.MODULE$.unapply((FrameEvent.RstStreamFrame)frameEvent);
            int n = rstStreamFrame._1();
            Http2Protocol.ErrorCode errorCode = rstStreamFrame._2();
            int streamId = n;
            Http2Protocol.ErrorCode errorCode3 = errorCode;
            return FrameRenderer$Frame$.MODULE$.apply(4, Http2Protocol$FrameType$RST_STREAM$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), streamId).putInt32(errorCode3.id()).build();
        }
        if (frameEvent instanceof FrameEvent.PushPromiseFrame) {
            FrameEvent.PushPromiseFrame pushPromiseFrame = FrameEvent$PushPromiseFrame$.MODULE$.unapply((FrameEvent.PushPromiseFrame)frameEvent);
            int n = pushPromiseFrame._1();
            boolean bl = pushPromiseFrame._2();
            int n3 = pushPromiseFrame._3();
            ByteString byteString = pushPromiseFrame._4();
            int streamId = n;
            boolean endHeaders = bl;
            int promisedStreamId = n3;
            ByteString headerBlockFragment = byteString;
            return FrameRenderer$Frame$.MODULE$.apply(4 + headerBlockFragment.length(), Http2Protocol$FrameType$PUSH_PROMISE$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders), streamId).putInt32(promisedStreamId).put(headerBlockFragment).build();
        }
        if (frameEvent instanceof FrameEvent.PriorityFrame) {
            FrameEvent.PriorityFrame priorityFrame = (FrameEvent.PriorityFrame)frameEvent;
            FrameEvent.PriorityFrame priorityFrame2 = FrameEvent$PriorityFrame$.MODULE$.unapply(priorityFrame);
            int n = priorityFrame2._1();
            boolean bl = priorityFrame2._2();
            int n4 = priorityFrame2._3();
            int n5 = priorityFrame2._4();
            int streamId = n;
            FrameEvent.PriorityFrame frame2 = priorityFrame;
            return FrameRenderer$Frame$.MODULE$.apply(5, Http2Protocol$FrameType$PRIORITY$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), streamId).putPriorityInfo(frame2).build();
        }
        throw new IllegalStateException(new StringBuilder(23).append("Unexpected frame type ").append(frame.frameTypeName()).append(".").toString());
    }

    public ByteString renderFrame(Http2Protocol.FrameType tpe, int flags, int streamId, ByteString payload) {
        return FrameRenderer$Frame$.MODULE$.apply(payload.length(), tpe, flags, streamId).put(payload).build();
    }

    private final void renderNext$1(FrameRenderer.Frame b$1, Seq remaining) {
        Tuple2 tuple2;
        FrameEvent.Setting setting;
        Option option;
        Seq seq;
        while ((seq = remaining) != null && !(option = package$.MODULE$.$plus$colon().unapply(seq)).isEmpty() && (setting = (FrameEvent.Setting)(tuple2 = option.get())._1()) != null) {
            FrameEvent.Setting setting2 = FrameEvent$Setting$.MODULE$.unapply(setting);
            Http2Protocol.SettingIdentifier settingIdentifier = setting2._1();
            int n = setting2._2();
            Http2Protocol.SettingIdentifier id = settingIdentifier;
            int value = n;
            Seq remaining2 = tuple2._2();
            b$1.putInt16(id.id());
            b$1.putInt32(value);
            remaining = remaining2;
        }
        Nil$ nil$ = package$.MODULE$.Nil();
        Seq seq2 = seq;
        if (!(nil$ != null ? !((Object)nil$).equals(seq2) : seq2 != null)) {
            return;
        }
        throw new MatchError(seq);
    }
}

