/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2.client;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.client.PersistentConnection;
import org.apache.pekko.http.impl.engine.http2.client.PersistentConnection$EmbargoEnded$;
import org.apache.pekko.http.impl.engine.http2.client.PersistentConnection$Stage$;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.AttributeKey$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.settings.Http2ClientSettings;
import org.apache.pekko.stream.StreamTcpException;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.util.PrettyDuration$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class PersistentConnection$
implements Serializable {
    public static final PersistentConnection$EmbargoEnded$ org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$$$EmbargoEnded;
    public static final AttributeKey<PersistentConnection.AssociationTag> org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$$$associationTagKey;
    private static final HttpResponse errorResponse;
    public static final PersistentConnection$ MODULE$;

    private PersistentConnection$() {
    }

    static {
        MODULE$ = new PersistentConnection$();
        org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$$$associationTagKey = AttributeKey$.MODULE$.apply("PersistentConnection.associationTagKey", ClassTag$.MODULE$.apply(PersistentConnection.AssociationTag.class));
        StatusCodes.ServerError serverError = StatusCodes$.MODULE$.BadGateway();
        HttpEntity.Strict strict = HttpEntity$.MODULE$.apply("The server closed the connection before delivering a response.");
        Seq<HttpHeader> seq = HttpResponse$.MODULE$.apply$default$2();
        HttpProtocol httpProtocol = HttpResponse$.MODULE$.apply$default$4();
        errorResponse = HttpResponse$.MODULE$.apply(serverError, seq, strict, httpProtocol);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PersistentConnection$.class);
    }

    public Flow<HttpRequest, HttpResponse, NotUsed> managedConnection(Flow<HttpRequest, HttpResponse, Future<Http.OutgoingConnection>> connectionFlow, Http2ClientSettings settings) {
        Option option;
        int n = settings.maxPersistentAttempts();
        if (0 == n) {
            option = None$.MODULE$;
        } else {
            int n2 = n;
            option = Some$.MODULE$.apply(BoxesRunTime.boxToInteger(n2));
        }
        return Flow$.MODULE$.fromGraph(new PersistentConnection.Stage(connectionFlow, option, settings.baseConnectionBackoff(), settings.maxConnectionBackoff()));
    }

    public static final /* synthetic */ int org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$Stage$$anon$1$$_$connect$$anonfun$1(int _$1) {
        return _$1 - 1;
    }

    private static final /* synthetic */ String $init$$$anonfun$3$$anonfun$1(int n) {
        return new StringBuilder(17).append(" (").append(n).append(" attempts left)").toString();
    }

    private static final String $init$$$anonfun$3$$anonfun$2() {
        return "";
    }

    private static final /* synthetic */ String $init$$$anonfun$3$$anonfun$3(int n) {
        return new StringBuilder(17).append(" (").append(n).append(" attempts left)").toString();
    }

    private static final String $init$$$anonfun$3$$anonfun$4() {
        return "";
    }

    public static final /* synthetic */ void org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$Stage$$anon$1$Connecting$$_$$lessinit$greater$$anonfun$3(GraphStageLogic.SubSinkInlet responseIn$2, GraphStageLogic.SubSourceOutlet requestOut$2, Option connectsLeft$1, PersistentConnection$Stage$.anon.1 $outer$2, FiniteDuration lastEmbargo$1, Throwable cause) {
        FiniteDuration finiteDuration;
        responseIn$2.cancel();
        requestOut$2.fail(new StreamTcpException("connection broken"));
        if (connectsLeft$1.contains(BoxesRunTime.boxToInteger(0))) {
            $outer$2.failStage(new RuntimeException(new StringBuilder(33).append("Connection failed after ").append($outer$2.org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$Stage$_$$anon$$$outer().org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$Stage$$maxAttempts).append(" attempts").toString(), cause));
            return;
        }
        $outer$2.protected$setHandler($outer$2.org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$Stage$_$$anon$$$outer().requestIn(), $outer$2.Unconnected());
        FiniteDuration finiteDuration2 = $outer$2.org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$Stage$_$$anon$$$outer().org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$Stage$$baseEmbargo;
        FiniteDuration finiteDuration3 = Duration$.MODULE$.Zero();
        if (!(finiteDuration2 != null ? !((Object)finiteDuration2).equals(finiteDuration3) : finiteDuration3 != null)) {
            $outer$2.log().info(new StringBuilder(53).append("Connection attempt failed: ").append(cause.getMessage()).append(". Trying to connect again").append(connectsLeft$1.map((Function1<Object, String> & Serializable)n -> PersistentConnection$.$init$$$anonfun$3$$anonfun$1(BoxesRunTime.unboxToInt(n))).getOrElse(PersistentConnection$::$init$$$anonfun$3$$anonfun$2)).append(".").toString());
            $outer$2.connect(connectsLeft$1, Duration$.MODULE$.Zero());
            return;
        }
        FiniteDuration finiteDuration4 = lastEmbargo$1;
        FiniteDuration finiteDuration5 = Duration$.MODULE$.Zero();
        FiniteDuration finiteDuration6 = finiteDuration4;
        if (!(finiteDuration5 != null ? !((Object)finiteDuration5).equals(finiteDuration6) : finiteDuration6 != null)) {
            finiteDuration = $outer$2.org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$Stage$_$$anon$$$outer().org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$Stage$$baseEmbargo;
        } else {
            FiniteDuration otherValue = finiteDuration4;
            finiteDuration = otherValue.$times(2L).min($outer$2.org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$Stage$_$$anon$$$outer().maxBaseEmbargo());
        }
        FiniteDuration embargo = finiteDuration;
        long minMillis = embargo.toMillis();
        long maxMillis = minMillis * 2L;
        FiniteDuration backoff = new package.DurationLong(package$.MODULE$.DurationLong(ThreadLocalRandom.current().nextLong(minMillis, maxMillis))).millis();
        $outer$2.log().info(new StringBuilder(69).append("Connection attempt failed: ").append(cause.getMessage()).append(". Trying to connect again after backoff ").append(PrettyDuration$.MODULE$.format(backoff)).append(" ").append(connectsLeft$1.map((Function1<Object, String> & Serializable)n -> PersistentConnection$.$init$$$anonfun$3$$anonfun$3(BoxesRunTime.unboxToInt(n))).getOrElse(PersistentConnection$::$init$$$anonfun$3$$anonfun$4)).append(".").toString());
        $outer$2.protected$scheduleOnce(PersistentConnection$EmbargoEnded$.MODULE$.apply(connectsLeft$1, embargo), backoff);
    }

    public static final /* synthetic */ HttpResponse org$apache$pekko$http$impl$engine$http2$client$PersistentConnection$Stage$$anon$1$Connected$$_$onDisconnected$$anonfun$1(Map _$3) {
        return errorResponse.withAttributes(_$3);
    }
}

