/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.http2.Http2$;
import org.apache.pekko.http.impl.engine.http2.MessageRendering;
import org.apache.pekko.http.impl.engine.rendering.DateHeaderRendering;
import org.apache.pekko.http.impl.util.JavaMapping;
import org.apache.pekko.http.impl.util.JavaMapping$;
import org.apache.pekko.http.javadsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.headers.Server;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.immutable.VectorBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.Nothing$;

@InternalApi
public class ResponseRendering
extends MessageRendering<HttpResponse> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ResponseRendering.class.getDeclaredField("peerIdHeader$lzy1"));
    private ServerSettings settings;
    private final LoggingAdapter log;
    private final DateHeaderRendering dateHeaderRendering;
    private volatile Object peerIdHeader$lzy1;

    public ResponseRendering(ServerSettings settings, LoggingAdapter log, DateHeaderRendering dateHeaderRendering) {
        this.settings = settings;
        this.log = log;
        this.dateHeaderRendering = dateHeaderRendering;
    }

    @Override
    public LoggingAdapter log() {
        return this.log;
    }

    @Override
    public DateHeaderRendering dateHeaderRendering() {
        return this.dateHeaderRendering;
    }

    private Nothing$ failBecauseOfMissingAttribute() {
        throw new RuntimeException("Received response for HTTP/2 request without x-http2-stream-id attribute. Failing connection.");
    }

    @Override
    public int nextStreamId(HttpResponse response) {
        return BoxesRunTime.unboxToInt(response.attribute((AttributeKey)Http2$.MODULE$.streamId(), (JavaMapping)JavaMapping$.MODULE$.attributeKey()).getOrElse(this::nextStreamId$$anonfun$1));
    }

    @Override
    public VectorBuilder<Tuple2<String, String>> initialHeaderPairs(HttpResponse response) {
        VectorBuilder<Tuple2<String, String>> headerPairs = new VectorBuilder<Tuple2<String, String>>();
        String string2 = Predef$.MODULE$.ArrowAssoc(":status");
        return (VectorBuilder)headerPairs.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToInteger(response.status().intValue()).toString()));
    }

    @Override
    public Option<Tuple2<String, String>> peerIdHeader() {
        Object object = this.peerIdHeader$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.peerIdHeader$lzyINIT1();
    }

    private Object peerIdHeader$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.peerIdHeader$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    Option option = null;
                    try {
                        option = this.settings.serverHeader().map((Function1<Server, Tuple2> & Serializable)h -> {
                            String string2 = Predef$.MODULE$.ArrowAssoc(h.lowercaseName());
                            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, h.value());
                        });
                        serializable = option == null ? LazyVals$NullValue$.MODULE$ : option;
                        this.settings = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.peerIdHeader$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final int nextStreamId$$anonfun$1() {
        throw this.failBecauseOfMissingAttribute();
    }
}

