/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import javax.net.ssl.SSLSession;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.Http2$;
import org.apache.pekko.http.impl.engine.http2.Http2Compliance;
import org.apache.pekko.http.impl.engine.http2.Http2SubStream;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$Authority$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$ContentLength$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$ContentType$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$Cookie$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$Method$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$OtherHeader$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$PathAndQuery$;
import org.apache.pekko.http.impl.engine.http2.hpack.Http2HeaderParsing$Scheme$;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser;
import org.apache.pekko.http.impl.engine.server.HttpAttributes;
import org.apache.pekko.http.scaladsl.model.AttributeKeys$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpProtocols$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.RemoteAddress;
import org.apache.pekko.http.scaladsl.model.RemoteAddress$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.SslSessionInfo$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.Uri$Authority$;
import org.apache.pekko.http.scaladsl.model.headers.Remote;
import org.apache.pekko.http.scaladsl.model.headers.Remote$minusAddress$;
import org.apache.pekko.http.scaladsl.model.headers.Tls;
import org.apache.pekko.http.scaladsl.model.headers.Tls$minusSession$minusInfo$;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;

@InternalApi
public final class RequestParsing$
implements Serializable {
    public static final RequestParsing$ MODULE$ = new RequestParsing$();

    private RequestParsing$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RequestParsing$.class);
    }

    public Function1<Http2SubStream, HttpRequest> parseRequest(HttpHeaderParser httpHeaderParser, ServerSettings serverSettings, Attributes streamAttributes) {
        Object object;
        Object object2;
        None$ remoteAddressHeader = serverSettings.remoteAddressHeader() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.RemoteAddress.class)).map((Function1<HttpAttributes.RemoteAddress, Remote.minusAddress> & Serializable)remote -> Remote$minusAddress$.MODULE$.apply(RemoteAddress$.MODULE$.apply(remote.address()))) : None$.MODULE$;
        None$ remoteAddressAttribute = serverSettings.remoteAddressAttribute() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.RemoteAddress.class)).map((Function1<HttpAttributes.RemoteAddress, RemoteAddress.IP> & Serializable)remote -> RemoteAddress$.MODULE$.apply(remote.address())) : None$.MODULE$;
        None$ tlsSessionInfoHeader = serverSettings.parserSettings().includeTlsSessionInfoHeader() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.TLSSessionInfo.class)).map((Function1<HttpAttributes.TLSSessionInfo, Tls.minusSession.minusInfo> & Serializable)sslSessionInfo -> Tls$minusSession$minusInfo$.MODULE$.apply(sslSessionInfo.session())) : None$.MODULE$;
        None$ sslSessionAttribute = serverSettings.parserSettings().includeSslSessionAttribute() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.TLSSessionInfo.class)).map((Function1<HttpAttributes.TLSSessionInfo, SSLSession> & Serializable)_$1 -> _$1.session()) : None$.MODULE$;
        Object map = Predef$.MODULE$.Map().empty();
        None$ none$ = sslSessionAttribute;
        if (none$ instanceof Some) {
            SSLSession sslSession = (SSLSession)((Some)((Object)none$)).value();
            object2 = (Map)map.updated(AttributeKeys$.MODULE$.sslSession(), SslSessionInfo$.MODULE$.apply(sslSession));
        } else if (None$.MODULE$.equals(none$)) {
            object2 = map;
        } else {
            throw new MatchError(none$);
        }
        map = object2;
        None$ none$2 = remoteAddressAttribute;
        if (none$2 instanceof Some) {
            RemoteAddress remoteAddress = (RemoteAddress)((Some)((Object)none$2)).value();
            object = (Map)map.updated(AttributeKeys$.MODULE$.remoteAddress(), remoteAddress);
        } else if (None$.MODULE$.equals(none$2)) {
            object = map;
        } else {
            throw new MatchError(none$2);
        }
        Object baseAttributes = map = object;
        return arg_0 -> this.parseRequest$$anonfun$1(httpHeaderParser, remoteAddressHeader, tlsSessionInfoHeader, (Map)baseAttributes, serverSettings, arg_0);
    }

    public HttpHeader parseHeaderPair(HttpHeaderParser httpHeaderParser, String name, String value) {
        String concHeaderLine = new java.lang.StringBuilder(5).append(name).append(": ").append(value).append("\r\nx").toString();
        ByteString byteString = ByteString$.MODULE$.apply(concHeaderLine);
        int n = httpHeaderParser.parseHeaderLine$default$2();
        httpHeaderParser.parseHeaderLine(byteString, n, httpHeaderParser.parseHeaderLine$default$3(byteString, n), httpHeaderParser.parseHeaderLine$default$4(byteString, n));
        return httpHeaderParser.resultHeader();
    }

    public void checkRequiredPseudoHeader(String name, Object value) {
        if (value == null) {
            throw this.malformedRequest(new java.lang.StringBuilder(34).append("Mandatory pseudo-header '").append(name).append("' missing").toString());
        }
    }

    public void checkUniquePseudoHeader(String name, Object value) {
        if (value != null) {
            throw this.malformedRequest(new java.lang.StringBuilder(46).append("Pseudo-header '").append(name).append("' must not occur more than once").toString());
        }
    }

    public void checkNoRegularHeadersBeforePseudoHeader(String name, boolean seenRegularHeader) {
        if (seenRegularHeader) {
            throw this.malformedRequest(new java.lang.StringBuilder(61).append("Pseudo-header field '").append(name).append("' must not appear after a regular header").toString());
        }
    }

    public Nothing$ malformedRequest(String msg) {
        throw new Http2Compliance.Http2ProtocolException(new java.lang.StringBuilder(19).append("Malformed request: ").append(msg).toString());
    }

    public void validateHeader(HttpHeader httpHeader) {
        String string2 = httpHeader.lowercaseName();
        switch (string2 == null ? 0 : string2.hashCode()) {
            case -775651618: {
                if (!"connection".equals(string2)) break;
                throw this.malformedRequest("Header 'Connection' must not be used with HTTP/2");
            }
            case 3697: {
                if (!"te".equals(string2)) break;
                if (httpHeader.value().compareToIgnoreCase("trailers") != 0) {
                    throw this.malformedRequest(new java.lang.StringBuilder(69).append("Header 'TE' must not contain value other than 'trailers', value was '").append(httpHeader.value()).toString());
                }
                return;
            }
            case 1274458357: {
                if (!"transfer-encoding".equals(string2)) break;
                throw this.malformedRequest("Header 'Transfer-Encoding' must not be used with HTTP/2");
            }
        }
    }

    private final HttpRequest createRequest$1(HttpHeaderParser httpHeaderParser$2, Option remoteAddressHeader$2, Option tlsSessionInfoHeader$2, Http2SubStream subStream$1, Map baseAttributes$2, HttpMethod method, String scheme, Uri.Authority authority, Tuple2 pathAndRawQuery, ContentType contentType, long contentLength, StringBuilder cookies, VectorBuilder headers) {
        this.checkRequiredPseudoHeader(":scheme", scheme);
        this.checkRequiredPseudoHeader(":method", method);
        this.checkRequiredPseudoHeader(":path", pathAndRawQuery);
        if (cookies != null) {
            headers.$plus$eq(this.parseHeaderPair(httpHeaderParser$2, "cookie", cookies.toString()));
        }
        if (remoteAddressHeader$2.isDefined()) {
            headers.$plus$eq(remoteAddressHeader$2.get());
        }
        if (tlsSessionInfoHeader$2.isDefined()) {
            headers.$plus$eq(tlsSessionInfoHeader$2.get());
        }
        RequestEntity entity = subStream$1.createEntity(contentLength, contentType);
        Tuple2 tuple2 = pathAndRawQuery;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Uri.Path path = (Uri.Path)tuple2._1();
        Option rawQueryString = (Option)tuple2._2();
        Tuple2<Uri.Path, Option> tuple22 = Tuple2$.MODULE$.apply(path, rawQueryString);
        Uri.Path path2 = tuple22._1();
        Option rawQueryString2 = tuple22._2();
        Uri.Authority authorityOrDefault = authority == null ? Uri$Authority$.MODULE$.Empty() : authority;
        Uri uri = Uri$.MODULE$.apply(scheme, authorityOrDefault, path2, rawQueryString2, Uri$.MODULE$.apply$default$5());
        Map attributes = (Map)baseAttributes$2.updated(Http2$.MODULE$.streamId(), BoxesRunTime.boxToInteger(subStream$1.streamId()));
        return new HttpRequest(method, uri, (Seq<HttpHeader>)headers.result(), attributes, entity, HttpProtocols$.MODULE$.HTTP$div2$u002E0());
    }

    private final HttpRequest rec$1(HttpHeaderParser httpHeaderParser$3, Option remoteAddressHeader$3, Option tlsSessionInfoHeader$3, Http2SubStream subStream$2, Map baseAttributes$3, IndexedSeq incomingHeaders, int offset, HttpMethod method, String scheme, Uri.Authority authority, Tuple2 pathAndRawQuery, ContentType contentType, long contentLength, StringBuilder cookies, boolean seenRegularHeader, VectorBuilder headers) {
        block10: while (offset != incomingHeaders.size()) {
            Tuple2 tuple2 = (Tuple2)incomingHeaders.apply(offset);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(name, value);
            String name2 = tuple22._1();
            Object value2 = tuple22._2();
            String string2 = name2;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -1354757532: {
                    if (!"cookie".equals(string2)) break;
                    StringBuilder cookiesBuilder = cookies == null ? new StringBuilder() : cookies.append("; ");
                    cookiesBuilder.append((String)Http2HeaderParsing$Cookie$.MODULE$.get(value2));
                    int n = offset + 1;
                    StringBuilder stringBuilder = cookiesBuilder;
                    boolean bl = true;
                    offset = n;
                    cookies = stringBuilder;
                    seenRegularHeader = bl;
                    continue block10;
                }
                case -1332238263: {
                    if (!":authority".equals(string2)) break;
                    this.checkUniquePseudoHeader(":authority", authority);
                    this.checkNoRegularHeadersBeforePseudoHeader(":authority", seenRegularHeader);
                    int n = offset + 1;
                    Uri.Authority authority2 = (Uri.Authority)Http2HeaderParsing$Authority$.MODULE$.get(value2);
                    offset = n;
                    authority = authority2;
                    continue block10;
                }
                case -1141949029: {
                    if (!":method".equals(string2)) break;
                    this.checkUniquePseudoHeader(":method", method);
                    this.checkNoRegularHeadersBeforePseudoHeader(":method", seenRegularHeader);
                    int n = offset + 1;
                    HttpMethod httpMethod = (HttpMethod)Http2HeaderParsing$Method$.MODULE$.get(value2);
                    offset = n;
                    method = httpMethod;
                    continue block10;
                }
                case -1132779846: {
                    if (!"content-length".equals(string2)) break;
                    if (contentLength == -1L) {
                        long contentLengthValue = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)Http2HeaderParsing$ContentLength$.MODULE$.get(value2)));
                        if (contentLengthValue < 0L) {
                            throw this.malformedRequest("HTTP message must not contain a negative content-length header");
                        }
                        int n = offset + 1;
                        long l = contentLengthValue;
                        boolean bl = true;
                        offset = n;
                        contentLength = l;
                        seenRegularHeader = bl;
                        continue block10;
                    }
                    throw this.malformedRequest("HTTP message must not contain more than one content-length header");
                }
                case -972381601: {
                    if (!":scheme".equals(string2)) break;
                    this.checkUniquePseudoHeader(":scheme", scheme);
                    this.checkNoRegularHeadersBeforePseudoHeader(":scheme", seenRegularHeader);
                    int n = offset + 1;
                    String string3 = (String)Http2HeaderParsing$Scheme$.MODULE$.get(value2);
                    offset = n;
                    scheme = string3;
                    continue block10;
                }
                case -956875604: {
                    if (!":status".equals(string2)) break;
                    throw this.malformedRequest("Pseudo-header ':status' is for responses only; it cannot appear in a request");
                }
                case 56997727: {
                    if (!":path".equals(string2)) break;
                    this.checkUniquePseudoHeader(":path", pathAndRawQuery);
                    this.checkNoRegularHeadersBeforePseudoHeader(":path", seenRegularHeader);
                    int n = offset + 1;
                    Tuple2 tuple23 = (Tuple2)Http2HeaderParsing$PathAndQuery$.MODULE$.get(value2);
                    offset = n;
                    pathAndRawQuery = tuple23;
                    continue block10;
                }
                case 785670158: {
                    if (!"content-type".equals(string2)) break;
                    if (OptionVal$.MODULE$.isEmpty$extension(contentType)) {
                        int n = offset + 1;
                        ContentType contentType2 = (ContentType)OptionVal$Some$.MODULE$.apply(Http2HeaderParsing$ContentType$.MODULE$.get(value2));
                        boolean bl = true;
                        offset = n;
                        contentType = contentType2;
                        seenRegularHeader = bl;
                        continue block10;
                    }
                    throw this.malformedRequest("HTTP message must not contain more than one content-type header");
                }
            }
            int n = offset + 1;
            boolean bl = true;
            VectorBuilder vectorBuilder = (VectorBuilder)headers.$plus$eq(Http2HeaderParsing$OtherHeader$.MODULE$.get(value2));
            offset = n;
            seenRegularHeader = bl;
            headers = vectorBuilder;
        }
        return this.createRequest$1(httpHeaderParser$3, remoteAddressHeader$3, tlsSessionInfoHeader$3, subStream$2, baseAttributes$3, method, scheme, authority, pathAndRawQuery, contentType, contentLength, cookies, headers);
    }

    private final HttpMethod rec$default$3$1() {
        return null;
    }

    private final String rec$default$4$1() {
        return null;
    }

    private final Uri.Authority rec$default$5$1() {
        return null;
    }

    private final Tuple2 rec$default$6$1() {
        return null;
    }

    private final ContentType rec$default$7$1() {
        OptionVal$.MODULE$.None();
        return null;
    }

    private final long rec$default$8$1() {
        return -1L;
    }

    private final StringBuilder rec$default$9$1() {
        return null;
    }

    private final boolean rec$default$10$1() {
        return false;
    }

    private final VectorBuilder rec$default$11$1() {
        return new VectorBuilder();
    }

    private final /* synthetic */ HttpRequest parseRequest$$anonfun$1(HttpHeaderParser httpHeaderParser$1, Option remoteAddressHeader$1, Option tlsSessionInfoHeader$1, Map baseAttributes$1, ServerSettings serverSettings$1, Http2SubStream subStream) {
        IndexedSeq incomingHeaders = subStream.initialHeaders().keyValuePairs().toIndexedSeq();
        if (incomingHeaders.size() > serverSettings$1.parserSettings().maxHeaderCount()) {
            throw this.malformedRequest(new java.lang.StringBuilder(64).append("HTTP message contains more than the configured limit of ").append(serverSettings$1.parserSettings().maxHeaderCount()).append(" headers").toString());
        }
        return this.rec$1(httpHeaderParser$1, remoteAddressHeader$1, tlsSessionInfoHeader$1, subStream, baseAttributes$1, incomingHeaders, 0, this.rec$default$3$1(), this.rec$default$4$1(), this.rec$default$5$1(), this.rec$default$6$1(), this.rec$default$7$1(), this.rec$default$8$1(), this.rec$default$9$1(), this.rec$default$10$1(), this.rec$default$11$1());
    }
}

