/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.http2.Http2$;
import org.apache.pekko.http.impl.engine.http2.OutgoingConnectionBuilderImpl$;
import org.apache.pekko.http.impl.engine.http2.OutgoingConnectionBuilderImpl$Impl$;
import org.apache.pekko.http.impl.engine.http2.client.PersistentConnection$;
import org.apache.pekko.http.javadsl.OutgoingConnection;
import org.apache.pekko.http.javadsl.OutgoingConnectionBuilder;
import org.apache.pekko.http.javadsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.ConnectionContext$;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.FutureConverters$FutureOps$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public final class OutgoingConnectionBuilderImpl {
    public static org.apache.pekko.http.scaladsl.OutgoingConnectionBuilder apply(String string2, ClassicActorSystemProvider classicActorSystemProvider) {
        return OutgoingConnectionBuilderImpl$.MODULE$.apply(string2, classicActorSystemProvider);
    }

    public static final class Impl
    implements org.apache.pekko.http.scaladsl.OutgoingConnectionBuilder,
    Product,
    Serializable {
        private final String host;
        private final Option port;
        private final ClientConnectionSettings clientConnectionSettings;
        private final Option connectionContext;
        private final LoggingAdapter log;
        private final ClassicActorSystemProvider system;
        private final boolean usingHttp2;

        public static Impl apply(String string2, Option<Object> option, ClientConnectionSettings clientConnectionSettings, Option<HttpsConnectionContext> option2, LoggingAdapter loggingAdapter, ClassicActorSystemProvider classicActorSystemProvider, boolean bl) {
            return OutgoingConnectionBuilderImpl$Impl$.MODULE$.apply(string2, option, clientConnectionSettings, option2, loggingAdapter, classicActorSystemProvider, bl);
        }

        public static Impl fromProduct(Product product) {
            return OutgoingConnectionBuilderImpl$Impl$.MODULE$.fromProduct(product);
        }

        public static Impl unapply(Impl impl) {
            return OutgoingConnectionBuilderImpl$Impl$.MODULE$.unapply(impl);
        }

        public Impl(String host, Option<Object> port, ClientConnectionSettings clientConnectionSettings, Option<HttpsConnectionContext> connectionContext, LoggingAdapter log, ClassicActorSystemProvider system, boolean usingHttp2) {
            this.host = host;
            this.port = port;
            this.clientConnectionSettings = clientConnectionSettings;
            this.connectionContext = connectionContext;
            this.log = log;
            this.system = system;
            this.usingHttp2 = usingHttp2;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.host()));
            n = Statics.mix(n, Statics.anyHash(this.port()));
            n = Statics.mix(n, Statics.anyHash(this.clientConnectionSettings()));
            n = Statics.mix(n, Statics.anyHash(this.connectionContext()));
            n = Statics.mix(n, Statics.anyHash(this.log()));
            n = Statics.mix(n, Statics.anyHash(this.system()));
            n = Statics.mix(n, this.usingHttp2() ? 1231 : 1237);
            return Statics.finalizeHash(n, 7);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Impl)) return false;
            Impl impl = (Impl)object;
            if (this.usingHttp2() != impl.usingHttp2()) return false;
            String string2 = this.host();
            String string3 = impl.host();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            Option<Object> option = this.port();
            Option<Object> option2 = impl.port();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            ClientConnectionSettings clientConnectionSettings = this.clientConnectionSettings();
            ClientConnectionSettings clientConnectionSettings2 = impl.clientConnectionSettings();
            if (clientConnectionSettings == null) {
                if (clientConnectionSettings2 != null) {
                    return false;
                }
            } else if (!clientConnectionSettings.equals(clientConnectionSettings2)) return false;
            Option<HttpsConnectionContext> option3 = this.connectionContext();
            Option<HttpsConnectionContext> option4 = impl.connectionContext();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            LoggingAdapter loggingAdapter = this.log();
            LoggingAdapter loggingAdapter2 = impl.log();
            if (loggingAdapter == null) {
                if (loggingAdapter2 != null) {
                    return false;
                }
            } else if (!loggingAdapter.equals(loggingAdapter2)) return false;
            ClassicActorSystemProvider classicActorSystemProvider = this.system();
            ClassicActorSystemProvider classicActorSystemProvider2 = impl.system();
            if (classicActorSystemProvider == null) {
                if (classicActorSystemProvider2 == null) return true;
                return false;
            } else {
                if (!classicActorSystemProvider.equals(classicActorSystemProvider2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Impl;
        }

        @Override
        public int productArity() {
            return 7;
        }

        @Override
        public String productPrefix() {
            return "Impl";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return BoxesRunTime.boxToBoolean(this._7());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "host";
                }
                case 1: {
                    return "port";
                }
                case 2: {
                    return "clientConnectionSettings";
                }
                case 3: {
                    return "connectionContext";
                }
                case 4: {
                    return "log";
                }
                case 5: {
                    return "system";
                }
                case 6: {
                    return "usingHttp2";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String host() {
            return this.host;
        }

        public Option<Object> port() {
            return this.port;
        }

        public ClientConnectionSettings clientConnectionSettings() {
            return this.clientConnectionSettings;
        }

        public Option<HttpsConnectionContext> connectionContext() {
            return this.connectionContext;
        }

        public LoggingAdapter log() {
            return this.log;
        }

        public ClassicActorSystemProvider system() {
            return this.system;
        }

        public boolean usingHttp2() {
            return this.usingHttp2;
        }

        @Override
        public org.apache.pekko.http.scaladsl.OutgoingConnectionBuilder toHost(String host) {
            return this.copy(host, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public org.apache.pekko.http.scaladsl.OutgoingConnectionBuilder toPort(int port) {
            Some<Object> some = Some$.MODULE$.apply(BoxesRunTime.boxToInteger(port));
            String string2 = this.copy$default$1();
            ClientConnectionSettings clientConnectionSettings = this.copy$default$3();
            Option<HttpsConnectionContext> option = this.copy$default$4();
            LoggingAdapter loggingAdapter = this.copy$default$5();
            ClassicActorSystemProvider classicActorSystemProvider = this.copy$default$6();
            boolean bl = this.copy$default$7();
            return this.copy(string2, some, clientConnectionSettings, option, loggingAdapter, classicActorSystemProvider, bl);
        }

        @Override
        public org.apache.pekko.http.scaladsl.OutgoingConnectionBuilder withCustomHttpsConnectionContext(HttpsConnectionContext httpsConnectionContext) {
            Some<HttpsConnectionContext> some = Some$.MODULE$.apply(httpsConnectionContext);
            String string2 = this.copy$default$1();
            Option<Object> option = this.copy$default$2();
            ClientConnectionSettings clientConnectionSettings = this.copy$default$3();
            LoggingAdapter loggingAdapter = this.copy$default$5();
            ClassicActorSystemProvider classicActorSystemProvider = this.copy$default$6();
            boolean bl = this.copy$default$7();
            return this.copy(string2, option, clientConnectionSettings, some, loggingAdapter, classicActorSystemProvider, bl);
        }

        @Override
        public org.apache.pekko.http.scaladsl.OutgoingConnectionBuilder withClientConnectionSettings(ClientConnectionSettings settings) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), settings, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public org.apache.pekko.http.scaladsl.OutgoingConnectionBuilder logTo(LoggingAdapter logger) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), logger, this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public Flow<HttpRequest, org.apache.pekko.http.scaladsl.model.HttpResponse, Future<Http.OutgoingConnection>> http() {
            return Http$.MODULE$.apply(this.system().classicSystem()).outgoingConnectionUsingContext(this.host(), BoxesRunTime.unboxToInt(this.port().getOrElse(this::http$$anonfun$1)), ConnectionContext$.MODULE$.noEncryption(), this.clientConnectionSettings(), this.log());
        }

        @Override
        public Flow<HttpRequest, org.apache.pekko.http.scaladsl.model.HttpResponse, Future<Http.OutgoingConnection>> https() {
            return Http$.MODULE$.apply(this.system().classicSystem()).outgoingConnectionHttps(this.host(), BoxesRunTime.unboxToInt(this.port().getOrElse(this::https$$anonfun$1)), (HttpsConnectionContext)this.connectionContext().getOrElse(this::https$$anonfun$2), None$.MODULE$, this.clientConnectionSettings(), this.log());
        }

        @Override
        public Flow<HttpRequest, org.apache.pekko.http.scaladsl.model.HttpResponse, Future<Http.OutgoingConnection>> http2() {
            int port = BoxesRunTime.unboxToInt(this.port().getOrElse(this::$anonfun$1));
            return Http2$.MODULE$.apply(this.system().classicSystem()).outgoingConnection(this.host(), port, (HttpsConnectionContext)this.connectionContext().getOrElse(this::http2$$anonfun$1), this.clientConnectionSettings(), this.log());
        }

        @Override
        public Flow<HttpRequest, org.apache.pekko.http.scaladsl.model.HttpResponse, NotUsed> managedPersistentHttp2() {
            return PersistentConnection$.MODULE$.managedConnection(this.http2(), this.clientConnectionSettings().http2Settings());
        }

        @Override
        public Flow<HttpRequest, org.apache.pekko.http.scaladsl.model.HttpResponse, Future<Http.OutgoingConnection>> http2WithPriorKnowledge() {
            return Http2$.MODULE$.apply(this.system().classicSystem()).outgoingConnectionPriorKnowledge(this.host(), BoxesRunTime.unboxToInt(this.port().getOrElse(this::http2WithPriorKnowledge$$anonfun$1)), this.clientConnectionSettings(), this.log());
        }

        @Override
        public Flow<HttpRequest, org.apache.pekko.http.scaladsl.model.HttpResponse, NotUsed> managedPersistentHttp2WithPriorKnowledge() {
            return PersistentConnection$.MODULE$.managedConnection(this.http2WithPriorKnowledge(), this.clientConnectionSettings().http2Settings());
        }

        @Override
        public OutgoingConnectionBuilder toJava() {
            return new JavaAdapter(this);
        }

        public Impl copy(String host, Option<Object> port, ClientConnectionSettings clientConnectionSettings, Option<HttpsConnectionContext> connectionContext, LoggingAdapter log, ClassicActorSystemProvider system, boolean usingHttp2) {
            return new Impl(host, port, clientConnectionSettings, connectionContext, log, system, usingHttp2);
        }

        public String copy$default$1() {
            return this.host();
        }

        public Option<Object> copy$default$2() {
            return this.port();
        }

        public ClientConnectionSettings copy$default$3() {
            return this.clientConnectionSettings();
        }

        public Option<HttpsConnectionContext> copy$default$4() {
            return this.connectionContext();
        }

        public LoggingAdapter copy$default$5() {
            return this.log();
        }

        public ClassicActorSystemProvider copy$default$6() {
            return this.system();
        }

        public boolean copy$default$7() {
            return this.usingHttp2();
        }

        public String _1() {
            return this.host();
        }

        public Option<Object> _2() {
            return this.port();
        }

        public ClientConnectionSettings _3() {
            return this.clientConnectionSettings();
        }

        public Option<HttpsConnectionContext> _4() {
            return this.connectionContext();
        }

        public LoggingAdapter _5() {
            return this.log();
        }

        public ClassicActorSystemProvider _6() {
            return this.system();
        }

        public boolean _7() {
            return this.usingHttp2();
        }

        private final int http$$anonfun$1() {
            return 80;
        }

        private final int https$$anonfun$1() {
            return 443;
        }

        private final HttpsConnectionContext https$$anonfun$2() {
            return Http$.MODULE$.apply(this.system().classicSystem()).defaultClientHttpsContext();
        }

        private final int $anonfun$1() {
            return 443;
        }

        private final HttpsConnectionContext http2$$anonfun$1() {
            return Http$.MODULE$.apply(this.system().classicSystem()).defaultClientHttpsContext();
        }

        private final int http2WithPriorKnowledge$$anonfun$1() {
            return 80;
        }
    }

    public static class JavaAdapter
    implements OutgoingConnectionBuilder {
        private final Impl actual;

        public JavaAdapter(Impl actual) {
            this.actual = actual;
        }

        @Override
        public OutgoingConnectionBuilder toHost(String host) {
            return new JavaAdapter((Impl)this.actual.toHost(host));
        }

        @Override
        public OutgoingConnectionBuilder toPort(int port) {
            return new JavaAdapter((Impl)this.actual.toPort(port));
        }

        @Override
        public org.apache.pekko.stream.javadsl.Flow<org.apache.pekko.http.javadsl.model.HttpRequest, HttpResponse, CompletionStage<OutgoingConnection>> http() {
            return this.javaFlow(this.actual.http());
        }

        @Override
        public org.apache.pekko.stream.javadsl.Flow<org.apache.pekko.http.javadsl.model.HttpRequest, HttpResponse, CompletionStage<OutgoingConnection>> https() {
            return this.javaFlow(this.actual.https());
        }

        @Override
        public org.apache.pekko.stream.javadsl.Flow<org.apache.pekko.http.javadsl.model.HttpRequest, HttpResponse, NotUsed> managedPersistentHttp2() {
            return this.javaFlowKeepMatVal(this.actual.managedPersistentHttp2());
        }

        @Override
        public org.apache.pekko.stream.javadsl.Flow<org.apache.pekko.http.javadsl.model.HttpRequest, HttpResponse, CompletionStage<OutgoingConnection>> http2WithPriorKnowledge() {
            return this.javaFlow(this.actual.http2WithPriorKnowledge());
        }

        @Override
        public org.apache.pekko.stream.javadsl.Flow<org.apache.pekko.http.javadsl.model.HttpRequest, HttpResponse, NotUsed> managedPersistentHttp2WithPriorKnowledge() {
            return this.javaFlowKeepMatVal(this.actual.managedPersistentHttp2WithPriorKnowledge());
        }

        @Override
        public org.apache.pekko.stream.javadsl.Flow<org.apache.pekko.http.javadsl.model.HttpRequest, HttpResponse, CompletionStage<OutgoingConnection>> http2() {
            return this.javaFlow(this.actual.http2());
        }

        @Override
        public OutgoingConnectionBuilder withCustomHttpsConnectionContext(org.apache.pekko.http.javadsl.HttpsConnectionContext httpsConnectionContext) {
            return new JavaAdapter((Impl)this.actual.withCustomHttpsConnectionContext((HttpsConnectionContext)httpsConnectionContext));
        }

        @Override
        public OutgoingConnectionBuilder withClientConnectionSettings(org.apache.pekko.http.javadsl.settings.ClientConnectionSettings settings) {
            return new JavaAdapter((Impl)this.actual.withClientConnectionSettings((ClientConnectionSettings)settings));
        }

        @Override
        public OutgoingConnectionBuilder logTo(LoggingAdapter logger) {
            return new JavaAdapter((Impl)this.actual.logTo(logger));
        }

        private org.apache.pekko.stream.javadsl.Flow<org.apache.pekko.http.javadsl.model.HttpRequest, HttpResponse, CompletionStage<OutgoingConnection>> javaFlow(Flow<HttpRequest, org.apache.pekko.http.scaladsl.model.HttpResponse, Future<Http.OutgoingConnection>> flow) {
            return this.javaFlowKeepMatVal((Flow)flow.mapMaterializedValue((Function1<Future, CompletionStage> & Serializable)f -> {
                Future future = FutureConverters$.MODULE$.FutureOps(f.map((Function1<Http.OutgoingConnection, OutgoingConnection> & Serializable)oc -> new OutgoingConnection((Http.OutgoingConnection)oc), ExecutionContexts$.MODULE$.parasitic()));
                return FutureConverters$FutureOps$.MODULE$.asJava$extension(future);
            }));
        }

        private <M> org.apache.pekko.stream.javadsl.Flow<org.apache.pekko.http.javadsl.model.HttpRequest, HttpResponse, M> javaFlowKeepMatVal(Flow<HttpRequest, org.apache.pekko.http.scaladsl.model.HttpResponse, M> flow) {
            return flow.asJava();
        }
    }
}

