/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.rendering.DateHeaderRendering;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.headers.Connection;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.CustomHeader;
import org.apache.pekko.http.scaladsl.model.headers.Date;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.Server;
import org.apache.pekko.http.scaladsl.model.headers.Transfer$minusEncoding;
import org.apache.pekko.http.scaladsl.model.headers.User$minusAgent;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class HttpMessageRendering$
implements Serializable {
    public static final HttpMessageRendering$ MODULE$ = new HttpMessageRendering$();

    private HttpMessageRendering$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpMessageRendering$.class);
    }

    public void addContentHeaders(VectorBuilder<Tuple2<String, String>> headerPairs, HttpEntity entity) {
        if (entity.contentType() != ContentTypes$.MODULE$.NoContentType()) {
            String string2 = Predef$.MODULE$.ArrowAssoc("content-type");
            headerPairs.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, entity.contentType().toString()));
        }
        entity.contentLengthOption().foreach((Function1<Object, VectorBuilder> & Serializable)_$2 -> this.addContentHeaders$$anonfun$1(headerPairs, BoxesRunTime.unboxToLong(_$2)));
    }

    public Seq<Tuple2<String, String>> renderHeaders(Seq<HttpHeader> headers, LoggingAdapter log, boolean isServer, boolean shouldRenderAutoHeaders, DateHeaderRendering dateHeaderRendering) {
        VectorBuilder<Tuple2<String, String>> headerPairs = new VectorBuilder<Tuple2<String, String>>();
        this.renderHeaders(headers, headerPairs, None$.MODULE$, log, isServer, shouldRenderAutoHeaders, dateHeaderRendering);
        return headerPairs.result();
    }

    public void renderHeaders(Seq<HttpHeader> headersSeq, VectorBuilder<Tuple2<String, String>> headerPairs, Option<Tuple2<String, String>> peerIdHeader, LoggingAdapter log, boolean isServer, boolean shouldRenderAutoHeaders, DateHeaderRendering dateHeaderRendering) {
        Iterator it = headersSeq.iterator();
        boolean peerIdSeen = false;
        boolean dateSeen = false;
        while (it.hasNext()) {
            RawHeader x;
            HttpHeader header = (HttpHeader)it.next();
            if ((!header.renderInResponses() || !isServer) && (!header.renderInRequests() || isServer)) continue;
            HttpHeader httpHeader = header;
            if (httpHeader instanceof Server) {
                Server x2 = (Server)httpHeader;
                if (isServer) {
                    this.addHeader$1(headerPairs, x2);
                    peerIdSeen = true;
                    continue;
                }
            }
            if (httpHeader instanceof User$minusAgent) {
                User$minusAgent x3 = (User$minusAgent)httpHeader;
                if (!isServer) {
                    this.addHeader$1(headerPairs, x3);
                    peerIdSeen = true;
                    continue;
                }
            }
            if (httpHeader instanceof Date) {
                Date x4 = (Date)httpHeader;
                if (isServer) {
                    this.addHeader$1(headerPairs, x4);
                    dateSeen = true;
                    continue;
                }
            }
            if (httpHeader instanceof CustomHeader) {
                CustomHeader x5 = (CustomHeader)httpHeader;
                this.addHeader$1(headerPairs, x5);
                continue;
            }
            if (httpHeader instanceof RawHeader && ((x = (RawHeader)httpHeader).is("content-type") || x.is("content-length") || x.is("transfer-encoding") || x.is("date") || x.is("server") || x.is("user-agent") || x.is("connection"))) {
                this.suppressionWarning$1(log, x, "illegal RawHeader");
                continue;
            }
            if (httpHeader instanceof Content$minusLength) {
                Content$minusLength x6 = (Content$minusLength)httpHeader;
                this.suppressionWarning$1(log, x6, "explicit `Content-Length` header is not allowed. Use the appropriate HttpEntity subtype.");
                continue;
            }
            if (httpHeader instanceof Content$minusType) {
                Content$minusType x7 = (Content$minusType)httpHeader;
                this.suppressionWarning$1(log, x7, "explicit `Content-Type` header is not allowed. Set `HttpResponse.entity.contentType` instead.");
                continue;
            }
            if (httpHeader instanceof Transfer$minusEncoding) {
                Transfer$minusEncoding x8 = (Transfer$minusEncoding)httpHeader;
                this.suppressionWarning$1(log, x8, "`Transfer-Encoding` header is not allowed for HTTP/2");
                continue;
            }
            if (httpHeader instanceof Connection) {
                Connection x9 = (Connection)httpHeader;
                this.suppressionWarning$1(log, x9, "`Connection` header is not allowed for HTTP/2");
                continue;
            }
            HttpHeader x10 = httpHeader;
            this.addHeader$1(headerPairs, x10);
        }
        if (shouldRenderAutoHeaders && !dateSeen && isServer) {
            headerPairs.$plus$eq(dateHeaderRendering.renderHeaderPair());
        }
        if (shouldRenderAutoHeaders && !peerIdSeen) {
            Option<Tuple2<String, String>> option = peerIdHeader;
            if (option instanceof Some) {
                Tuple2 peerIdTuple = (Tuple2)((Some)option).value();
                headerPairs.$plus$eq(peerIdTuple);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                return;
            }
            throw new MatchError(option);
        }
    }

    private final /* synthetic */ VectorBuilder addContentHeaders$$anonfun$1(VectorBuilder headerPairs$1, long _$2) {
        String string2 = Predef$.MODULE$.ArrowAssoc("content-length");
        return (VectorBuilder)headerPairs$1.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, BoxesRunTime.boxToLong(_$2).toString()));
    }

    private final void suppressionWarning$1(LoggingAdapter log$1, HttpHeader h, String msg) {
        log$1.warning("Explicitly set HTTP header '{}' is ignored, {}", h, (Object)msg);
    }

    private final void addHeader$1(VectorBuilder headerPairs$2, HttpHeader h) {
        String string2 = Predef$.MODULE$.ArrowAssoc(h.lowercaseName());
        headerPairs$2.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, h.value()));
    }
}

