/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.impl.engine.http2.Http2SubStream$;
import org.apache.pekko.http.scaladsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Chunk$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Chunked$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Strict$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@InternalApi
public class Http2SubStream
implements Product,
Serializable {
    private final FrameEvent.ParsedHeadersFrame initialHeaders;
    private final FrameEvent.ParsedHeadersFrame trailingHeaders;
    private final Either data;
    private final Map correlationAttributes;

    public static Http2SubStream apply(HttpEntity httpEntity, FrameEvent.ParsedHeadersFrame parsedHeadersFrame, FrameEvent.ParsedHeadersFrame parsedHeadersFrame2, Map<AttributeKey<?>, ?> map) {
        return Http2SubStream$.MODULE$.apply(httpEntity, parsedHeadersFrame, parsedHeadersFrame2, map);
    }

    public static Http2SubStream apply(FrameEvent.ParsedHeadersFrame parsedHeadersFrame, FrameEvent.ParsedHeadersFrame parsedHeadersFrame2, Either<ByteString, Source<Object, Object>> either, Map<AttributeKey<?>, ?> map) {
        return Http2SubStream$.MODULE$.apply(parsedHeadersFrame, parsedHeadersFrame2, either, map);
    }

    public static Http2SubStream fromProduct(Product product) {
        return Http2SubStream$.MODULE$.fromProduct(product);
    }

    public static Http2SubStream unapply(Http2SubStream http2SubStream) {
        return Http2SubStream$.MODULE$.unapply(http2SubStream);
    }

    public static Map<AttributeKey<?>, ?> apply$default$4() {
        return Http2SubStream$.MODULE$.apply$default$4();
    }

    public Http2SubStream(FrameEvent.ParsedHeadersFrame initialHeaders, FrameEvent.ParsedHeadersFrame trailingHeaders, Either<ByteString, Source<Object, Object>> data, Map<AttributeKey<?>, ?> correlationAttributes) {
        this.initialHeaders = initialHeaders;
        this.trailingHeaders = trailingHeaders;
        this.data = data;
        this.correlationAttributes = correlationAttributes;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Http2SubStream)) return false;
        Http2SubStream http2SubStream = (Http2SubStream)object;
        FrameEvent.ParsedHeadersFrame parsedHeadersFrame = this.initialHeaders();
        FrameEvent.ParsedHeadersFrame parsedHeadersFrame2 = http2SubStream.initialHeaders();
        if (parsedHeadersFrame == null) {
            if (parsedHeadersFrame2 != null) {
                return false;
            }
        } else if (!((Object)parsedHeadersFrame).equals(parsedHeadersFrame2)) return false;
        FrameEvent.ParsedHeadersFrame parsedHeadersFrame3 = this.trailingHeaders();
        FrameEvent.ParsedHeadersFrame parsedHeadersFrame4 = http2SubStream.trailingHeaders();
        if (parsedHeadersFrame3 == null) {
            if (parsedHeadersFrame4 != null) {
                return false;
            }
        } else if (!((Object)parsedHeadersFrame3).equals(parsedHeadersFrame4)) return false;
        Either<ByteString, Source<Object, Object>> either = this.data();
        Either<ByteString, Source<Object, Object>> either2 = http2SubStream.data();
        if (either == null) {
            if (either2 != null) {
                return false;
            }
        } else if (!either.equals(either2)) return false;
        Map<AttributeKey<?>, ?> map = this.correlationAttributes();
        Map<AttributeKey<?>, ?> map2 = http2SubStream.correlationAttributes();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!http2SubStream.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof Http2SubStream;
    }

    @Override
    public int productArity() {
        return 4;
    }

    @Override
    public String productPrefix() {
        return "Http2SubStream";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return new OptionVal<FrameEvent.ParsedHeadersFrame>(this._2());
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "initialHeaders";
            }
            case 1: {
                return "trailingHeaders";
            }
            case 2: {
                return "data";
            }
            case 3: {
                return "correlationAttributes";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public FrameEvent.ParsedHeadersFrame initialHeaders() {
        return this.initialHeaders;
    }

    public FrameEvent.ParsedHeadersFrame trailingHeaders() {
        return this.trailingHeaders;
    }

    public Either<ByteString, Source<Object, Object>> data() {
        return this.data;
    }

    public Map<AttributeKey<?>, ?> correlationAttributes() {
        return this.correlationAttributes;
    }

    public int streamId() {
        return this.initialHeaders().streamId();
    }

    public boolean hasEntity() {
        return !this.initialHeaders().endStream();
    }

    public Http2SubStream withCorrelationAttributes(Map<AttributeKey<?>, ?> newAttributes) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), newAttributes);
    }

    public RequestEntity createEntity(long contentLength, ContentType contentTypeOption) {
        RequestEntity requestEntity;
        Either<ByteString, Source<Object, Object>> either = this.data();
        if (either instanceof Right) {
            Source data;
            Source source = data = (Source)((Right)either).value();
            Source source2 = Source$.MODULE$.empty();
            if (!(source == null ? source2 != null : !source.equals(source2)) || contentLength == 0L || !this.hasEntity()) {
                requestEntity = OptionVal$.MODULE$.isEmpty$extension(contentTypeOption) ? HttpEntity$.MODULE$.Empty() : HttpEntity$Strict$.MODULE$.apply(Http2SubStream.contentType$1(contentTypeOption), ByteString$.MODULE$.empty());
            } else {
                Source chunkSource = (Source)data.map((Function1<Object, HttpEntity.ChunkStreamPart> & Serializable)x$1 -> {
                    Object object = x$1;
                    if (object instanceof ByteString) {
                        ByteString b = (ByteString)object;
                        return HttpEntity$Chunk$.MODULE$.apply(b, HttpEntity$Chunk$.MODULE$.$lessinit$greater$default$2());
                    }
                    if (object instanceof HttpEntity.ChunkStreamPart) {
                        HttpEntity.ChunkStreamPart p = (HttpEntity.ChunkStreamPart)object;
                        return p;
                    }
                    Object x = object;
                    throw new IllegalStateException(new StringBuilder(52).append("Only ByteString or ChunkStreamPart expected but got ").append(x).toString());
                });
                requestEntity = HttpEntity$Chunked$.MODULE$.apply(Http2SubStream.contentType$1(contentTypeOption), chunkSource);
            }
        } else if (either instanceof Left) {
            ByteString dataBytes = (ByteString)((Left)either).value();
            requestEntity = dataBytes.isEmpty() && OptionVal$.MODULE$.isEmpty$extension(contentTypeOption) ? HttpEntity$.MODULE$.Empty() : HttpEntity$Strict$.MODULE$.apply(Http2SubStream.contentType$1(contentTypeOption), dataBytes);
        } else {
            throw new MatchError(either);
        }
        return requestEntity;
    }

    public Http2SubStream copy(FrameEvent.ParsedHeadersFrame initialHeaders, FrameEvent.ParsedHeadersFrame trailingHeaders, Either<ByteString, Source<Object, Object>> data, Map<AttributeKey<?>, ?> correlationAttributes) {
        return new Http2SubStream(initialHeaders, trailingHeaders, data, correlationAttributes);
    }

    public FrameEvent.ParsedHeadersFrame copy$default$1() {
        return this.initialHeaders();
    }

    public FrameEvent.ParsedHeadersFrame copy$default$2() {
        return this.trailingHeaders();
    }

    public Either<ByteString, Source<Object, Object>> copy$default$3() {
        return this.data();
    }

    public Map<AttributeKey<?>, ?> copy$default$4() {
        return this.correlationAttributes();
    }

    public FrameEvent.ParsedHeadersFrame _1() {
        return this.initialHeaders();
    }

    public FrameEvent.ParsedHeadersFrame _2() {
        return this.trailingHeaders();
    }

    public Either<ByteString, Source<Object, Object>> _3() {
        return this.data();
    }

    public Map<AttributeKey<?>, ?> _4() {
        return this.correlationAttributes();
    }

    private static final ContentType contentType$1(ContentType contentTypeOption$1) {
        return OptionVal$.MODULE$.getOrElse$extension(contentTypeOption$1, ContentTypes$.MODULE$.application$divoctet$minusstream());
    }
}

