/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$DataFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$ParsedHeadersFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$RstStreamFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$WindowUpdateFrame$;
import org.apache.pekko.http.impl.engine.http2.Http2Multiplexer;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$ErrorCode$CANCEL$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$ErrorCode$FLOW_CONTROL_ERROR$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$ErrorCode$INTERNAL_ERROR$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$ErrorCode$PROTOCOL_ERROR$;
import org.apache.pekko.http.impl.engine.http2.Http2StreamHandling$;
import org.apache.pekko.http.impl.engine.http2.Http2StreamHandling$Closed$;
import org.apache.pekko.http.impl.engine.http2.Http2StreamHandling$CollectingIncomingData$;
import org.apache.pekko.http.impl.engine.http2.Http2StreamHandling$HalfClosedLocal$;
import org.apache.pekko.http.impl.engine.http2.Http2StreamHandling$HalfClosedLocalWaitingForPeerStream$;
import org.apache.pekko.http.impl.engine.http2.Http2StreamHandling$HalfClosedRemoteSendingData$;
import org.apache.pekko.http.impl.engine.http2.Http2StreamHandling$HalfClosedRemoteWaitingForOutgoingStream$;
import org.apache.pekko.http.impl.engine.http2.Http2StreamHandling$Idle$;
import org.apache.pekko.http.impl.engine.http2.Http2StreamHandling$Open$;
import org.apache.pekko.http.impl.engine.http2.Http2StreamHandling$OpenReceivingDataFirst$;
import org.apache.pekko.http.impl.engine.http2.Http2StreamHandling$OpenSendingData$;
import org.apache.pekko.http.impl.engine.http2.Http2StreamHandling$OutStream$;
import org.apache.pekko.http.impl.engine.http2.Http2SubStream;
import org.apache.pekko.http.impl.engine.http2.HttpMessageRendering$;
import org.apache.pekko.http.impl.engine.http2.IncomingFlowController;
import org.apache.pekko.http.impl.engine.http2.IncomingFlowController$;
import org.apache.pekko.http.impl.engine.http2.IncomingFlowController$WindowIncrements$;
import org.apache.pekko.http.impl.engine.http2.PullFrameResult;
import org.apache.pekko.http.impl.engine.http2.PullFrameResult$SendFrame$;
import org.apache.pekko.http.impl.engine.http2.PullFrameResult$SendFrameAndTrailer$;
import org.apache.pekko.http.impl.engine.rendering.DateHeaderRendering$;
import org.apache.pekko.http.scaladsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Chunk$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$LastChunk$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.http2.PeerClosedStreamException;
import org.apache.pekko.http.scaladsl.settings.Http2CommonSettings;
import org.apache.pekko.macros.LogHelper;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple2$mcII$sp;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LongMap;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@InternalApi
public interface Http2StreamHandling
extends LogHelper {
    public static IllegalStateException ConnectionWasAbortedException() {
        return Http2StreamHandling$.MODULE$.ConnectionWasAbortedException();
    }

    public static void $init$(Http2StreamHandling $this) {
        $this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$_setter_$org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$streamStates_$eq(new LongMap($this.settings().maxConcurrentStreams()));
        $this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$largestIncomingStreamId_$eq(0);
        $this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$outstandingConnectionLevelWindow_$eq(65535);
        $this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$totalBufferedData_$eq(0);
        $this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$maxConcurrentStreams_$eq(Integer.MAX_VALUE);
        $this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$deferredStreamToEnqueue_$eq(-1);
        $this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$stateMachineRunning_$eq(false);
    }

    public /* synthetic */ Materializer org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$super$subFusingMaterializer();

    public boolean isServer();

    public Http2Multiplexer multiplexer();

    public Http2CommonSettings settings();

    public void pushGOAWAY(Http2Protocol.ErrorCode var1, String var2);

    public void dispatchSubstream(FrameEvent.ParsedHeadersFrame var1, Either<ByteString, Source<Object, Object>> var2, Map<AttributeKey<?>, ?> var3);

    public boolean isUpgraded();

    public Option<HttpEntity.ChunkStreamPart> wrapTrailingHeaders(FrameEvent.ParsedHeadersFrame var1);

    public static IncomingFlowController flowController$(Http2StreamHandling $this) {
        return $this.flowController();
    }

    default public IncomingFlowController flowController() {
        return IncomingFlowController$.MODULE$.default(this.settings());
    }

    public void tryPullSubStreams();

    public LongMap<StreamState> org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$streamStates();

    public void org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$_setter_$org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$streamStates_$eq(LongMap var1);

    public int org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$largestIncomingStreamId();

    public void org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$largestIncomingStreamId_$eq(int var1);

    public int org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$outstandingConnectionLevelWindow();

    public void org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$outstandingConnectionLevelWindow_$eq(int var1);

    public int org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$totalBufferedData();

    public void org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$totalBufferedData_$eq(int var1);

    public static int lastStreamId$(Http2StreamHandling $this) {
        return $this.lastStreamId();
    }

    default public int lastStreamId() {
        return this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$largestIncomingStreamId();
    }

    public int org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$maxConcurrentStreams();

    public void org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$maxConcurrentStreams_$eq(int var1);

    public static void setMaxConcurrentStreams$(Http2StreamHandling $this, int newValue) {
        $this.setMaxConcurrentStreams(newValue);
    }

    default public void setMaxConcurrentStreams(int newValue) {
        this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$maxConcurrentStreams_$eq(newValue);
    }

    public static boolean hasCapacityToCreateStreams$(Http2StreamHandling $this) {
        return $this.hasCapacityToCreateStreams();
    }

    default public boolean hasCapacityToCreateStreams() {
        return this.activeStreamCount() < this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$maxConcurrentStreams();
    }

    public void onAllStreamsClosed();

    private StreamState streamFor(int streamId) {
        StreamState streamState = this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$streamStates().getOrNull(Int$.MODULE$.int2long(streamId));
        if (streamState == null) {
            StreamState streamState2;
            if (streamId <= this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$largestIncomingStreamId()) {
                return this.Closed();
            }
            if (this.isUpgraded() && streamId == 1) {
                Predef$.MODULE$.require(this.isServer());
                this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$largestIncomingStreamId_$eq(streamId);
                this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$streamStates().put(Int$.MODULE$.int2long(streamId), (StreamState)this.HalfClosedRemoteWaitingForOutgoingStream().apply(0));
                streamState2 = this.HalfClosedRemoteWaitingForOutgoingStream().apply(0);
            } else {
                this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$largestIncomingStreamId_$eq(streamId);
                this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$streamStates().put(Int$.MODULE$.int2long(streamId), (StreamState)this.Idle());
                streamState2 = this.Idle();
            }
            return streamState2;
        }
        StreamState state = streamState;
        return state;
    }

    public static int activeStreamCount$(Http2StreamHandling $this) {
        return $this.activeStreamCount();
    }

    default public int activeStreamCount() {
        return this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$streamStates().size();
    }

    public static void handleStreamEvent$(Http2StreamHandling $this, FrameEvent.StreamFrameEvent e) {
        $this.handleStreamEvent(e);
    }

    default public void handleStreamEvent(FrameEvent.StreamFrameEvent e) {
        this.updateState(e.streamId(), (Function1<StreamState, StreamState> & Serializable)_$1 -> _$1.handle(e), "handleStreamEvent", e.frameTypeName());
    }

    public static void handleOutgoingCreated$(Http2StreamHandling $this, Http2SubStream stream) {
        $this.handleOutgoingCreated(stream);
    }

    default public void handleOutgoingCreated(Http2SubStream stream) {
        Http2Multiplexer http2Multiplexer = this.multiplexer();
        stream.initialHeaders().priorityInfo().foreach(priorityFrame -> http2Multiplexer.updatePriority((FrameEvent.PriorityFrame)priorityFrame));
        StreamState streamState = this.streamFor(stream.streamId());
        Http2StreamHandling$Closed$ http2StreamHandling$Closed$ = this.Closed();
        if (streamState == null ? http2StreamHandling$Closed$ != null : !streamState.equals(http2StreamHandling$Closed$)) {
            this.multiplexer().pushControlFrame(stream.initialHeaders());
            if (stream.initialHeaders().endStream()) {
                this.updateState(stream.streamId(), (Function1<StreamState, StreamState> & Serializable)_$2 -> _$2.handleOutgoingCreatedAndFinished(stream.correlationAttributes()), "handleOutgoingCreatedAndFinished", this.updateState$default$4());
                return;
            }
            OutStream outStream = this.OutStream().apply(stream);
            this.updateState(stream.streamId(), (Function1<StreamState, StreamState> & Serializable)_$3 -> _$3.handleOutgoingCreated(outStream, stream.correlationAttributes()), "handleOutgoingCreated", this.updateState$default$4());
            return;
        }
        stream.data().foreach((Function1<Source, NotUsed> & Serializable)_$4 -> _$4.runWith(Sink$.MODULE$.cancelled(), ((GraphStageLogic)((Object)this)).subFusingMaterializer()));
    }

    public static void handleOutgoingEnded$(Http2StreamHandling $this, int streamId) {
        $this.handleOutgoingEnded(streamId);
    }

    default public void handleOutgoingEnded(int streamId) {
        this.updateState(streamId, (Function1<StreamState, StreamState> & Serializable)_$5 -> _$5.handleOutgoingEnded(), "handleOutgoingEnded", this.updateState$default$4());
    }

    public static void handleOutgoingFailed$(Http2StreamHandling $this, int streamId, Throwable cause) {
        $this.handleOutgoingFailed(streamId, cause);
    }

    default public void handleOutgoingFailed(int streamId, Throwable cause) {
        this.updateState(streamId, (Function1<StreamState, StreamState> & Serializable)_$6 -> _$6.handleOutgoingFailed(cause), "handleOutgoingFailed", this.updateState$default$4());
    }

    public static void distributeWindowDeltaToAllStreams$(Http2StreamHandling $this, int delta) {
        $this.distributeWindowDeltaToAllStreams(delta);
    }

    default public void distributeWindowDeltaToAllStreams(int delta) {
        this.updateAllStates((Function1<StreamState, StreamState> & Serializable)x$1 -> {
            StreamState streamState = x$1;
            if (streamState instanceof Sending && ((Sending)((Object)streamState)).org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$Sending$$$outer() == this) {
                Sending s2 = (Sending)((Object)streamState);
                return s2.increaseWindow(delta);
            }
            StreamState x = streamState;
            return x;
        }, "distributeWindowDeltaToAllStreams", this.updateAllStates$default$3());
    }

    public static PullFrameResult pullNextFrame$(Http2StreamHandling $this, int streamId, int maxSize) {
        return $this.pullNextFrame(streamId, maxSize);
    }

    default public PullFrameResult pullNextFrame(int streamId, int maxSize) {
        return (PullFrameResult)this.updateStateAndReturn(streamId, (Function1<StreamState, Tuple2> & Serializable)_$7 -> _$7.pullNextFrame(maxSize), "pullNextFrame", this.updateStateAndReturn$default$4());
    }

    public static void incomingStreamPulled$(Http2StreamHandling $this, int streamId) {
        $this.incomingStreamPulled(streamId);
    }

    default public void incomingStreamPulled(int streamId) {
        this.updateState(streamId, (Function1<StreamState, StreamState> & Serializable)_$8 -> _$8.incomingStreamPulled(), "incomingStreamPulled", this.updateState$default$4());
    }

    private void updateAllStates(Function1<StreamState, StreamState> handle, String event, Object eventArg) {
        this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$streamStates().keys().foreach(streamId -> this.updateState((int)streamId, handle, event, eventArg));
    }

    private Object updateAllStates$default$3() {
        return null;
    }

    private void updateState(int streamId, Function1<StreamState, StreamState> handle, String event, Object eventArg) {
        this.updateStateAndReturn(streamId, (Function1<StreamState, Tuple2> & Serializable)x -> Tuple2$.MODULE$.apply(handle.apply((StreamState)x), BoxedUnit.UNIT), event, eventArg);
    }

    private Object updateState$default$4() {
        return null;
    }

    public int org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$deferredStreamToEnqueue();

    public void org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$deferredStreamToEnqueue_$eq(int var1);

    public static void org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$enqueueOutStream$(Http2StreamHandling $this, int streamId) {
        $this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$enqueueOutStream(streamId);
    }

    default public void org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$enqueueOutStream(int streamId) {
        if (this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$stateMachineRunning()) {
            Predef$.MODULE$.require(this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$deferredStreamToEnqueue() == -1, Http2StreamHandling::enqueueOutStream$$anonfun$1);
            this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$deferredStreamToEnqueue_$eq(streamId);
            return;
        }
        this.multiplexer().enqueueOutStream(streamId);
    }

    public boolean org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$stateMachineRunning();

    public void org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$stateMachineRunning_$eq(boolean var1);

    private <R> R updateStateAndReturn(int streamId, Function1<StreamState, Tuple2<StreamState, R>> handle, String event, Object eventArg) {
        Serializable serializable;
        Predef$.MODULE$.require(!this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$stateMachineRunning(), Http2StreamHandling::updateStateAndReturn$$anonfun$1);
        this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$stateMachineRunning_$eq(true);
        StreamState oldState = this.streamFor(streamId);
        Tuple2<StreamState, R> tuple2 = handle.apply(oldState);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        StreamState newState = tuple2._1();
        R ret = tuple2._2();
        Tuple2<StreamState, R> tuple22 = Tuple2$.MODULE$.apply(newState, ret);
        StreamState newState2 = tuple22._1();
        R ret2 = tuple22._2();
        StreamState streamState = newState2;
        if (this.Closed().equals(streamState)) {
            this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$streamStates().remove(BoxesRunTime.boxToLong(Int$.MODULE$.int2long(streamId)));
            if (this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$streamStates().isEmpty()) {
                this.onAllStreamsClosed();
            }
            this.tryPullSubStreams();
            serializable = BoxedUnit.UNIT;
        } else {
            StreamState newState3 = streamState;
            serializable = this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$streamStates().put(Int$.MODULE$.int2long(streamId), newState3);
        }
        Http2StreamHandling LogHelperMacro_this = this;
        if (LogHelperMacro_this.isDebugEnabled()) {
            LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(64).append("Incoming side of stream [").append(streamId).append("] changed state: ").append(oldState.stateName()).append(" -> ").append(newState2.stateName()).append(" after handling [").append(event).append(eventArg != null ? new StringBuilder(2).append("(").append(eventArg).append(")").toString() : "").append("]").toString()).toString());
        }
        this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$stateMachineRunning_$eq(false);
        if (this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$deferredStreamToEnqueue() != -1) {
            int streamId2 = this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$deferredStreamToEnqueue();
            this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$deferredStreamToEnqueue_$eq(-1);
            if (this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$streamStates().contains(Int$.MODULE$.int2long(streamId2))) {
                this.multiplexer().enqueueOutStream(streamId2);
            }
        }
        return ret2;
    }

    private <R> Object updateStateAndReturn$default$4() {
        return null;
    }

    public static void shutdownStreamHandling$(Http2StreamHandling $this) {
        $this.shutdownStreamHandling();
    }

    default public void shutdownStreamHandling() {
        this.updateAllStates((Function1<StreamState, StreamState> & Serializable)id -> {
            id.shutdown();
            return this.Closed();
        }, "shutdownStreamHandling", this.updateAllStates$default$3());
    }

    public static void resetStream$(Http2StreamHandling $this, int streamId, Http2Protocol.ErrorCode errorCode) {
        $this.resetStream(streamId, errorCode);
    }

    default public void resetStream(int streamId, Http2Protocol.ErrorCode errorCode) {
        this.updateState(streamId, (Function1<StreamState, StreamState> & Serializable)_$9 -> this.Closed(), "resetStream", this.updateState$default$4());
        this.multiplexer().pushControlFrame(FrameEvent$RstStreamFrame$.MODULE$.apply(streamId, errorCode));
    }

    public static Http2StreamHandling$Idle$ Idle$(Http2StreamHandling $this) {
        return $this.Idle();
    }

    default public Http2StreamHandling$Idle$ Idle() {
        return new Http2StreamHandling$Idle$(this);
    }

    public static Http2StreamHandling$CollectingIncomingData$ CollectingIncomingData$(Http2StreamHandling $this) {
        return $this.CollectingIncomingData();
    }

    default public Http2StreamHandling$CollectingIncomingData$ CollectingIncomingData() {
        return new Http2StreamHandling$CollectingIncomingData$(this);
    }

    public static Http2StreamHandling$OpenReceivingDataFirst$ OpenReceivingDataFirst$(Http2StreamHandling $this) {
        return $this.OpenReceivingDataFirst();
    }

    default public Http2StreamHandling$OpenReceivingDataFirst$ OpenReceivingDataFirst() {
        return new Http2StreamHandling$OpenReceivingDataFirst$(this);
    }

    public static Http2StreamHandling$OpenSendingData$ OpenSendingData$(Http2StreamHandling $this) {
        return $this.OpenSendingData();
    }

    default public Http2StreamHandling$OpenSendingData$ OpenSendingData() {
        return new Http2StreamHandling$OpenSendingData$(this);
    }

    public static Http2StreamHandling$HalfClosedLocalWaitingForPeerStream$ HalfClosedLocalWaitingForPeerStream$(Http2StreamHandling $this) {
        return $this.HalfClosedLocalWaitingForPeerStream();
    }

    default public Http2StreamHandling$HalfClosedLocalWaitingForPeerStream$ HalfClosedLocalWaitingForPeerStream() {
        return new Http2StreamHandling$HalfClosedLocalWaitingForPeerStream$(this);
    }

    public static Http2StreamHandling$Open$ Open$(Http2StreamHandling $this) {
        return $this.Open();
    }

    default public Http2StreamHandling$Open$ Open() {
        return new Http2StreamHandling$Open$(this);
    }

    public static Http2StreamHandling$HalfClosedLocal$ HalfClosedLocal$(Http2StreamHandling $this) {
        return $this.HalfClosedLocal();
    }

    default public Http2StreamHandling$HalfClosedLocal$ HalfClosedLocal() {
        return new Http2StreamHandling$HalfClosedLocal$(this);
    }

    public static Http2StreamHandling$HalfClosedRemoteWaitingForOutgoingStream$ HalfClosedRemoteWaitingForOutgoingStream$(Http2StreamHandling $this) {
        return $this.HalfClosedRemoteWaitingForOutgoingStream();
    }

    default public Http2StreamHandling$HalfClosedRemoteWaitingForOutgoingStream$ HalfClosedRemoteWaitingForOutgoingStream() {
        return new Http2StreamHandling$HalfClosedRemoteWaitingForOutgoingStream$(this);
    }

    public static Http2StreamHandling$HalfClosedRemoteSendingData$ HalfClosedRemoteSendingData$(Http2StreamHandling $this) {
        return $this.HalfClosedRemoteSendingData();
    }

    default public Http2StreamHandling$HalfClosedRemoteSendingData$ HalfClosedRemoteSendingData() {
        return new Http2StreamHandling$HalfClosedRemoteSendingData$(this);
    }

    public static Http2StreamHandling$Closed$ Closed$(Http2StreamHandling $this) {
        return $this.Closed();
    }

    default public Http2StreamHandling$Closed$ Closed() {
        return new Http2StreamHandling$Closed$(this);
    }

    public static Http2StreamHandling$OutStream$ OutStream$(Http2StreamHandling $this) {
        return $this.OutStream();
    }

    default public Http2StreamHandling$OutStream$ OutStream() {
        return new Http2StreamHandling$OutStream$(this);
    }

    private static Object enqueueOutStream$$anonfun$1() {
        return "Only one stream can be enqueued during a single state change";
    }

    private static Object updateStateAndReturn$$anonfun$1() {
        return "State machine already running";
    }

    public class CollectingIncomingData
    extends ReceivingData
    implements Product,
    Serializable {
        private final FrameEvent.ParsedHeadersFrame headers;
        private final Map correlationAttributes;
        private final ByteString collectedData;
        private final int extraInitialWindow;
        private final /* synthetic */ Http2StreamHandling $outer;

        public CollectingIncomingData(Http2StreamHandling $outer, FrameEvent.ParsedHeadersFrame headers, Map<AttributeKey<?>, ?> correlationAttributes, ByteString collectedData, int extraInitialWindow) {
            this.headers = headers;
            this.correlationAttributes = correlationAttributes;
            this.collectedData = collectedData;
            this.extraInitialWindow = extraInitialWindow;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.headers()));
            n = Statics.mix(n, Statics.anyHash(this.correlationAttributes()));
            n = Statics.mix(n, Statics.anyHash(this.collectedData()));
            n = Statics.mix(n, this.extraInitialWindow());
            return Statics.finalizeHash(n, 4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CollectingIncomingData)) return false;
            if (((CollectingIncomingData)object).org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$CollectingIncomingData$$$outer() != this.$outer) return false;
            CollectingIncomingData collectingIncomingData = (CollectingIncomingData)object;
            if (this.extraInitialWindow() != collectingIncomingData.extraInitialWindow()) return false;
            FrameEvent.ParsedHeadersFrame parsedHeadersFrame = this.headers();
            FrameEvent.ParsedHeadersFrame parsedHeadersFrame2 = collectingIncomingData.headers();
            if (parsedHeadersFrame == null) {
                if (parsedHeadersFrame2 != null) {
                    return false;
                }
            } else if (!((Object)parsedHeadersFrame).equals(parsedHeadersFrame2)) return false;
            Map<AttributeKey<?>, ?> map = this.correlationAttributes();
            Map<AttributeKey<?>, ?> map2 = collectingIncomingData.correlationAttributes();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            ByteString byteString = this.collectedData();
            ByteString byteString2 = collectingIncomingData.collectedData();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!((Object)byteString).equals(byteString2)) return false;
            if (!collectingIncomingData.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof CollectingIncomingData;
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public String productPrefix() {
            return "CollectingIncomingData";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger(this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "headers";
                }
                case 1: {
                    return "correlationAttributes";
                }
                case 2: {
                    return "collectedData";
                }
                case 3: {
                    return "extraInitialWindow";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public FrameEvent.ParsedHeadersFrame headers() {
            return this.headers;
        }

        public Map<AttributeKey<?>, ?> correlationAttributes() {
            return this.correlationAttributes;
        }

        public ByteString collectedData() {
            return this.collectedData;
        }

        public int extraInitialWindow() {
            return this.extraInitialWindow;
        }

        @Override
        public StreamState onDataFrame(FrameEvent.DataFrame dataFrame) {
            ByteString newData = this.collectedData().$plus$plus(dataFrame.payload());
            if (dataFrame.endStream()) {
                this.$outer.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$totalBufferedData_$eq(this.$outer.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$totalBufferedData() - newData.length());
                this.$outer.dispatchSubstream(this.headers(), package$.MODULE$.Left().apply(newData), this.correlationAttributes());
                return this.$outer.HalfClosedRemoteWaitingForOutgoingStream().apply(this.extraInitialWindow());
            }
            if (newData.length() >= this.$outer.settings().minCollectStrictEntitySize()) {
                return this.dispatchStream(dataFrame.streamId(), this.headers(), newData, this.correlationAttributes(), (Function1<IncomingStreamBuffer, StreamState> & Serializable)_$11 -> this.$outer.OpenReceivingDataFirst().apply((IncomingStreamBuffer)_$11, this.extraInitialWindow()));
            }
            return this.copy(this.copy$default$1(), this.copy$default$2(), newData, this.copy$default$4());
        }

        @Override
        public StreamState onTrailer(FrameEvent.ParsedHeadersFrame parsedHeadersFrame) {
            return this;
        }

        @Override
        public StreamState incrementWindow(int delta) {
            int n = this.extraInitialWindow() + delta;
            FrameEvent.ParsedHeadersFrame parsedHeadersFrame = this.copy$default$1();
            Map<AttributeKey<?>, ?> map = this.copy$default$2();
            ByteString byteString = this.copy$default$3();
            return this.copy(parsedHeadersFrame, map, byteString, n);
        }

        @Override
        public void onRstStreamFrame(FrameEvent.RstStreamFrame rstStreamFrame) {
        }

        public CollectingIncomingData copy(FrameEvent.ParsedHeadersFrame headers, Map<AttributeKey<?>, ?> correlationAttributes, ByteString collectedData, int extraInitialWindow) {
            return new CollectingIncomingData(this.$outer, headers, correlationAttributes, collectedData, extraInitialWindow);
        }

        public FrameEvent.ParsedHeadersFrame copy$default$1() {
            return this.headers();
        }

        public Map<AttributeKey<?>, ?> copy$default$2() {
            return this.correlationAttributes();
        }

        public ByteString copy$default$3() {
            return this.collectedData();
        }

        public int copy$default$4() {
            return this.extraInitialWindow();
        }

        public FrameEvent.ParsedHeadersFrame _1() {
            return this.headers();
        }

        public Map<AttributeKey<?>, ?> _2() {
            return this.correlationAttributes();
        }

        public ByteString _3() {
            return this.collectedData();
        }

        public int _4() {
            return this.extraInitialWindow();
        }

        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$CollectingIncomingData$$$outer() {
            return this.$outer;
        }
    }

    public class HalfClosedLocal
    extends ReceivingDataWithBuffer
    implements Product,
    Serializable {
        private final IncomingStreamBuffer buffer;
        private final /* synthetic */ Http2StreamHandling $outer;

        public HalfClosedLocal(Http2StreamHandling $outer, IncomingStreamBuffer buffer) {
            this.buffer = buffer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, $outer.Closed());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HalfClosedLocal)) return false;
            if (((HalfClosedLocal)object).org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$HalfClosedLocal$$$outer() != this.$outer) return false;
            HalfClosedLocal halfClosedLocal = (HalfClosedLocal)object;
            IncomingStreamBuffer incomingStreamBuffer = this.buffer();
            IncomingStreamBuffer incomingStreamBuffer2 = halfClosedLocal.buffer();
            if (incomingStreamBuffer == null) {
                if (incomingStreamBuffer2 != null) {
                    return false;
                }
            } else if (!incomingStreamBuffer.equals(incomingStreamBuffer2)) return false;
            if (!halfClosedLocal.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof HalfClosedLocal;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "HalfClosedLocal";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "buffer";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public IncomingStreamBuffer buffer() {
            return this.buffer;
        }

        @Override
        public StreamState incrementWindow(int delta) {
            return this;
        }

        public HalfClosedLocal copy(IncomingStreamBuffer buffer) {
            return new HalfClosedLocal(this.$outer, buffer);
        }

        public IncomingStreamBuffer copy$default$1() {
            return this.buffer();
        }

        public IncomingStreamBuffer _1() {
            return this.buffer();
        }

        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$HalfClosedLocal$$$outer() {
            return this.$outer;
        }
    }

    public class HalfClosedLocalWaitingForPeerStream
    extends StreamState
    implements Product,
    Serializable {
        private final Map correlationAttributes;
        private final /* synthetic */ Http2StreamHandling $outer;

        public HalfClosedLocalWaitingForPeerStream(Http2StreamHandling $outer, Map<AttributeKey<?>, ?> correlationAttributes) {
            this.correlationAttributes = correlationAttributes;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HalfClosedLocalWaitingForPeerStream)) return false;
            if (((HalfClosedLocalWaitingForPeerStream)object).org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$HalfClosedLocalWaitingForPeerStream$$$outer() != this.$outer) return false;
            HalfClosedLocalWaitingForPeerStream halfClosedLocalWaitingForPeerStream = (HalfClosedLocalWaitingForPeerStream)object;
            Map<AttributeKey<?>, ?> map = this.correlationAttributes();
            Map<AttributeKey<?>, ?> map2 = halfClosedLocalWaitingForPeerStream.correlationAttributes();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!halfClosedLocalWaitingForPeerStream.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof HalfClosedLocalWaitingForPeerStream;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "HalfClosedLocalWaitingForPeerStream";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "correlationAttributes";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Map<AttributeKey<?>, ?> correlationAttributes() {
            return this.correlationAttributes;
        }

        @Override
        public StreamState handle(FrameEvent.StreamFrameEvent event) {
            FrameEvent.StreamFrameEvent streamFrameEvent = event;
            if (streamFrameEvent instanceof FrameEvent.WindowUpdateFrame) {
                return this;
            }
            return this.expectIncomingStream(event, this.$outer.Closed(), (Function1<IncomingStreamBuffer, StreamState> & Serializable)_$13 -> this.$outer.HalfClosedLocal().apply((IncomingStreamBuffer)_$13), this.correlationAttributes());
        }

        public HalfClosedLocalWaitingForPeerStream copy(Map<AttributeKey<?>, ?> correlationAttributes) {
            return new HalfClosedLocalWaitingForPeerStream(this.$outer, correlationAttributes);
        }

        public Map<AttributeKey<?>, ?> copy$default$1() {
            return this.correlationAttributes();
        }

        public Map<AttributeKey<?>, ?> _1() {
            return this.correlationAttributes();
        }

        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$HalfClosedLocalWaitingForPeerStream$$$outer() {
            return this.$outer;
        }
    }

    public class HalfClosedRemoteSendingData
    extends StreamState
    implements Sending,
    Product,
    Serializable {
        private final OutStream outStream;
        private final /* synthetic */ Http2StreamHandling $outer;

        public HalfClosedRemoteSendingData(Http2StreamHandling $outer, OutStream outStream) {
            this.outStream = outStream;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public /* synthetic */ void org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$Sending$$super$shutdown() {
            super.shutdown();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HalfClosedRemoteSendingData)) return false;
            if (((HalfClosedRemoteSendingData)object).org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$HalfClosedRemoteSendingData$$$outer() != this.$outer) return false;
            HalfClosedRemoteSendingData halfClosedRemoteSendingData = (HalfClosedRemoteSendingData)object;
            OutStream outStream = this.outStream();
            OutStream outStream2 = halfClosedRemoteSendingData.outStream();
            if (outStream == null) {
                if (outStream2 != null) {
                    return false;
                }
            } else if (!outStream.equals(outStream2)) return false;
            if (!halfClosedRemoteSendingData.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof HalfClosedRemoteSendingData;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "HalfClosedRemoteSendingData";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "outStream";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public OutStream outStream() {
            return this.outStream;
        }

        @Override
        public StreamState handle(FrameEvent.StreamFrameEvent event) {
            FrameEvent.StreamFrameEvent streamFrameEvent = event;
            if (streamFrameEvent instanceof FrameEvent.RstStreamFrame) {
                FrameEvent.RstStreamFrame r = (FrameEvent.RstStreamFrame)streamFrameEvent;
                this.outStream().cancelStream();
                return this.$outer.Closed();
            }
            if (streamFrameEvent instanceof FrameEvent.WindowUpdateFrame) {
                FrameEvent.WindowUpdateFrame w = (FrameEvent.WindowUpdateFrame)streamFrameEvent;
                return this.handleWindowUpdate(w);
            }
            return this.receivedUnexpectedFrame(event);
        }

        @Override
        public StreamState handleOutgoingEnded() {
            return this.$outer.Closed();
        }

        public HalfClosedRemoteSendingData copy(OutStream outStream) {
            return new HalfClosedRemoteSendingData(this.$outer, outStream);
        }

        public OutStream copy$default$1() {
            return this.outStream();
        }

        public OutStream _1() {
            return this.outStream();
        }

        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$HalfClosedRemoteSendingData$$$outer() {
            return this.$outer;
        }

        @Override
        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$Sending$$$outer() {
            return this.$outer;
        }
    }

    public class HalfClosedRemoteWaitingForOutgoingStream
    extends StreamState
    implements Product,
    Serializable {
        private final int extraInitialWindow;
        private final /* synthetic */ Http2StreamHandling $outer;

        public HalfClosedRemoteWaitingForOutgoingStream(Http2StreamHandling $outer, int extraInitialWindow) {
            this.extraInitialWindow = extraInitialWindow;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.extraInitialWindow());
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HalfClosedRemoteWaitingForOutgoingStream)) return false;
            if (((HalfClosedRemoteWaitingForOutgoingStream)object).org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$HalfClosedRemoteWaitingForOutgoingStream$$$outer() != this.$outer) return false;
            HalfClosedRemoteWaitingForOutgoingStream halfClosedRemoteWaitingForOutgoingStream = (HalfClosedRemoteWaitingForOutgoingStream)object;
            if (this.extraInitialWindow() != halfClosedRemoteWaitingForOutgoingStream.extraInitialWindow()) return false;
            if (!halfClosedRemoteWaitingForOutgoingStream.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof HalfClosedRemoteWaitingForOutgoingStream;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "HalfClosedRemoteWaitingForOutgoingStream";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToInteger(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "extraInitialWindow";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public int extraInitialWindow() {
            return this.extraInitialWindow;
        }

        @Override
        public StreamState handle(FrameEvent.StreamFrameEvent event) {
            FrameEvent.StreamFrameEvent streamFrameEvent = event;
            if (streamFrameEvent instanceof FrameEvent.RstStreamFrame) {
                FrameEvent.RstStreamFrame r = (FrameEvent.RstStreamFrame)streamFrameEvent;
                return this.$outer.Closed();
            }
            if (streamFrameEvent instanceof FrameEvent.WindowUpdateFrame) {
                FrameEvent.WindowUpdateFrame w = (FrameEvent.WindowUpdateFrame)streamFrameEvent;
                return this.copy(this.extraInitialWindow() + w.windowSizeIncrement());
            }
            return this.receivedUnexpectedFrame(event);
        }

        @Override
        public StreamState handleOutgoingCreated(OutStream outStream, Map<AttributeKey<?>, ?> correlationAttributes) {
            outStream.increaseWindow(this.extraInitialWindow());
            return this.$outer.HalfClosedRemoteSendingData().apply(outStream);
        }

        @Override
        public StreamState handleOutgoingCreatedAndFinished(Map<AttributeKey<?>, ?> correlationAttributes) {
            return this.$outer.Closed();
        }

        public HalfClosedRemoteWaitingForOutgoingStream copy(int extraInitialWindow) {
            return new HalfClosedRemoteWaitingForOutgoingStream(this.$outer, extraInitialWindow);
        }

        public int copy$default$1() {
            return this.extraInitialWindow();
        }

        public int _1() {
            return this.extraInitialWindow();
        }

        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$HalfClosedRemoteWaitingForOutgoingStream$$$outer() {
            return this.$outer;
        }
    }

    public class IncomingStreamBuffer
    implements OutHandler {
        private final int streamId;
        private final GraphStageLogic.SubSourceOutlet<Object> outlet;
        private ByteString buffer;
        private Option<HttpEntity.ChunkStreamPart> trailingHeaders;
        private boolean wasClosed;
        private int outstandingStreamWindow;
        private final /* synthetic */ Http2StreamHandling $outer;

        public IncomingStreamBuffer(Http2StreamHandling $outer, int streamId, GraphStageLogic.SubSourceOutlet<Object> outlet) {
            this.streamId = streamId;
            this.outlet = outlet;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.buffer = ByteString$.MODULE$.empty();
            this.trailingHeaders = None$.MODULE$;
            this.wasClosed = false;
            this.outstandingStreamWindow = 65535;
            outlet.setHandler(this);
        }

        @Override
        public void onPull() {
            this.$outer.incomingStreamPulled(this.streamId);
        }

        @Override
        public void onDownstreamFinish() {
            Http2StreamHandling LogHelperMacro_this = this.$outer;
            if (LogHelperMacro_this.isDebugEnabled()) {
                LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(66).append("Incoming side of stream [").append(this.streamId).append("]: cancelling because downstream finished").toString()).toString());
            }
            this.$outer.multiplexer().pushControlFrame(FrameEvent$RstStreamFrame$.MODULE$.apply(this.streamId, Http2Protocol$ErrorCode$CANCEL$.MODULE$));
            this.$outer.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$streamStates().remove(BoxesRunTime.boxToLong(Int$.MODULE$.int2long(this.streamId)));
            this.wasClosed = true;
            this.buffer = ByteString$.MODULE$.empty();
            this.trailingHeaders = None$.MODULE$;
        }

        public boolean isDone() {
            return this.outlet.isClosed();
        }

        public void onDataFrame(FrameEvent.DataFrame data) {
            if (this.wasClosed) {
                this.shutdown();
                this.$outer.pushGOAWAY(Http2Protocol$ErrorCode$PROTOCOL_ERROR$.MODULE$, "Received unexpected DATA frame after stream was already (half-)closed");
                return;
            }
            this.wasClosed = data.endStream();
            this.outstandingStreamWindow -= data.sizeInWindow();
            if (this.outstandingStreamWindow < 0) {
                this.shutdown();
                this.$outer.multiplexer().pushControlFrame(FrameEvent$RstStreamFrame$.MODULE$.apply(this.streamId, Http2Protocol$ErrorCode$FLOW_CONTROL_ERROR$.MODULE$));
                this.$outer.multiplexer().closeStream(this.streamId);
                return;
            }
            this.buffer = this.buffer.$plus$plus(data.payload());
            Http2StreamHandling LogHelperMacro_this = this.$outer;
            if (LogHelperMacro_this.isDebugEnabled()) {
                LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(69).append("Received DATA ").append(data.sizeInWindow()).append(" for stream [").append(this.streamId).append("], remaining window space now ").append(this.outstandingStreamWindow).append(", buffered: ").append(this.buffer.length()).toString()).toString());
            }
            this.dispatchNextChunk();
        }

        public void onTrailingHeaders(FrameEvent.ParsedHeadersFrame headers) {
            this.trailingHeaders = this.$outer.wrapTrailingHeaders(headers);
            if (headers.endStream()) {
                this.onDataFrame(FrameEvent$DataFrame$.MODULE$.apply(headers.streamId(), true, ByteString$.MODULE$.empty()));
                return;
            }
            this.$outer.pushGOAWAY(Http2Protocol$ErrorCode$PROTOCOL_ERROR$.MODULE$, "Got unexpected mid-stream HEADERS frame");
        }

        public void onRstStreamFrame(FrameEvent.RstStreamFrame rst) {
            this.outlet.fail(new PeerClosedStreamException(rst.streamId(), rst.errorCode()));
            this.buffer = ByteString$.MODULE$.empty();
            this.trailingHeaders = None$.MODULE$;
            this.wasClosed = true;
        }

        public void dispatchNextChunk() {
            if (this.buffer.nonEmpty() && this.outlet.isAvailable()) {
                int dataSize = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.buffer.length()), this.$outer.settings().requestEntityChunkSize());
                this.outlet.push(this.buffer.take(dataSize));
                this.buffer = this.buffer.drop(dataSize);
                this.$outer.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$totalBufferedData_$eq(this.$outer.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$totalBufferedData() - dataSize);
                Http2StreamHandling LogHelperMacro_this = this.$outer;
                if (LogHelperMacro_this.isDebugEnabled()) {
                    LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(75).append("Dispatched chunk of ").append(dataSize).append(" for stream [").append(this.streamId).append("], remaining window space now ").append(this.outstandingStreamWindow).append(", buffered: ").append(this.buffer.length()).toString()).toString());
                }
                this.updateWindows();
            }
            if (this.buffer.isEmpty() && this.wasClosed) {
                Option<HttpEntity.ChunkStreamPart> option = this.trailingHeaders;
                if (option instanceof Some) {
                    HttpEntity.ChunkStreamPart trailer = (HttpEntity.ChunkStreamPart)((Some)option).value();
                    if (this.outlet.isAvailable()) {
                        this.outlet.push(trailer);
                        this.trailingHeaders = None$.MODULE$;
                        this.outlet.complete();
                        return;
                    }
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    this.outlet.complete();
                    return;
                }
                throw new MatchError(option);
            }
        }

        private void updateWindows() {
            Http2StreamHandling LogHelperMacro_this;
            IncomingFlowController.WindowIncrements windowIncrements = this.$outer.flowController().onStreamDataDispatched(this.$outer.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$outstandingConnectionLevelWindow(), this.$outer.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$totalBufferedData(), this.outstandingStreamWindow, this.buffer.length());
            if (windowIncrements == null) {
                throw new MatchError(windowIncrements);
            }
            IncomingFlowController.WindowIncrements windowIncrements2 = IncomingFlowController$WindowIncrements$.MODULE$.unapply(windowIncrements);
            int n = windowIncrements2._1();
            int n2 = windowIncrements2._2();
            int connectionLevel = n;
            int streamLevel = n2;
            Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(connectionLevel, streamLevel);
            int connectionLevel2 = ((Tuple2)tuple2$mcII$sp)._1$mcI$sp();
            int streamLevel2 = ((Tuple2)tuple2$mcII$sp)._2$mcI$sp();
            if (connectionLevel2 > 0) {
                this.$outer.multiplexer().pushControlFrame(FrameEvent$WindowUpdateFrame$.MODULE$.apply(0, connectionLevel2));
                this.$outer.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$outstandingConnectionLevelWindow_$eq(this.$outer.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$outstandingConnectionLevelWindow() + connectionLevel2);
            }
            if (streamLevel2 > 0 && !this.wasClosed) {
                this.$outer.multiplexer().pushControlFrame(FrameEvent$WindowUpdateFrame$.MODULE$.apply(this.streamId, streamLevel2));
                this.outstandingStreamWindow += streamLevel2;
            }
            if ((LogHelperMacro_this = this.$outer).isDebugEnabled()) {
                LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(57).append("adjusting con-level window by ").append(connectionLevel2).append(", stream-level window by ").append(streamLevel2).append(", ").append(new StringBuilder(41).append("remaining window space now ").append(this.outstandingStreamWindow).append(", buffered: ").append(this.buffer.length()).append(", ").toString()).append(new StringBuilder(56).append("remaining connection window space now ").append(this.$outer.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$outstandingConnectionLevelWindow()).append(", total buffered: ").append(this.$outer.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$totalBufferedData()).toString()).toString()).toString());
                return;
            }
        }

        public void shutdown() {
            if (!this.outlet.isClosed()) {
                this.outlet.fail(Http2StreamHandling$.MODULE$.ConnectionWasAbortedException());
                return;
            }
        }

        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$IncomingStreamBuffer$$$outer() {
            return this.$outer;
        }
    }

    public class Open
    extends ReceivingDataWithBuffer
    implements Sending,
    Product,
    Serializable {
        private final IncomingStreamBuffer buffer;
        private final OutStream outStream;
        private final /* synthetic */ Http2StreamHandling $outer;

        public Open(Http2StreamHandling $outer, IncomingStreamBuffer buffer, OutStream outStream) {
            this.buffer = buffer;
            this.outStream = outStream;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, $outer.HalfClosedRemoteSendingData().apply(outStream));
        }

        @Override
        public /* synthetic */ void org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$Sending$$super$shutdown() {
            super.shutdown();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Open)) return false;
            if (((Open)object).org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$Open$$$outer() != this.$outer) return false;
            Open open = (Open)object;
            IncomingStreamBuffer incomingStreamBuffer = this.buffer();
            IncomingStreamBuffer incomingStreamBuffer2 = open.buffer();
            if (incomingStreamBuffer == null) {
                if (incomingStreamBuffer2 != null) {
                    return false;
                }
            } else if (!incomingStreamBuffer.equals(incomingStreamBuffer2)) return false;
            OutStream outStream = this.outStream();
            OutStream outStream2 = open.outStream();
            if (outStream == null) {
                if (outStream2 != null) {
                    return false;
                }
            } else if (!outStream.equals(outStream2)) return false;
            if (!open.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Open;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Open";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "buffer";
            }
            if (1 == n2) {
                return "outStream";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public IncomingStreamBuffer buffer() {
            return this.buffer;
        }

        @Override
        public OutStream outStream() {
            return this.outStream;
        }

        @Override
        public StreamState handleOutgoingEnded() {
            return this.$outer.HalfClosedLocal().apply(this.buffer());
        }

        @Override
        public void onRstStreamFrame(FrameEvent.RstStreamFrame rstStreamFrame) {
            super.onRstStreamFrame(rstStreamFrame);
            this.outStream().cancelStream();
        }

        @Override
        public StreamState incrementWindow(int delta) {
            this.outStream().increaseWindow(delta);
            return this;
        }

        public Open copy(IncomingStreamBuffer buffer, OutStream outStream) {
            return new Open(this.$outer, buffer, outStream);
        }

        public IncomingStreamBuffer copy$default$1() {
            return this.buffer();
        }

        public OutStream copy$default$2() {
            return this.outStream();
        }

        public IncomingStreamBuffer _1() {
            return this.buffer();
        }

        public OutStream _2() {
            return this.outStream();
        }

        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$Open$$$outer() {
            return this.$outer;
        }

        @Override
        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$Sending$$$outer() {
            return this.$outer;
        }
    }

    public class OpenReceivingDataFirst
    extends ReceivingDataWithBuffer
    implements Product,
    Serializable {
        private final IncomingStreamBuffer buffer;
        private final int extraInitialWindow;
        private final /* synthetic */ Http2StreamHandling $outer;

        public OpenReceivingDataFirst(Http2StreamHandling $outer, IncomingStreamBuffer buffer, int extraInitialWindow) {
            this.buffer = buffer;
            this.extraInitialWindow = extraInitialWindow;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, $outer.HalfClosedRemoteWaitingForOutgoingStream().apply(extraInitialWindow));
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.buffer()));
            n = Statics.mix(n, this.extraInitialWindow());
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OpenReceivingDataFirst)) return false;
            if (((OpenReceivingDataFirst)object).org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$OpenReceivingDataFirst$$$outer() != this.$outer) return false;
            OpenReceivingDataFirst openReceivingDataFirst = (OpenReceivingDataFirst)object;
            if (this.extraInitialWindow() != openReceivingDataFirst.extraInitialWindow()) return false;
            IncomingStreamBuffer incomingStreamBuffer = this.buffer();
            IncomingStreamBuffer incomingStreamBuffer2 = openReceivingDataFirst.buffer();
            if (incomingStreamBuffer == null) {
                if (incomingStreamBuffer2 != null) {
                    return false;
                }
            } else if (!incomingStreamBuffer.equals(incomingStreamBuffer2)) return false;
            if (!openReceivingDataFirst.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof OpenReceivingDataFirst;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "OpenReceivingDataFirst";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger(this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "buffer";
            }
            if (1 == n2) {
                return "extraInitialWindow";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public IncomingStreamBuffer buffer() {
            return this.buffer;
        }

        public int extraInitialWindow() {
            return this.extraInitialWindow;
        }

        @Override
        public StreamState handleOutgoingCreated(OutStream outStream, Map<AttributeKey<?>, ?> correlationAttributes) {
            outStream.increaseWindow(this.extraInitialWindow());
            return this.$outer.Open().apply(this.buffer(), outStream);
        }

        @Override
        public StreamState handleOutgoingCreatedAndFinished(Map<AttributeKey<?>, ?> correlationAttributes) {
            return this.$outer.HalfClosedLocal().apply(this.buffer());
        }

        @Override
        public StreamState handleOutgoingEnded() {
            return this.$outer.Closed();
        }

        @Override
        public StreamState incrementWindow(int delta) {
            int n = this.extraInitialWindow() + delta;
            IncomingStreamBuffer incomingStreamBuffer = this.copy$default$1();
            return this.copy(incomingStreamBuffer, n);
        }

        public OpenReceivingDataFirst copy(IncomingStreamBuffer buffer, int extraInitialWindow) {
            return new OpenReceivingDataFirst(this.$outer, buffer, extraInitialWindow);
        }

        public IncomingStreamBuffer copy$default$1() {
            return this.buffer();
        }

        public int copy$default$2() {
            return this.extraInitialWindow();
        }

        public IncomingStreamBuffer _1() {
            return this.buffer();
        }

        public int _2() {
            return this.extraInitialWindow();
        }

        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$OpenReceivingDataFirst$$$outer() {
            return this.$outer;
        }
    }

    public class OpenSendingData
    extends StreamState
    implements Sending,
    Product,
    Serializable {
        private final OutStream outStream;
        private final Map correlationAttributes;
        private final /* synthetic */ Http2StreamHandling $outer;

        public OpenSendingData(Http2StreamHandling $outer, OutStream outStream, Map<AttributeKey<?>, ?> correlationAttributes) {
            this.outStream = outStream;
            this.correlationAttributes = correlationAttributes;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public /* synthetic */ void org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$Sending$$super$shutdown() {
            super.shutdown();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OpenSendingData)) return false;
            if (((OpenSendingData)object).org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$OpenSendingData$$$outer() != this.$outer) return false;
            OpenSendingData openSendingData = (OpenSendingData)object;
            OutStream outStream = this.outStream();
            OutStream outStream2 = openSendingData.outStream();
            if (outStream == null) {
                if (outStream2 != null) {
                    return false;
                }
            } else if (!outStream.equals(outStream2)) return false;
            Map<AttributeKey<?>, ?> map = this.correlationAttributes();
            Map<AttributeKey<?>, ?> map2 = openSendingData.correlationAttributes();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!openSendingData.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof OpenSendingData;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "OpenSendingData";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "outStream";
            }
            if (1 == n2) {
                return "correlationAttributes";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public OutStream outStream() {
            return this.outStream;
        }

        public Map<AttributeKey<?>, ?> correlationAttributes() {
            return this.correlationAttributes;
        }

        @Override
        public StreamState handle(FrameEvent.StreamFrameEvent event) {
            FrameEvent.StreamFrameEvent streamFrameEvent = event;
            if (streamFrameEvent instanceof FrameEvent.ParsedHeadersFrame) {
                return this.expectIncomingStream(event, this.$outer.HalfClosedRemoteSendingData().apply(this.outStream()), (Function1<IncomingStreamBuffer, StreamState> & Serializable)_$12 -> this.$outer.Open().apply((IncomingStreamBuffer)_$12, this.outStream()), this.correlationAttributes());
            }
            if (streamFrameEvent instanceof FrameEvent.WindowUpdateFrame) {
                FrameEvent.WindowUpdateFrame w = (FrameEvent.WindowUpdateFrame)streamFrameEvent;
                return this.handleWindowUpdate(w);
            }
            if (streamFrameEvent instanceof FrameEvent.RstStreamFrame) {
                FrameEvent.RstStreamFrame r = (FrameEvent.RstStreamFrame)streamFrameEvent;
                this.outStream().cancelStream();
                return this.$outer.Closed();
            }
            this.outStream().cancelStream();
            return this.receivedUnexpectedFrame(event);
        }

        @Override
        public StreamState handleOutgoingEnded() {
            return this.$outer.HalfClosedLocalWaitingForPeerStream().apply(this.correlationAttributes());
        }

        public OpenSendingData copy(OutStream outStream, Map<AttributeKey<?>, ?> correlationAttributes) {
            return new OpenSendingData(this.$outer, outStream, correlationAttributes);
        }

        public OutStream copy$default$1() {
            return this.outStream();
        }

        public Map<AttributeKey<?>, ?> copy$default$2() {
            return this.correlationAttributes();
        }

        public OutStream _1() {
            return this.outStream();
        }

        public Map<AttributeKey<?>, ?> _2() {
            return this.correlationAttributes();
        }

        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$OpenSendingData$$$outer() {
            return this.$outer;
        }

        @Override
        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$Sending$$$outer() {
            return this.$outer;
        }
    }

    public interface OutStream {
        public boolean canSend();

        public void cancelStream();

        public Option<FrameEvent> endStreamIfPossible();

        public FrameEvent.DataFrame nextFrame(int var1);

        public void increaseWindow(int var1);

        public boolean isDone();
    }

    public final class OutStreamImpl
    implements InHandler,
    OutStream {
        private final int streamId;
        private GraphStageLogic.SubSinkInlet maybeInlet;
        private int outboundWindowLeft;
        private FrameEvent.ParsedHeadersFrame trailer;
        private ByteString buffer;
        private boolean upstreamClosed;
        private boolean isEnqueued;
        private boolean endStreamSent;
        private final /* synthetic */ Http2StreamHandling $outer;

        public OutStreamImpl(Http2StreamHandling $outer, int streamId, GraphStageLogic.SubSinkInlet maybeInlet, int outboundWindowLeft, FrameEvent.ParsedHeadersFrame trailer) {
            this.streamId = streamId;
            this.maybeInlet = maybeInlet;
            this.outboundWindowLeft = outboundWindowLeft;
            this.trailer = trailer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.buffer = ByteString$.MODULE$.empty();
            this.upstreamClosed = false;
            this.isEnqueued = false;
            this.endStreamSent = false;
        }

        public int streamId() {
            return this.streamId;
        }

        private GraphStageLogic.SubSinkInlet maybeInlet() {
            return this.maybeInlet;
        }

        private void maybeInlet_$eq(GraphStageLogic.SubSinkInlet x$0) {
            this.maybeInlet = x$0;
        }

        public int outboundWindowLeft() {
            return this.outboundWindowLeft;
        }

        public void outboundWindowLeft_$eq(int x$1) {
            this.outboundWindowLeft = x$1;
        }

        public FrameEvent.ParsedHeadersFrame trailer() {
            return this.trailer;
        }

        public void trailer_$eq(FrameEvent.ParsedHeadersFrame x$1) {
            this.trailer = x$1;
        }

        private GraphStageLogic.SubSinkInlet<?> inlet() {
            GraphStageLogic.SubSinkInlet subSinkInlet = this.maybeInlet();
            return (GraphStageLogic.SubSinkInlet)OptionVal$.MODULE$.get$extension(subSinkInlet);
        }

        public boolean endStreamSent() {
            return this.endStreamSent;
        }

        public void endStreamSent_$eq(boolean x$1) {
            this.endStreamSent = x$1;
        }

        @Override
        public boolean canSend() {
            return this.buffer.nonEmpty() && this.outboundWindowLeft() > 0;
        }

        @Override
        public boolean isDone() {
            return this.endStreamSent();
        }

        public void enqueueIfPossible() {
            if (this.canSend() && !this.isEnqueued) {
                this.isEnqueued = true;
                this.$outer.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$enqueueOutStream(this.streamId());
                return;
            }
        }

        public void registerIncomingData(GraphStageLogic.SubSinkInlet<?> inlet) {
            GraphStageLogic.SubSinkInlet subSinkInlet = this.maybeInlet();
            Predef$.MODULE$.require(!OptionVal$.MODULE$.isDefined$extension(subSinkInlet));
            this.maybeInlet_$eq((GraphStageLogic.SubSinkInlet)OptionVal$Some$.MODULE$.apply(inlet));
            inlet.pull();
            inlet.setHandler(this);
        }

        public void addAllData(ByteString data) {
            Predef$.MODULE$.require(this.buffer.isEmpty());
            this.buffer = data;
            this.upstreamClosed = true;
            this.enqueueIfPossible();
        }

        @Override
        public FrameEvent.DataFrame nextFrame(int maxBytesToSend) {
            FrameEvent.ParsedHeadersFrame parsedHeadersFrame;
            boolean endStream;
            int toTake = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(maxBytesToSend), this.buffer.length())), this.outboundWindowLeft());
            ByteString toSend = this.buffer.take(toTake);
            Predef$.MODULE$.require(toSend.nonEmpty());
            this.outboundWindowLeft_$eq(this.outboundWindowLeft() - toTake);
            this.buffer = this.buffer.drop(toTake);
            boolean bl = endStream = this.upstreamClosed && this.buffer.isEmpty() && OptionVal$.MODULE$.isEmpty$extension(parsedHeadersFrame = this.trailer());
            if (endStream) {
                this.endStreamSent_$eq(true);
            } else {
                this.maybePull();
            }
            Http2StreamHandling LogHelperMacro_this = this.$outer;
            if (LogHelperMacro_this.isDebugEnabled()) {
                LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(86).append("[").append(this.streamId()).append("] sending ").append(toSend.length()).append(" bytes, endStream = ").append(endStream).append(", remaining buffer [").append(this.buffer.length()).append("], remaining stream-level WINDOW [").append(this.outboundWindowLeft()).append("]").toString()).toString());
            }
            this.isEnqueued = !this.isDone() && this.canSend();
            return FrameEvent$DataFrame$.MODULE$.apply(this.streamId(), endStream, toSend);
        }

        private boolean readyToSendFinalFrame() {
            return this.upstreamClosed && !this.endStreamSent() && this.buffer.isEmpty();
        }

        @Override
        public Option<FrameEvent> endStreamIfPossible() {
            if (this.readyToSendFinalFrame()) {
                FrameEvent.ParsedHeadersFrame parsedHeadersFrame = this.trailer();
                FrameEvent.StreamFrameEvent finalFrame = OptionVal$.MODULE$.getOrElse$extension(parsedHeadersFrame, FrameEvent$DataFrame$.MODULE$.apply(this.streamId(), true, ByteString$.MODULE$.empty()));
                this.endStreamSent_$eq(true);
                return Some$.MODULE$.apply(finalFrame);
            }
            return None$.MODULE$;
        }

        private void maybePull() {
            if (!(this.upstreamClosed || this.buffer.length() >= this.$outer.multiplexer().maxBytesToBufferPerSubstream() || this.inlet().hasBeenPulled() || this.inlet().isClosed())) {
                this.inlet().pull();
                return;
            }
        }

        private void cleanupStream() {
            this.buffer = ByteString$.MODULE$.empty();
            this.upstreamClosed = true;
            this.endStreamSent_$eq(true);
            GraphStageLogic.SubSinkInlet subSinkInlet = this.maybeInlet();
            GraphStageLogic.SubSinkInlet subSinkInlet2 = (GraphStageLogic.SubSinkInlet)OptionVal$Some$.MODULE$.unapply(subSinkInlet);
            if (!OptionVal$.MODULE$.isEmpty$extension(subSinkInlet2)) {
                GraphStageLogic.SubSinkInlet subSinkInlet3;
                GraphStageLogic.SubSinkInlet inlet = subSinkInlet3 = (GraphStageLogic.SubSinkInlet)OptionVal$.MODULE$.get$extension(subSinkInlet2);
                inlet.cancel();
                return;
            }
            OptionVal$.MODULE$.None();
            GraphStageLogic.SubSinkInlet subSinkInlet4 = subSinkInlet;
            if (!(null != null ? !((Object)null).equals(subSinkInlet4) : subSinkInlet4 != null)) {
                return;
            }
            throw new MatchError(new OptionVal<GraphStageLogic.SubSinkInlet>(subSinkInlet));
        }

        @Override
        public void cancelStream() {
            this.cleanupStream();
            if (this.isEnqueued) {
                this.$outer.multiplexer().closeStream(this.streamId());
                return;
            }
        }

        public int bufferedBytes() {
            return this.buffer.length();
        }

        @Override
        public void increaseWindow(int increment) {
            if (increment >= 0) {
                this.outboundWindowLeft_$eq(this.outboundWindowLeft() + increment);
                Http2StreamHandling LogHelperMacro_this = this.$outer;
                if (LogHelperMacro_this.isDebugEnabled()) {
                    LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(45).append("Updating window for ").append(this.streamId()).append(" by ").append(increment).append(" to ").append(this.outboundWindowLeft()).append(" buffered bytes: ").append(this.bufferedBytes()).toString()).toString());
                }
                this.enqueueIfPossible();
                return;
            }
        }

        @Override
        public void onPush() {
            Object obj = this.inlet().grab();
            if (obj instanceof ByteString) {
                ByteString newData = (ByteString)obj;
                this.buffer = this.buffer.$plus$plus(newData);
            } else if (obj instanceof HttpEntity.Chunk) {
                HttpEntity.Chunk chunk = HttpEntity$Chunk$.MODULE$.unapply((HttpEntity.Chunk)obj);
                ByteString byteString = chunk._1();
                String string2 = chunk._2();
                ByteString newData = byteString;
                this.buffer = this.buffer.$plus$plus(newData);
            } else if (obj instanceof HttpEntity.LastChunk) {
                FrameEvent.ParsedHeadersFrame parsedHeadersFrame;
                HttpEntity.LastChunk lastChunk = HttpEntity$LastChunk$.MODULE$.unapply((HttpEntity.LastChunk)obj);
                String string3 = lastChunk._1();
                Seq<HttpHeader> seq = lastChunk._2();
                Seq<HttpHeader> headers = seq;
                if (headers.nonEmpty() && !OptionVal$.MODULE$.isEmpty$extension(parsedHeadersFrame = this.trailer())) {
                    this.$outer.log().warning("Found both an attribute with trailing headers, and headers in the `LastChunk`. This is not supported.");
                }
                this.trailer_$eq((FrameEvent.ParsedHeadersFrame)OptionVal$Some$.MODULE$.apply(FrameEvent$ParsedHeadersFrame$.MODULE$.apply(this.streamId(), true, HttpMessageRendering$.MODULE$.renderHeaders(headers, this.$outer.log(), this.$outer.isServer(), false, DateHeaderRendering$.MODULE$.Unavailable()), None$.MODULE$)));
            } else {
                throw new MatchError(obj);
            }
            this.maybePull();
            this.enqueueIfPossible();
        }

        @Override
        public void onUpstreamFinish() {
            this.upstreamClosed = true;
            this.endStreamIfPossible().foreach(frame -> {
                this.$outer.multiplexer().pushControlFrame((FrameEvent)frame);
                this.$outer.handleOutgoingEnded(this.streamId());
                this.cleanupStream();
            });
        }

        @Override
        public void onUpstreamFailure(Throwable ex) {
            this.$outer.log().error(ex, new StringBuilder(23).append("Substream ").append(this.streamId()).append(" failed with ").append(ex).toString());
            this.$outer.multiplexer().pushControlFrame(FrameEvent$RstStreamFrame$.MODULE$.apply(this.streamId(), Http2Protocol$ErrorCode$INTERNAL_ERROR$.MODULE$));
            this.$outer.handleOutgoingFailed(this.streamId(), ex);
            this.cleanupStream();
        }

        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$OutStreamImpl$$$outer() {
            return this.$outer;
        }
    }

    public abstract class ReceivingData
    extends StreamState {
        public ReceivingData() {
            if (Http2StreamHandling.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public StreamState handle(FrameEvent.StreamFrameEvent event) {
            FrameEvent.StreamFrameEvent streamFrameEvent = event;
            if (streamFrameEvent instanceof FrameEvent.DataFrame) {
                FrameEvent.DataFrame d = (FrameEvent.DataFrame)streamFrameEvent;
                Http2StreamHandling.this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$outstandingConnectionLevelWindow_$eq(Http2StreamHandling.this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$outstandingConnectionLevelWindow() - d.sizeInWindow());
                Http2StreamHandling.this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$totalBufferedData_$eq(Http2StreamHandling.this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$totalBufferedData() + d.payload().length());
                if (Http2StreamHandling.this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$outstandingConnectionLevelWindow() < 0) {
                    this.shutdown();
                    Http2StreamHandling.this.pushGOAWAY(Http2Protocol$ErrorCode$FLOW_CONTROL_ERROR$.MODULE$, "Received more data than connection-level window would allow");
                    return Http2StreamHandling.this.Closed();
                }
                StreamState nextState = this.onDataFrame(d);
                int windowSizeIncrement = Http2StreamHandling.this.flowController().onConnectionDataReceived(Http2StreamHandling.this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$outstandingConnectionLevelWindow(), Http2StreamHandling.this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$totalBufferedData());
                if (windowSizeIncrement > 0) {
                    Http2StreamHandling.this.multiplexer().pushControlFrame(FrameEvent$WindowUpdateFrame$.MODULE$.apply(0, windowSizeIncrement));
                    Http2StreamHandling.this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$outstandingConnectionLevelWindow_$eq(Http2StreamHandling.this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$$outstandingConnectionLevelWindow() + windowSizeIncrement);
                }
                return nextState;
            }
            if (streamFrameEvent instanceof FrameEvent.RstStreamFrame) {
                FrameEvent.RstStreamFrame r = (FrameEvent.RstStreamFrame)streamFrameEvent;
                this.onRstStreamFrame(r);
                return Http2StreamHandling.this.Closed();
            }
            if (streamFrameEvent instanceof FrameEvent.ParsedHeadersFrame) {
                FrameEvent.ParsedHeadersFrame h = (FrameEvent.ParsedHeadersFrame)streamFrameEvent;
                return this.onTrailer(h);
            }
            if (streamFrameEvent instanceof FrameEvent.WindowUpdateFrame) {
                FrameEvent.WindowUpdateFrame w = (FrameEvent.WindowUpdateFrame)streamFrameEvent;
                return this.incrementWindow(w.windowSizeIncrement());
            }
            return this.receivedUnexpectedFrame(event);
        }

        public abstract StreamState onDataFrame(FrameEvent.DataFrame var1);

        public abstract StreamState onTrailer(FrameEvent.ParsedHeadersFrame var1);

        public abstract StreamState incrementWindow(int var1);

        public abstract void onRstStreamFrame(FrameEvent.RstStreamFrame var1);

        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$ReceivingData$$$outer() {
            return Http2StreamHandling.this;
        }
    }

    public abstract class ReceivingDataWithBuffer
    extends ReceivingData {
        private final StreamState afterEndStreamReceived;
        private final /* synthetic */ Http2StreamHandling $outer;

        public ReceivingDataWithBuffer(Http2StreamHandling $outer, StreamState afterEndStreamReceived) {
            this.afterEndStreamReceived = afterEndStreamReceived;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public abstract IncomingStreamBuffer buffer();

        @Override
        public StreamState onDataFrame(FrameEvent.DataFrame dataFrame) {
            this.buffer().onDataFrame(dataFrame);
            return this.afterBufferEvent();
        }

        @Override
        public StreamState onTrailer(FrameEvent.ParsedHeadersFrame parsedHeadersFrame) {
            this.buffer().onTrailingHeaders(parsedHeadersFrame);
            return this.afterBufferEvent();
        }

        @Override
        public void onRstStreamFrame(FrameEvent.RstStreamFrame rstStreamFrame) {
            this.buffer().onRstStreamFrame(rstStreamFrame);
        }

        @Override
        public StreamState incomingStreamPulled() {
            this.buffer().dispatchNextChunk();
            return this.afterBufferEvent();
        }

        @Override
        public void shutdown() {
            this.buffer().shutdown();
            super.shutdown();
        }

        @Override
        public abstract StreamState incrementWindow(int var1);

        public StreamState afterBufferEvent() {
            if (this.buffer().isDone()) {
                return this.afterEndStreamReceived;
            }
            return this;
        }

        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$ReceivingDataWithBuffer$$$outer() {
            return this.$outer;
        }
    }

    public interface Sending {
        public /* synthetic */ void org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$Sending$$super$shutdown();

        public OutStream outStream();

        public static Tuple2 pullNextFrame$(Sending $this, int maxSize) {
            return $this.pullNextFrame(maxSize);
        }

        default public Tuple2<StreamState, PullFrameResult> pullNextFrame(int maxSize) {
            PullFrameResult pullFrameResult;
            FrameEvent.DataFrame frame = this.outStream().nextFrame(maxSize);
            Option<FrameEvent> option = this.outStream().endStreamIfPossible();
            if (option instanceof Some) {
                FrameEvent trailer = (FrameEvent)((Some)option).value();
                pullFrameResult = PullFrameResult$SendFrameAndTrailer$.MODULE$.apply(frame, trailer);
            } else if (None$.MODULE$.equals(option)) {
                pullFrameResult = PullFrameResult$SendFrame$.MODULE$.apply(frame, this.outStream().canSend());
            } else {
                throw new MatchError(option);
            }
            PullFrameResult res = pullFrameResult;
            StreamState nextState = this.outStream().isDone() ? ((StreamState)((Object)this)).handleOutgoingEnded() : (StreamState)((Object)this);
            return Tuple2$.MODULE$.apply(nextState, res);
        }

        public static StreamState handleWindowUpdate$(Sending $this, FrameEvent.WindowUpdateFrame windowUpdate) {
            return $this.handleWindowUpdate(windowUpdate);
        }

        default public StreamState handleWindowUpdate(FrameEvent.WindowUpdateFrame windowUpdate) {
            return this.increaseWindow(windowUpdate.windowSizeIncrement());
        }

        public static StreamState handleOutgoingFailed$(Sending $this, Throwable cause) {
            return $this.handleOutgoingFailed(cause);
        }

        default public StreamState handleOutgoingFailed(Throwable cause) {
            return this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$Sending$$$outer().Closed();
        }

        public static void shutdown$(Sending $this) {
            $this.shutdown();
        }

        default public void shutdown() {
            this.outStream().cancelStream();
            this.org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$Sending$$super$shutdown();
        }

        public static StreamState increaseWindow$(Sending $this, int delta) {
            return $this.increaseWindow(delta);
        }

        default public StreamState increaseWindow(int delta) {
            this.outStream().increaseWindow(delta);
            return (StreamState)((Object)this);
        }

        public /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$Sending$$$outer();
    }

    public abstract class StreamState {
        public StreamState() {
            if (Http2StreamHandling.this == null) {
                throw new NullPointerException();
            }
        }

        public abstract StreamState handle(FrameEvent.StreamFrameEvent var1);

        public String stateName() {
            return ((Product)((Object)this)).productPrefix();
        }

        public StreamState handleOutgoingCreated(OutStream outStream, Map<AttributeKey<?>, ?> correlationAttributes) {
            Http2StreamHandling LogHelperMacro_this = Http2StreamHandling.this;
            if (LogHelperMacro_this.isWarningEnabled()) {
                LogHelperMacro_this.log().warning(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(129).append("handleOutgoingCreated received unexpectedly in state ").append(this.stateName()).append(". This indicates a bug in Pekko HTTP, please report it to the issue tracker.").toString()).toString());
            }
            return this;
        }

        public StreamState handleOutgoingCreatedAndFinished(Map<AttributeKey<?>, ?> correlationAttributes) {
            Http2StreamHandling LogHelperMacro_this = Http2StreamHandling.this;
            if (LogHelperMacro_this.isWarningEnabled()) {
                LogHelperMacro_this.log().warning(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(140).append("handleOutgoingCreatedAndFinished received unexpectedly in state ").append(this.stateName()).append(". This indicates a bug in Pekko HTTP, please report it to the issue tracker.").toString()).toString());
            }
            return this;
        }

        public StreamState handleOutgoingEnded() {
            Http2StreamHandling LogHelperMacro_this = Http2StreamHandling.this;
            if (LogHelperMacro_this.isWarningEnabled()) {
                LogHelperMacro_this.log().warning(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(127).append("handleOutgoingEnded received unexpectedly in state ").append(this.stateName()).append(". This indicates a bug in Pekko HTTP, please report it to the issue tracker.").toString()).toString());
            }
            return this;
        }

        public StreamState handleOutgoingFailed(Throwable cause) {
            Http2StreamHandling LogHelperMacro_this = Http2StreamHandling.this;
            if (LogHelperMacro_this.isWarningEnabled()) {
                LogHelperMacro_this.log().warning(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(128).append("handleOutgoingFailed received unexpectedly in state ").append(this.stateName()).append(". This indicates a bug in Pekko HTTP, please report it to the issue tracker.").toString()).toString());
            }
            return this;
        }

        public StreamState receivedUnexpectedFrame(FrameEvent.StreamFrameEvent e) {
            Http2StreamHandling LogHelperMacro_this = Http2StreamHandling.this;
            if (LogHelperMacro_this.isDebugEnabled()) {
                LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(56).append("Received unexpected frame of type ").append(e.frameTypeName()).append(" for stream ").append(e.streamId()).append(" in state ").append(this.stateName()).toString()).toString());
            }
            Http2StreamHandling.this.pushGOAWAY(Http2Protocol$ErrorCode$PROTOCOL_ERROR$.MODULE$, new StringBuilder(56).append("Received unexpected frame of type ").append(e.frameTypeName()).append(" for stream ").append(e.streamId()).append(" in state ").append(this.stateName()).toString());
            this.shutdown();
            return Http2StreamHandling.this.Closed();
        }

        public StreamState expectIncomingStream(FrameEvent.StreamFrameEvent event, StreamState nextStateEmpty, Function1<IncomingStreamBuffer, StreamState> nextStateStream, Map<AttributeKey<?>, ?> correlationAttributes) {
            FrameEvent.StreamFrameEvent streamFrameEvent = event;
            if (streamFrameEvent instanceof FrameEvent.ParsedHeadersFrame) {
                FrameEvent.ParsedHeadersFrame parsedHeadersFrame = (FrameEvent.ParsedHeadersFrame)streamFrameEvent;
                FrameEvent.ParsedHeadersFrame parsedHeadersFrame2 = FrameEvent$ParsedHeadersFrame$.MODULE$.unapply(parsedHeadersFrame);
                int n = parsedHeadersFrame2._1();
                boolean bl = parsedHeadersFrame2._2();
                Seq<Tuple2<String, Object>> seq = parsedHeadersFrame2._3();
                Option<FrameEvent.PriorityFrame> option = parsedHeadersFrame2._4();
                int streamId = n;
                boolean endStream = bl;
                FrameEvent.ParsedHeadersFrame frame = parsedHeadersFrame;
                if (endStream) {
                    Http2StreamHandling.this.dispatchSubstream(frame, package$.MODULE$.Left().apply(ByteString$.MODULE$.empty()), correlationAttributes);
                    return nextStateEmpty;
                }
                if (Http2StreamHandling.this.settings().minCollectStrictEntitySize() > 0) {
                    return Http2StreamHandling.this.CollectingIncomingData().apply(frame, correlationAttributes, ByteString$.MODULE$.empty(), 0);
                }
                return this.dispatchStream(streamId, frame, ByteString$.MODULE$.empty(), correlationAttributes, nextStateStream);
            }
            FrameEvent.StreamFrameEvent x = streamFrameEvent;
            return this.receivedUnexpectedFrame(x);
        }

        public Map<AttributeKey<?>, ?> expectIncomingStream$default$4() {
            return Predef$.MODULE$.Map().empty();
        }

        public StreamState dispatchStream(int streamId, FrameEvent.ParsedHeadersFrame headers, ByteString initialData, Map<AttributeKey<?>, ?> correlationAttributes, Function1<IncomingStreamBuffer, StreamState> nextStateStream) {
            GraphStageLogic.SubSourceOutlet<Object> subSource = new GraphStageLogic.SubSourceOutlet<Object>((GraphStageLogic)((Object)Http2StreamHandling.this), new StringBuilder(14).append("substream-out-").append(streamId).toString());
            IncomingStreamBuffer buffer = new IncomingStreamBuffer(Http2StreamHandling.this, streamId, subSource);
            if (initialData.nonEmpty()) {
                buffer.onDataFrame(FrameEvent$DataFrame$.MODULE$.apply(streamId, false, initialData));
            }
            Http2StreamHandling.this.dispatchSubstream(headers, package$.MODULE$.Right().apply(Source$.MODULE$.fromGraph(subSource.source())), correlationAttributes);
            return nextStateStream.apply(buffer);
        }

        public Tuple2<StreamState, PullFrameResult> pullNextFrame(int maxSize) {
            throw new IllegalStateException(new StringBuilder(37).append("pullNextFrame not supported in state ").append(this.stateName()).toString());
        }

        public StreamState incomingStreamPulled() {
            throw new IllegalStateException(new StringBuilder(44).append("incomingStreamPulled not supported in state ").append(this.stateName()).toString());
        }

        public void shutdown() {
        }

        public final /* synthetic */ Http2StreamHandling org$apache$pekko$http$impl$engine$http2$Http2StreamHandling$StreamState$$$outer() {
            return Http2StreamHandling.this;
        }
    }
}

