/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.HttpConnectionIdleTimeoutBidi$;
import org.apache.pekko.http.impl.engine.http2.Http2$;
import org.apache.pekko.http.impl.engine.http2.Http2AlpnSupport$;
import org.apache.pekko.http.impl.engine.http2.Http2Blueprint$;
import org.apache.pekko.http.impl.engine.http2.NoOpTelemetry$;
import org.apache.pekko.http.impl.engine.http2.ProtocolSwitch$;
import org.apache.pekko.http.impl.engine.http2.TelemetryAttributes$;
import org.apache.pekko.http.impl.engine.http2.TelemetrySpi;
import org.apache.pekko.http.impl.engine.http2.TelemetrySpi$;
import org.apache.pekko.http.impl.engine.server.GracefulTerminatorStage$;
import org.apache.pekko.http.impl.engine.server.MasterServerTerminator;
import org.apache.pekko.http.impl.engine.server.ServerTerminator;
import org.apache.pekko.http.impl.engine.server.UpgradeToOtherProtocolResponseHeader$;
import org.apache.pekko.http.impl.util.LogByteStringTools$;
import org.apache.pekko.http.javadsl.ConnectionContext;
import org.apache.pekko.http.javadsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.DeprecatedSslContextParameters;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.Http$ServerBinding$;
import org.apache.pekko.http.scaladsl.HttpExt;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.headers.Connection;
import org.apache.pekko.http.scaladsl.model.headers.Connection$;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.Upgrade;
import org.apache.pekko.http.scaladsl.model.headers.Upgrade$;
import org.apache.pekko.http.scaladsl.model.headers.UpgradeProtocol;
import org.apache.pekko.http.scaladsl.model.headers.UpgradeProtocol$;
import org.apache.pekko.http.scaladsl.model.http2.Http2SettingsHeader$;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.http.scaladsl.settings.ServerSettings$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.IgnoreComplete$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.TLSClosing$;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.impl.io.TlsUtils$;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.RunnableGraph;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.TLS$;
import org.apache.pekko.stream.scaladsl.TLSPlacebo$;
import org.apache.pekko.stream.scaladsl.Tcp;
import org.apache.pekko.stream.scaladsl.Tcp$;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

@InternalApi
public final class Http2Ext
implements Extension {
    private final ActorSystem system;
    private final HttpExt http;
    private final TelemetrySpi telemetry;
    private final Connection ConnectionUpgradeHeader;
    private final Upgrade UpgradeHeader;

    public Http2Ext(ActorSystem system) {
        this.system = system;
        int DefaultPortForProtocol = -1;
        this.http = Http$.MODULE$.apply(system);
        this.telemetry = TelemetrySpi$.MODULE$.create(system);
        this.ConnectionUpgradeHeader = Connection$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"upgrade"})));
        this.UpgradeHeader = Upgrade$.MODULE$.apply((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new UpgradeProtocol[]{UpgradeProtocol$.MODULE$.apply("h2c", UpgradeProtocol$.MODULE$.$lessinit$greater$default$2())})));
    }

    public ActorSystem system() {
        return this.system;
    }

    public HttpExt http() {
        return this.http;
    }

    public TelemetrySpi telemetry() {
        return this.telemetry;
    }

    public Future<Http.ServerBinding> bindAndHandleAsync(Function1<HttpRequest, Future<HttpResponse>> handler, String string2, int port, org.apache.pekko.http.scaladsl.ConnectionContext connectionContext, ServerSettings settings, LoggingAdapter log, Materializer fm) {
        Function2<Flow, Flow, Flow> & Serializable httpPlusSwitching;
        Function2<Flow, Flow, Flow> & Serializable intersect;
        if (((ConnectionContext)((Object)connectionContext)).isSecure()) {
            HttpsConnectionContext httpsConnectionContext = (HttpsConnectionContext)connectionContext;
            intersect = (Function2<Flow, Flow, Flow> & Serializable)(http1, http2) -> this.httpsWithAlpn(httpsConnectionContext, (Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsOutbound, ServerTerminator>)http1, (Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsOutbound, ServerTerminator>)http2);
        } else {
            intersect = httpPlusSwitching = (Function2<Flow, Flow, Flow> & Serializable)(http1, http2) -> Http2$.MODULE$.priorKnowledge((Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsOutbound, ServerTerminator>)http1, (Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsOutbound, ServerTerminator>)http2);
        }
        int effectivePort = port >= 0 ? port : (((ConnectionContext)((Object)connectionContext)).isSecure() ? settings.defaultHttpsPort() : settings.defaultHttpPort());
        Flow http12 = ((Flow)Flow$.MODULE$.apply().mapAsync(settings.pipeliningLimit(), this.handleUpgradeRequests(handler, settings, log))).joinMat(GracefulTerminatorStage$.MODULE$.apply(this.system(), settings).atop(this.http().serverLayer(settings, this.http().serverLayer$default$2(), log, this.http().serverLayer$default$4())), Keep$.MODULE$.right());
        Flow http22 = Http2Blueprint$.MODULE$.handleWithStreamIdHeader(settings.http2Settings().maxConcurrentStreams(), handler, this.system().dispatcher()).joinMat(Http2Blueprint$.MODULE$.serverStackTls(settings, log, this.telemetry(), ((HttpExt)Http$.MODULE$.apply((ClassicActorSystemProvider)this.system())).dateHeaderRendering()), Keep$.MODULE$.right());
        MasterServerTerminator masterTerminator = new MasterServerTerminator(log);
        TelemetrySpi telemetrySpi = this.telemetry();
        NoOpTelemetry$ noOpTelemetry$ = NoOpTelemetry$.MODULE$;
        return (Future)((RunnableGraph)((Source)((Source)((Source)((Tcp)Tcp$.MODULE$.apply((ClassicActorSystemProvider)this.system())).bind(string2, effectivePort, settings.backlog(), settings.socketOptions(), false, Duration$.MODULE$.Inf()).via(!(telemetrySpi != null ? !telemetrySpi.equals(noOpTelemetry$) : noOpTelemetry$ != null) ? Flow$.MODULE$.apply() : this.telemetry().serverBinding())).mapAsyncUnordered(settings.maxConnections(), (Function1<Tcp.IncomingConnection, Future> & Serializable)incoming -> {
            Future<Done> future;
            try {
                future = ((Future)((RunnableGraph)((Flow)((Flow)((Flow)httpPlusSwitching.apply(http12, http22)).addAttributes(this.prepareServerAttributes(settings, (Tcp.IncomingConnection)incoming))).watchTermination((Function2<Future, Future, Future> & Serializable)(x$1, x$2) -> {
                    Tuple2<Future, Future> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Future connectionTerminatorF = tuple2._1();
                        Future future = tuple2._2();
                        connectionTerminatorF.foreach(connectionTerminator -> {
                            masterTerminator.registerConnection((ServerTerminator)connectionTerminator, fm.executionContext());
                            future.onComplete(_$1 -> masterTerminator.removeConnection((ServerTerminator)connectionTerminator), fm.executionContext());
                        }, fm.executionContext());
                        return future;
                    }
                    throw new MatchError(tuple2);
                })).join(HttpConnectionIdleTimeoutBidi$.MODULE$.apply(ServerSettings$.MODULE$.timeoutsShortcut(settings).idleTimeout(), Some$.MODULE$.apply(incoming.remoteAddress())).join(incoming.flow())).addAttributes(Http$.MODULE$.cancellationStrategyAttributeForDelay(settings.streamCancellationDelay()))).run(fm)).recover(new Serializable(){

                    public final boolean isDefinedAt(Throwable x) {
                        Option<Throwable> option;
                        Throwable throwable = x;
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2;
                            Throwable ex = throwable2 = option.get();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Option<Throwable> option;
                        Throwable throwable = x;
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2;
                            Throwable ex = throwable2 = option.get();
                            return Done$.MODULE$;
                        }
                        return function1.apply(x);
                    }
                }, ExecutionContexts$.MODULE$.parasitic());
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    log.error(e, "Could not materialize handling flow for {}", incoming);
                    throw e;
                }
                throw throwable;
            }
            return future;
        })).mapMaterializedValue((Function1<Future, Future> & Serializable)_$2 -> _$2.map((Function1<Tcp.ServerBinding, Http.ServerBinding> & Serializable)tcpBinding -> Http$ServerBinding$.MODULE$.apply(tcpBinding.localAddress(), (Function0<Future<BoxedUnit>>)(Function0<Future> & Serializable)() -> tcpBinding.unbind(), (Function1<FiniteDuration, Future<Http.HttpTerminated>>)(Function1<FiniteDuration, Future> & Serializable)timeout -> masterTerminator.terminate((FiniteDuration)timeout, fm.executionContext())), fm.executionContext()))).to(Sink$.MODULE$.ignore())).run(fm);
    }

    public int bindAndHandleAsync$default$3() {
        return -1;
    }

    public ServerSettings bindAndHandleAsync$default$5() {
        return (ServerSettings)ServerSettings$.MODULE$.apply(this.system());
    }

    public LoggingAdapter bindAndHandleAsync$default$6() {
        return this.system().log();
    }

    private Attributes prepareServerAttributes(ServerSettings settings, Tcp.IncomingConnection incoming) {
        Attributes attrs = Http$.MODULE$.prepareAttributes(settings, incoming);
        TelemetrySpi telemetrySpi = this.telemetry();
        NoOpTelemetry$ noOpTelemetry$ = NoOpTelemetry$.MODULE$;
        if (!(telemetrySpi != null ? !telemetrySpi.equals(noOpTelemetry$) : noOpTelemetry$ != null)) {
            return attrs;
        }
        return attrs.and(incoming.flow().traversalBuilder().attributes());
    }

    private Function1<HttpRequest, Future<HttpResponse>> handleUpgradeRequests(Function1<HttpRequest, Future<HttpResponse>> handler, ServerSettings settings, LoggingAdapter log) {
        return (Function1<HttpRequest, Future> & Serializable)req -> {
            Upgrade upgrade;
            Option option = req.header(ClassTag$.MODULE$.apply(Upgrade.class));
            if (option instanceof Some && (upgrade = (Upgrade)((Some)option).value()).protocols().exists((Function1<UpgradeProtocol, boolean> & Serializable)_$3 -> _$3.name().equalsIgnoreCase("h2c"))) {
                SeqOps seqOps;
                Seq upgradeSettings;
                log.debug("Got h2c upgrade request from HTTP/1.1 to HTTP2");
                Seq seq = upgradeSettings = (Seq)req.headers().collect(new Serializable(log){
                    private final LoggingAdapter log$3;
                    {
                        this.log$3 = log$4;
                    }

                    public final boolean isDefinedAt(HttpHeader x) {
                        HttpHeader httpHeader = x;
                        if (httpHeader instanceof RawHeader) {
                            RawHeader raw = (RawHeader)httpHeader;
                            String string2 = raw.lowercaseName();
                            String string3 = Http2SettingsHeader$.MODULE$.name();
                            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                return true;
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(HttpHeader x, Function1 function1) {
                        HttpHeader httpHeader = x;
                        if (httpHeader instanceof RawHeader) {
                            RawHeader raw = (RawHeader)httpHeader;
                            String string2 = raw.lowercaseName();
                            String string3 = Http2SettingsHeader$.MODULE$.name();
                            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                return Http2SettingsHeader$.MODULE$.parse(raw.value(), this.log$3);
                            }
                        }
                        return function1.apply(x);
                    }
                });
                if (seq != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = Seq$.MODULE$.unapplySeq(seq), 1) == 0) {
                    Try try_ = (Try)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    if (try_ instanceof Success) {
                        Seq settingsFromHeader = (Seq)((Success)try_).value();
                        Source<HttpMessage, NotUsed> injectedRequest = Source$.MODULE$.single(req.addAttribute((AttributeKey)Http2$.MODULE$.streamId(), BoxesRunTime.boxToInteger(1)));
                        Flow<ByteString, ByteString, Object> serverLayer = Flow$.MODULE$.fromGraph(((Flow)((Flow)Flow$.MODULE$.apply().watchTermination(Keep$.MODULE$.right()).prepend(injectedRequest)).via(Http2Blueprint$.MODULE$.handleWithStreamIdHeader(settings.http2Settings().maxConcurrentStreams(), handler, this.system().dispatcher()))).joinMat(Http2Blueprint$.MODULE$.serverStack(settings, log, settingsFromHeader, true, this.telemetry(), ((HttpExt)Http$.MODULE$.apply((ClassicActorSystemProvider)this.system())).dateHeaderRendering()), Keep$.MODULE$.left()));
                        return Future$.MODULE$.successful(HttpResponse$.MODULE$.apply(StatusCodes$.MODULE$.SwitchingProtocols(), (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new HttpHeader[]{this.ConnectionUpgradeHeader(), this.UpgradeHeader(), UpgradeToOtherProtocolResponseHeader$.MODULE$.apply(serverLayer)})), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4()));
                    }
                    if (try_ instanceof Failure) {
                        Throwable e = ((Failure)try_).exception();
                        log.warning("Failed to parse http2-settings header in upgrade [{}], continuing with HTTP/1.1", (Object)e.getMessage());
                        return (Future)handler.apply((HttpRequest)req);
                    }
                }
                log.debug("Invalid upgrade request (http2-settings header missing or repeated)");
                return (Future)handler.apply((HttpRequest)req);
            }
            return (Future)handler.apply((HttpRequest)req);
        };
    }

    public Connection ConnectionUpgradeHeader() {
        return this.ConnectionUpgradeHeader;
    }

    public Upgrade UpgradeHeader() {
        return this.UpgradeHeader;
    }

    public Flow<ByteString, ByteString, Future<ServerTerminator>> httpsWithAlpn(HttpsConnectionContext httpsContext, Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsOutbound, ServerTerminator> http1, Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsOutbound, ServerTerminator> http2) {
        ObjectRef<None$> chosenProtocol = ObjectRef.create(None$.MODULE$);
        ObjectRef<None$> eng = ObjectRef.create(None$.MODULE$);
        BidiFlow<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound, NotUsed> tls = TLS$.MODULE$.apply((Function0<SSLEngine> & Serializable)() -> Http2Ext.createEngine$1(httpsContext, eng, chosenProtocol), (Function1<SSLSession, Try<BoxedUnit>>)(Function1<SSLSession, Try> & Serializable)_$4 -> Success$.MODULE$.apply(BoxedUnit.UNIT), IgnoreComplete$.MODULE$);
        return ProtocolSwitch$.MODULE$.apply((Function1<TLSProtocol.SessionBytes, String> & Serializable)_$5 -> Http2Ext.getChosenProtocol$1(chosenProtocol), http1, http2).join(tls);
    }

    public Flow<HttpRequest, HttpResponse, Future<Http.OutgoingConnection>> outgoingConnection(String host, int port, HttpsConnectionContext connectionContext, ClientConnectionSettings clientConnectionSettings, LoggingAdapter log) {
        BidiFlow stack = ((BidiFlow)Http2Blueprint$.MODULE$.clientStack(clientConnectionSettings, log, this.telemetry()).addAttributes(this.prepareClientAttributes(host, port))).atop(Http2Blueprint$.MODULE$.unwrapTls()).atop(LogByteStringTools$.MODULE$.logTLSBidiBySetting("client-plain-text", clientConnectionSettings.logUnencryptedNetworkBytes())).atop(TLS$.MODULE$.apply((Function0<SSLEngine> & Serializable)() -> Http2Ext.createEngine$2(connectionContext, host, port), TLSClosing$.MODULE$.eagerClose()));
        return stack.joinMat(clientConnectionSettings.transport().connectTo(host, port, clientConnectionSettings, this.system().classicSystem()), Keep$.MODULE$.right()).addAttributes(Http$.MODULE$.cancellationStrategyAttributeForDelay(clientConnectionSettings.streamCancellationDelay()));
    }

    public Flow<HttpRequest, HttpResponse, Future<Http.OutgoingConnection>> outgoingConnectionPriorKnowledge(String host, int port, ClientConnectionSettings clientConnectionSettings, LoggingAdapter log) {
        BidiFlow stack = ((BidiFlow)Http2Blueprint$.MODULE$.clientStack(clientConnectionSettings, log, this.telemetry()).addAttributes(this.prepareClientAttributes(host, port))).atop(Http2Blueprint$.MODULE$.unwrapTls()).atop(LogByteStringTools$.MODULE$.logTLSBidiBySetting("client-plain-text", clientConnectionSettings.logUnencryptedNetworkBytes())).atop(TLSPlacebo$.MODULE$.apply());
        return stack.joinMat(clientConnectionSettings.transport().connectTo(host, port, clientConnectionSettings, this.system().classicSystem()), Keep$.MODULE$.right()).addAttributes(Http$.MODULE$.cancellationStrategyAttributeForDelay(clientConnectionSettings.streamCancellationDelay()));
    }

    private Attributes prepareClientAttributes(String serverHost, int port) {
        TelemetrySpi telemetrySpi = this.telemetry();
        NoOpTelemetry$ noOpTelemetry$ = NoOpTelemetry$.MODULE$;
        if (!(telemetrySpi != null ? !telemetrySpi.equals(noOpTelemetry$) : noOpTelemetry$ != null)) {
            return Attributes$.MODULE$.none();
        }
        return TelemetryAttributes$.MODULE$.prepareClientFlowAttributes(serverHost, port);
    }

    private static final void setChosenProtocol$1(ObjectRef chosenProtocol$1, String protocol) {
        if (((Option)chosenProtocol$1.elem).isEmpty()) {
            Some some = Some$.MODULE$.apply(protocol);
            chosenProtocol$1.elem = some;
            some = null;
            return;
        }
        throw new IllegalStateException("ChosenProtocol was set twice. Http2.serverLayer is not reusable.");
    }

    private static final String getChosenProtocol$1$$anonfun$1() {
        return Http2AlpnSupport$.MODULE$.HTTP11();
    }

    private static final String getChosenProtocol$1(ObjectRef chosenProtocol$2) {
        return (String)((Option)chosenProtocol$2.elem).getOrElse(Http2Ext::getChosenProtocol$1$$anonfun$1);
    }

    private static final SSLEngine createEngine$1(HttpsConnectionContext httpsContext$2, ObjectRef eng$1, ObjectRef chosenProtocol$3) {
        SSLEngine sSLEngine;
        Either<DeprecatedSslContextParameters, Function1<Option<Tuple2<String, Object>>, SSLEngine>> either = httpsContext$2.sslContextData();
        if (either instanceof Left) {
            DeprecatedSslContextParameters ssl = (DeprecatedSslContextParameters)((Left)either).value();
            SSLEngine e = ssl.sslContext().createSSLEngine();
            TlsUtils$.MODULE$.applySessionParameters(e, ssl.firstSession());
            sSLEngine = e;
        } else if (either instanceof Right) {
            Function1 e = (Function1)((Right)either).value();
            sSLEngine = (SSLEngine)e.apply(None$.MODULE$);
        } else {
            throw new MatchError(either);
        }
        SSLEngine engine = sSLEngine;
        Some some = Some$.MODULE$.apply(engine);
        eng$1.elem = some;
        some = null;
        engine.setUseClientMode(false);
        return Http2AlpnSupport$.MODULE$.enableForServer(engine, protocol -> Http2Ext.setChosenProtocol$1(chosenProtocol$3, protocol));
    }

    private static final SSLEngine createEngine$2(HttpsConnectionContext connectionContext$1, String host$1, int port$1) {
        SSLEngine sSLEngine;
        Either<DeprecatedSslContextParameters, Function1<Option<Tuple2<String, Object>>, SSLEngine>> either = connectionContext$1.sslContextData();
        if (either instanceof Left) {
            DeprecatedSslContextParameters ssl = (DeprecatedSslContextParameters)((Left)either).value();
            SSLEngine e = ssl.sslContext().createSSLEngine(host$1, port$1);
            TlsUtils$.MODULE$.applySessionParameters(e, ssl.firstSession());
            sSLEngine = e;
        } else if (either instanceof Right) {
            Function1 e = (Function1)((Right)either).value();
            sSLEngine = (SSLEngine)e.apply(Some$.MODULE$.apply(Tuple2$.MODULE$.apply(host$1, BoxesRunTime.boxToInteger(port$1))));
        } else {
            throw new MatchError(either);
        }
        SSLEngine engine = sSLEngine;
        engine.setUseClientMode(true);
        Http2AlpnSupport$.MODULE$.clientSetApplicationProtocols(engine, new String[]{"h2"});
        return engine;
    }
}

