/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.Http2JDKAlpnSupport$;
import org.apache.pekko.http.impl.util.JavaVersion$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.sys.package$;
import scala.util.Try$;

@InternalApi
public final class Http2AlpnSupport$
implements Serializable {
    private static final String H2;
    private static final String HTTP11;
    public static final Http2AlpnSupport$ MODULE$;

    private Http2AlpnSupport$() {
    }

    static {
        MODULE$ = new Http2AlpnSupport$();
        H2 = "h2";
        HTTP11 = "http/1.1";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Http2AlpnSupport$.class);
    }

    public String H2() {
        return H2;
    }

    public String HTTP11() {
        return HTTP11;
    }

    public SSLEngine enableForServer(SSLEngine engine, Function1<String, BoxedUnit> setChosenProtocol) {
        if (this.isAlpnSupportedByJDK()) {
            return Http2JDKAlpnSupport$.MODULE$.jdkAlpnSupport(engine, setChosenProtocol);
        }
        throw new RuntimeException(new StringBuilder(77).append("Need to run on a JVM >= 8u252 for ALPN support needed for HTTP/2. Running on ").append(package$.MODULE$.props().apply("java.version")).toString());
    }

    public void clientSetApplicationProtocols(SSLEngine engine, String[] protocols) {
        if (this.isAlpnSupportedByJDK()) {
            Http2JDKAlpnSupport$.MODULE$.clientSetApplicationProtocols(engine, protocols);
            return;
        }
        throw new RuntimeException(new StringBuilder(77).append("Need to run on a JVM >= 8u252 for ALPN support needed for HTTP/2. Running on ").append(package$.MODULE$.props().apply("java.version")).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAlpnSupportedByJDK() {
        if (JavaVersion$.MODULE$.majorVersion() >= 9) return true;
        Object object = Predef$.MODULE$.refArrayOps(SSLEngine.class.getMethods());
        if (!ArrayOps$.MODULE$.exists$extension(object, (Function1<Method, boolean> & Serializable)_$1 -> {
            String string2 = _$1.getName();
            String string3 = "setHandshakeApplicationProtocolSelector";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        })) return false;
        boolean jettyAlpnClassesAvailable = Try$.MODULE$.apply(this::$anonfun$1).toOption().exists((Function1<Class, boolean> & Serializable)_$2 -> {
            Object object = Predef$.MODULE$.refArrayOps(_$2.getDeclaredMethods());
            return ArrayOps$.MODULE$.exists$extension(object, (Function1<Method, boolean> & Serializable)_$3 -> {
                String string2 = _$3.getName();
                String string3 = "init";
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            });
        });
        if (jettyAlpnClassesAvailable) {
            throw new RuntimeException("On JDK >= 8u252 you need to either remove jetty-alpn-agent or use version 2.0.10 (which is a noop)");
        }
        if (!true) return false;
        return true;
    }

    private final Class $anonfun$1() {
        return Class.forName("sun.security.ssl.ALPNExtension");
    }
}

