/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.client;

import org.apache.pekko.Done;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.client.PoolId;
import org.apache.pekko.http.impl.engine.client.PoolMaster$;
import org.apache.pekko.http.impl.engine.client.PoolMasterActor;
import org.apache.pekko.http.impl.engine.client.PoolMasterActor$PoolSize$;
import org.apache.pekko.http.impl.engine.client.PoolMasterActor$SendRequest$;
import org.apache.pekko.http.impl.engine.client.PoolMasterActor$Shutdown$;
import org.apache.pekko.http.impl.engine.client.PoolMasterActor$ShutdownAll$;
import org.apache.pekko.http.impl.engine.client.PoolMasterActor$StartPool$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.stream.Materializer;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;

@InternalApi
public class PoolMaster {
    private final ActorRef ref;

    public static PoolMaster apply(ExtendedActorSystem extendedActorSystem) {
        return PoolMaster$.MODULE$.apply(extendedActorSystem);
    }

    public PoolMaster(ActorRef ref) {
        this.ref = ref;
    }

    public ActorRef ref() {
        return this.ref;
    }

    public Future<HttpResponse> dispatchRequest(PoolId poolId, HttpRequest request, Materializer fm) {
        Promise<HttpResponse> responsePromise = Promise$.MODULE$.apply();
        PoolMasterActor.SendRequest sendRequest = PoolMasterActor$SendRequest$.MODULE$.apply(poolId, request, responsePromise, fm);
        this.ref().$bang(sendRequest, this.ref().$bang$default$2(sendRequest));
        return responsePromise.future();
    }

    public void startPool(PoolId poolId, Materializer fm) {
        PoolMasterActor.StartPool startPool = PoolMasterActor$StartPool$.MODULE$.apply(poolId, fm);
        this.ref().$bang(startPool, this.ref().$bang$default$2(startPool));
    }

    public Future<Done> shutdown(PoolId poolId) {
        Promise<Done> shutdownCompletedPromise = Promise$.MODULE$.apply();
        PoolMasterActor.Shutdown shutdown = PoolMasterActor$Shutdown$.MODULE$.apply(poolId, shutdownCompletedPromise);
        this.ref().$bang(shutdown, this.ref().$bang$default$2(shutdown));
        return shutdownCompletedPromise.future();
    }

    public Future<Done> shutdownAll() {
        Promise<Done> shutdownCompletedPromise = Promise$.MODULE$.apply();
        PoolMasterActor.ShutdownAll shutdownAll = PoolMasterActor$ShutdownAll$.MODULE$.apply(shutdownCompletedPromise);
        this.ref().$bang(shutdownAll, this.ref().$bang$default$2(shutdownAll));
        return shutdownCompletedPromise.future();
    }

    public Future<Object> poolSize() {
        Promise<Object> sizePromise = Promise$.MODULE$.apply();
        PoolMasterActor.PoolSize poolSize = PoolMasterActor$PoolSize$.MODULE$.apply(sizePromise);
        this.ref().$bang(poolSize, this.ref().$bang$default$2(poolSize));
        return sizePromise.future();
    }
}

