/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.client;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorRefFactory;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.LogSource;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.client.PoolFlow;
import org.apache.pekko.http.impl.engine.client.PoolFlow$RequestContext$;
import org.apache.pekko.http.impl.engine.client.PoolFlow$ResponseContext$;
import org.apache.pekko.http.impl.engine.client.PoolId;
import org.apache.pekko.http.impl.engine.client.PoolInterface$;
import org.apache.pekko.http.impl.engine.client.PoolInterface$ShutdownReason$;
import org.apache.pekko.http.impl.engine.client.PoolInterface$ShutdownReason$IdleTimeout$;
import org.apache.pekko.http.impl.engine.client.PoolInterface$ShutdownReason$ShutdownRequested$;
import org.apache.pekko.http.impl.engine.client.PoolMaster;
import org.apache.pekko.http.impl.settings.HostConnectionPoolSetup;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.impl.util.StreamUtils$CaptureTerminationOp$;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.impl.util.package$RichHttpRequest$;
import org.apache.pekko.http.javadsl.ConnectionContext;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.OptHttpResponse$;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Host$;
import org.apache.pekko.macros.LogHelper;
import org.apache.pekko.macros.LogHelperMacro;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.BufferOverflowException;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.stream.stage.TimerGraphStageLogic;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;

public interface PoolInterface {
    public static LogSource<PoolId> PoolLogSource() {
        return PoolInterface$.MODULE$.PoolLogSource();
    }

    public static PoolInterface apply(PoolId poolId, ActorRefFactory actorRefFactory, PoolMaster poolMaster, Materializer materializer) {
        return PoolInterface$.MODULE$.apply(poolId, actorRefFactory, poolMaster, materializer);
    }

    public void request(HttpRequest var1, Promise<HttpResponse> var2);

    public Future<ShutdownReason> shutdown(ExecutionContext var1);

    public Future<ShutdownReason> whenShutdown();

    @InternalStableApi
    public static class Logic
    extends TimerGraphStageLogic
    implements PoolInterface,
    InHandler,
    OutHandler,
    LogHelperMacro,
    LogHelper {
        private final PoolId poolId;
        private final PoolMaster master;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;
        private final int bufferSize;
        private final LoggingAdapter log;
        private final ExecutionContext executionContext;
        private final BufferOverflowException PoolOverflowException;
        private final HostConnectionPoolSetup hcps;
        private final Duration idleTimeout;
        private final Promise shutdownPromise;
        private Option shuttingDownReason;
        private int remainingRequested;
        private final ArrayDeque buffer;
        private final AsyncCallback responseCompletedCallback;
        private final AsyncCallback requestCallback;
        private final AsyncCallback shutdownCallback;

        public Logic(PoolId poolId, FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape, PoolMaster master, Outlet<PoolFlow.RequestContext> requestOut, Inlet<PoolFlow.ResponseContext> responseIn, int bufferSize, LoggingAdapter log, ExecutionContext executionContext) {
            this.poolId = poolId;
            this.master = master;
            this.requestOut = requestOut;
            this.responseIn = responseIn;
            this.bufferSize = bufferSize;
            this.log = log;
            this.executionContext = executionContext;
            super(shape);
            this.PoolOverflowException = new BufferOverflowException(new StringBuilder(376).append("Exceeded configured max-open-requests value of [").append(poolId.hcps().setup().settings().maxOpenRequests()).append("]. This means that the request queue of this pool (").append(poolId.hcps()).append(") ").append("has completely filled up because the pool currently does not process requests fast enough to handle the incoming request load. ").append("Please retry the request later. See https://pekko.apache.org/docs/pekko-http/current/scala/http/client-side/pool-overflow.html for ").append("more information.").toString());
            this.hcps = poolId.hcps();
            this.idleTimeout = this.hcps().setup().settings().idleTimeout();
            this.shutdownPromise = Promise$.MODULE$.apply();
            this.shuttingDownReason = None$.MODULE$;
            this.remainingRequested = 0;
            this.buffer = new ArrayDeque(bufferSize);
            this.setHandlers(responseIn, requestOut, this);
            this.responseCompletedCallback = this.getAsyncCallback(_$2 -> {
                this.remainingRequested_$eq(this.remainingRequested() - 1);
                this.afterRequestFinished();
            });
            this.requestCallback = this.getAsyncCallback(x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    HttpRequest request = (HttpRequest)tuple2._1();
                    Promise responsePromise = (Promise)tuple2._2();
                    String scheme = Uri$.MODULE$.httpScheme(((ConnectionContext)((Object)this.hcps().setup().connectionContext())).isSecure());
                    Host hostHeader = Host$.MODULE$.apply(this.hcps().host(), Uri$.MODULE$.normalizePort(this.hcps().port(), scheme));
                    HttpRequest effectiveRequest = this.onDispatch((HttpRequest)request.withUri(request.uri().toHttpRequestTargetOriginForm()).withDefaultHeaders((HttpHeader)hostHeader, ScalaRunTime$.MODULE$.wrapRefArray(new HttpHeader[0])));
                    int retries = request.method().isIdempotent() ? this.hcps().setup().settings().maxRetries() : 0;
                    this.remainingRequested_$eq(this.remainingRequested() + 1);
                    this.resetIdleTimer();
                    PoolFlow.RequestContext ctx = PoolFlow$RequestContext$.MODULE$.apply(effectiveRequest, responsePromise, retries);
                    if (this.isAvailable(requestOut)) {
                        Logic LogHelperMacro_this = this;
                        if (LogHelperMacro_this.isDebugEnabled()) {
                            LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(30).append("Dispatching request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] to pool").toString()).toString());
                        }
                        this.push(requestOut, ctx);
                        return;
                    }
                    if (this.buffer().size() < bufferSize) {
                        this.buffer().addLast(ctx);
                        Logic LogHelperMacro_this = this;
                        if (LogHelperMacro_this.isDebugEnabled()) {
                            LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(34).append("Buffering request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] at position ").append(this.buffer().size()).append("/").append(bufferSize).toString()).toString());
                            return;
                        }
                        return;
                    }
                    Logic LogHelperMacro_this = this;
                    if (LogHelperMacro_this.isDebugEnabled()) {
                        LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(52).append("Could not dispatch request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] because buffer is full").toString()).toString());
                    }
                    responsePromise.tryFailure(this.PoolOverflowException);
                    return;
                }
                throw new MatchError(tuple2);
            });
            this.shutdownCallback = this.getAsyncCallback(_$3 -> this.requestShutdown(PoolInterface$ShutdownReason$ShutdownRequested$.MODULE$));
        }

        @Override
        public LoggingAdapter log() {
            return this.log;
        }

        public HostConnectionPoolSetup hcps() {
            return this.hcps;
        }

        public Duration idleTimeout() {
            return this.idleTimeout;
        }

        public Promise<ShutdownReason> shutdownPromise() {
            return this.shutdownPromise;
        }

        public boolean shuttingDown() {
            return this.shuttingDownReason().isDefined();
        }

        public Option<ShutdownReason> shuttingDownReason() {
            return this.shuttingDownReason;
        }

        public void shuttingDownReason_$eq(Option<ShutdownReason> x$1) {
            this.shuttingDownReason = x$1;
        }

        public int remainingRequested() {
            return this.remainingRequested;
        }

        public void remainingRequested_$eq(int x$1) {
            this.remainingRequested = x$1;
        }

        public ArrayDeque<PoolFlow.RequestContext> buffer() {
            return this.buffer;
        }

        @Override
        public void preStart() {
            this.onInit(this.poolId);
            this.pull(this.responseIn);
            this.resetIdleTimer();
        }

        @Override
        public void onTimer(Object timerKey) {
            Logic LogHelperMacro_this = this;
            if (LogHelperMacro_this.isDebugEnabled()) {
                LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(89).append("Pool shutting down because pekko.http.host-connection-pool.idle-timeout triggered after ").append(this.idleTimeout()).append(".").toString()).toString());
            }
            this.requestShutdown(PoolInterface$ShutdownReason$IdleTimeout$.MODULE$);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void onPush() {
            block7: {
                block6: {
                    var2_1 = this.grab(this.responseIn);
                    if (var2_1 == null) {
                        throw new MatchError(var2_1);
                    }
                    var3_2 = PoolFlow$ResponseContext$.MODULE$.unapply(var2_1);
                    var4_3 = var3_2._1();
                    var5_4 = var3_2._2();
                    rc = var4_3;
                    response0 = var5_4;
                    var1_7 = Tuple2$.MODULE$.apply(rc, response0);
                    rc = var1_7._1();
                    response0 = var1_7._2();
                    ctx = this.onResponse(rc.request(), response0);
                    var12_11 = response0;
                    if (!(var12_11 instanceof Success)) break block6;
                    var13_12 = (HttpResponse)((Success)var12_11).value();
                    if (var13_12 == null || OptHttpResponse$.MODULE$.isEmpty$extension(var14_13 = HttpResponse$.MODULE$.unapply(var13_12))) ** GOTO lbl-1000
                    var15_14 = var14_13._1();
                    var16_15 = var14_13._2();
                    var17_16 = var14_13._3();
                    var18_17 = var14_13._4();
                    entity = var17_16;
                    r = var13_12;
                    if (!entity.isStrict()) {
                        var22_20 = StreamUtils$.MODULE$.transformEntityStream(entity, StreamUtils$CaptureTerminationOp$.MODULE$);
                        if (var22_20 == null) {
                            throw new MatchError(var22_20);
                        }
                        newEntity = var22_20._1();
                        termination = var22_20._2();
                        var21_23 = Tuple2$.MODULE$.apply(newEntity, termination);
                        newEntity = var21_23._1();
                        termination = var21_23._2();
                        termination.onComplete((JProcedure1<Try<T>>)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, $anonfun$1(scala.util.Try ), (Lscala/util/Try;)V)((Logic)this), this.executionContext);
                        v0 = Success$.MODULE$.apply(r.withEntity(newEntity));
                    } else lbl-1000:
                    // 2 sources

                    {
                        response = var13_12;
                        this.remainingRequested_$eq(this.remainingRequested() - 1);
                        v0 = Success$.MODULE$.apply(response);
                    }
                    break block7;
                }
                if (var12_11 instanceof Failure) {
                    this.remainingRequested_$eq(this.remainingRequested() - 1);
                    v0 = response0;
                } else {
                    throw new MatchError(var12_11);
                }
            }
            response1 = v0;
            rc.responsePromise().complete(response1);
            this.onResponseComplete(ctx);
            this.pull(this.responseIn);
            this.afterRequestFinished();
        }

        @Override
        public void onPull() {
            if (!this.buffer().isEmpty()) {
                PoolFlow.RequestContext ctx = this.buffer().removeFirst();
                Logic LogHelperMacro_this = this;
                if (LogHelperMacro_this.isDebugEnabled()) {
                    LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(63).append("Dispatching request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(ctx.request()))).append("] from buffer to pool. Remaining buffer: ").append(this.buffer().size()).append("/").append(this.bufferSize).toString()).toString());
                }
                this.push(this.requestOut, ctx);
                return;
            }
        }

        public AsyncCallback<Done> responseCompletedCallback() {
            return this.responseCompletedCallback;
        }

        public AsyncCallback<Tuple2<HttpRequest, Promise<HttpResponse>>> requestCallback() {
            return this.requestCallback;
        }

        public AsyncCallback<BoxedUnit> shutdownCallback() {
            return this.shutdownCallback;
        }

        public void afterRequestFinished() {
            this.shutdownIfRequestedAndPossible();
            this.resetIdleTimer();
        }

        public void requestShutdown(ShutdownReason reason) {
            this.shuttingDownReason_$eq(Some$.MODULE$.apply(reason));
            this.shutdownIfRequestedAndPossible();
        }

        public void shutdownIfRequestedAndPossible() {
            if (this.shuttingDown()) {
                if (this.remainingRequested() == 0) {
                    Logic LogHelperMacro_this = this;
                    if (LogHelperMacro_this.isDebugEnabled()) {
                        LogHelperMacro_this.log().debug(new StringBuilder(39).append(LogHelperMacro_this.prefixString()).append("Pool is now shutting down as requested.").toString());
                    }
                    this.shutdownPromise().trySuccess(this.shuttingDownReason().get());
                    this.completeStage();
                    return;
                }
                Logic LogHelperMacro_this = this;
                if (LogHelperMacro_this.isDebugEnabled()) {
                    LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(64).append("Pool is shutting down after waiting for [").append(this.remainingRequested()).append("] outstanding requests.").toString()).toString());
                    return;
                }
                return;
            }
        }

        public void resetIdleTimer() {
            this.cancelTimer(PoolInterface$.org$apache$pekko$http$impl$engine$client$PoolInterface$$$IdleTimeout);
            if (this.shouldStopOnIdle()) {
                this.scheduleOnce((Object)PoolInterface$.org$apache$pekko$http$impl$engine$client$PoolInterface$$$IdleTimeout, (FiniteDuration)this.idleTimeout());
                return;
            }
        }

        public boolean shouldStopOnIdle() {
            return !this.shuttingDown() && this.remainingRequested() == 0 && this.idleTimeout().isFinite() && this.hcps().setup().settings().minConnections() == 0;
        }

        @Override
        public void onUpstreamFailure(Throwable ex) {
            this.shutdownPromise().tryFailure(ex);
        }

        @Override
        public void postStop() {
            this.shutdownPromise().tryFailure(new IllegalStateException("Pool shutdown unexpectedly"));
        }

        @Override
        public void request(HttpRequest request, Promise<HttpResponse> responsePromise) {
            this.requestCallback().invokeWithFeedback(Tuple2$.MODULE$.apply(request, responsePromise)).failed().foreach((Function1<Throwable, Promise> & Serializable)_$4 -> {
                Logic LogHelperMacro_this = this;
                if (LogHelperMacro_this.isDebugEnabled()) {
                    LogHelperMacro_this.log().debug(new StringBuilder(106).append(LogHelperMacro_this.prefixString()).append("Request was sent to pool which was already closed, retrying through the master to create new pool instance").toString());
                }
                return responsePromise.tryCompleteWith(this.master.dispatchRequest(this.poolId, request, this.materializer()));
            }, this.executionContext);
        }

        @Override
        public Future<ShutdownReason> shutdown(ExecutionContext ec) {
            this.shutdownCallback().invoke(BoxedUnit.UNIT);
            return this.whenShutdown();
        }

        @Override
        public Future<ShutdownReason> whenShutdown() {
            return this.shutdownPromise().future();
        }

        @InternalStableApi
        public void onInit(PoolId poolId) {
        }

        @InternalStableApi
        public HttpRequest onDispatch(HttpRequest request) {
            return request;
        }

        @InternalStableApi
        public Object onResponse(HttpRequest request, Try<HttpResponse> response) {
            return None$.MODULE$;
        }

        @InternalStableApi
        public void onResponseComplete(Object any2) {
        }

        private final /* synthetic */ void $anonfun$1(Try _$1) {
            this.responseCompletedCallback().invoke(Done$.MODULE$);
        }
    }

    public static class PoolInterfaceStage
    extends GraphStageWithMaterializedValue<FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext>, PoolInterface> {
        private final PoolId poolId;
        private final PoolMaster master;
        private final int bufferSize;
        private final LoggingAdapter log;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;

        public PoolInterfaceStage(PoolId poolId, PoolMaster master, int bufferSize, LoggingAdapter log) {
            this.poolId = poolId;
            this.master = master;
            this.bufferSize = bufferSize;
            this.log = log;
            this.requestOut = Outlet$.MODULE$.apply("PoolInterface.requestOut");
            this.responseIn = Inlet$.MODULE$.apply("PoolInterface.responseIn");
        }

        @Override
        public FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape() {
            return FlowShape$.MODULE$.apply(this.responseIn, this.requestOut);
        }

        @Override
        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
            throw new IllegalStateException("Should not be called");
        }

        @Override
        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes, Materializer _materializer) {
            Logic logic = new Logic(this.poolId, (FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext>)this.shape(), this.master, this.requestOut, this.responseIn, this.bufferSize, this.log, _materializer.executionContext());
            return Tuple2$.MODULE$.apply(logic, logic);
        }
    }

    public static interface ShutdownReason {
        public static int ordinal(ShutdownReason shutdownReason) {
            return PoolInterface$ShutdownReason$.MODULE$.ordinal(shutdownReason);
        }
    }
}

