/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.client;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.client.PoolFlow$RequestContext$;
import org.apache.pekko.http.impl.engine.client.PoolFlow$ResponseContext$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import scala.Predef$;
import scala.Product;
import scala.concurrent.Promise;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try;

@InternalApi
public final class PoolFlow {

    public static class RequestContext
    implements Product,
    Serializable {
        private final HttpRequest request;
        private final Promise responsePromise;
        private final int retriesLeft;

        public static RequestContext apply(HttpRequest httpRequest, Promise<HttpResponse> promise, int n) {
            return PoolFlow$RequestContext$.MODULE$.apply(httpRequest, promise, n);
        }

        public static RequestContext fromProduct(Product product) {
            return PoolFlow$RequestContext$.MODULE$.fromProduct(product);
        }

        public static RequestContext unapply(RequestContext requestContext) {
            return PoolFlow$RequestContext$.MODULE$.unapply(requestContext);
        }

        public RequestContext(HttpRequest request, Promise<HttpResponse> responsePromise, int retriesLeft) {
            this.request = request;
            this.responsePromise = responsePromise;
            this.retriesLeft = retriesLeft;
            Predef$.MODULE$.require(retriesLeft >= 0);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.request()));
            n = Statics.mix(n, Statics.anyHash(this.responsePromise()));
            n = Statics.mix(n, this.retriesLeft());
            return Statics.finalizeHash(n, 3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RequestContext)) return false;
            RequestContext requestContext = (RequestContext)object;
            if (this.retriesLeft() != requestContext.retriesLeft()) return false;
            HttpRequest httpRequest = this.request();
            HttpRequest httpRequest2 = requestContext.request();
            if (httpRequest == null) {
                if (httpRequest2 != null) {
                    return false;
                }
            } else if (!((Object)httpRequest).equals(httpRequest2)) return false;
            Promise<HttpResponse> promise = this.responsePromise();
            Promise<HttpResponse> promise2 = requestContext.responsePromise();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!requestContext.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof RequestContext;
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "RequestContext";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger(this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "request";
                }
                case 1: {
                    return "responsePromise";
                }
                case 2: {
                    return "retriesLeft";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public HttpRequest request() {
            return this.request;
        }

        public Promise<HttpResponse> responsePromise() {
            return this.responsePromise;
        }

        public int retriesLeft() {
            return this.retriesLeft;
        }

        public boolean canBeRetried() {
            return this.retriesLeft() > 0;
        }

        public RequestContext copy(HttpRequest request, Promise<HttpResponse> responsePromise, int retriesLeft) {
            return new RequestContext(request, responsePromise, retriesLeft);
        }

        public HttpRequest copy$default$1() {
            return this.request();
        }

        public Promise<HttpResponse> copy$default$2() {
            return this.responsePromise();
        }

        public int copy$default$3() {
            return this.retriesLeft();
        }

        public HttpRequest _1() {
            return this.request();
        }

        public Promise<HttpResponse> _2() {
            return this.responsePromise();
        }

        public int _3() {
            return this.retriesLeft();
        }
    }

    public static class ResponseContext
    implements Product,
    Serializable {
        private final RequestContext rc;
        private final Try response;

        public static ResponseContext apply(RequestContext requestContext, Try<HttpResponse> try_) {
            return PoolFlow$ResponseContext$.MODULE$.apply(requestContext, try_);
        }

        public static ResponseContext fromProduct(Product product) {
            return PoolFlow$ResponseContext$.MODULE$.fromProduct(product);
        }

        public static ResponseContext unapply(ResponseContext responseContext) {
            return PoolFlow$ResponseContext$.MODULE$.unapply(responseContext);
        }

        public ResponseContext(RequestContext rc, Try<HttpResponse> response) {
            this.rc = rc;
            this.response = response;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResponseContext)) return false;
            ResponseContext responseContext = (ResponseContext)object;
            RequestContext requestContext = this.rc();
            RequestContext requestContext2 = responseContext.rc();
            if (requestContext == null) {
                if (requestContext2 != null) {
                    return false;
                }
            } else if (!((Object)requestContext).equals(requestContext2)) return false;
            Try<HttpResponse> try_ = this.response();
            Try<HttpResponse> try_2 = responseContext.response();
            if (try_ == null) {
                if (try_2 != null) {
                    return false;
                }
            } else if (!try_.equals(try_2)) return false;
            if (!responseContext.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof ResponseContext;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "ResponseContext";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "rc";
            }
            if (1 == n2) {
                return "response";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public RequestContext rc() {
            return this.rc;
        }

        public Try<HttpResponse> response() {
            return this.response;
        }

        public ResponseContext copy(RequestContext rc, Try<HttpResponse> response) {
            return new ResponseContext(rc, response);
        }

        public RequestContext copy$default$1() {
            return this.rc();
        }

        public Try<HttpResponse> copy$default$2() {
            return this.response();
        }

        public RequestContext _1() {
            return this.rc();
        }

        public Try<HttpResponse> _2() {
            return this.response();
        }
    }
}

