/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.extension.quartz;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.text.ParseException;
import java.util.TimeZone;
import org.apache.pekko.extension.quartz.QuartzCronSchedule;
import org.apache.pekko.extension.quartz.QuartzSchedule;
import org.quartz.CronExpression;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception;
import scala.util.control.Exception$;

public final class QuartzSchedules$
implements Serializable {
    private static final Exception.Catch catchMissing;
    private static final Exception.Catch catchWrongType;
    private static final Exception.Catch catchParseErr;
    public static final QuartzSchedules$ MODULE$;

    private QuartzSchedules$() {
    }

    static {
        MODULE$ = new QuartzSchedules$();
        catchMissing = Exception$.MODULE$.catching((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray(new Class[]{ConfigException.Missing.class}));
        catchWrongType = Exception$.MODULE$.catching((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray(new Class[]{ConfigException.WrongType.class}));
        catchParseErr = Exception$.MODULE$.catching((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray(new Class[]{ParseException.class}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(QuartzSchedules$.class);
    }

    public Exception.Catch<Nothing$> catchMissing() {
        return catchMissing;
    }

    public Exception.Catch<Nothing$> catchWrongType() {
        return catchWrongType;
    }

    public Exception.Catch<Nothing$> catchParseErr() {
        return catchParseErr;
    }

    public Map<String, QuartzSchedule> apply(Config config, TimeZone defaultTimezone) {
        return (Map)this.catchMissing().opt(() -> this.apply$$anonfun$1(config, defaultTimezone)).getOrElse(this::apply$$anonfun$2);
    }

    public QuartzSchedule parseSchedule(String name, Config config, TimeZone defaultTimezone) {
        TimeZone timezone = (TimeZone)this.catchMissing().opt(() -> this.$anonfun$1(config)).getOrElse(() -> this.$anonfun$2(defaultTimezone));
        Option<String> calendar = this.catchMissing().opt(() -> this.$anonfun$3(config)).flatten($less$colon$less$.MODULE$.refl());
        Option<String> desc = this.catchMissing().opt(() -> this.$anonfun$4(config));
        return this.parseCronSchedule(name, desc, config, timezone, calendar);
    }

    public QuartzCronSchedule parseCronSchedule(String name, Option<String> desc, Config config, TimeZone tz, Option<String> calendar) {
        Either either;
        Either either2 = this.catchMissing().or(this.catchWrongType()).either(() -> this.$anonfun$5(config));
        if (either2 instanceof Left) {
            Throwable t = (Throwable)((Left)either2).value();
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'expression' for Cron Schedule '%s'. You must provide a valid Quartz CronExpression."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name})), t);
        }
        if (either2 instanceof Right) {
            String str = (String)((Right)either2).value();
            either = this.catchParseErr().either(() -> this.$anonfun$6(str));
            if (either instanceof Left) {
                Throwable t = (Throwable)((Left)either).value();
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid 'expression' for Cron Schedule '%s'. Failed to validate CronExpression."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name})), t);
            }
            if (!(either instanceof Right)) {
                throw new MatchError(either);
            }
        } else {
            throw new MatchError(either2);
        }
        CronExpression expr = (CronExpression)((Right)either).value();
        CronExpression expression = expr;
        return new QuartzCronSchedule(name, desc, expression, tz, calendar);
    }

    private final Map apply$$anonfun$1(Config config$1, TimeZone defaultTimezone$1) {
        return (Map)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(config$1.getConfig("schedules").root()).asScala()).toMap($less$colon$less$.MODULE$.refl()).flatMap((Function1<Tuple2, Option> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ConfigValue configValue = (ConfigValue)tuple2._2();
                String key2 = (String)tuple2._1();
                if (configValue instanceof ConfigObject) {
                    ConfigObject value = (ConfigObject)configValue;
                    String string2 = Predef$.MODULE$.ArrowAssoc(key2);
                    return Some$.MODULE$.apply(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, this.parseSchedule(key2, value.toConfig(), defaultTimezone$1)));
                }
            }
            return None$.MODULE$;
        });
    }

    private final Map apply$$anonfun$2() {
        return Map$.MODULE$.empty();
    }

    private final TimeZone $anonfun$1(Config config$2) {
        return TimeZone.getTimeZone(config$2.getString("timezone"));
    }

    private final TimeZone $anonfun$2(TimeZone defaultTimezone$3) {
        return defaultTimezone$3;
    }

    private final Option $anonfun$3(Config config$3) {
        return Option$.MODULE$.apply(config$3.getString("calendar"));
    }

    private final String $anonfun$4(Config config$4) {
        return config$4.getString("description");
    }

    private final String $anonfun$5(Config config$5) {
        return config$5.getString("expression");
    }

    private final CronExpression $anonfun$6(String str$1) {
        return new CronExpression(str$1);
    }
}

