/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.extension.quartz;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.extension.quartz.QuartzCalendars$;
import org.apache.pekko.extension.quartz.QuartzCronSchedule;
import org.apache.pekko.extension.quartz.QuartzSchedule;
import org.apache.pekko.extension.quartz.QuartzSchedulerExtension$;
import org.apache.pekko.extension.quartz.QuartzSchedules$;
import org.apache.pekko.extension.quartz.SimpleActorMessageJob;
import org.apache.pekko.extension.quartz.package$;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;

public class QuartzSchedulerExtension
implements Extension {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(QuartzSchedulerExtension.class.getDeclaredField("scheduler$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(QuartzSchedulerExtension.class.getDeclaredField("jobStore$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(QuartzSchedulerExtension.class.getDeclaredField("threadPool$lzy1"));
    private final ActorSystem system;
    private final LoggingAdapter log;
    private final int threadCount;
    private final int threadPriority;
    private final boolean daemonThreads_$qmark;
    private final TimeZone defaultTimezone;
    private final TrieMap schedules;
    private final TrieMap runningJobs;
    private volatile Object threadPool$lzy1;
    private volatile Object jobStore$lzy1;
    private volatile Object scheduler$lzy1;

    public static Extension apply(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return QuartzSchedulerExtension$.MODULE$.apply(classicActorSystemProvider);
    }

    public static QuartzSchedulerExtension createExtension(ExtendedActorSystem extendedActorSystem) {
        return QuartzSchedulerExtension$.MODULE$.createExtension(extendedActorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.get(actorSystem);
    }

    public static QuartzSchedulerExtension get(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.get(actorSystem);
    }

    public static Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return QuartzSchedulerExtension$.MODULE$.get(classicActorSystemProvider);
    }

    public static QuartzSchedulerExtension$ lookup() {
        return QuartzSchedulerExtension$.MODULE$.lookup();
    }

    public QuartzSchedulerExtension(ActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply(system, this, package$.MODULE$.quartzExtensionLoggerType());
        this.threadCount = this.config().getInt("threadPool.threadCount");
        Predef$.MODULE$.require(this.threadCount() >= 1, QuartzSchedulerExtension::$init$$$anonfun$1);
        this.threadPriority = this.config().getInt("threadPool.threadPriority");
        Predef$.MODULE$.require(this.threadPriority() >= 1 && this.threadPriority() <= 10, QuartzSchedulerExtension::$init$$$anonfun$2);
        this.daemonThreads_$qmark = this.config().getBoolean("threadPool.daemonThreads");
        this.defaultTimezone = TimeZone.getTimeZone(this.config().getString("defaultTimezone"));
        this.schedules = new TrieMap();
        this.schedules().$plus$plus$eq((IterableOnce<Tuple2<String, QuartzSchedule>>)QuartzSchedules$.MODULE$.apply(this.config(), this.defaultTimezone()));
        this.runningJobs = new TrieMap();
        this.log.debug("Configured Schedules: {}", this.schedules());
        this.scheduler().start();
        this.initialiseCalendars();
    }

    public String schedulerName() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("QuartzScheduler~%s"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.system.name()}));
    }

    public Config config() {
        return this.system.settings().config().getConfig("pekko.quartz").root().toConfig();
    }

    public int threadCount() {
        return this.threadCount;
    }

    public int threadPriority() {
        return this.threadPriority;
    }

    public boolean daemonThreads_$qmark() {
        return this.daemonThreads_$qmark;
    }

    public TimeZone defaultTimezone() {
        return this.defaultTimezone;
    }

    public TrieMap<String, QuartzSchedule> schedules() {
        return this.schedules;
    }

    public TrieMap<String, JobKey> runningJobs() {
        return this.runningJobs;
    }

    public void standby() {
        this.scheduler().standby();
    }

    public boolean isInStandbyMode() {
        return this.scheduler().isInStandbyMode();
    }

    public boolean start() {
        if (this.isStarted()) {
            this.log.warning("Cannot start scheduler, already started.");
            return false;
        }
        this.scheduler().start();
        return true;
    }

    public boolean isStarted() {
        return this.scheduler().isStarted();
    }

    public Option<Date> nextTrigger(String name) {
        return this.runningJobs().get(name).flatMap((Function1<JobKey, Option> & Serializable)jobKey -> ((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getTriggersOfJob((JobKey)jobKey)).asScala()).headOption().map((Function1<Trigger, Date> & Serializable)trigger -> trigger.getNextFireTime()));
    }

    public void suspendAll() {
        this.log.info("Suspending all Quartz jobs.");
        this.scheduler().pauseAll();
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.scheduler().shutdown(waitForJobsToComplete);
    }

    public boolean shutdown$default$1() {
        return false;
    }

    public boolean suspendJob(String name) {
        Option<JobKey> option = this.runningJobs().get(name);
        if (option instanceof Some) {
            JobKey job = (JobKey)((Some)option).value();
            this.log.info("Suspending Quartz Job '{}'", name);
            this.scheduler().pauseJob(job);
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            this.log.warning("No running Job named '{}' found: Cannot suspend", (Object)name);
            return false;
        }
        throw new MatchError(option);
    }

    public boolean resumeJob(String name) {
        Option<JobKey> option = this.runningJobs().get(name);
        if (option instanceof Some) {
            JobKey job = (JobKey)((Some)option).value();
            this.log.info("Resuming Quartz Job '{}'", name);
            this.scheduler().resumeJob(job);
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            this.log.warning("No running Job named '{}' found: Cannot unpause", (Object)name);
            return false;
        }
        throw new MatchError(option);
    }

    public void resumeAll() {
        this.log.info("Resuming all Quartz jobs.");
        this.scheduler().resumeAll();
    }

    public boolean cancelJob(String name) {
        Option<JobKey> option = this.runningJobs().get(name);
        if (option instanceof Some) {
            JobKey job = (JobKey)((Some)option).value();
            this.log.info("Cancelling Quartz Job '{}'", name);
            boolean result = this.scheduler().deleteJob(job);
            this.runningJobs().$minus$eq(name);
            return result;
        }
        if (None$.MODULE$.equals(option)) {
            this.log.warning("No running Job named '{}' found: Cannot cancel", (Object)name);
            return false;
        }
        throw new MatchError(option);
    }

    public Date createJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.schedule(name, receiver, msg);
    }

    public Option<String> createJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> createJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone createJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public Date updateJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        return this.rescheduleJob(name, receiver, msg, description, cronExpression, calendar, timezone);
    }

    public Option<String> updateJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> updateJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone updateJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public boolean deleteJobSchedule(String name) {
        return this.unscheduleJob(name);
    }

    public void deleteAll() {
        this.log.info("Deleting all Quartz jobs.");
        this.runningJobs().clear();
        this.schedules().clear();
        this.scheduler().clear();
    }

    public boolean unscheduleJob(String name) {
        boolean isJobCancelled = this.cancelJob(name);
        if (isJobCancelled) {
            this.removeSchedule(name);
        }
        return isJobCancelled;
    }

    public void createSchedule(String name, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        Either either = Exception$.MODULE$.catching((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray(new Class[]{ParseException.class})).either(() -> QuartzSchedulerExtension.$anonfun$1(cronExpression));
        if (either instanceof Left) {
            Throwable t = (Throwable)((Left)either).value();
            throw new IllegalArgumentException(new StringBuilder(77).append("Invalid 'expression' for Cron Schedule '").append(name).append("'. Failed to validate CronExpression.").toString(), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        CronExpression expr = (CronExpression)((Right)either).value();
        CronExpression expression = expr;
        QuartzCronSchedule schedule = new QuartzCronSchedule(name, description, expression, timezone, calendar);
        Option<QuartzSchedule> option = this.schedules().putIfAbsent(name, schedule);
        if (option instanceof Some) {
            throw new IllegalArgumentException(new StringBuilder(44).append("A schedule with this name already exists: [").append(name).append("]").toString());
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public Option<String> createSchedule$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createSchedule$default$4() {
        return None$.MODULE$;
    }

    public TimeZone createSchedule$default$5() {
        return this.defaultTimezone();
    }

    public Date rescheduleJob(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.cancelJob(name);
        this.removeSchedule(name);
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.scheduleInternal(name, receiver, msg, None$.MODULE$);
    }

    public Option<String> rescheduleJob$default$4() {
        return None$.MODULE$;
    }

    public Option<String> rescheduleJob$default$6() {
        return None$.MODULE$;
    }

    public TimeZone rescheduleJob$default$7() {
        return this.defaultTimezone();
    }

    public TrieMap<String, QuartzSchedule> removeSchedule(String name) {
        return (TrieMap)this.schedules().$minus$eq(name);
    }

    public Date schedule(String name, ActorRef receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, None$.MODULE$);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, None$.MODULE$);
    }

    public Date schedule(String name, EventStream receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, None$.MODULE$);
    }

    public Date schedule(String name, ActorRef receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, EventStream receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date scheduleInternal(String name, Object receiver, Object msg, Option<Date> startDate) {
        Option<QuartzSchedule> option = this.schedules().get(name);
        if (option instanceof Some) {
            QuartzSchedule schedule = (QuartzSchedule)((Some)option).value();
            return this.scheduleJob(name, receiver, msg, startDate, schedule);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("No matching quartz configuration found for schedule '%s'"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name})));
        }
        throw new MatchError(option);
    }

    public Date scheduleJob(String name, Object receiver, Object msg, Option<Date> startDate, QuartzSchedule schedule) {
        this.log.info("Setting up scheduled job '{}', with '{}'", name, schedule);
        Tuple2[] tuple2Array = new Tuple2[3];
        String string2 = Predef$.MODULE$.ArrowAssoc("logBus");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, this.system.eventStream());
        String string3 = Predef$.MODULE$.ArrowAssoc("receiver");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, receiver);
        String string4 = Predef$.MODULE$.ArrowAssoc("message");
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, msg);
        Map jobDataMap = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
        JobDataMap jobData = JobDataMapSupport.newJobDataMap(JavaConverters$.MODULE$.mapAsJavaMapConverter(jobDataMap).asJava());
        JobDetail job = JobBuilder.newJob(SimpleActorMessageJob.class).withIdentity(new StringBuilder(4).append(name).append("_Job").toString()).usingJobData(jobData).withDescription((String)schedule.description().orNull($less$colon$less$.MODULE$.refl())).build();
        this.log.debug("Adding jobKey {} to runningJobs map.", job.getKey());
        String string5 = Predef$.MODULE$.ArrowAssoc(name);
        this.runningJobs().$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, job.getKey()));
        this.log.debug("Building Trigger with startDate '{}", startDate.getOrElse(QuartzSchedulerExtension::scheduleJob$$anonfun$1));
        Trigger trigger = schedule.buildTrigger(name, startDate);
        this.log.debug("Scheduling Job '{}' and Trigger '{}'. Is Scheduler Running? {}", job, trigger, BoxesRunTime.boxToBoolean(this.scheduler().isStarted()));
        return this.scheduler().scheduleJob(job, trigger);
    }

    public void initialiseCalendars() {
        QuartzCalendars$.MODULE$.apply(this.config(), this.defaultTimezone()).withFilter((Function1<Tuple2<String, Calendar>, Object>)(Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Calendar calendar = (Calendar)tuple2._2();
                return true;
            }
            return false;
        }).foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Calendar calendar = (Calendar)tuple2._2();
                this.log.info("Configuring Calendar '{}'", name);
                this.scheduler().addCalendar(name, calendar, true, true);
                return;
            }
            throw new MatchError(tuple2);
        });
        this.log.info(new StringBuilder(23).append("Initialized calendars: ").append(((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getCalendarNames()).asScala()).mkString(",")).toString());
    }

    public SimpleThreadPool threadPool() {
        Object object = this.threadPool$lzy1;
        if (object instanceof SimpleThreadPool) {
            return (SimpleThreadPool)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (SimpleThreadPool)this.threadPool$lzyINIT1();
    }

    private Object threadPool$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.threadPool$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SimpleThreadPool simpleThreadPool = null;
                    try {
                        SimpleThreadPool _tp = new SimpleThreadPool(this.threadCount(), this.threadPriority());
                        _tp.setThreadNamePrefix("PEKKO_QRTZ_");
                        _tp.setMakeThreadsDaemons(this.daemonThreads_$qmark());
                        simpleThreadPool = _tp;
                        object2 = simpleThreadPool == null ? LazyVals$NullValue$.MODULE$ : simpleThreadPool;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.threadPool$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.threadPool$lzy1;
                        LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                        waiting.countDown();
                    }
                    return simpleThreadPool;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public JobStore jobStore() {
        Object object = this.jobStore$lzy1;
        if (object instanceof JobStore) {
            return (JobStore)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (JobStore)this.jobStore$lzyINIT1();
    }

    private Object jobStore$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.jobStore$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RAMJobStore rAMJobStore = null;
                    try {
                        rAMJobStore = new RAMJobStore();
                        object2 = rAMJobStore == null ? LazyVals$NullValue$.MODULE$ : rAMJobStore;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.jobStore$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return rAMJobStore;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        Object object = this.scheduler$lzy1;
        if (object instanceof Scheduler) {
            return (Scheduler)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Scheduler)this.scheduler$lzyINIT1();
    }

    private Object scheduler$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.scheduler$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$2, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Scheduler scheduler = null;
                    try {
                        DirectSchedulerFactory.getInstance().createScheduler(this.schedulerName(), this.system.name(), this.threadPool(), this.jobStore());
                        Scheduler scheduler2 = DirectSchedulerFactory.getInstance().getScheduler(this.schedulerName());
                        this.log.debug("Initialized a Quartz Scheduler '{}'", scheduler2);
                        this.system.registerOnTermination((Function0<Object> & Serializable)() -> {
                            this.scheduler$lzyINIT1$$anonfun$1(scheduler2);
                            return BoxedUnit.UNIT;
                        });
                        scheduler = scheduler2;
                        object2 = scheduler == null ? LazyVals$NullValue$.MODULE$ : scheduler;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$2, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.scheduler$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$2, waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$2, LazyVals$Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.scheduler$lzy1;
                        LazyVals$.MODULE$.objCAS(this, OFFSET$2, waiting, object2);
                        waiting.countDown();
                    }
                    return scheduler;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$2, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final Object $init$$$anonfun$1() {
        return "Quartz Thread Count (pekko.quartz.threadPool.threadCount) must be a positive integer.";
    }

    private static final Object $init$$$anonfun$2() {
        return "Quartz Thread Priority (pekko.quartz.threadPool.threadPriority) must be a positive integer between 1 (lowest) and 10 (highest).";
    }

    private static final CronExpression $anonfun$1(String cronExpression$1) {
        return new CronExpression(cronExpression$1);
    }

    private static final Date scheduleJob$$anonfun$1() {
        return new Date();
    }

    private final void scheduler$lzyINIT1$$anonfun$1(Scheduler scheduler$1) {
        this.log.info("Shutting down Quartz Scheduler with ActorSystem Termination (Any jobs awaiting completion will end as well, as actors are ending)...");
        scheduler$1.shutdown(false);
    }
}

