/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.extension.quartz;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.quartz.CronExpression;
import org.quartz.impl.calendar.AnnualCalendar;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.impl.calendar.CronCalendar;
import org.quartz.impl.calendar.DailyCalendar;
import org.quartz.impl.calendar.HolidayCalendar;
import org.quartz.impl.calendar.MonthlyCalendar;
import org.quartz.impl.calendar.WeeklyCalendar;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception;
import scala.util.control.Exception$;

public final class QuartzCalendars$
implements Serializable {
    private static final Exception.Catch catchMissing;
    private static final Exception.Catch catchWrongType;
    private static final Exception.Catch catchParseErr;
    public static final QuartzCalendars$ MODULE$;

    private QuartzCalendars$() {
    }

    static {
        MODULE$ = new QuartzCalendars$();
        catchMissing = Exception$.MODULE$.catching((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray(new Class[]{ConfigException.Missing.class}));
        catchWrongType = Exception$.MODULE$.catching((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray(new Class[]{ConfigException.WrongType.class}));
        catchParseErr = Exception$.MODULE$.catching((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray(new Class[]{ParseException.class}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(QuartzCalendars$.class);
    }

    public Exception.Catch<Nothing$> catchMissing() {
        return catchMissing;
    }

    public Exception.Catch<Nothing$> catchWrongType() {
        return catchWrongType;
    }

    public Exception.Catch<Nothing$> catchParseErr() {
        return catchParseErr;
    }

    public Map<String, org.quartz.Calendar> apply(Config config, TimeZone defaultTimezone) {
        return (Map)this.catchMissing().opt(() -> this.apply$$anonfun$1(config, defaultTimezone)).getOrElse(this::apply$$anonfun$2);
    }

    public Calendar parseFmt(String raw, SimpleDateFormat fmt, TimeZone tz) {
        Calendar c = Calendar.getInstance(tz);
        c.setTime(fmt.parse(raw));
        return c;
    }

    public AnnualCalendar parseAnnualCalendar(String name, Config config, TimeZone tz) {
        SimpleDateFormat dateFmt = new SimpleDateFormat("MM-dd");
        dateFmt.setTimeZone(tz);
        Either either = this.catchMissing().or(this.catchWrongType()).either(() -> this.$anonfun$1(config));
        if (either instanceof Left) {
            Throwable t = (Throwable)((Left)either).value();
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDates' for Annual calendar '%s'. You must provide a list of ISO-8601 compliant dates ('YYYY-MM-DD')."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name})), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        List dates = (List)((Right)either).value();
        Buffer excludeDates = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(dates).asScala()).map((Function1<String, Calendar> & Serializable)d -> {
            Either either = this.catchParseErr().either(() -> this.$anonfun$2$$anonfun$1(d, dateFmt, tz));
            if (either instanceof Left) {
                Throwable t = (Throwable)((Left)either).value();
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid date '%s' in Annual Calendar '%s' - 'excludeDates'. You must provide an ISO-8601 compliant date ('YYYY-MM-DD')."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{d, name})), t);
            }
            if (either instanceof Right) {
                Calendar dt = (Calendar)((Right)either).value();
                return dt;
            }
            throw new MatchError(either);
        });
        AnnualCalendar cal = new AnnualCalendar();
        cal.setDaysExcluded(new ArrayList<Calendar>(JavaConverters$.MODULE$.bufferAsJavaListConverter(excludeDates).asJava()));
        return cal;
    }

    public HolidayCalendar parseHolidayCalendar(String name, Config config, TimeZone tz) {
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        dateFmt.setTimeZone(tz);
        Either either = this.catchMissing().or(this.catchWrongType()).either(() -> this.$anonfun$3(config));
        if (either instanceof Left) {
            Throwable t = (Throwable)((Left)either).value();
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDates' for Holiday Calendar '%s'. You must provide a list of ISO-8601 compliant dates ('YYYY-MM-DD')."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name})), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        List dates = (List)((Right)either).value();
        Buffer excludeDates = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(dates).asScala()).map((Function1<String, Date> & Serializable)d -> {
            Either either = this.catchParseErr().either(() -> this.$anonfun$4$$anonfun$1(d, dateFmt, tz));
            if (either instanceof Left) {
                Throwable t = (Throwable)((Left)either).value();
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid date '%s' in Holiday Calendar '%s' - 'excludeDates'. You must provide an ISO-8601 compliant date ('YYYY-MM-DD')."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{d, name})), t);
            }
            if (either instanceof Right) {
                Date dt = (Date)((Right)either).value();
                return dt;
            }
            throw new MatchError(either);
        });
        HolidayCalendar cal = new HolidayCalendar();
        excludeDates.foreach(x$0 -> cal.addExcludedDate((Date)x$0));
        return cal;
    }

    public DailyCalendar parseDailyCalendar(String name, Config config) {
        String startTime = this.parseTimeEntry$1(config, name, "exclude.startTime");
        String endTime = this.parseTimeEntry$1(config, name, "exclude.endTime");
        return new DailyCalendar(startTime, endTime);
    }

    public WeeklyCalendar parseWeeklyCalendar(String name, Config config) {
        Either either = this.catchMissing().or(this.catchWrongType()).either(() -> this.$anonfun$5(config));
        if (either instanceof Left) {
            Throwable t = (Throwable)((Left)either).value();
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDays' for Weekly Calendar '%s'. You must provide a list of Integers between 1 and 7."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name})), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        List days = (List)((Right)either).value();
        Buffer excludeDays = JavaConverters$.MODULE$.asScalaBufferConverter(days).asScala();
        boolean excludeWeekends = BoxesRunTime.unboxToBoolean(this.catchMissing().opt(() -> this.$anonfun$6(config)).getOrElse(this::$anonfun$7));
        Predef$.MODULE$.require(excludeDays.forall((Function1<Integer, boolean> & Serializable)d -> Predef$.MODULE$.Integer2int((Integer)d) <= 7 && Predef$.MODULE$.Integer2int((Integer)d) >= 1), () -> this.parseWeeklyCalendar$$anonfun$2(name));
        WeeklyCalendar cal = new WeeklyCalendar();
        excludeDays.foreach(_$1 -> cal.setDayExcluded(Predef$.MODULE$.Integer2int((Integer)_$1), true));
        if (!excludeWeekends) {
            if (excludeDays.contains(BoxesRunTime.boxToInteger(7)) || excludeDays.contains(BoxesRunTime.boxToInteger(1))) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Weekly Calendar '%s' - Cannot set 'excludeWeekends' to false when you have explicitly excluded Saturday (7) or Sunday (1)"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name})));
            }
            cal.setDayExcluded(1, false);
            cal.setDayExcluded(7, false);
        }
        return cal;
    }

    public MonthlyCalendar parseMonthlyCalendar(String name, Config config) {
        Either either = this.catchMissing().or(this.catchWrongType()).either(() -> this.$anonfun$8(config));
        if (either instanceof Left) {
            Throwable t = (Throwable)((Left)either).value();
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDays' for Monthly Calendar '%s'. You must provide a list of Integers between 1 and 31."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name})), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        List days = (List)((Right)either).value();
        Buffer excludeDays = JavaConverters$.MODULE$.asScalaBufferConverter(days).asScala();
        Predef$.MODULE$.require(excludeDays.forall((Function1<Integer, boolean> & Serializable)d -> Predef$.MODULE$.Integer2int((Integer)d) <= 31 && Predef$.MODULE$.Integer2int((Integer)d) >= 1), () -> this.parseMonthlyCalendar$$anonfun$2(name));
        MonthlyCalendar cal = new MonthlyCalendar();
        excludeDays.foreach(_$2 -> cal.setDayExcluded(Predef$.MODULE$.Integer2int((Integer)_$2), true));
        return cal;
    }

    public CronCalendar parseCronCalendar(String name, Config config) {
        String expr;
        Either either = this.catchMissing().or(this.catchWrongType()).either(() -> this.$anonfun$9(config));
        if (either instanceof Left) {
            Throwable t = (Throwable)((Left)either).value();
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeExpression' for Cron Calendar '%s'. You must provide a valid Quartz CronExpression."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name})), t);
        }
        if (either instanceof Right) {
            expr = (String)((Right)either).value();
            Either either2 = this.catchParseErr().either((Function0<Object> & Serializable)() -> {
                this.$anonfun$10(expr);
                return BoxedUnit.UNIT;
            });
            if (either2 instanceof Left) {
                Throwable t = (Throwable)((Left)either2).value();
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid 'excludeExpression' for Cron Calendar '%s'. Failed to validate CronExpression."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name})), t);
            }
            if (!(either2 instanceof Right)) {
                throw new MatchError(either2);
            }
        } else {
            throw new MatchError(either);
        }
        String exclude = expr;
        CronCalendar cal = new CronCalendar(exclude);
        return cal;
    }

    /*
     * Enabled aggressive block sorting
     */
    public org.quartz.Calendar parseCalendar(String name, Config config, TimeZone defaultTimezone) {
        BaseCalendar baseCalendar;
        Option description;
        TimeZone timezone;
        block10: {
            timezone = (TimeZone)this.catchMissing().opt(() -> this.$anonfun$11(config)).getOrElse(() -> this.$anonfun$12(defaultTimezone));
            description = this.catchMissing().opt(() -> this.$anonfun$13(config));
            Either either = this.catchMissing().either(() -> this.parseCalendar$$anonfun$1(config));
            if (either instanceof Left) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Calendar Type must be defined for ").append(name).toString());
            }
            if (!(either instanceof Right)) {
                throw new MatchError(either);
            }
            String typ = (String)((Right)either).value();
            String string2 = typ.toUpperCase();
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -1738378111: {
                    if (!"WEEKLY".equals(string2)) break;
                    baseCalendar = this.parseWeeklyCalendar(name, config);
                    break block10;
                }
                case 2077326: {
                    if (!"CRON".equals(string2)) break;
                    baseCalendar = this.parseCronCalendar(name, config);
                    break block10;
                }
                case 64808441: {
                    if (!"DAILY".equals(string2)) break;
                    baseCalendar = this.parseDailyCalendar(name, config);
                    break block10;
                }
                case 1809888312: {
                    if (!"HOLIDAY".equals(string2)) break;
                    baseCalendar = this.parseHolidayCalendar(name, config, timezone);
                    break block10;
                }
                case 1935336927: {
                    if (!"ANNUAL".equals(string2)) break;
                    baseCalendar = this.parseAnnualCalendar(name, config, timezone);
                    break block10;
                }
                case 1954618349: {
                    if (!"MONTHLY".equals(string2)) break;
                    baseCalendar = this.parseMonthlyCalendar(name, config);
                    break block10;
                }
            }
            String other = string2;
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unknown Quartz Calendar type '%s' for calendar '%s'. Valid types are Annual, Holiday, Daily, Monthly, Weekly, and Cron."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{other, name})));
        }
        BaseCalendar cal = baseCalendar;
        description.foreach(x$0 -> cal.setDescription((String)x$0));
        cal.setTimeZone(timezone);
        return cal;
    }

    private final Map apply$$anonfun$1(Config config$1, TimeZone defaultTimezone$1) {
        return (Map)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(config$1.getConfig("calendars").root()).asScala()).toMap($less$colon$less$.MODULE$.refl()).flatMap((Function1<Tuple2, Option> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ConfigValue configValue = (ConfigValue)tuple2._2();
                String key2 = (String)tuple2._1();
                if (configValue instanceof ConfigObject) {
                    ConfigObject value = (ConfigObject)configValue;
                    String string2 = Predef$.MODULE$.ArrowAssoc(key2);
                    return Some$.MODULE$.apply(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, this.parseCalendar(key2, value.toConfig(), defaultTimezone$1)));
                }
            }
            return None$.MODULE$;
        });
    }

    private final Map apply$$anonfun$2() {
        return Map$.MODULE$.empty();
    }

    private final List $anonfun$1(Config config$2) {
        return config$2.getStringList("excludeDates");
    }

    private final Calendar $anonfun$2$$anonfun$1(String d$1, SimpleDateFormat dateFmt$1, TimeZone tz$1) {
        return this.parseFmt(d$1, dateFmt$1, tz$1);
    }

    private final List $anonfun$3(Config config$3) {
        return config$3.getStringList("excludeDates");
    }

    private final Date $anonfun$4$$anonfun$1(String d$2, SimpleDateFormat dateFmt$3, TimeZone tz$3) {
        return this.parseFmt(d$2, dateFmt$3, tz$3).getTime();
    }

    private final String parseTimeEntry$1$$anonfun$1(Config config$5, String entry$1) {
        return config$5.getString(entry$1);
    }

    private final String parseTimeEntry$1(Config config$4, String name$3, String entry) {
        Either either = this.catchMissing().or(this.catchWrongType()).either(() -> this.parseTimeEntry$1$$anonfun$1(config$4, entry));
        if (either instanceof Left) {
            Throwable t = (Throwable)((Left)either).value();
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry '%s' for Daily Calendar '%s'. You must provide a time in the format 'HH:MM[:SS[:mmm]]'"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{entry, name$3})), t);
        }
        if (either instanceof Right) {
            String rawTime = (String)((Right)either).value();
            return rawTime;
        }
        throw new MatchError(either);
    }

    private final List $anonfun$5(Config config$6) {
        return config$6.getIntList("excludeDays");
    }

    private final boolean $anonfun$6(Config config$7) {
        return config$7.getBoolean("excludeWeekends");
    }

    private final boolean $anonfun$7() {
        return true;
    }

    private final Object parseWeeklyCalendar$$anonfun$2(String name$4) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Weekly Calendar '%s' - 'excludeDays' must consist of a list of Integers between 1 and 7"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name$4}));
    }

    private final List $anonfun$8(Config config$8) {
        return config$8.getIntList("excludeDays");
    }

    private final Object parseMonthlyCalendar$$anonfun$2(String name$5) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Monthly Calendar '%s' - 'excludeDays' must consist of a list of Integers between 1 and 31"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name$5}));
    }

    private final String $anonfun$9(Config config$9) {
        return config$9.getString("excludeExpression");
    }

    private final void $anonfun$10(String expr$1) {
        CronExpression.validateExpression(expr$1);
    }

    private final TimeZone $anonfun$11(Config config$10) {
        return TimeZone.getTimeZone(config$10.getString("timezone"));
    }

    private final TimeZone $anonfun$12(TimeZone defaultTimezone$3) {
        return defaultTimezone$3;
    }

    private final String $anonfun$13(Config config$11) {
        return config$11.getString("description");
    }

    private final String parseCalendar$$anonfun$1(Config config$12) {
        return config$12.getString("type");
    }
}

