/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.event.slf4j;

import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.LogMarker;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.Logging$LogLevel$;
import org.apache.pekko.event.LoggingFilterWithMarker;
import org.apache.pekko.event.slf4j.Logger$;
import org.apache.pekko.event.slf4j.Slf4jLogMarker;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Slf4jLoggingFilter
implements LoggingFilterWithMarker {
    private final EventStream eventStream;

    public Slf4jLoggingFilter(ActorSystem.Settings settings, EventStream eventStream) {
        this.eventStream = eventStream;
    }

    @Override
    public boolean isErrorEnabled(Class<?> logClass, String logSource) {
        return Logging$LogLevel$.MODULE$.$greater$eq$extension(this.eventStream.logLevel(), Logging$.MODULE$.ErrorLevel()) && Logger$.MODULE$.apply(logClass, logSource).isErrorEnabled();
    }

    @Override
    public boolean isWarningEnabled(Class<?> logClass, String logSource) {
        return Logging$LogLevel$.MODULE$.$greater$eq$extension(this.eventStream.logLevel(), Logging$.MODULE$.WarningLevel()) && Logger$.MODULE$.apply(logClass, logSource).isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled(Class<?> logClass, String logSource) {
        return Logging$LogLevel$.MODULE$.$greater$eq$extension(this.eventStream.logLevel(), Logging$.MODULE$.InfoLevel()) && Logger$.MODULE$.apply(logClass, logSource).isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled(Class<?> logClass, String logSource) {
        return Logging$LogLevel$.MODULE$.$greater$eq$extension(this.eventStream.logLevel(), Logging$.MODULE$.DebugLevel()) && Logger$.MODULE$.apply(logClass, logSource).isDebugEnabled();
    }

    private Marker slf4jMarker(LogMarker marker) {
        LogMarker logMarker = marker;
        if (logMarker == null) {
            return null;
        }
        if (logMarker instanceof Slf4jLogMarker) {
            Slf4jLogMarker slf4jMarker = (Slf4jLogMarker)logMarker;
            return slf4jMarker.marker();
        }
        LogMarker marker2 = logMarker;
        return MarkerFactory.getMarker(marker2.name());
    }

    @Override
    public boolean isErrorEnabled(Class<?> logClass, String logSource, LogMarker marker) {
        return Logging$LogLevel$.MODULE$.$greater$eq$extension(this.eventStream.logLevel(), Logging$.MODULE$.ErrorLevel()) && Logger$.MODULE$.apply(logClass, logSource).isErrorEnabled(this.slf4jMarker(marker));
    }

    @Override
    public boolean isWarningEnabled(Class<?> logClass, String logSource, LogMarker marker) {
        return Logging$LogLevel$.MODULE$.$greater$eq$extension(this.eventStream.logLevel(), Logging$.MODULE$.WarningLevel()) && Logger$.MODULE$.apply(logClass, logSource).isWarnEnabled(this.slf4jMarker(marker));
    }

    @Override
    public boolean isInfoEnabled(Class<?> logClass, String logSource, LogMarker marker) {
        return Logging$LogLevel$.MODULE$.$greater$eq$extension(this.eventStream.logLevel(), Logging$.MODULE$.InfoLevel()) && Logger$.MODULE$.apply(logClass, logSource).isInfoEnabled(this.slf4jMarker(marker));
    }

    @Override
    public boolean isDebugEnabled(Class<?> logClass, String logSource, LogMarker marker) {
        return Logging$LogLevel$.MODULE$.$greater$eq$extension(this.eventStream.logLevel(), Logging$.MODULE$.DebugLevel()) && Logger$.MODULE$.apply(logClass, logSource).isDebugEnabled(this.slf4jMarker(marker));
    }
}

