/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.event;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystemImpl;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.InvalidActorNameException;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.UnhandledMessage;
import org.apache.pekko.actor.UnhandledMessage$;
import org.apache.pekko.event.ActorEventBus;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.Logging$Debug$;
import org.apache.pekko.event.Logging$Error$;
import org.apache.pekko.event.Logging$InitializeLogger$;
import org.apache.pekko.event.Logging$LogExt$;
import org.apache.pekko.event.Logging$LogLevel$;
import org.apache.pekko.event.Logging$LoggerInitialized$;
import org.apache.pekko.event.Logging$Warning$;
import org.apache.pekko.event.LoggingBus$;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.util.ReentrantGuard;
import org.apache.pekko.util.Timeout;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface LoggingBus
extends ActorEventBus {
    public static void $init$(LoggingBus $this) {
        $this.org$apache$pekko$event$LoggingBus$_setter_$org$apache$pekko$event$LoggingBus$$guard_$eq(new ReentrantGuard());
        $this.org$apache$pekko$event$LoggingBus$$loggers_$eq((Seq)package$.MODULE$.Seq().empty());
    }

    public ReentrantGuard org$apache$pekko$event$LoggingBus$$guard();

    public void org$apache$pekko$event$LoggingBus$_setter_$org$apache$pekko$event$LoggingBus$$guard_$eq(ReentrantGuard var1);

    public Seq<ActorRef> org$apache$pekko$event$LoggingBus$$loggers();

    public void org$apache$pekko$event$LoggingBus$$loggers_$eq(Seq<ActorRef> var1);

    public int org$apache$pekko$event$LoggingBus$$_logLevel();

    public void org$apache$pekko$event$LoggingBus$$_logLevel_$eq(int var1);

    public static int logLevel$(LoggingBus $this) {
        return $this.logLevel();
    }

    default public int logLevel() {
        return this.org$apache$pekko$event$LoggingBus$$_logLevel();
    }

    public static void setLogLevel$(LoggingBus $this, int level) {
        $this.setLogLevel(level);
    }

    default public void setLogLevel(int level) {
        this.org$apache$pekko$event$LoggingBus$$guard().withGuard((Function0<Object> & Serializable)() -> {
            this.setLogLevel$$anonfun$1(level);
            return BoxedUnit.UNIT;
        });
    }

    private void setUpStdoutLogger(ActorSystem.Settings config) {
        Object b = Logging$.MODULE$.levelFor(config.StdoutLogLevel()).getOrElse((Function0<Object> & Serializable)() -> new Logging.LogLevel(this.$anonfun$1(config)));
        int level = b == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)b).asInt();
        ((IterableOnceOps)Logging$.MODULE$.AllLogLevels().filter((Function1<Object, boolean> & Serializable)_$2 -> Logging$LogLevel$.MODULE$.$greater$eq$extension(level, _$2 == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)_$2).asInt()))).foreach((Function1<Object, boolean> & Serializable)l -> this.setUpStdoutLogger$$anonfun$2(l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt()));
        this.org$apache$pekko$event$LoggingBus$$guard().withGuard((Function0<Object> & Serializable)() -> {
            this.setUpStdoutLogger$$anonfun$3(level);
            return BoxedUnit.UNIT;
        });
    }

    public static void startStdoutLogger$(LoggingBus $this, ActorSystem.Settings config) {
        $this.startStdoutLogger(config);
    }

    default public void startStdoutLogger(ActorSystem.Settings config) {
        this.setUpStdoutLogger(config);
        this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), "StandardOutLogger started"));
    }

    public static void startDefaultLoggers$(LoggingBus $this, ActorSystemImpl system) {
        $this.startDefaultLoggers(system);
    }

    default public void startDefaultLoggers(ActorSystemImpl system) {
        String logName = new StringBuilder(2).append(Logging$.MODULE$.simpleName(this)).append("(").append(system).append(")").toString();
        Object b = Logging$.MODULE$.levelFor(system.settings().LogLevel()).getOrElse((Function0<Object> & Serializable)() -> new Logging.LogLevel(this.$anonfun$2(logName, system)));
        int level = b == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)b).asInt();
        try {
            Seq<String> seq;
            Seq<String> seq2 = system.settings().Loggers();
            Nil$ nil$ = package$.MODULE$.Nil();
            Seq<String> seq3 = seq2;
            if (!(nil$ != null ? !((Object)nil$).equals(seq3) : seq3 != null)) {
                String string2 = Logging.DefaultLogger.class.getName();
                seq = package$.MODULE$.Nil().$colon$colon(string2);
            } else {
                Seq<String> loggers;
                seq = loggers = seq2;
            }
            Seq<String> defaultLoggers = seq;
            Seq myloggers = (Seq)defaultLoggers.withFilter((Function1<String, boolean> & Serializable)loggerName -> {
                String string2 = loggerName;
                String string3 = Logging$.MODULE$.StandardOutLogger().getClass().getName();
                return string2 == null ? string3 != null : !string2.equals(string3);
            }).map((Function1<String, ActorRef> & Serializable)loggerName -> system.dynamicAccess().getClassFor((String)loggerName, ClassTag$.MODULE$.apply(Actor.class)).map((Function1<Class, ActorRef> & Serializable)actorClass -> this.addLogger(system, (Class<? extends Actor>)actorClass, level, logName)).recover(new Serializable((String)loggerName){
                private final String loggerName$1;
                {
                    this.loggerName$1 = loggerName$2;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    throw new ConfigurationException(new StringBuilder(55).append("Logger specified in config can't be loaded [").append(this.loggerName$1).append("] due to [").append(e.toString()).append("]").toString(), e);
                }
            }).get());
            this.org$apache$pekko$event$LoggingBus$$guard().withGuard((Function0<Object> & Serializable)() -> {
                this.startDefaultLoggers$$anonfun$1(myloggers, level);
                return BoxedUnit.UNIT;
            });
            try {
                if (system.settings().DebugUnhandledMessage()) {
                    this.subscribe(system.systemActorOf(Props$.MODULE$.apply(this::startDefaultLoggers$$anonfun$2, ClassTag$.MODULE$.apply(Actor.class)), "UnhandledMessageForwarder"), UnhandledMessage.class);
                }
            }
            catch (InvalidActorNameException invalidActorNameException) {}
            this.publish(Logging$Debug$.MODULE$.apply(logName, this.getClass(), "Default Loggers started"));
            if (!defaultLoggers.contains(Logging$.MODULE$.StandardOutLogger().getClass().getName())) {
                this.unsubscribe(Logging$.MODULE$.StandardOutLogger());
            }
        }
        catch (Exception e) {
            System.err.println("error while starting up loggers");
            e.printStackTrace();
            throw new ConfigurationException(new StringBuilder(32).append("Could not start logger due to [").append(e.toString()).append("]").toString());
        }
    }

    public static void stopDefaultLoggers$(LoggingBus $this, ActorSystem system) {
        $this.stopDefaultLoggers(system);
    }

    default public void stopDefaultLoggers(ActorSystem system) {
        int level = this.org$apache$pekko$event$LoggingBus$$_logLevel();
        if (!this.org$apache$pekko$event$LoggingBus$$loggers().contains(Logging$.MODULE$.StandardOutLogger())) {
            this.setUpStdoutLogger(system.settings());
            this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), "shutting down: StandardOutLogger"));
        }
        this.org$apache$pekko$event$LoggingBus$$loggers().withFilter((Function1<ActorRef, boolean> & Serializable)logger -> {
            ActorRef actorRef = logger;
            Logging.StandardOutLogger standardOutLogger = Logging$.MODULE$.StandardOutLogger();
            return actorRef == null ? standardOutLogger != null : !((Object)actorRef).equals(standardOutLogger);
        }).foreach(logger -> {
            this.unsubscribe(logger);
            ActorRef actorRef = logger;
            if (actorRef instanceof InternalActorRef) {
                InternalActorRef ref = (InternalActorRef)actorRef;
                ref.stop();
                return;
            }
        });
        this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), "all default loggers stopped"));
    }

    private ActorRef addLogger(ActorSystemImpl system, Class<? extends Actor> clazz, int level, String logName) {
        Object response;
        Object object;
        String name = new StringBuilder(4).append("log").append(((Logging.LogExt)Logging$LogExt$.MODULE$.apply(system)).id()).append("-").append(Logging$.MODULE$.simpleName(clazz)).toString();
        ActorRef actor = system.systemActorOf(Props$.MODULE$.apply(clazz, ScalaRunTime$.MODULE$.genericWrapArray(new Object[0])).withDispatcher(system.settings().LoggersDispatcher()), name);
        try {
            ActorRef actorRef = org.apache.pekko.pattern.package$.MODULE$.ask(actor);
            Logging.InitializeLogger initializeLogger = Logging$InitializeLogger$.MODULE$.apply(this);
            object = Await$.MODULE$.result(AskableActorRef$.MODULE$.$qmark$extension(actorRef, initializeLogger, LoggingBus.timeout$1(system), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, initializeLogger)), LoggingBus.timeout$1(system).duration());
        }
        catch (TimeoutException timeoutException) {
            this.publish(Logging$Warning$.MODULE$.apply(logName, this.getClass(), new StringBuilder(56).append("Logger ").append(name).append(" did not respond within ").append(LoggingBus.timeout$1(system)).append(" to InitializeLogger(bus)").toString()));
            object = "[TIMEOUT]";
        }
        Object object2 = response = object;
        Logging$LoggerInitialized$ logging$LoggerInitialized$ = Logging$LoggerInitialized$.MODULE$;
        if (object2 == null ? logging$LoggerInitialized$ != null : !object2.equals(logging$LoggerInitialized$)) {
            throw new Logging.LoggerInitializationException(new StringBuilder(61).append("Logger ").append(name).append(" did not respond with LoggerInitialized, sent instead ").append(response).toString());
        }
        ((IterableOnceOps)Logging$.MODULE$.AllLogLevels().filter((Function1<Object, boolean> & Serializable)_$3 -> Logging$LogLevel$.MODULE$.$greater$eq$extension(level, _$3 == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)_$3).asInt()))).foreach((Function1<Object, boolean> & Serializable)l -> this.addLogger$$anonfun$2(actor, l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt()));
        this.publish(Logging$Debug$.MODULE$.apply(logName, this.getClass(), new StringBuilder(15).append("logger ").append(name).append(" started").toString()));
        return actor;
    }

    private static /* synthetic */ boolean setLogLevel$$anonfun$1$$anonfun$1(int logLvl$1, int level$1, int l) {
        return Logging$LogLevel$.MODULE$.$greater$extension(l, logLvl$1) && Logging$LogLevel$.MODULE$.$less$eq$extension(l, level$1);
    }

    private /* synthetic */ void setLogLevel$$anonfun$1$$anonfun$2(int l) {
        this.org$apache$pekko$event$LoggingBus$$loggers().foreach((Function1<ActorRef, boolean> & Serializable)log -> this.subscribe(log, Logging$.MODULE$.classFor(l)));
    }

    private static /* synthetic */ boolean setLogLevel$$anonfun$1$$anonfun$3(int logLvl$2, int level$3, int l) {
        return Logging$LogLevel$.MODULE$.$less$eq$extension(l, logLvl$2) && Logging$LogLevel$.MODULE$.$greater$extension(l, level$3);
    }

    private /* synthetic */ void setLogLevel$$anonfun$1$$anonfun$4(int l) {
        this.org$apache$pekko$event$LoggingBus$$loggers().foreach((Function1<ActorRef, boolean> & Serializable)log -> this.unsubscribe(log, Logging$.MODULE$.classFor(l)));
    }

    private void setLogLevel$$anonfun$1(int level$2) {
        int logLvl = this.org$apache$pekko$event$LoggingBus$$_logLevel();
        Logging$.MODULE$.AllLogLevels().withFilter((Function1<Object, boolean> & Serializable)l -> LoggingBus.setLogLevel$$anonfun$1$$anonfun$1(logLvl, level$2, l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt())).foreach((Function1<Object, Object> & Serializable)v1 -> {
            this.setLogLevel$$anonfun$1$$anonfun$2(v1 == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)v1).asInt());
            return BoxedUnit.UNIT;
        });
        Logging$.MODULE$.AllLogLevels().withFilter((Function1<Object, boolean> & Serializable)l -> LoggingBus.setLogLevel$$anonfun$1$$anonfun$3(logLvl, level$2, l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt())).foreach((Function1<Object, Object> & Serializable)v1 -> {
            this.setLogLevel$$anonfun$1$$anonfun$4(v1 == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)v1).asInt());
            return BoxedUnit.UNIT;
        });
        this.org$apache$pekko$event$LoggingBus$$_logLevel_$eq(level$2);
    }

    private int $anonfun$1(ActorSystem.Settings config$1) {
        Logging$.MODULE$.StandardOutLogger().print(Logging$Error$.MODULE$.apply(new Logging.LoggerException(), Logging$.MODULE$.simpleName(this), this.getClass(), new StringBuilder(30).append("unknown pekko.stdout-loglevel ").append(config$1.StdoutLogLevel()).toString()));
        return Logging$.MODULE$.ErrorLevel();
    }

    private /* synthetic */ boolean setUpStdoutLogger$$anonfun$2(int l) {
        return this.subscribe(Logging$.MODULE$.StandardOutLogger(), Logging$.MODULE$.classFor(l));
    }

    private void setUpStdoutLogger$$anonfun$3(int level$5) {
        this.org$apache$pekko$event$LoggingBus$$loggers_$eq((Seq)this.org$apache$pekko$event$LoggingBus$$loggers().$colon$plus(Logging$.MODULE$.StandardOutLogger()));
        this.org$apache$pekko$event$LoggingBus$$_logLevel_$eq(level$5);
    }

    private int $anonfun$2(String logName$1, ActorSystemImpl system$1) {
        Logging$.MODULE$.StandardOutLogger().print(Logging$Error$.MODULE$.apply(new Logging.LoggerException(), logName$1, this.getClass(), new StringBuilder(23).append("unknown pekko.loglevel ").append(system$1.settings().LogLevel()).toString()));
        return Logging$.MODULE$.ErrorLevel();
    }

    private void startDefaultLoggers$$anonfun$1(Seq myloggers$1, int level$8) {
        this.org$apache$pekko$event$LoggingBus$$loggers_$eq(myloggers$1);
        this.org$apache$pekko$event$LoggingBus$$_logLevel_$eq(level$8);
    }

    private Actor startDefaultLoggers$$anonfun$2() {
        return new Actor(this){
            private ActorContext context;
            private ActorRef self;
            private final /* synthetic */ LoggingBus $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Actor.$init$(this);
                Statics.releaseFence();
            }

            public ActorContext context() {
                return this.context;
            }

            public final ActorRef self() {
                return this.self;
            }

            public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
                this.context = x$0;
            }

            public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
                this.self = x$0;
            }

            public PartialFunction receive() {
                return new Serializable(this){
                    private final /* synthetic */ $anon$2 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Object x) {
                        Object object = x;
                        if (object instanceof UnhandledMessage) {
                            UnhandledMessage unhandledMessage = UnhandledMessage$.MODULE$.unapply((UnhandledMessage)object);
                            Object object2 = unhandledMessage._1();
                            ActorRef actorRef = unhandledMessage._2();
                            ActorRef actorRef2 = unhandledMessage._3();
                            Object msg = object2;
                            ActorRef sender = actorRef;
                            ActorRef rcp = actorRef2;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Object x, Function1 function1) {
                        Object object = x;
                        if (object instanceof UnhandledMessage) {
                            UnhandledMessage unhandledMessage = UnhandledMessage$.MODULE$.unapply((UnhandledMessage)object);
                            Object object2 = unhandledMessage._1();
                            ActorRef actorRef = unhandledMessage._2();
                            ActorRef actorRef2 = unhandledMessage._3();
                            Object msg = object2;
                            ActorRef sender = actorRef;
                            ActorRef rcp = actorRef2;
                            this.$outer.org$apache$pekko$event$LoggingBus$_$_$$anon$$$outer().publish(Logging$Debug$.MODULE$.apply(rcp.path().toString(), rcp.getClass(), new StringBuilder(25).append("unhandled message from ").append(sender).append(": ").append(msg).toString()));
                            return BoxedUnit.UNIT;
                        }
                        return function1.apply(x);
                    }
                };
            }

            public final /* synthetic */ LoggingBus org$apache$pekko$event$LoggingBus$_$_$$anon$$$outer() {
                return this.$outer;
            }
        };
    }

    private static Timeout timeout$1(ActorSystemImpl system$4) {
        return system$4.settings().LoggerStartTimeout();
    }

    private /* synthetic */ boolean addLogger$$anonfun$2(ActorRef actor$1, int l) {
        return this.subscribe(actor$1, Logging$.MODULE$.classFor(l));
    }
}

