/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.event;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorSelectionMessage;
import org.apache.pekko.actor.ActorSelectionMessage$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.SelectionPathElement;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.BusLogging;
import org.apache.pekko.event.DiagnosticLoggingAdapter;
import org.apache.pekko.event.DiagnosticMarkerBusLoggingAdapter;
import org.apache.pekko.event.LogSource;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$Debug$;
import org.apache.pekko.event.Logging$Error$;
import org.apache.pekko.event.Logging$Error$NoCause$;
import org.apache.pekko.event.Logging$Error2$;
import org.apache.pekko.event.Logging$Info$;
import org.apache.pekko.event.Logging$InitializeLogger$;
import org.apache.pekko.event.Logging$LogEvent$;
import org.apache.pekko.event.Logging$LogExt$;
import org.apache.pekko.event.Logging$LogLevel$;
import org.apache.pekko.event.Logging$LoggerInitialized$;
import org.apache.pekko.event.Logging$StdOutLogger$;
import org.apache.pekko.event.Logging$Warning$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.LoggingBus;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.util.Helpers$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NoStackTrace;

public final class Logging$
implements Serializable {
    public static final Logging$LogExt$ LogExt;
    public static final Logging$LogLevel$ LogLevel;
    private static final int ErrorLevel;
    private static final int WarningLevel;
    private static final int InfoLevel;
    private static final int DebugLevel;
    @InternalApi
    private static final int OffLevel;
    private static final Seq AllLogLevels;
    public static final Logging$LogEvent$ LogEvent;
    public static final Logging$Error2$ Error2;
    public static final Logging$Error$ Error;
    public static final Logging$Warning$ Warning;
    public static final Logging$Info$ Info;
    public static final Logging$Debug$ Debug;
    public static final Logging$InitializeLogger$ InitializeLogger;
    public static final Logging$LoggerInitialized$ LoggerInitialized;
    public static final Logging$StdOutLogger$ StdOutLogger;
    public static final Logging.SerializedStandardOutLogger org$apache$pekko$event$Logging$$$serializedStandardOutLogger;
    private static final Logging.StandardOutLogger StandardOutLogger;
    private static final Map emptyMDC;
    public static final Logging$ MODULE$;

    private Logging$() {
    }

    static {
        MODULE$ = new Logging$();
        ErrorLevel = Logging$LogLevel$.MODULE$.apply(1);
        WarningLevel = Logging$LogLevel$.MODULE$.apply(2);
        InfoLevel = Logging$LogLevel$.MODULE$.apply(3);
        DebugLevel = Logging$LogLevel$.MODULE$.apply(4);
        OffLevel = Logging$LogLevel$.MODULE$.apply(Integer.MIN_VALUE);
        AllLogLevels = (Seq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Logging.LogLevel[]{new Logging.LogLevel(MODULE$.ErrorLevel()), new Logging.LogLevel(MODULE$.WarningLevel()), new Logging.LogLevel(MODULE$.InfoLevel()), new Logging.LogLevel(MODULE$.DebugLevel())}));
        org$apache$pekko$event$Logging$$$serializedStandardOutLogger = new Logging.SerializedStandardOutLogger();
        StandardOutLogger = new Logging.StandardOutLogger();
        emptyMDC = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Logging$.class);
    }

    public String simpleName(Object obj) {
        return this.simpleName(obj.getClass());
    }

    public String simpleName(Class<?> clazz) {
        String n = clazz.getName();
        int i = n.lastIndexOf(46);
        return n.substring(i + 1);
    }

    public String messageClassName(Object message) {
        Object object = message;
        if (object == null) {
            return "null";
        }
        if (object instanceof ActorSelectionMessage) {
            ActorSelectionMessage actorSelectionMessage = ActorSelectionMessage$.MODULE$.unapply((ActorSelectionMessage)object);
            Object object2 = actorSelectionMessage._1();
            Iterable<SelectionPathElement> iterable = actorSelectionMessage._2();
            boolean bl = actorSelectionMessage._3();
            Object m = object2;
            return new StringBuilder(23).append("ActorSelectionMessage(").append(m.getClass().getName()).append(")").toString();
        }
        Object m = object;
        return m.getClass().getName();
    }

    public final int ErrorLevel() {
        return ErrorLevel;
    }

    public final int WarningLevel() {
        return WarningLevel;
    }

    public final int InfoLevel() {
        return InfoLevel;
    }

    public final int DebugLevel() {
        return DebugLevel;
    }

    public final int OffLevel() {
        return OffLevel;
    }

    public Option<Logging.LogLevel> levelFor(String s2) {
        String string2 = Helpers$.MODULE$.toRootLowerCase(s2);
        switch (string2 == null ? 0 : string2.hashCode()) {
            case 109935: {
                if (!"off".equals(string2)) break;
                return Some$.MODULE$.apply(new Logging.LogLevel(this.OffLevel()));
            }
            case 3237038: {
                if (!"info".equals(string2)) break;
                return Some$.MODULE$.apply(new Logging.LogLevel(this.InfoLevel()));
            }
            case 95458899: {
                if (!"debug".equals(string2)) break;
                return Some$.MODULE$.apply(new Logging.LogLevel(this.DebugLevel()));
            }
            case 96784904: {
                if (!"error".equals(string2)) break;
                return Some$.MODULE$.apply(new Logging.LogLevel(this.ErrorLevel()));
            }
            case 1124446108: {
                if (!"warning".equals(string2)) break;
                return Some$.MODULE$.apply(new Logging.LogLevel(this.WarningLevel()));
            }
        }
        return None$.MODULE$;
    }

    public int levelFor(Class<? extends Logging.LogEvent> eventClass) {
        if (Logging.Error.class.isAssignableFrom(eventClass)) {
            return this.ErrorLevel();
        }
        if (Logging.Warning.class.isAssignableFrom(eventClass)) {
            return this.WarningLevel();
        }
        if (Logging.Info.class.isAssignableFrom(eventClass)) {
            return this.InfoLevel();
        }
        if (Logging.Debug.class.isAssignableFrom(eventClass)) {
            return this.DebugLevel();
        }
        return this.DebugLevel();
    }

    public Class<? extends Logging.LogEvent> classFor(int level) {
        int n = level;
        if (this.ErrorLevel() == n) {
            return Logging.Error.class;
        }
        if (this.WarningLevel() == n) {
            return Logging.Warning.class;
        }
        if (this.InfoLevel() == n) {
            return Logging.Info.class;
        }
        if (this.DebugLevel() == n) {
            return Logging.Debug.class;
        }
        int level2 = n;
        throw new IllegalArgumentException(new StringBuilder(24).append("Unsupported log level [").append(new Logging.LogLevel(level2)).append("]").toString());
    }

    public Seq<Logging.LogLevel> AllLogLevels() {
        return AllLogLevels;
    }

    public <T> LoggingAdapter apply(ActorSystem system, T logSource, LogSource<T> evidence$1) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, system, evidence$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2<String, Class<?>> tuple22 = Tuple2$.MODULE$.apply(str, clazz);
        String str2 = tuple22._1();
        Class<?> clazz2 = tuple22._2();
        return new BusLogging(system.eventStream(), str2, clazz2, ((ExtendedActorSystem)system).logFilter());
    }

    public <T> MarkerLoggingAdapter withMarker(ActorSystem system, T logSource, LogSource<T> evidence$1) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, system, evidence$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2<String, Class<?>> tuple22 = Tuple2$.MODULE$.apply(str, clazz);
        String str2 = tuple22._1();
        Class<?> clazz2 = tuple22._2();
        return new MarkerLoggingAdapter(system.eventStream(), str2, clazz2, ((ExtendedActorSystem)system).logFilter());
    }

    public <T> LoggingAdapter apply(LoggingBus bus, T logSource, LogSource<T> evidence$1) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, evidence$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2<String, Class<?>> tuple22 = Tuple2$.MODULE$.apply(str, clazz);
        String str2 = tuple22._1();
        Class<?> clazz2 = tuple22._2();
        return new BusLogging(bus, str2, clazz2);
    }

    public <T> MarkerLoggingAdapter withMarker(LoggingBus bus, T logSource, LogSource<T> evidence$1) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, evidence$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2<String, Class<?>> tuple22 = Tuple2$.MODULE$.apply(str, clazz);
        String str2 = tuple22._1();
        Class<?> clazz2 = tuple22._2();
        return new MarkerLoggingAdapter(bus, str2, clazz2);
    }

    public DiagnosticLoggingAdapter apply(Actor logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, LogSource$.MODULE$.fromActor());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2<String, Class<?>> tuple22 = Tuple2$.MODULE$.apply(str, clazz);
        String str2 = tuple22._1();
        Class<?> clazz2 = tuple22._2();
        ExtendedActorSystem system = (ExtendedActorSystem)logSource.context().system();
        return new DiagnosticLoggingAdapter(system, str2, clazz2){
            private Map org$apache$pekko$event$DiagnosticLoggingAdapter$$_mdc;
            {
                DiagnosticLoggingAdapter.$init$(this);
            }

            public Map org$apache$pekko$event$DiagnosticLoggingAdapter$$_mdc() {
                return this.org$apache$pekko$event$DiagnosticLoggingAdapter$$_mdc;
            }

            public void org$apache$pekko$event$DiagnosticLoggingAdapter$$_mdc_$eq(Map x$1) {
                this.org$apache$pekko$event$DiagnosticLoggingAdapter$$_mdc = x$1;
            }
        };
    }

    public DiagnosticMarkerBusLoggingAdapter withMarker(Actor logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, LogSource$.MODULE$.fromActor());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2<String, Class<?>> tuple22 = Tuple2$.MODULE$.apply(str, clazz);
        String str2 = tuple22._1();
        Class<?> clazz2 = tuple22._2();
        ExtendedActorSystem system = (ExtendedActorSystem)logSource.context().system();
        return new DiagnosticMarkerBusLoggingAdapter(system.eventStream(), str2, clazz2, system.logFilter());
    }

    public LoggingAdapter getLogger(ActorSystem system, Object logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource, system);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2<String, Class<?>> tuple22 = Tuple2$.MODULE$.apply(str, clazz);
        String str2 = tuple22._1();
        Class<?> clazz2 = tuple22._2();
        return new BusLogging(system.eventStream(), str2, clazz2, ((ExtendedActorSystem)system).logFilter());
    }

    public LoggingAdapter getLogger(LoggingBus bus, Object logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String str = tuple2._1();
        Class<?> clazz = tuple2._2();
        Tuple2<String, Class<?>> tuple22 = Tuple2$.MODULE$.apply(str, clazz);
        String str2 = tuple22._1();
        Class<?> clazz2 = tuple22._2();
        return new BusLogging(bus, str2, clazz2);
    }

    public DiagnosticLoggingAdapter getLogger(Actor logSource) {
        return this.apply(logSource);
    }

    public Logging$Error$NoCause$ noCause() {
        return Logging$Error$NoCause$.MODULE$;
    }

    public Logging$LoggerInitialized$ loggerInitialized() {
        return Logging$LoggerInitialized$.MODULE$;
    }

    public Logging.StandardOutLogger StandardOutLogger() {
        return StandardOutLogger;
    }

    public String stackTraceFor(Throwable e) {
        Throwable throwable = e;
        if (throwable == null || Logging$Error$NoCause$.MODULE$.equals(throwable)) {
            return "";
        }
        if (throwable instanceof NoStackTrace) {
            return new StringBuilder(5).append(" (").append(e.getClass().getName()).append(": ").append(e.getMessage()).append(")").toString();
        }
        Throwable other = throwable;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.append('\n');
        other.printStackTrace(pw);
        return sw.toString();
    }

    public Map<String, Object> emptyMDC() {
        return emptyMDC;
    }

    public static final /* synthetic */ String org$apache$pekko$event$Logging$StdOutLogger$$_$formatMDC$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            return new StringBuilder(1).append(k).append(":").append(v).toString();
        }
        throw new MatchError(tuple2);
    }
}

