/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.event;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogMarker$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRef$;
import org.apache.pekko.actor.AllDeadLetters;
import org.apache.pekko.actor.DeadLetter;
import org.apache.pekko.actor.DeadLetterActorRef;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.Dropped;
import org.apache.pekko.actor.UnhandledMessage;
import org.apache.pekko.actor.WrappedMessage;
import org.apache.pekko.actor.WrappedMessage$;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.Logging$Info$;
import org.apache.pekko.util.PrettyDuration$;
import org.apache.pekko.util.PrettyDuration$PrettyPrintableDuration$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

public class DeadLetterListener
implements Actor {
    private ActorContext context;
    private ActorRef self;
    private final EventStream eventStream;
    private final int maxCount;
    private final boolean isAlwaysLoggingDeadLetters;
    private int count;

    public DeadLetterListener() {
        Actor.$init$(this);
        this.eventStream = this.context().system().eventStream();
        this.maxCount = this.context().system().settings().LogDeadLetters();
        this.isAlwaysLoggingDeadLetters = this.maxCount() == Integer.MAX_VALUE;
        this.count = 0;
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public EventStream eventStream() {
        return this.eventStream;
    }

    public int maxCount() {
        return this.maxCount;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    @Override
    public void preStart() {
        this.eventStream().subscribe(this.self(), DeadLetter.class);
        this.eventStream().subscribe(this.self(), Dropped.class);
        this.eventStream().subscribe(this.self(), UnhandledMessage.class);
    }

    @Override
    public void postRestart(Throwable reason) {
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) {
    }

    @Override
    public void postStop() {
        this.eventStream().unsubscribe(this.self());
    }

    public void org$apache$pekko$event$DeadLetterListener$$incrementCount() {
        if (this.count() == Integer.MAX_VALUE) {
            Logging$.MODULE$.getLogger(this).info("Resetting DeadLetterListener counter after reaching Int.MaxValue.");
            this.count_$eq(1);
            return;
        }
        this.count_$eq(this.count() + 1);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        if (this.isAlwaysLoggingDeadLetters) {
            return this.receiveWithAlwaysLogging();
        }
        Duration duration = this.context().system().settings().LogDeadLettersSuspendDuration();
        if (duration instanceof FiniteDuration) {
            FiniteDuration suspendDuration = (FiniteDuration)duration;
            return this.org$apache$pekko$event$DeadLetterListener$$receiveWithSuspendLogging(suspendDuration);
        }
        return this.receiveWithMaxCountLogging();
    }

    private PartialFunction<Object, BoxedUnit> receiveWithAlwaysLogging() {
        return new Serializable(this){
            private final /* synthetic */ DeadLetterListener $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object;
                    if (!this.$outer.org$apache$pekko$event$DeadLetterListener$$isWrappedSuppressed(d)) {
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$incrementCount();
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$logDeadLetter(d, "");
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    private PartialFunction<Object, BoxedUnit> receiveWithMaxCountLogging() {
        return new Serializable(this){
            private final /* synthetic */ DeadLetterListener $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object;
                    if (!this.$outer.org$apache$pekko$event$DeadLetterListener$$isWrappedSuppressed(d)) {
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$incrementCount();
                        if (this.$outer.count() == this.$outer.maxCount()) {
                            this.$outer.org$apache$pekko$event$DeadLetterListener$$logDeadLetter(d, ", no more dead letters will be logged");
                            this.$outer.context().stop(this.$outer.self());
                            return BoxedUnit.UNIT;
                        }
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$logDeadLetter(d, "");
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> org$apache$pekko$event$DeadLetterListener$$receiveWithSuspendLogging(FiniteDuration suspendDuration) {
        return new Serializable(suspendDuration, this){
            private final FiniteDuration suspendDuration$1;
            private final /* synthetic */ DeadLetterListener $outer;
            {
                this.suspendDuration$1 = suspendDuration$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object;
                    if (!this.$outer.org$apache$pekko$event$DeadLetterListener$$isWrappedSuppressed(d)) {
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$incrementCount();
                        if (this.$outer.count() == this.$outer.maxCount()) {
                            String doneMsg = new StringBuilder(48).append(", no more dead letters will be logged in next [").append(PrettyDuration$PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration(this.suspendDuration$1))).append("]").toString();
                            this.$outer.org$apache$pekko$event$DeadLetterListener$$logDeadLetter(d, doneMsg);
                            this.$outer.context().become(this.$outer.org$apache$pekko$event$DeadLetterListener$$receiveWhenSuspended(this.suspendDuration$1, Deadline$.MODULE$.now().$plus(this.suspendDuration$1)));
                            return BoxedUnit.UNIT;
                        }
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$logDeadLetter(d, "");
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> org$apache$pekko$event$DeadLetterListener$$receiveWhenSuspended(FiniteDuration suspendDuration, Deadline suspendDeadline) {
        return new Serializable(suspendDeadline, suspendDuration, this){
            private final Deadline suspendDeadline$1;
            private final FiniteDuration suspendDuration$2;
            private final /* synthetic */ DeadLetterListener $outer;
            {
                this.suspendDeadline$1 = suspendDeadline$2;
                this.suspendDuration$2 = suspendDuration$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object;
                    if (!this.$outer.org$apache$pekko$event$DeadLetterListener$$isWrappedSuppressed(d)) {
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$incrementCount();
                        if (this.suspendDeadline$1.isOverdue()) {
                            String doneMsg = new StringBuilder(58).append(", of which ").append(this.$outer.count() - this.$outer.maxCount() - 1).append(" were not logged. The counter will be reset now").toString();
                            this.$outer.org$apache$pekko$event$DeadLetterListener$$logDeadLetter(d, doneMsg);
                            this.$outer.count_$eq(0);
                            this.$outer.context().become(this.$outer.org$apache$pekko$event$DeadLetterListener$$receiveWithSuspendLogging(this.suspendDuration$2));
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public void org$apache$pekko$event$DeadLetterListener$$logDeadLetter(AllDeadLetters d, String doneMsg) {
        String string2;
        String origin = this.isReal(d.sender()) ? new StringBuilder(6).append(" from ").append(d.sender()).toString() : "";
        Object unwrapped = WrappedMessage$.MODULE$.unwrap(d.message());
        String messageStr = unwrapped.getClass().getName();
        String wrappedIn = d.message() instanceof WrappedMessage ? new StringBuilder(14).append(" wrapped in [").append(d.message().getClass().getName()).append("]").toString() : "";
        AllDeadLetters allDeadLetters = d;
        if (allDeadLetters instanceof Dropped) {
            Dropped dropped = (Dropped)allDeadLetters;
            String destination = this.isReal(d.recipient()) ? new StringBuilder(4).append(" to ").append(d.recipient()).toString() : "";
            string2 = new StringBuilder(26).append("Message [").append(messageStr).append("]").append(wrappedIn).append(origin).append(destination).append(" was dropped. ").append(dropped.reason()).append(". ").append(new StringBuilder(29).append("[").append(this.count()).append("] dead letters encountered").append(doneMsg).append(". ").toString()).toString();
        } else if (allDeadLetters instanceof UnhandledMessage) {
            String destination = this.isReal(d.recipient()) ? new StringBuilder(4).append(" to ").append(d.recipient()).toString() : "";
            string2 = new StringBuilder(26).append("Message [").append(messageStr).append("]").append(wrappedIn).append(origin).append(destination).append(" was unhandled. ").append(new StringBuilder(29).append("[").append(this.count()).append("] dead letters encountered").append(doneMsg).append(". ").toString()).toString();
        } else {
            string2 = new StringBuilder(34).append("Message [").append(messageStr).append("]").append(wrappedIn).append(origin).append(" to ").append(d.recipient()).append(" was not delivered. ").append(new StringBuilder(29).append("[").append(this.count()).append("] dead letters encountered").append(doneMsg).append(". ").toString()).append(new StringBuilder(76).append("If this is not an expected behavior then ").append(d.recipient()).append(" may have terminated unexpectedly. ").toString()).toString();
        }
        String logMessage = string2;
        this.eventStream().publish(Logging$Info$.MODULE$.apply(d.recipient().path().toString(), d.recipient().getClass(), new StringBuilder(141).append(logMessage).append("This logging can be turned off or adjusted with configuration settings 'pekko.log-dead-letters' ").append("and 'pekko.log-dead-letters-during-shutdown'.").toString(), Logging$.MODULE$.emptyMDC(), ActorLogMarker$.MODULE$.deadLetter(messageStr)));
    }

    private boolean isReal(ActorRef snd) {
        return snd != ActorRef$.MODULE$.noSender() && snd != this.context().system().deadLetters() && !(snd instanceof DeadLetterActorRef);
    }

    public boolean org$apache$pekko$event$DeadLetterListener$$isWrappedSuppressed(AllDeadLetters d) {
        WrappedMessage w;
        Object object = d.message();
        return object instanceof WrappedMessage && (w = (WrappedMessage)object).message() instanceof DeadLetterSuppression;
    }
}

