/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.event;

import java.io.Serializable;
import org.apache.pekko.event.DefaultLoggingFilter;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$Debug$;
import org.apache.pekko.event.Logging$Error$;
import org.apache.pekko.event.Logging$Info$;
import org.apache.pekko.event.Logging$Warning$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.LoggingBus;
import org.apache.pekko.event.LoggingFilter;
import scala.Function0;

public class BusLogging
implements LoggingAdapter {
    private final LoggingBus bus;
    private final String logSource;
    private final Class logClass;
    private final LoggingFilter loggingFilter;

    public BusLogging(LoggingBus bus, String logSource, Class<?> logClass, LoggingFilter loggingFilter) {
        this.bus = bus;
        this.logSource = logSource;
        this.logClass = logClass;
        this.loggingFilter = loggingFilter;
    }

    public LoggingBus bus() {
        return this.bus;
    }

    public String logSource() {
        return this.logSource;
    }

    public Class<?> logClass() {
        return this.logClass;
    }

    public BusLogging(LoggingBus bus, String logSource, Class<?> logClass) {
        this(bus, logSource, logClass, BusLogging.BusLogging$superArg$1(bus, logSource, logClass));
    }

    @Override
    public boolean isErrorEnabled() {
        return this.loggingFilter.isErrorEnabled(this.logClass(), this.logSource());
    }

    @Override
    public boolean isWarningEnabled() {
        return this.loggingFilter.isWarningEnabled(this.logClass(), this.logSource());
    }

    @Override
    public boolean isInfoEnabled() {
        return this.loggingFilter.isInfoEnabled(this.logClass(), this.logSource());
    }

    @Override
    public boolean isDebugEnabled() {
        return this.loggingFilter.isDebugEnabled(this.logClass(), this.logSource());
    }

    @Override
    public void notifyError(String message) {
        this.bus().publish(Logging$Error$.MODULE$.apply(this.logSource(), this.logClass(), (Object)message, this.mdc()));
    }

    @Override
    public void notifyError(Throwable cause, String message) {
        this.bus().publish(Logging$Error$.MODULE$.apply(cause, this.logSource(), this.logClass(), message, this.mdc()));
    }

    @Override
    public void notifyWarning(String message) {
        this.bus().publish(Logging$Warning$.MODULE$.apply(this.logSource(), this.logClass(), message, this.mdc()));
    }

    @Override
    public void notifyWarning(Throwable cause, String message) {
        this.bus().publish(Logging$Warning$.MODULE$.apply(cause, this.logSource(), this.logClass(), message, this.mdc()));
    }

    @Override
    public void notifyInfo(String message) {
        this.bus().publish(Logging$Info$.MODULE$.apply(this.logSource(), this.logClass(), message, this.mdc()));
    }

    @Override
    public void notifyDebug(String message) {
        this.bus().publish(Logging$Debug$.MODULE$.apply(this.logSource(), this.logClass(), message, this.mdc()));
    }

    private static DefaultLoggingFilter BusLogging$superArg$1(LoggingBus bus, String logSource, Class<?> logClass) {
        return new DefaultLoggingFilter((Function0<Logging.LogLevel>)(Function0<Object> & Serializable)() -> new Logging.LogLevel(bus.logLevel()));
    }
}

