/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch.affinity;

import com.typesafe.config.Config;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.affinity.QueueSelector;
import org.apache.pekko.dispatch.affinity.QueueSelectorFactory;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$Requiring$;
import org.apache.pekko.util.ImmutableIntMap;
import org.apache.pekko.util.ImmutableIntMap$;
import scala.runtime.BoxesRunTime;

@ApiMayChange
@InternalApi
public final class FairDistributionHashCache
implements QueueSelectorFactory {
    private final Config config;
    public final int org$apache$pekko$dispatch$affinity$FairDistributionHashCache$$fairDistributionThreshold;

    public FairDistributionHashCache(Config config) {
        this.config = config;
        int MaxFairDistributionThreshold = 2048;
        Integer n = (Integer)Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger(config.getInt("fair-work-distribution.threshold")));
        this.org$apache$pekko$dispatch$affinity$FairDistributionHashCache$$fairDistributionThreshold = BoxesRunTime.unboxToInt(Helpers$Requiring$.MODULE$.requiring$extension((Object)n, thr -> 0 <= thr && thr <= 2048, FairDistributionHashCache::$init$$$anonfun$5));
    }

    public Config config() {
        return this.config;
    }

    @Override
    public QueueSelector create() {
        return new QueueSelector(this){
            private final /* synthetic */ FairDistributionHashCache $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(ImmutableIntMap$.MODULE$.empty());
            }

            public String toString() {
                return new StringBuilder(55).append("FairDistributionHashCache(fairDistributionThreshold = ").append(this.$outer.org$apache$pekko$dispatch$affinity$FairDistributionHashCache$$fairDistributionThreshold).append(")").toString();
            }

            private final int improve(int h) {
                return Integer.MAX_VALUE & Integer.reverseBytes(h * -1640532531) * -1640532531;
            }

            public final int getQueue(Runnable command, int queues) {
                int runnableHash = command.hashCode();
                if (this.$outer.org$apache$pekko$dispatch$affinity$FairDistributionHashCache$$fairDistributionThreshold == 0) {
                    return this.improve(runnableHash) % queues;
                }
                return this.cacheLookup$1(runnableHash, queues, (ImmutableIntMap)this.get(), runnableHash);
            }

            private final int cacheLookup$1(int runnableHash$1, int queues$1, ImmutableIntMap prev, int hash) {
                int existingIndex;
                while ((existingIndex = prev.get(runnableHash$1)) < 0) {
                    if (prev.size() > this.$outer.org$apache$pekko$dispatch$affinity$FairDistributionHashCache$$fairDistributionThreshold) {
                        return this.improve(hash) % queues$1;
                    }
                    int index = prev.size() % queues$1;
                    if (this.compareAndSet(prev, prev.updated(runnableHash$1, index))) {
                        return index;
                    }
                    prev = (ImmutableIntMap)this.get();
                }
                return existingIndex;
            }
        };
    }

    private static final Object $init$$$anonfun$5() {
        return new StringBuilder(69).append("fair-work-distribution.threshold must be between 0 and ").append(2048).toString();
    }
}

