/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch.affinity;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.DispatcherPrerequisites;
import org.apache.pekko.dispatch.ExecutorServiceConfigurator;
import org.apache.pekko.dispatch.ExecutorServiceFactory;
import org.apache.pekko.dispatch.MonitorableThreadFactory;
import org.apache.pekko.dispatch.ThreadPoolConfig$;
import org.apache.pekko.dispatch.affinity.AffinityPool;
import org.apache.pekko.dispatch.affinity.QueueSelectorFactory;
import org.apache.pekko.dispatch.affinity.RejectionHandlerFactory;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$Requiring$;
import scala.Function1;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ApiMayChange
@InternalApi
public final class AffinityPoolConfigurator
extends ExecutorServiceConfigurator {
    public final int org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$poolSize;
    public final int org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$taskQueueSize;
    public final int org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$idleCpuLevel;
    public final String org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactoryFQCN;
    public final QueueSelectorFactory org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactory;
    public final String org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactoryFCQN;
    public final RejectionHandlerFactory org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactory;

    public AffinityPoolConfigurator(Config config, DispatcherPrerequisites prerequisites) {
        super(config, prerequisites);
        this.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$poolSize = ThreadPoolConfig$.MODULE$.scaledPoolSize(config.getInt("parallelism-min"), config.getDouble("parallelism-factor"), config.getInt("parallelism-max"));
        this.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$taskQueueSize = config.getInt("task-queue-size");
        Integer n = (Integer)Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger(config.getInt("idle-cpu-level")));
        this.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$idleCpuLevel = BoxesRunTime.unboxToInt(Helpers$Requiring$.MODULE$.requiring$extension((Object)n, level -> 1 <= level && level <= 10, AffinityPoolConfigurator::$init$$$anonfun$3));
        this.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactoryFQCN = config.getString("queue-selector");
        Class<Config> clazz = Predef$.MODULE$.ArrowAssoc(Config.class);
        this.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactory = prerequisites.dynamicAccess().createInstanceFor(this.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactoryFQCN, (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(clazz, config)), Nil$.MODULE$)), ClassTag$.MODULE$.apply(QueueSelectorFactory.class)).recover(new Serializable(this){
            private final /* synthetic */ AffinityPoolConfigurator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                throw new IllegalArgumentException(new StringBuilder(134).append("Cannot instantiate QueueSelectorFactory(queueSelector = ").append(this.$outer.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactoryFQCN).append("), make sure it has an accessible constructor which accepts a Config parameter").toString());
            }
        }).get();
        this.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactoryFCQN = config.getString("rejection-handler");
        this.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactory = prerequisites.dynamicAccess().createInstanceFor(this.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactoryFCQN, package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(RejectionHandlerFactory.class)).recover(new Serializable(this){
            private final /* synthetic */ AffinityPoolConfigurator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable exception = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable exception = throwable = x;
                throw new IllegalArgumentException(new StringBuilder(114).append("Cannot instantiate RejectionHandlerFactory(rejection-handler = ").append(this.$outer.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactoryFCQN).append("), make sure it has an accessible empty constructor").toString(), exception);
            }
        }).get();
    }

    @Override
    public ExecutorServiceFactory createExecutorServiceFactory(String id, ThreadFactory threadFactory) {
        ThreadFactory threadFactory2;
        ThreadFactory threadFactory3 = threadFactory;
        if (threadFactory3 instanceof MonitorableThreadFactory) {
            MonitorableThreadFactory m = (MonitorableThreadFactory)threadFactory3;
            threadFactory2 = m.withName(new StringBuilder(1).append(m.name()).append("-").append(id).toString());
        } else {
            ThreadFactory other;
            threadFactory2 = other = threadFactory3;
        }
        ThreadFactory tf = threadFactory2;
        return new ExecutorServiceFactory(id, tf, this){
            private final String id$1;
            private final ThreadFactory tf$1;
            private final /* synthetic */ AffinityPoolConfigurator $outer;
            {
                this.id$1 = id$2;
                this.tf$1 = tf$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public ExecutorService createExecutorService() {
                return new AffinityPool(this.id$1, this.$outer.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$poolSize, this.$outer.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$taskQueueSize, this.tf$1, this.$outer.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$idleCpuLevel, this.$outer.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$queueSelectorFactory.create(), this.$outer.org$apache$pekko$dispatch$affinity$AffinityPoolConfigurator$$rejectionHandlerFactory.create()).start();
            }
        };
    }

    private static final Object $init$$$anonfun$3() {
        return "idle-cpu-level must be between 1 and 10";
    }
}

