/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.MailboxType;
import org.apache.pekko.dispatch.ProducesMessageQueue;
import org.apache.pekko.dispatch.UnboundedQueueBasedMessageQueue;
import scala.Option;

public class UnboundedPriorityMailbox
implements MailboxType,
ProducesMessageQueue<MessageQueue> {
    private final Comparator cmp;
    private final int initialCapacity;

    public UnboundedPriorityMailbox(Comparator<Envelope> cmp, int initialCapacity) {
        this.cmp = cmp;
        this.initialCapacity = initialCapacity;
    }

    public Comparator<Envelope> cmp() {
        return this.cmp;
    }

    public int initialCapacity() {
        return this.initialCapacity;
    }

    public UnboundedPriorityMailbox(Comparator<Envelope> cmp) {
        this(cmp, 11);
    }

    @Override
    public final org.apache.pekko.dispatch.MessageQueue create(Option<ActorRef> owner, Option<ActorSystem> system) {
        return new MessageQueue(this.initialCapacity(), this.cmp());
    }

    public static class MessageQueue
    extends PriorityBlockingQueue<Envelope>
    implements UnboundedQueueBasedMessageQueue {
        public MessageQueue(int initialCapacity, Comparator<Envelope> cmp) {
            super(initialCapacity, cmp);
        }

        @Override
        public final Queue<Envelope> queue() {
            return this;
        }
    }
}

