/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.apache.pekko.dispatch.DispatcherPrerequisites;
import org.apache.pekko.dispatch.ExecutorServiceConfigurator;
import org.apache.pekko.dispatch.ExecutorServiceFactory;
import org.apache.pekko.dispatch.ThreadPoolConfig;
import org.apache.pekko.dispatch.ThreadPoolConfig$;
import org.apache.pekko.dispatch.ThreadPoolConfigBuilder;
import org.apache.pekko.dispatch.ThreadPoolConfigBuilder$;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$ConfigOps$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ThreadPoolExecutorConfigurator
extends ExecutorServiceConfigurator {
    private final ThreadPoolConfig threadPoolConfig;

    public ThreadPoolExecutorConfigurator(Config config, DispatcherPrerequisites prerequisites) {
        super(config, prerequisites);
        this.threadPoolConfig = this.createThreadPoolConfigBuilder(config, prerequisites).config();
    }

    public ThreadPoolConfig threadPoolConfig() {
        return this.threadPoolConfig;
    }

    public ThreadPoolConfigBuilder createThreadPoolConfigBuilder(Config config, DispatcherPrerequisites prerequisites) {
        ThreadPoolConfigBuilder builder = ThreadPoolConfigBuilder$.MODULE$.apply(ThreadPoolConfig$.MODULE$.apply(ThreadPoolConfig$.MODULE$.$lessinit$greater$default$1(), ThreadPoolConfig$.MODULE$.$lessinit$greater$default$2(), ThreadPoolConfig$.MODULE$.$lessinit$greater$default$3(), ThreadPoolConfig$.MODULE$.$lessinit$greater$default$4(), ThreadPoolConfig$.MODULE$.$lessinit$greater$default$5(), ThreadPoolConfig$.MODULE$.$lessinit$greater$default$6())).setKeepAliveTime(Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "keep-alive-time")).setAllowCoreThreadTimeout(config.getBoolean("allow-core-timeout")).configure(ScalaRunTime$.MODULE$.wrapRefArray(new Option[]{Some$.MODULE$.apply(BoxesRunTime.boxToInteger(config.getInt("task-queue-size"))).flatMap((Function1<Object, Option> & Serializable)x$1 -> ThreadPoolExecutorConfigurator.$anonfun$1(config, BoxesRunTime.unboxToInt(x$1)))}));
        String string2 = config.getString("fixed-pool-size");
        String string3 = "off";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return builder.setCorePoolSizeFromFactor(config.getInt("core-pool-size-min"), config.getDouble("core-pool-size-factor"), config.getInt("core-pool-size-max")).setMaxPoolSizeFromFactor(config.getInt("max-pool-size-min"), config.getDouble("max-pool-size-factor"), config.getInt("max-pool-size-max"));
        }
        return builder.setFixedPoolSize(config.getInt("fixed-pool-size"));
    }

    @Override
    public ExecutorServiceFactory createExecutorServiceFactory(String id, ThreadFactory threadFactory) {
        return this.threadPoolConfig().createExecutorServiceFactory(id, threadFactory);
    }

    private static final /* synthetic */ Option $anonfun$1(Config config$1, int x$12) {
        int n = x$12;
        int size = n;
        if (size > 0) {
            return Some$.MODULE$.apply(config$1.getString("task-queue-type")).map((Function1<String, Function0> & Serializable)x$1 -> {
                String string2 = x$1;
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case -1102666215: {
                        if ("linked".equals(string2)) return ThreadPoolConfig$.MODULE$.linkedBlockingQueue(size);
                        break;
                    }
                    case 0: {
                        if ("".equals(string2)) return ThreadPoolConfig$.MODULE$.linkedBlockingQueue(size);
                        break;
                    }
                    case 93090393: {
                        if (!"array".equals(string2)) break;
                        return ThreadPoolConfig$.MODULE$.arrayBlockingQueue(size, false);
                    }
                }
                String x = string2;
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("[%s] is not a valid task-queue-type [array|linked]!"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{x})));
            }).map((Function1<Function0, Function1> & Serializable)qf -> (Function1<ThreadPoolConfigBuilder, ThreadPoolConfigBuilder> & Serializable)q -> q.setQueueFactory((Function0<BlockingQueue<Runnable>>)qf));
        }
        return None$.MODULE$;
    }
}

