/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.dispatch.ThreadPoolConfig;
import org.apache.pekko.dispatch.ThreadPoolConfig$;
import org.apache.pekko.dispatch.ThreadPoolConfigBuilder$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ThreadPoolConfigBuilder
implements Product,
Serializable {
    private final ThreadPoolConfig config;

    public static ThreadPoolConfigBuilder apply(ThreadPoolConfig threadPoolConfig) {
        return ThreadPoolConfigBuilder$.MODULE$.apply(threadPoolConfig);
    }

    public static ThreadPoolConfigBuilder fromProduct(Product product) {
        return ThreadPoolConfigBuilder$.MODULE$.fromProduct(product);
    }

    public static ThreadPoolConfigBuilder unapply(ThreadPoolConfigBuilder threadPoolConfigBuilder) {
        return ThreadPoolConfigBuilder$.MODULE$.unapply(threadPoolConfigBuilder);
    }

    public ThreadPoolConfigBuilder(ThreadPoolConfig config) {
        this.config = config;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ThreadPoolConfigBuilder)) return false;
        ThreadPoolConfigBuilder threadPoolConfigBuilder = (ThreadPoolConfigBuilder)object;
        ThreadPoolConfig threadPoolConfig = this.config();
        ThreadPoolConfig threadPoolConfig2 = threadPoolConfigBuilder.config();
        if (threadPoolConfig != null) {
            if (!((Object)threadPoolConfig).equals(threadPoolConfig2)) return false;
            return true;
        }
        if (threadPoolConfig2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof ThreadPoolConfigBuilder;
    }

    @Override
    public int productArity() {
        return 1;
    }

    @Override
    public String productPrefix() {
        return "ThreadPoolConfigBuilder";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "config";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public ThreadPoolConfig config() {
        return this.config;
    }

    public ThreadPoolConfigBuilder withNewThreadPoolWithCustomBlockingQueue(Function0<BlockingQueue<Runnable>> newQueueFactory) {
        return this.copy(this.config().copy(this.config().copy$default$1(), this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), newQueueFactory, this.config().copy$default$6()));
    }

    public ThreadPoolConfigBuilder withNewThreadPoolWithCustomBlockingQueue(BlockingQueue<Runnable> queue) {
        return this.withNewThreadPoolWithCustomBlockingQueue(ThreadPoolConfig$.MODULE$.reusableQueue(queue));
    }

    public ThreadPoolConfigBuilder withNewThreadPoolWithLinkedBlockingQueueWithUnboundedCapacity() {
        Function0<BlockingQueue<Runnable>> function0 = ThreadPoolConfig$.MODULE$.linkedBlockingQueue();
        boolean bl = this.config().copy$default$1();
        int n = this.config().copy$default$2();
        int n2 = this.config().copy$default$3();
        Duration duration = this.config().copy$default$4();
        RejectedExecutionHandler rejectedExecutionHandler = this.config().copy$default$6();
        return this.copy(this.config().copy(bl, n, n2, duration, function0, rejectedExecutionHandler));
    }

    public ThreadPoolConfigBuilder withNewThreadPoolWithLinkedBlockingQueueWithCapacity(int capacity) {
        Function0<BlockingQueue<Runnable>> function0 = ThreadPoolConfig$.MODULE$.linkedBlockingQueue(capacity);
        boolean bl = this.config().copy$default$1();
        int n = this.config().copy$default$2();
        int n2 = this.config().copy$default$3();
        Duration duration = this.config().copy$default$4();
        RejectedExecutionHandler rejectedExecutionHandler = this.config().copy$default$6();
        return this.copy(this.config().copy(bl, n, n2, duration, function0, rejectedExecutionHandler));
    }

    public ThreadPoolConfigBuilder withNewThreadPoolWithSynchronousQueueWithFairness(boolean fair) {
        Function0<BlockingQueue<Runnable>> function0 = ThreadPoolConfig$.MODULE$.synchronousQueue(fair);
        boolean bl = this.config().copy$default$1();
        int n = this.config().copy$default$2();
        int n2 = this.config().copy$default$3();
        Duration duration = this.config().copy$default$4();
        RejectedExecutionHandler rejectedExecutionHandler = this.config().copy$default$6();
        return this.copy(this.config().copy(bl, n, n2, duration, function0, rejectedExecutionHandler));
    }

    public ThreadPoolConfigBuilder withNewThreadPoolWithArrayBlockingQueueWithCapacityAndFairness(int capacity, boolean fair) {
        Function0<BlockingQueue<Runnable>> function0 = ThreadPoolConfig$.MODULE$.arrayBlockingQueue(capacity, fair);
        boolean bl = this.config().copy$default$1();
        int n = this.config().copy$default$2();
        int n2 = this.config().copy$default$3();
        Duration duration = this.config().copy$default$4();
        RejectedExecutionHandler rejectedExecutionHandler = this.config().copy$default$6();
        return this.copy(this.config().copy(bl, n, n2, duration, function0, rejectedExecutionHandler));
    }

    public ThreadPoolConfigBuilder setFixedPoolSize(int size) {
        return this.copy(this.config().copy(this.config().copy$default$1(), size, size, this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6()));
    }

    public ThreadPoolConfigBuilder setCorePoolSize(int size) {
        int n = package$.MODULE$.max(size, this.config().maxPoolSize());
        boolean bl = this.config().copy$default$1();
        Duration duration = this.config().copy$default$4();
        Function0<BlockingQueue<Runnable>> function0 = this.config().copy$default$5();
        RejectedExecutionHandler rejectedExecutionHandler = this.config().copy$default$6();
        return this.copy(this.config().copy(bl, size, n, duration, function0, rejectedExecutionHandler));
    }

    public ThreadPoolConfigBuilder setMaxPoolSize(int size) {
        int n = package$.MODULE$.max(size, this.config().corePoolSize());
        boolean bl = this.config().copy$default$1();
        int n2 = this.config().copy$default$2();
        Duration duration = this.config().copy$default$4();
        Function0<BlockingQueue<Runnable>> function0 = this.config().copy$default$5();
        RejectedExecutionHandler rejectedExecutionHandler = this.config().copy$default$6();
        return this.copy(this.config().copy(bl, n2, n, duration, function0, rejectedExecutionHandler));
    }

    public ThreadPoolConfigBuilder setCorePoolSizeFromFactor(int min2, double multiplier, int max2) {
        return this.setCorePoolSize(ThreadPoolConfig$.MODULE$.scaledPoolSize(min2, multiplier, max2));
    }

    public ThreadPoolConfigBuilder setMaxPoolSizeFromFactor(int min2, double multiplier, int max2) {
        return this.setMaxPoolSize(ThreadPoolConfig$.MODULE$.scaledPoolSize(min2, multiplier, max2));
    }

    public ThreadPoolConfigBuilder setKeepAliveTimeInMillis(long time) {
        return this.setKeepAliveTime(Duration$.MODULE$.apply(time, TimeUnit.MILLISECONDS));
    }

    public ThreadPoolConfigBuilder setKeepAliveTime(Duration time) {
        return this.copy(this.config().copy(this.config().copy$default$1(), this.config().copy$default$2(), this.config().copy$default$3(), time, this.config().copy$default$5(), this.config().copy$default$6()));
    }

    public ThreadPoolConfigBuilder setAllowCoreThreadTimeout(boolean allow) {
        return this.copy(this.config().copy(allow, this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6()));
    }

    public ThreadPoolConfigBuilder setQueueFactory(Function0<BlockingQueue<Runnable>> newQueueFactory) {
        return this.copy(this.config().copy(this.config().copy$default$1(), this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), newQueueFactory, this.config().copy$default$6()));
    }

    public ThreadPoolConfigBuilder configure(Seq<Option<Function1<ThreadPoolConfigBuilder, ThreadPoolConfigBuilder>>> fs) {
        return fs.foldLeft(this, (Function2<ThreadPoolConfigBuilder, Option, ThreadPoolConfigBuilder> & Serializable)(c, f) -> (ThreadPoolConfigBuilder)f.map((Function1<Function1, ThreadPoolConfigBuilder> & Serializable)_$1 -> (ThreadPoolConfigBuilder)_$1.apply(c)).getOrElse(() -> ThreadPoolConfigBuilder.configure$$anonfun$1$$anonfun$2(c)));
    }

    public ThreadPoolConfigBuilder copy(ThreadPoolConfig config) {
        return new ThreadPoolConfigBuilder(config);
    }

    public ThreadPoolConfig copy$default$1() {
        return this.config();
    }

    public ThreadPoolConfig _1() {
        return this.config();
    }

    private static final ThreadPoolConfigBuilder configure$$anonfun$1$$anonfun$2(ThreadPoolConfigBuilder c$2) {
        return c$2;
    }
}

