/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.pekko.dispatch.ExecutorServiceFactory;
import org.apache.pekko.dispatch.ExecutorServiceFactoryProvider;
import org.apache.pekko.dispatch.LoadMetrics;
import org.apache.pekko.dispatch.MonitorableThreadFactory;
import org.apache.pekko.dispatch.ThreadPoolConfig$;
import scala.Function0;
import scala.Product;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ThreadPoolConfig
implements ExecutorServiceFactoryProvider,
Product,
Serializable {
    private final boolean allowCorePoolTimeout;
    private final int corePoolSize;
    private final int maxPoolSize;
    private final Duration threadTimeout;
    private final Function0 queueFactory;
    private final RejectedExecutionHandler rejectionPolicy;

    public static ThreadPoolConfig apply(boolean bl, int n, int n2, Duration duration, Function0<BlockingQueue<Runnable>> function0, RejectedExecutionHandler rejectedExecutionHandler) {
        return ThreadPoolConfig$.MODULE$.apply(bl, n, n2, duration, function0, rejectedExecutionHandler);
    }

    public static Function0<BlockingQueue<Runnable>> arrayBlockingQueue(int n, boolean bl) {
        return ThreadPoolConfig$.MODULE$.arrayBlockingQueue(n, bl);
    }

    public static boolean defaultAllowCoreThreadTimeout() {
        return ThreadPoolConfig$.MODULE$.defaultAllowCoreThreadTimeout();
    }

    public static int defaultCorePoolSize() {
        return ThreadPoolConfig$.MODULE$.defaultCorePoolSize();
    }

    public static int defaultMaxPoolSize() {
        return ThreadPoolConfig$.MODULE$.defaultMaxPoolSize();
    }

    public static RejectedExecutionHandler defaultRejectionPolicy() {
        return ThreadPoolConfig$.MODULE$.defaultRejectionPolicy();
    }

    public static Duration defaultTimeout() {
        return ThreadPoolConfig$.MODULE$.defaultTimeout();
    }

    public static ThreadPoolConfig fromProduct(Product product) {
        return ThreadPoolConfig$.MODULE$.fromProduct(product);
    }

    public static Function0<BlockingQueue<Runnable>> linkedBlockingQueue() {
        return ThreadPoolConfig$.MODULE$.linkedBlockingQueue();
    }

    public static Function0<BlockingQueue<Runnable>> linkedBlockingQueue(int n) {
        return ThreadPoolConfig$.MODULE$.linkedBlockingQueue(n);
    }

    public static Function0<BlockingQueue<Runnable>> reusableQueue(BlockingQueue<Runnable> blockingQueue) {
        return ThreadPoolConfig$.MODULE$.reusableQueue(blockingQueue);
    }

    public static Function0<BlockingQueue<Runnable>> reusableQueue(Function0<BlockingQueue<Runnable>> function0) {
        return ThreadPoolConfig$.MODULE$.reusableQueue(function0);
    }

    public static int scaledPoolSize(int n, double d, int n2) {
        return ThreadPoolConfig$.MODULE$.scaledPoolSize(n, d, n2);
    }

    public static Function0<BlockingQueue<Runnable>> synchronousQueue(boolean bl) {
        return ThreadPoolConfig$.MODULE$.synchronousQueue(bl);
    }

    public static ThreadPoolConfig unapply(ThreadPoolConfig threadPoolConfig) {
        return ThreadPoolConfig$.MODULE$.unapply(threadPoolConfig);
    }

    public static boolean $lessinit$greater$default$1() {
        return ThreadPoolConfig$.MODULE$.$lessinit$greater$default$1();
    }

    public static int $lessinit$greater$default$2() {
        return ThreadPoolConfig$.MODULE$.$lessinit$greater$default$2();
    }

    public static int $lessinit$greater$default$3() {
        return ThreadPoolConfig$.MODULE$.$lessinit$greater$default$3();
    }

    public static Duration $lessinit$greater$default$4() {
        return ThreadPoolConfig$.MODULE$.$lessinit$greater$default$4();
    }

    public static Function0<BlockingQueue<Runnable>> $lessinit$greater$default$5() {
        return ThreadPoolConfig$.MODULE$.$lessinit$greater$default$5();
    }

    public static RejectedExecutionHandler $lessinit$greater$default$6() {
        return ThreadPoolConfig$.MODULE$.$lessinit$greater$default$6();
    }

    public ThreadPoolConfig(boolean allowCorePoolTimeout, int corePoolSize, int maxPoolSize, Duration threadTimeout, Function0<BlockingQueue<Runnable>> queueFactory, RejectedExecutionHandler rejectionPolicy) {
        this.allowCorePoolTimeout = allowCorePoolTimeout;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.threadTimeout = threadTimeout;
        this.queueFactory = queueFactory;
        this.rejectionPolicy = rejectionPolicy;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, this.allowCorePoolTimeout() ? 1231 : 1237);
        n = Statics.mix(n, this.corePoolSize());
        n = Statics.mix(n, this.maxPoolSize());
        n = Statics.mix(n, Statics.anyHash(this.threadTimeout()));
        n = Statics.mix(n, Statics.anyHash(this.queueFactory()));
        n = Statics.mix(n, Statics.anyHash(this.rejectionPolicy()));
        return Statics.finalizeHash(n, 6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ThreadPoolConfig)) return false;
        ThreadPoolConfig threadPoolConfig = (ThreadPoolConfig)object;
        if (this.allowCorePoolTimeout() != threadPoolConfig.allowCorePoolTimeout()) return false;
        if (this.corePoolSize() != threadPoolConfig.corePoolSize()) return false;
        if (this.maxPoolSize() != threadPoolConfig.maxPoolSize()) return false;
        Duration duration = this.threadTimeout();
        Duration duration2 = threadPoolConfig.threadTimeout();
        if (duration == null) {
            if (duration2 != null) {
                return false;
            }
        } else if (!duration.equals(duration2)) return false;
        Function0<BlockingQueue<Runnable>> function0 = this.queueFactory();
        Function0<BlockingQueue<Runnable>> function02 = threadPoolConfig.queueFactory();
        if (function0 == null) {
            if (function02 != null) {
                return false;
            }
        } else if (!function0.equals(function02)) return false;
        RejectedExecutionHandler rejectedExecutionHandler = this.rejectionPolicy();
        RejectedExecutionHandler rejectedExecutionHandler2 = threadPoolConfig.rejectionPolicy();
        if (rejectedExecutionHandler == null) {
            if (rejectedExecutionHandler2 == null) return true;
            return false;
        } else {
            if (!rejectedExecutionHandler.equals(rejectedExecutionHandler2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof ThreadPoolConfig;
    }

    @Override
    public int productArity() {
        return 6;
    }

    @Override
    public String productPrefix() {
        return "ThreadPoolConfig";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToBoolean(this._1());
            }
            case 1: {
                return BoxesRunTime.boxToInteger(this._2());
            }
            case 2: {
                return BoxesRunTime.boxToInteger(this._3());
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "allowCorePoolTimeout";
            }
            case 1: {
                return "corePoolSize";
            }
            case 2: {
                return "maxPoolSize";
            }
            case 3: {
                return "threadTimeout";
            }
            case 4: {
                return "queueFactory";
            }
            case 5: {
                return "rejectionPolicy";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public boolean allowCorePoolTimeout() {
        return this.allowCorePoolTimeout;
    }

    public int corePoolSize() {
        return this.corePoolSize;
    }

    public int maxPoolSize() {
        return this.maxPoolSize;
    }

    public Duration threadTimeout() {
        return this.threadTimeout;
    }

    public Function0<BlockingQueue<Runnable>> queueFactory() {
        return this.queueFactory;
    }

    public RejectedExecutionHandler rejectionPolicy() {
        return this.rejectionPolicy;
    }

    public ThreadPoolConfig copy(boolean allowCorePoolTimeout, int corePoolSize, int maxPoolSize, Duration threadTimeout, Function0<BlockingQueue<Runnable>> queueFactory, RejectedExecutionHandler rejectionPolicy) {
        return ThreadPoolConfig$.MODULE$.apply(allowCorePoolTimeout, corePoolSize, maxPoolSize, threadTimeout, queueFactory, rejectionPolicy);
    }

    public boolean copy$default$1() {
        return this.allowCorePoolTimeout();
    }

    public int copy$default$2() {
        return this.corePoolSize();
    }

    public int copy$default$3() {
        return this.maxPoolSize();
    }

    public Duration copy$default$4() {
        return this.threadTimeout();
    }

    public Function0<BlockingQueue<Runnable>> copy$default$5() {
        return this.queueFactory();
    }

    public RejectedExecutionHandler copy$default$6() {
        return this.rejectionPolicy();
    }

    @Override
    public ExecutorServiceFactory createExecutorServiceFactory(String id, ThreadFactory threadFactory) {
        ThreadFactory threadFactory2;
        ThreadFactory threadFactory3 = threadFactory;
        if (threadFactory3 instanceof MonitorableThreadFactory) {
            MonitorableThreadFactory m = (MonitorableThreadFactory)threadFactory3;
            threadFactory2 = m.withName(new StringBuilder(1).append(m.name()).append("-").append(id).toString());
        } else {
            ThreadFactory other;
            threadFactory2 = other = threadFactory3;
        }
        ThreadFactory tf = threadFactory2;
        return new ThreadPoolExecutorServiceFactory(this, tf);
    }

    public boolean _1() {
        return this.allowCorePoolTimeout();
    }

    public int _2() {
        return this.corePoolSize();
    }

    public int _3() {
        return this.maxPoolSize();
    }

    public Duration _4() {
        return this.threadTimeout();
    }

    public Function0<BlockingQueue<Runnable>> _5() {
        return this.queueFactory();
    }

    public RejectedExecutionHandler _6() {
        return this.rejectionPolicy();
    }

    public class ThreadPoolExecutorServiceFactory
    implements ExecutorServiceFactory {
        private final ThreadFactory threadFactory;
        private final /* synthetic */ ThreadPoolConfig $outer;

        public ThreadPoolExecutorServiceFactory(ThreadPoolConfig $outer, ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        @Override
        public ExecutorService createExecutorService() {
            LoadMetrics service = new LoadMetrics(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super($outer.org$apache$pekko$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$$outer().corePoolSize(), $outer.org$apache$pekko$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$$outer().maxPoolSize(), $outer.org$apache$pekko$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$$outer().threadTimeout().length(), $outer.org$apache$pekko$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$$outer().threadTimeout().unit(), $outer.org$apache$pekko$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$$outer().queueFactory().apply(), $outer.threadFactory(), $outer.org$apache$pekko$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$$outer().rejectionPolicy());
                }

                public boolean atFullThrottle() {
                    return this.getActiveCount() >= this.getPoolSize();
                }
            };
            ((ThreadPoolExecutor)((Object)service)).allowCoreThreadTimeOut(this.$outer.allowCorePoolTimeout());
            return service;
        }

        public final /* synthetic */ ThreadPoolConfig org$apache$pekko$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$$outer() {
            return this.$outer;
        }
    }
}

