/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.dispatch.CachingConfig;
import org.apache.pekko.dispatch.DefaultExecutorServiceConfigurator;
import org.apache.pekko.dispatch.DispatcherPrerequisites;
import org.apache.pekko.dispatch.ExecutorServiceConfigurator;
import org.apache.pekko.dispatch.ForkJoinExecutorConfigurator;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.dispatch.ThreadPoolExecutorConfigurator;
import org.apache.pekko.dispatch.VirtualThreadExecutorConfigurator;
import org.apache.pekko.dispatch.VirtualThreadSupport$;
import org.apache.pekko.dispatch.affinity.AffinityPoolConfigurator;
import scala.Function1;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class MessageDispatcherConfigurator {
    private final DispatcherPrerequisites prerequisites;
    private final Config config;

    public MessageDispatcherConfigurator(Config _config, DispatcherPrerequisites prerequisites) {
        this.prerequisites = prerequisites;
        this.config = new CachingConfig(_config);
    }

    public DispatcherPrerequisites prerequisites() {
        return this.prerequisites;
    }

    public Config config() {
        return this.config;
    }

    public abstract MessageDispatcher dispatcher();

    public ExecutorServiceConfigurator configureExecutor() {
        String string2 = this.config().getString("executor");
        if ("default-executor".equals(string2)) {
            return new DefaultExecutorServiceConfigurator(this.config().getConfig("default-executor"), this.prerequisites(), this.configurator$1(this.config().getString("default-executor.fallback")));
        }
        String other = string2;
        return this.configurator$1(other);
    }

    private final ExecutorServiceConfigurator configurator$1(String executor) {
        String string2;
        block5: while (true) {
            if ((string2 = executor) == null || "".equals(string2) || "fork-join-executor".equals(string2)) {
                return new ForkJoinExecutorConfigurator(this.config().getConfig("fork-join-executor"), this.prerequisites());
            }
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -70555423: {
                    if (!"thread-pool-executor".equals(string2)) break block5;
                    return new ThreadPoolExecutorConfigurator(this.config().getConfig("thread-pool-executor"), this.prerequisites());
                }
                case 867582580: {
                    if (!"virtual-thread-executor".equals(string2)) break block5;
                    if (VirtualThreadSupport$.MODULE$.isSupported()) {
                        return new VirtualThreadExecutorConfigurator(this.config().getConfig("virtual-thread-executor"), this.prerequisites());
                    }
                    executor = this.config().getString("virtual-thread-executor.fallback");
                    continue block5;
                }
                case 1768732543: {
                    if (!"affinity-pool-executor".equals(string2)) break block5;
                    return new AffinityPoolConfigurator(this.config().getConfig("affinity-pool-executor"), this.prerequisites());
                }
            }
            break;
        }
        String fqcn = string2;
        Class<Config> clazz = Predef$.MODULE$.ArrowAssoc(Config.class);
        Class<DispatcherPrerequisites> clazz2 = Predef$.MODULE$.ArrowAssoc(DispatcherPrerequisites.class);
        List args = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(clazz, this.config())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(clazz2, this.prerequisites())), Nil$.MODULE$)));
        return this.prerequisites().dynamicAccess().createInstanceFor(fqcn, args, ClassTag$.MODULE$.apply(ExecutorServiceConfigurator.class)).recover(new Serializable(fqcn, this){
            private final String fqcn$1;
            private final /* synthetic */ MessageDispatcherConfigurator $outer;
            {
                this.fqcn$1 = fqcn$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable exception = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable exception = throwable = x;
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cannot instantiate ExecutorServiceConfigurator (\"executor = [%s]\"), defined in [%s],\n                make sure it has an accessible constructor with a [%s,%s] signature"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.fqcn$1, this.$outer.config().getString("id"), Config.class, DispatcherPrerequisites.class})), exception);
            }
        }).get();
    }
}

