/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import java.util.concurrent.ForkJoinTask;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.dispatch.AbstractMailbox;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.Mailbox$;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.dispatch.MessageQueue;
import org.apache.pekko.dispatch.SystemMessageQueue;
import org.apache.pekko.dispatch.sysmsg.EarliestFirstSystemMessageList$;
import org.apache.pekko.dispatch.sysmsg.NoMessage$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.dispatch.sysmsg.SystemMessageList$;
import org.apache.pekko.event.Logging$Error$;
import org.apache.pekko.util.Unsafe;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public abstract class Mailbox
extends ForkJoinTask<BoxedUnit>
implements SystemMessageQueue,
Runnable {
    private final MessageQueue messageQueue;
    private volatile ActorCell actor;
    private volatile int _statusDoNotCallMeDirectly;
    private volatile SystemMessage _systemQueueDoNotCallMeDirectly;

    public static int Closed() {
        return Mailbox$.MODULE$.Closed();
    }

    public static int Open() {
        return Mailbox$.MODULE$.Open();
    }

    public static int Scheduled() {
        return Mailbox$.MODULE$.Scheduled();
    }

    public static boolean debug() {
        return Mailbox$.MODULE$.debug();
    }

    public static int shouldNotProcessMask() {
        return Mailbox$.MODULE$.shouldNotProcessMask();
    }

    public static int shouldScheduleMask() {
        return Mailbox$.MODULE$.shouldScheduleMask();
    }

    public static int suspendMask() {
        return Mailbox$.MODULE$.suspendMask();
    }

    public static int suspendUnit() {
        return Mailbox$.MODULE$.suspendUnit();
    }

    public Mailbox(MessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    public MessageQueue messageQueue() {
        return this.messageQueue;
    }

    public ActorCell actor() {
        return this.actor;
    }

    public void actor_$eq(ActorCell x$1) {
        this.actor = x$1;
    }

    public void setActor(ActorCell cell) {
        this.actor_$eq(cell);
    }

    public MessageDispatcher dispatcher() {
        return this.actor().dispatcher();
    }

    public void enqueue(ActorRef receiver, Envelope msg) {
        this.messageQueue().enqueue(receiver, msg);
    }

    public Envelope dequeue() {
        return this.messageQueue().dequeue();
    }

    public boolean hasMessages() {
        return this.messageQueue().hasMessages();
    }

    public int numberOfMessages() {
        return this.messageQueue().numberOfMessages();
    }

    public int _statusDoNotCallMeDirectly() {
        return this._statusDoNotCallMeDirectly;
    }

    public void _statusDoNotCallMeDirectly_$eq(int x$1) {
        this._statusDoNotCallMeDirectly = x$1;
    }

    public SystemMessage _systemQueueDoNotCallMeDirectly() {
        return this._systemQueueDoNotCallMeDirectly;
    }

    public void _systemQueueDoNotCallMeDirectly_$eq(SystemMessage x$1) {
        this._systemQueueDoNotCallMeDirectly = x$1;
    }

    public final int currentStatus() {
        return Unsafe.instance.getIntVolatile(this, AbstractMailbox.mailboxStatusOffset);
    }

    public final boolean shouldProcessMessage() {
        return (this.currentStatus() & 0xFFFFFFFD) == 0;
    }

    public final int suspendCount() {
        return this.currentStatus() / 4;
    }

    public final boolean isSuspended() {
        return (this.currentStatus() & 0xFFFFFFFC) != 0;
    }

    public final boolean isClosed() {
        return this.currentStatus() == 1;
    }

    public final boolean isScheduled() {
        return (this.currentStatus() & 2) != 0;
    }

    public final boolean updateStatus(int oldStatus, int newStatus) {
        return Unsafe.instance.compareAndSwapInt(this, AbstractMailbox.mailboxStatusOffset, oldStatus, newStatus);
    }

    public final void setStatus(int newStatus) {
        Unsafe.instance.putIntVolatile(this, AbstractMailbox.mailboxStatusOffset, newStatus);
    }

    public final boolean resume() {
        int n;
        int next;
        int s2;
        do {
            if (1 != (n = this.currentStatus())) continue;
            this.setStatus(1);
            return false;
        } while (!this.updateStatus(s2, next = (s2 = n) < 4 ? s2 : s2 - 4));
        return next < 4;
    }

    public final boolean suspend() {
        int n;
        int s2;
        do {
            if (1 != (n = this.currentStatus())) continue;
            this.setStatus(1);
            return false;
        } while (!this.updateStatus(s2 = n, s2 + 4));
        return s2 < 4;
    }

    public final boolean becomeClosed() {
        int n;
        int s2;
        do {
            if (1 != (n = this.currentStatus())) continue;
            this.setStatus(1);
            return false;
        } while (!this.updateStatus(s2 = n, 1));
        return true;
    }

    public final boolean setAsScheduled() {
        int s2;
        do {
            if (((s2 = this.currentStatus()) & 3) == 0) continue;
            return false;
        } while (!this.updateStatus(s2, s2 | 2));
        return true;
    }

    public final boolean setAsIdle() {
        int s2;
        while (!this.updateStatus(s2 = this.currentStatus(), s2 & 0xFFFFFFFD)) {
        }
        return true;
    }

    public final SystemMessage systemQueueGet() {
        return (SystemMessage)Unsafe.instance.getObjectVolatile(this, AbstractMailbox.systemMessageOffset);
    }

    public final boolean systemQueuePut(SystemMessage _old, SystemMessage _new) {
        return _old == _new || Unsafe.instance.compareAndSwapObject(this, AbstractMailbox.systemMessageOffset, _old, _new);
    }

    public final boolean canBeScheduledForExecution(boolean hasMessageHint, boolean hasSystemMessageHint) {
        int n = this.currentStatus();
        switch (n) {
            case 0: 
            case 2: {
                return hasMessageHint || hasSystemMessageHint || this.hasSystemMessages() || this.hasMessages();
            }
            case 1: {
                return false;
            }
        }
        return hasSystemMessageHint || this.hasSystemMessages();
    }

    @Override
    public final void run() {
        try {
            if (!this.isClosed()) {
                this.processAllSystemMessages();
                this.processMailbox(this.processMailbox$default$1(), this.processMailbox$default$2());
            }
        }
        finally {
            this.setAsIdle();
            this.dispatcher().registerForExecution(this, false, false);
        }
    }

    @Override
    public final void getRawResult() {
    }

    @Override
    public final void setRawResult(BoxedUnit unit) {
    }

    @Override
    public final boolean exec() {
        boolean bl;
        try {
            this.run();
            bl = false;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            bl = false;
        }
        catch (Throwable anything) {
            Thread t = Thread.currentThread();
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = t.getUncaughtExceptionHandler();
            if (uncaughtExceptionHandler != null) {
                Thread.UncaughtExceptionHandler some = uncaughtExceptionHandler;
                some.uncaughtException(t, anything);
            }
            throw anything;
        }
        return bl;
    }

    private final void processMailbox(int left, long deadlineNs) {
        while (this.shouldProcessMessage()) {
            Envelope next = this.dequeue();
            if (next != null) {
                this.actor().invoke(next);
                if (Thread.interrupted()) {
                    throw new InterruptedException("Interrupted while processing actor messages");
                }
                this.processAllSystemMessages();
                if (!(left <= 1 || this.dispatcher().isThroughputDeadlineTimeDefined() && System.nanoTime() - deadlineNs >= 0L)) {
                    --left;
                    continue;
                }
                return;
            }
            return;
        }
    }

    private int processMailbox$default$1() {
        return Math.max(this.dispatcher().throughput(), 1);
    }

    private long processMailbox$default$2() {
        if (this.dispatcher().isThroughputDeadlineTimeDefined()) {
            return System.nanoTime() + this.dispatcher().throughputDeadlineTime().toNanos();
        }
        return 0L;
    }

    public final void processAllSystemMessages() {
        Mailbox dlm;
        InterruptedException interruption = null;
        SystemMessage messageList = this.systemDrain(SystemMessageList$.MODULE$.LNil());
        while (EarliestFirstSystemMessageList$.MODULE$.nonEmpty$extension(messageList) && !this.isClosed()) {
            SystemMessage msg = messageList;
            messageList = EarliestFirstSystemMessageList$.MODULE$.tail$extension(messageList);
            msg.unlink();
            this.actor().systemInvoke(msg);
            if (Thread.interrupted()) {
                interruption = new InterruptedException("Interrupted while processing system messages");
            }
            if (!EarliestFirstSystemMessageList$.MODULE$.isEmpty$extension(messageList) || this.isClosed()) continue;
            messageList = this.systemDrain(SystemMessageList$.MODULE$.LNil());
        }
        Mailbox mailbox = dlm = EarliestFirstSystemMessageList$.MODULE$.nonEmpty$extension(messageList) ? this.actor().dispatcher().mailboxes().deadLetterMailbox() : null;
        while (EarliestFirstSystemMessageList$.MODULE$.nonEmpty$extension(messageList)) {
            SystemMessage msg = messageList;
            messageList = EarliestFirstSystemMessageList$.MODULE$.tail$extension(messageList);
            msg.unlink();
            try {
                dlm.systemEnqueue(this.actor().self(), msg);
            }
            catch (InterruptedException e) {
                interruption = e;
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    this.actor().system().eventStream().publish(Logging$Error$.MODULE$.apply(e, this.actor().self().path().toString(), this.getClass(), new StringBuilder(39).append("error while enqueuing ").append(msg).append(" to deadLetters: ").append(e.getMessage()).toString()));
                    continue;
                }
                throw throwable;
            }
        }
        if (interruption != null) {
            Thread.interrupted();
            throw interruption;
        }
    }

    public void cleanUp() {
        if (this.actor() != null) {
            Mailbox dlm = this.actor().dispatcher().mailboxes().deadLetterMailbox();
            SystemMessage messageList = this.systemDrain(NoMessage$.MODULE$);
            while (EarliestFirstSystemMessageList$.MODULE$.nonEmpty$extension(messageList)) {
                SystemMessage msg = messageList;
                messageList = EarliestFirstSystemMessageList$.MODULE$.tail$extension(messageList);
                msg.unlink();
                dlm.systemEnqueue(this.actor().self(), msg);
            }
            if (this.messageQueue() != null) {
                this.messageQueue().cleanUp(this.actor().self(), this.actor().dispatcher().mailboxes().deadLetterMailbox().messageQueue());
                return;
            }
            return;
        }
    }
}

