/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import com.typesafe.config.Config;
import org.apache.pekko.dispatch.BalancingDispatcher;
import org.apache.pekko.dispatch.BalancingDispatcherConfigurator$;
import org.apache.pekko.dispatch.DispatcherPrerequisites;
import org.apache.pekko.dispatch.MailboxType;
import org.apache.pekko.dispatch.Mailboxes;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.dispatch.MessageDispatcherConfigurator;
import org.apache.pekko.dispatch.MultipleConsumerSemantics;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$ConfigOps$;

public class BalancingDispatcherConfigurator
extends MessageDispatcherConfigurator {
    private final BalancingDispatcher instance;

    public static Config amendConfig(Config config) {
        return BalancingDispatcherConfigurator$.MODULE$.amendConfig(config);
    }

    public BalancingDispatcherConfigurator(Config _config, DispatcherPrerequisites _prerequisites) {
        super(BalancingDispatcherConfigurator$.MODULE$.amendConfig(_config), _prerequisites);
        MailboxType mailboxType;
        Mailboxes mailboxes = this.prerequisites().mailboxes();
        String id = this.config().getString("id");
        Class<? extends Object> requirement = mailboxes.getMailboxRequirement(this.config());
        if (!MultipleConsumerSemantics.class.isAssignableFrom(requirement)) {
            throw new IllegalArgumentException(new StringBuilder(122).append("BalancingDispatcher must have 'mailbox-requirement' which implements org.apache.pekko.dispatch.MultipleConsumerSemantics; ").append(new StringBuilder(20).append("dispatcher [").append(id).append("] has [").append(requirement).append("]").toString()).toString());
        }
        if (this.config().hasPath("mailbox")) {
            MailboxType mt = mailboxes.lookup(this.config().getString("mailbox"));
            if (!requirement.isAssignableFrom(mailboxes.getProducedMessageQueueType(mt))) {
                throw new IllegalArgumentException(new StringBuilder(91).append("BalancingDispatcher [").append(id).append("] has 'mailbox' [").append(mt.getClass()).append("] which is incompatible with 'mailbox-requirement' [").append(requirement).append("]").toString());
            }
            mailboxType = mt;
        } else if (this.config().hasPath("mailbox-type")) {
            MailboxType mt = mailboxes.lookup(id);
            if (!requirement.isAssignableFrom(mailboxes.getProducedMessageQueueType(mt))) {
                throw new IllegalArgumentException(new StringBuilder(96).append("BalancingDispatcher [").append(id).append("] has 'mailbox-type' [").append(mt.getClass()).append("] which is incompatible with 'mailbox-requirement' [").append(requirement).append("]").toString());
            }
            mailboxType = mt;
        } else {
            mailboxType = mailboxes.lookupByQueueType(requirement);
        }
        MailboxType mailboxType2 = mailboxType;
        this.instance = this.create(mailboxType2);
    }

    public BalancingDispatcher create(MailboxType mailboxType) {
        return new BalancingDispatcher(this, this.config().getString("id"), this.config().getInt("throughput"), Helpers$ConfigOps$.MODULE$.getNanosDuration$extension(Helpers$.MODULE$.ConfigOps(this.config()), "throughput-deadline-time"), mailboxType, this.configureExecutor(), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.config()), "shutdown-timeout"), this.config().getBoolean("attempt-teamwork"));
    }

    @Override
    public MessageDispatcher dispatcher() {
        return this.instance;
    }
}

