/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.scaladsl;

import java.io.Serializable;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.ExtensibleBehavior;
import org.apache.pekko.actor.typed.MessageAdaptionFailure;
import org.apache.pekko.actor.typed.MessageAdaptionFailure$;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import scala.Function1;
import scala.PartialFunction;
import scala.PartialFunction$;

public abstract class AbstractBehavior<T>
extends ExtensibleBehavior<T> {
    private final ActorContext context;

    public AbstractBehavior(ActorContext<T> context) {
        this.context = context;
        if (context == null) {
            throw new IllegalArgumentException("context must not be null. Wrap in Behaviors.setup and pass the context to the constructor of AbstractBehavior.");
        }
    }

    public ActorContext<T> context() {
        return this.context;
    }

    public abstract Behavior<T> onMessage(T var1) throws Exception;

    public PartialFunction<Signal, Behavior<T>> onSignal() throws Exception {
        return PartialFunction$.MODULE$.empty();
    }

    private void checkRightContext(TypedActorContext<T> ctx) {
        if (ctx.asJava() != this.context()) {
            throw new IllegalStateException(new StringBuilder(119).append("Actor [").append(ctx.asJava().getSelf()).append("] of AbstractBehavior class ").append(new StringBuilder(43).append("[").append(this.getClass().getName()).append("] was created with wrong ActorContext [").append(this.context().asJava().getSelf()).append("]. ").toString()).append("Wrap in Behaviors.setup and pass the context to the constructor of AbstractBehavior.").toString());
        }
    }

    @Override
    public final Behavior<T> receive(TypedActorContext<T> ctx, T msg) throws Exception {
        this.checkRightContext(ctx);
        return this.onMessage(msg);
    }

    @Override
    public final Behavior<T> receiveSignal(TypedActorContext<T> ctx, Signal msg) throws Exception {
        this.checkRightContext(ctx);
        return (Behavior)this.onSignal().applyOrElse(msg, new Serializable(){

            public final boolean isDefinedAt(Signal x) {
                Signal signal = x;
                if (signal instanceof MessageAdaptionFailure) {
                    Throwable throwable;
                    MessageAdaptionFailure messageAdaptionFailure = MessageAdaptionFailure$.MODULE$.unapply((MessageAdaptionFailure)signal);
                    Throwable ex = throwable = messageAdaptionFailure._1();
                    return true;
                }
                return true;
            }

            public final Object applyOrElse(Signal x, Function1 function1) {
                Signal signal = x;
                if (signal instanceof MessageAdaptionFailure) {
                    Throwable throwable;
                    MessageAdaptionFailure messageAdaptionFailure = MessageAdaptionFailure$.MODULE$.unapply((MessageAdaptionFailure)signal);
                    Throwable ex = throwable = messageAdaptionFailure._1();
                    throw ex;
                }
                return Behaviors$.MODULE$.unhandled();
            }
        });
    }
}

