/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.javadsl;

import java.io.Serializable;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.javadsl.BehaviorBuilder$;
import org.apache.pekko.actor.typed.javadsl.BehaviorBuilder$Case$;
import org.apache.pekko.actor.typed.javadsl.BuiltBehavior;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.japi.function.Creator;
import org.apache.pekko.japi.function.Function;
import org.apache.pekko.japi.function.Predicate;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import scala.Function1;
import scala.Product;
import scala.collection.AbstractIterable;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class BehaviorBuilder<T> {
    private final List<Case<T, T>> messageHandlers;
    private final List<Case<T, Signal>> signalHandlers;

    public static <T> BehaviorBuilder<T> create() {
        return BehaviorBuilder$.MODULE$.create();
    }

    public BehaviorBuilder(List<Case<T, T>> messageHandlers, List<Case<T, Signal>> signalHandlers) {
        this.messageHandlers = messageHandlers;
        this.signalHandlers = signalHandlers;
    }

    public Behavior<T> build() {
        return new BuiltBehavior((Case[])((AbstractIterable)this.messageHandlers.reverse()).toArray(ClassTag$.MODULE$.apply(Case.class)), (Case[])((AbstractIterable)this.signalHandlers.reverse()).toArray(ClassTag$.MODULE$.apply(Case.class)));
    }

    public <M extends T> BehaviorBuilder<T> onMessage(Class<M> type2, Function<M, Behavior<T>> handler) {
        Class clazz = (Class)OptionVal$Some$.MODULE$.apply(type2);
        OptionVal$.MODULE$.None();
        return this.withMessage(clazz, null, handler);
    }

    public <M extends T> BehaviorBuilder<T> onMessage(Class<M> type2, Predicate<M> test, Function<M, Behavior<T>> handler) {
        return this.withMessage((Class)OptionVal$Some$.MODULE$.apply(type2), (Function1)OptionVal$Some$.MODULE$.apply((Function1<Object, boolean> & Serializable)t -> test.test(t)), handler);
    }

    public <M extends T> BehaviorBuilder<T> onMessageUnchecked(Class<? extends T> type2, Function<M, Behavior<T>> handler) {
        Class clazz = (Class)OptionVal$Some$.MODULE$.apply(type2);
        OptionVal$.MODULE$.None();
        return this.withMessage(clazz, null, handler);
    }

    public BehaviorBuilder<T> onMessageEquals(T msg, Creator<Behavior<T>> handler) {
        return this.withMessage((Class)OptionVal$Some$.MODULE$.apply(msg.getClass()), (Function1)OptionVal$Some$.MODULE$.apply((Function1<Object, boolean> & Serializable)_$1 -> BoxesRunTime.equals(_$1, msg)), _$2 -> (Behavior)handler.create());
    }

    public BehaviorBuilder<T> onAnyMessage(Function<T, Behavior<T>> handler) {
        OptionVal$.MODULE$.None();
        OptionVal$.MODULE$.None();
        return this.withMessage(null, null, handler);
    }

    public <M extends Signal> BehaviorBuilder<T> onSignal(Class<M> type2, Function<M, Behavior<T>> handler) {
        OptionVal$.MODULE$.None();
        return this.withSignal(type2, null, handler);
    }

    public <M extends Signal> BehaviorBuilder<T> onSignal(Class<M> type2, Predicate<M> test, Function<M, Behavior<T>> handler) {
        return this.withSignal(type2, (Function1)OptionVal$Some$.MODULE$.apply((Function1<Signal, boolean> & Serializable)t -> test.test(t)), handler);
    }

    public BehaviorBuilder<T> onSignalEquals(Signal signal, Creator<Behavior<T>> handler) {
        return this.withSignal(signal.getClass(), (Function1)OptionVal$Some$.MODULE$.apply((Function1<Signal, boolean> & Serializable)_$3 -> _$3.equals(signal)), _$4 -> (Behavior)handler.create());
    }

    private <M extends T> BehaviorBuilder<T> withMessage(Class clazz, Function1 test, Function<M, Behavior<T>> handler) {
        Case<T, M> newCase;
        Case<T, M> case_ = newCase = BehaviorBuilder$Case$.MODULE$.apply(clazz, test, handler);
        return new BehaviorBuilder<T>((List)this.messageHandlers.$plus$colon(case_), this.signalHandlers);
    }

    private <M extends Signal> BehaviorBuilder<T> withSignal(Class<M> type2, Function1 test, Function<Signal, Behavior<T>> handler) {
        Case<T, Signal> case_ = BehaviorBuilder$Case$.MODULE$.apply((Class)OptionVal$Some$.MODULE$.apply(type2), test, handler);
        return new BehaviorBuilder<T>(this.messageHandlers, (List)this.signalHandlers.$plus$colon(case_));
    }

    @InternalApi
    public static final class Case<BT, MT>
    implements Product,
    Serializable {
        private final Class type;
        private final Function1 test;
        private final Function handler;

        public static <BT, MT> Case<BT, MT> apply(Class clazz, Function1 function1, Function<MT, Behavior<BT>> function) {
            return BehaviorBuilder$Case$.MODULE$.apply(clazz, function1, function);
        }

        public static Case<?, ?> fromProduct(Product product) {
            return BehaviorBuilder$Case$.MODULE$.fromProduct(product);
        }

        public static <BT, MT> Case<BT, MT> unapply(Case<BT, MT> case_) {
            return BehaviorBuilder$Case$.MODULE$.unapply(case_);
        }

        public Case(Class type2, Function1 test, Function<MT, Behavior<BT>> handler) {
            this.type = type2;
            this.test = test;
            this.handler = handler;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Case)) return false;
            Case case_ = (Case)object;
            Class clazz = this.type();
            Class clazz2 = case_.type();
            if (clazz == null) {
                if (clazz2 != null) {
                    return false;
                }
            } else if (!clazz.equals(clazz2)) return false;
            Function1 function1 = this.test();
            Function1 function12 = case_.test();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Function<MT, Behavior<BT>> function = this.handler();
            Function<MT, Behavior<BT>> function2 = case_.handler();
            if (function == null) {
                if (function2 == null) return true;
                return false;
            } else {
                if (!function.equals(function2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Case;
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "Case";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return new OptionVal<Class>(this._1());
                }
                case 1: {
                    return new OptionVal<Function1>(this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "type";
                }
                case 1: {
                    return "test";
                }
                case 2: {
                    return "handler";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Class type() {
            return this.type;
        }

        public Function1 test() {
            return this.test;
        }

        public Function<MT, Behavior<BT>> handler() {
            return this.handler;
        }

        public <BT, MT> Case<BT, MT> copy(Class type2, Function1 test, Function<MT, Behavior<BT>> handler) {
            return new Case<BT, MT>(type2, test, handler);
        }

        public <BT, MT> Class copy$default$1() {
            return this.type();
        }

        public <BT, MT> Function1 copy$default$2() {
            return this.test();
        }

        public <BT, MT> Function<MT, Behavior<BT>> copy$default$3() {
            return this.handler();
        }

        public Class _1() {
            return this.type();
        }

        public Function1 _2() {
            return this.test();
        }

        public Function<MT, Behavior<BT>> _3() {
            return this.handler();
        }
    }
}

