/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.javadsl;

import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.ExtensibleBehavior;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.javadsl.ActorContext;
import org.apache.pekko.actor.typed.javadsl.Receive;
import org.apache.pekko.actor.typed.javadsl.ReceiveBuilder;
import org.apache.pekko.actor.typed.javadsl.ReceiveBuilder$;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;

public abstract class AbstractBehavior<T>
extends ExtensibleBehavior<T> {
    private final ActorContext<T> context;
    private Receive _receive;

    public AbstractBehavior(ActorContext<T> context) {
        this.context = context;
        if (context == null) {
            throw new IllegalArgumentException("context must not be null. Wrap in Behaviors.setup and pass the context to the constructor of AbstractBehavior.");
        }
        OptionVal$.MODULE$.None();
        this._receive = null;
    }

    private Receive<T> receive() {
        Receive receive = this._receive;
        Receive receive2 = (Receive)OptionVal$Some$.MODULE$.unapply(receive);
        if (!OptionVal$.MODULE$.isEmpty$extension(receive2)) {
            Receive receive3;
            Receive r = receive3 = (Receive)OptionVal$.MODULE$.get$extension(receive2);
            return r;
        }
        Receive<T> receive4 = this.createReceive();
        this._receive = (Receive)OptionVal$Some$.MODULE$.apply(receive4);
        return receive4;
    }

    public ActorContext<T> getContext() {
        return this.context;
    }

    private void checkRightContext(TypedActorContext<T> ctx) {
        if (ctx.asJava() != this.context) {
            throw new IllegalStateException(new StringBuilder(119).append("Actor [").append(ctx.asJava().getSelf()).append("] of AbstractBehavior class ").append(new StringBuilder(43).append("[").append(this.getClass().getName()).append("] was created with wrong ActorContext [").append(this.context.asJava().getSelf()).append("]. ").toString()).append("Wrap in Behaviors.setup and pass the context to the constructor of AbstractBehavior.").toString());
        }
    }

    @Override
    public final Behavior<T> receive(TypedActorContext<T> ctx, T msg) throws Exception {
        this.checkRightContext(ctx);
        return this.receive().receive(ctx, msg);
    }

    @Override
    public final Behavior<T> receiveSignal(TypedActorContext<T> ctx, Signal msg) throws Exception {
        this.checkRightContext(ctx);
        return this.receive().receiveSignal(ctx, msg);
    }

    public abstract Receive<T> createReceive();

    public ReceiveBuilder<T> newReceiveBuilder() {
        return ReceiveBuilder$.MODULE$.create();
    }
}

