/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal.routing;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.internal.routing.RoutingLogic;
import org.apache.pekko.actor.typed.internal.routing.RoutingLogics$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.routing.ConsistentHash;
import org.apache.pekko.routing.ConsistentHash$;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Ordering$;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;

@InternalApi
public final class RoutingLogics {

    public static final class ConsistentHashingLogic<T>
    implements RoutingLogic<T> {
        private final Function1<T, String> mapping;
        private final Address baseAddress;
        private Map<String, ActorRef<T>> pathToRefs;
        private ConsistentHash<String> consistentHash;

        public ConsistentHashingLogic(int virtualNodesFactor, Function1<T, String> mapping, Address baseAddress) {
            this.mapping = mapping;
            this.baseAddress = baseAddress;
            Predef$.MODULE$.require(virtualNodesFactor > 0, this::$init$$$anonfun$1);
            this.pathToRefs = Predef$.MODULE$.Map().empty();
            this.consistentHash = ConsistentHash$.MODULE$.apply(Predef$.MODULE$.Set().empty(), virtualNodesFactor, ClassTag$.MODULE$.apply(String.class));
        }

        @Override
        public ActorRef<T> selectRoutee(T msg) {
            return (ActorRef)this.pathToRefs.apply(this.consistentHash.nodeFor(this.mapping.apply(msg)));
        }

        @Override
        public void routeesUpdated(Set<ActorRef<T>> newRoutees) {
            Map updatedPathToRefs = ((IterableOnceOps)newRoutees.map((Function1<ActorRef, Tuple2> & Serializable)routee -> {
                String string2 = Predef$.MODULE$.ArrowAssoc(this.toFullAddressString((ActorRef<T>)routee));
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, routee);
            })).toMap($less$colon$less$.MODULE$.refl());
            ConsistentHash<String> withoutOld = this.pathToRefs.keySet().diff(updatedPathToRefs.keySet()).foldLeft(this.consistentHash, RoutingLogics$::org$apache$pekko$actor$typed$internal$routing$RoutingLogics$ConsistentHashingLogic$$_$_$$anonfun$3);
            this.consistentHash = updatedPathToRefs.keySet().diff(this.pathToRefs.keySet()).foldLeft(withoutOld, RoutingLogics$::org$apache$pekko$actor$typed$internal$routing$RoutingLogics$ConsistentHashingLogic$$_$routeesUpdated$$anonfun$1);
            this.pathToRefs = updatedPathToRefs;
        }

        private String toFullAddressString(ActorRef<T> routee) {
            Address address = routee.path().address();
            if (address != null) {
                Address address2 = Address$.MODULE$.unapply(address);
                String string2 = address2._1();
                String string3 = address2._2();
                Option<String> option = address2._3();
                Option<Object> option2 = address2._4();
                if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                    return routee.path().toStringWithAddress(this.baseAddress);
                }
            }
            return routee.path().toString();
        }

        private final Object $init$$$anonfun$1() {
            return "virtualNodesFactor has to be a positive integer";
        }
    }

    public static final class RandomLogic<T>
    implements RoutingLogic<T> {
        private ActorRef<T>[] currentRoutees;

        @Override
        public ActorRef<T> selectRoutee(T msg) {
            int selectedIdx = ThreadLocalRandom.current().nextInt(this.currentRoutees.length);
            return this.currentRoutees[selectedIdx];
        }

        @Override
        public void routeesUpdated(Set<ActorRef<T>> newRoutees) {
            this.currentRoutees = (ActorRef[])newRoutees.toArray(ClassTag$.MODULE$.apply(ActorRef.class));
        }
    }

    public static final class RoundRobinLogic<T>
    implements RoutingLogic<T> {
        private ActorRef<T>[] currentRoutees;
        private int nextIdx = 0;

        @Override
        public ActorRef<T> selectRoutee(T msg) {
            if (this.nextIdx >= this.currentRoutees.length) {
                this.nextIdx = 0;
            }
            ActorRef<T> selected = this.currentRoutees[this.nextIdx];
            ++this.nextIdx;
            return selected;
        }

        @Override
        public void routeesUpdated(Set<ActorRef<T>> newRoutees) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])newRoutees.toArray(ClassTag$.MODULE$.apply(ActorRef.class)));
            ActorRef[] sortedNewRoutees = (ActorRef[])ArrayOps$.MODULE$.sortBy$extension(object, RoutingLogics$::org$apache$pekko$actor$typed$internal$routing$RoutingLogics$RoundRobinLogic$$_$_$$anonfun$1, Ordering$.MODULE$.Tuple2(Ordering$String$.MODULE$, Address$.MODULE$.addressOrdering()));
            if (this.currentRoutees != null) {
                int firstDiffIndex;
                int idx;
                for (idx = 0; idx < this.currentRoutees.length && idx < sortedNewRoutees.length; ++idx) {
                    ActorRef<T> actorRef = this.currentRoutees[idx];
                    ActorRef actorRef2 = sortedNewRoutees[idx];
                    if (actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null) break;
                }
                if (this.nextIdx > (firstDiffIndex = idx)) {
                    --this.nextIdx;
                }
            }
            this.currentRoutees = sortedNewRoutees;
        }
    }
}

