/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal.routing;

import java.io.Serializable;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorRef$ActorRefOps$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.Props;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.Terminated;
import org.apache.pekko.actor.typed.Terminated$;
import org.apache.pekko.actor.typed.internal.routing.RoutingLogic;
import org.apache.pekko.actor.typed.scaladsl.AbstractBehavior;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.ConstantFun$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@InternalApi
public final class PoolRouterImpl<T>
extends AbstractBehavior<T> {
    private final ActorContext<T> ctx;
    private final Behavior<T> behavior;
    private final RoutingLogic<T> logic;
    private final Function1<T, Object> broadcastPredicate;
    private final Props routeeProps;

    public PoolRouterImpl(ActorContext<T> ctx, int poolSize, Behavior<T> behavior, RoutingLogic<T> logic, Function1<T, Object> broadcastPredicate, Props routeeProps) {
        this.ctx = ctx;
        this.behavior = behavior;
        this.logic = logic;
        this.broadcastPredicate = broadcastPredicate;
        this.routeeProps = routeeProps;
        super(ctx);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), poolSize).foreach((Function1<Object, ActorRef> & Serializable)_$5 -> this.$init$$$anonfun$1(behavior, routeeProps, BoxesRunTime.unboxToInt(_$5)));
        this.org$apache$pekko$actor$typed$internal$routing$PoolRouterImpl$$onRouteesChanged();
    }

    public void org$apache$pekko$actor$typed$internal$routing$PoolRouterImpl$$onRouteesChanged() {
        Set children = this.context().children().toSet();
        this.logic.routeesUpdated(children);
    }

    @Override
    public Behavior<T> onMessage(T msg) {
        if (this.broadcastPredicate != ConstantFun$.MODULE$.anyToFalse() && BoxesRunTime.unboxToBoolean(this.broadcastPredicate.apply(msg))) {
            this.ctx.children().foreach(_$6 -> {
                ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(_$6.unsafeUpcast());
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, msg);
            });
        } else {
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.logic.selectRoutee(msg));
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, msg);
        }
        return this;
    }

    @Override
    public PartialFunction<Signal, Behavior<T>> onSignal() {
        return new Serializable(this){
            private final /* synthetic */ PoolRouterImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Signal x) {
                Option<ActorRef<Nothing$>> option;
                Signal signal = x;
                if (signal instanceof Terminated && !(option = Terminated$.MODULE$.unapply((Terminated)signal)).isEmpty()) {
                    ActorRef<Nothing$> actorRef;
                    ActorRef<Nothing$> child = actorRef = option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Signal x, Function1 function1) {
                Option<ActorRef<Nothing$>> option;
                Signal signal = x;
                if (signal instanceof Terminated && !(option = Terminated$.MODULE$.unapply((Terminated)signal)).isEmpty()) {
                    ActorRef<Nothing$> actorRef;
                    ActorRef<Nothing$> child = actorRef = option.get();
                    if (this.$outer.protected$context().children().nonEmpty()) {
                        this.$outer.protected$context().log().debug("Pool child stopped [{}]", (Object)child.path());
                        this.$outer.org$apache$pekko$actor$typed$internal$routing$PoolRouterImpl$$onRouteesChanged();
                        return this.$outer;
                    }
                    this.$outer.protected$context().log().info("Last pool child stopped, stopping pool [{}]", (Object)this.$outer.protected$context().self().path());
                    return Behaviors$.MODULE$.stopped();
                }
                return function1.apply(x);
            }
        };
    }

    public ActorContext<T> protected$context() {
        return this.context();
    }

    private final /* synthetic */ ActorRef $init$$$anonfun$1(Behavior behavior$1, Props routeeProps$1, int _$5) {
        ActorRef child = this.context().spawnAnonymous(behavior$1, routeeProps$1);
        this.context().watch(child);
        return child;
    }
}

