/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal.routing;

import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.Props;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.internal.routing.PoolRouterBuilder$;
import org.apache.pekko.actor.typed.internal.routing.PoolRouterImpl;
import org.apache.pekko.actor.typed.internal.routing.RoutingLogic;
import org.apache.pekko.actor.typed.internal.routing.RoutingLogics;
import org.apache.pekko.actor.typed.scaladsl.PoolRouter;
import org.apache.pekko.annotation.InternalApi;
import scala.Function1;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public final class PoolRouterBuilder<T>
extends org.apache.pekko.actor.typed.javadsl.PoolRouter<T>
implements PoolRouter<T>,
Product,
Serializable {
    private final int poolSize;
    private final Behavior behavior;
    private final Function1 logicFactory;
    private final Function1 broadcastPredicate;
    private final Props routeeProps;

    public static PoolRouterBuilder<?> fromProduct(Product product) {
        return PoolRouterBuilder$.MODULE$.fromProduct(product);
    }

    public static <T> PoolRouterBuilder<T> unapply(PoolRouterBuilder<T> poolRouterBuilder) {
        return PoolRouterBuilder$.MODULE$.unapply(poolRouterBuilder);
    }

    public static <T> Function1<ActorSystem<?>, RoutingLogic<T>> $lessinit$greater$default$3() {
        return PoolRouterBuilder$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> Function1<Object, Object> $lessinit$greater$default$4() {
        return PoolRouterBuilder$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> Props $lessinit$greater$default$5() {
        return PoolRouterBuilder$.MODULE$.$lessinit$greater$default$5();
    }

    public PoolRouterBuilder(int poolSize, Behavior<T> behavior, Function1<ActorSystem<?>, RoutingLogic<T>> logicFactory, Function1<T, Object> broadcastPredicate, Props routeeProps) {
        this.poolSize = poolSize;
        this.behavior = behavior;
        this.logicFactory = logicFactory;
        this.broadcastPredicate = broadcastPredicate;
        this.routeeProps = routeeProps;
        if (poolSize < 1) {
            throw new IllegalArgumentException(new StringBuilder(32).append("pool size must be positive, was ").append(poolSize).toString());
        }
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, this.poolSize());
        n = Statics.mix(n, Statics.anyHash(this.behavior()));
        n = Statics.mix(n, Statics.anyHash(this.logicFactory()));
        n = Statics.mix(n, Statics.anyHash(this.broadcastPredicate()));
        n = Statics.mix(n, Statics.anyHash(this.routeeProps()));
        return Statics.finalizeHash(n, 5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof PoolRouterBuilder)) return false;
        PoolRouterBuilder poolRouterBuilder = (PoolRouterBuilder)object;
        if (this.poolSize() != poolRouterBuilder.poolSize()) return false;
        Behavior<T> behavior = this.behavior();
        Behavior<T> behavior2 = poolRouterBuilder.behavior();
        if (behavior == null) {
            if (behavior2 != null) {
                return false;
            }
        } else if (!behavior.equals(behavior2)) return false;
        Function1<ActorSystem<?>, RoutingLogic<T>> function1 = this.logicFactory();
        Function1<ActorSystem<?>, RoutingLogic<T>> function12 = poolRouterBuilder.logicFactory();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        Function1<T, Object> function13 = this.broadcastPredicate();
        Function1<T, Object> function14 = poolRouterBuilder.broadcastPredicate();
        if (function13 == null) {
            if (function14 != null) {
                return false;
            }
        } else if (!function13.equals(function14)) return false;
        Props props = this.routeeProps();
        Props props2 = poolRouterBuilder.routeeProps();
        if (props == null) {
            if (props2 == null) return true;
            return false;
        } else {
            if (!props.equals(props2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof PoolRouterBuilder;
    }

    @Override
    public int productArity() {
        return 5;
    }

    @Override
    public String productPrefix() {
        return "PoolRouterBuilder";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger(this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "poolSize";
            }
            case 1: {
                return "behavior";
            }
            case 2: {
                return "logicFactory";
            }
            case 3: {
                return "broadcastPredicate";
            }
            case 4: {
                return "routeeProps";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public int poolSize() {
        return this.poolSize;
    }

    public Behavior<T> behavior() {
        return this.behavior;
    }

    public Function1<ActorSystem<?>, RoutingLogic<T>> logicFactory() {
        return this.logicFactory;
    }

    public Function1<T, Object> broadcastPredicate() {
        return this.broadcastPredicate;
    }

    public Props routeeProps() {
        return this.routeeProps;
    }

    @Override
    public Behavior<T> apply(TypedActorContext<T> ctx) {
        return new PoolRouterImpl<T>(ctx.asScala(), this.poolSize(), this.behavior(), this.logicFactory().apply(ctx.asScala().system()), this.broadcastPredicate(), this.routeeProps());
    }

    @Override
    public PoolRouterBuilder<T> withRandomRouting() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), (Function1<ActorSystem, RoutingLogic> & Serializable)_$2 -> new RoutingLogics.RandomLogic(), this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public PoolRouterBuilder<T> withRoundRobinRouting() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), (Function1<ActorSystem, RoutingLogic> & Serializable)_$3 -> new RoutingLogics.RoundRobinLogic(), this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public org.apache.pekko.actor.typed.javadsl.PoolRouter<T> withConsistentHashingRouting(int virtualNodesFactor, Function<T, String> mapping) {
        return this.withConsistentHashingRouting(virtualNodesFactor, (Function1<Object, String> & Serializable)(T1 _$4) -> (String)mapping.apply(_$4));
    }

    @Override
    public PoolRouterBuilder<T> withConsistentHashingRouting(int virtualNodesFactor, Function1<T, String> mapping) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), (Function1<ActorSystem, RoutingLogic> & Serializable)system -> new RoutingLogics.ConsistentHashingLogic(virtualNodesFactor, mapping, system.address()), this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public PoolRouterBuilder<T> withPoolSize(int poolSize) {
        return this.copy(poolSize, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public PoolRouterBuilder<T> withRouteeProps(Props routeeProps) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), routeeProps);
    }

    @Override
    public org.apache.pekko.actor.typed.javadsl.PoolRouter<T> withBroadcastPredicate(Predicate<T> predicate) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), (Function1<Object, boolean> & Serializable)value -> predicate.test(value), this.copy$default$5());
    }

    @Override
    public PoolRouter<T> withBroadcastPredicate(Function1<T, Object> predicate) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), predicate, this.copy$default$5());
    }

    public <T> PoolRouterBuilder<T> copy(int poolSize, Behavior<T> behavior, Function1<ActorSystem<?>, RoutingLogic<T>> logicFactory, Function1<T, Object> broadcastPredicate, Props routeeProps) {
        return new PoolRouterBuilder<T>(poolSize, behavior, logicFactory, broadcastPredicate, routeeProps);
    }

    public int copy$default$1() {
        return this.poolSize();
    }

    public <T> Behavior<T> copy$default$2() {
        return this.behavior();
    }

    public <T> Function1<ActorSystem<?>, RoutingLogic<T>> copy$default$3() {
        return this.logicFactory();
    }

    public <T> Function1<T, Object> copy$default$4() {
        return this.broadcastPredicate();
    }

    public <T> Props copy$default$5() {
        return this.routeeProps();
    }

    public int _1() {
        return this.poolSize();
    }

    public Behavior<T> _2() {
        return this.behavior();
    }

    public Function1<ActorSystem<?>, RoutingLogic<T>> _3() {
        return this.logicFactory();
    }

    public Function1<T, Object> _4() {
        return this.broadcastPredicate();
    }

    public Props _5() {
        return this.routeeProps();
    }
}

