/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal.routing;

import org.apache.pekko.actor.Dropped$;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorRef$ActorRefOps$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.eventstream.EventStream$Publish$;
import org.apache.pekko.actor.typed.internal.routing.GroupRouterHelper$;
import org.apache.pekko.actor.typed.internal.routing.RoutingLogic;
import org.apache.pekko.actor.typed.receptionist.Receptionist;
import org.apache.pekko.actor.typed.receptionist.ServiceKey;
import org.apache.pekko.actor.typed.scaladsl.AbstractBehavior;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$TypedActorRefOps$;
import org.apache.pekko.annotation.InternalApi;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.Set;

@InternalApi
public final class GroupRouterImpl<T>
extends AbstractBehavior<T> {
    private final ServiceKey<T> serviceKey;
    private final boolean preferLocalRoutees;
    private final RoutingLogic<T> routingLogic;
    private boolean routeesEmpty;

    public GroupRouterImpl(ActorContext<T> ctx, ServiceKey<T> serviceKey, boolean preferLocalRoutees, RoutingLogic<T> routingLogic, boolean routeesInitiallyEmpty) {
        this.serviceKey = serviceKey;
        this.preferLocalRoutees = preferLocalRoutees;
        this.routingLogic = routingLogic;
        super(ctx);
        this.routeesEmpty = routeesInitiallyEmpty;
    }

    @Override
    public Behavior<T> onMessage(T msg) {
        T t = msg;
        if (t instanceof Receptionist.Listing) {
            Receptionist.Listing listing = (Receptionist.Listing)t;
            Option option = this.serviceKey.Listing().unapply(listing);
            if (!option.isEmpty()) {
                Set set;
                Set allRoutees = set = option.get();
                Receptionist.Listing l = listing;
                this.context().log().debug("Update from receptionist: [{}]", (Object)l);
                Set update = GroupRouterHelper$.MODULE$.routeesToUpdate(allRoutees, this.preferLocalRoutees);
                Set routees = update.nonEmpty() ? update : l.allServiceInstances(this.serviceKey);
                this.routeesEmpty = routees.isEmpty();
                this.routingLogic.routeesUpdated(routees);
                return this;
            }
        }
        if (t instanceof Object) {
            T msg2 = t;
            if (!this.routeesEmpty) {
                ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.routingLogic.selectRoutee(msg2));
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, msg2);
            } else {
                ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.context().system().eventStream());
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, EventStream$Publish$.MODULE$.apply(Dropped$.MODULE$.apply(msg2, new StringBuilder(33).append("No routees in group router for [").append(this.serviceKey).append("]").toString(), package$TypedActorRefOps$.MODULE$.toClassic$extension(package$.MODULE$.TypedActorRefOps(this.context().self())))));
            }
            return this;
        }
        throw new MatchError(t);
    }
}

