/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal.routing;

import java.io.Serializable;
import java.util.function.Function;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.internal.routing.GroupRouterBuilder$;
import org.apache.pekko.actor.typed.internal.routing.InitialGroupRouterImpl;
import org.apache.pekko.actor.typed.internal.routing.RoutingLogic;
import org.apache.pekko.actor.typed.internal.routing.RoutingLogics;
import org.apache.pekko.actor.typed.javadsl.GroupRouter;
import org.apache.pekko.actor.typed.receptionist.ServiceKey;
import org.apache.pekko.annotation.InternalApi;
import scala.Function1;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public final class GroupRouterBuilder<T>
extends GroupRouter<T>
implements org.apache.pekko.actor.typed.scaladsl.GroupRouter<T>,
Product,
Serializable {
    private final ServiceKey key;
    private final boolean preferLocalRoutees;
    private final Function1 logicFactory;

    public static GroupRouterBuilder<?> fromProduct(Product product) {
        return GroupRouterBuilder$.MODULE$.fromProduct(product);
    }

    public static <T> GroupRouterBuilder<T> unapply(GroupRouterBuilder<T> groupRouterBuilder) {
        return GroupRouterBuilder$.MODULE$.unapply(groupRouterBuilder);
    }

    public static <T> boolean $lessinit$greater$default$2() {
        return GroupRouterBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> Function1<ActorSystem<?>, RoutingLogic<T>> $lessinit$greater$default$3() {
        return GroupRouterBuilder$.MODULE$.$lessinit$greater$default$3();
    }

    public GroupRouterBuilder(ServiceKey<T> key2, boolean preferLocalRoutees, Function1<ActorSystem<?>, RoutingLogic<T>> logicFactory) {
        this.key = key2;
        this.preferLocalRoutees = preferLocalRoutees;
        this.logicFactory = logicFactory;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, Statics.anyHash(this.key()));
        n = Statics.mix(n, this.preferLocalRoutees() ? 1231 : 1237);
        n = Statics.mix(n, Statics.anyHash(this.logicFactory()));
        return Statics.finalizeHash(n, 3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof GroupRouterBuilder)) return false;
        GroupRouterBuilder groupRouterBuilder = (GroupRouterBuilder)object;
        if (this.preferLocalRoutees() != groupRouterBuilder.preferLocalRoutees()) return false;
        ServiceKey<T> serviceKey = this.key();
        ServiceKey<T> serviceKey2 = groupRouterBuilder.key();
        if (serviceKey == null) {
            if (serviceKey2 != null) {
                return false;
            }
        } else if (!serviceKey.equals(serviceKey2)) return false;
        Function1<ActorSystem<?>, RoutingLogic<T>> function1 = this.logicFactory();
        Function1<ActorSystem<?>, RoutingLogic<T>> function12 = groupRouterBuilder.logicFactory();
        if (function1 == null) {
            if (function12 == null) return true;
            return false;
        } else {
            if (!function1.equals(function12)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof GroupRouterBuilder;
    }

    @Override
    public int productArity() {
        return 3;
    }

    @Override
    public String productPrefix() {
        return "GroupRouterBuilder";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean(this._2());
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "key";
            }
            case 1: {
                return "preferLocalRoutees";
            }
            case 2: {
                return "logicFactory";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public ServiceKey<T> key() {
        return this.key;
    }

    public boolean preferLocalRoutees() {
        return this.preferLocalRoutees;
    }

    public Function1<ActorSystem<?>, RoutingLogic<T>> logicFactory() {
        return this.logicFactory;
    }

    @Override
    public Behavior<T> apply(TypedActorContext<T> ctx) {
        return new InitialGroupRouterImpl<T>(ctx.asScala(), this.key(), this.preferLocalRoutees(), this.logicFactory().apply(ctx.asScala().system()));
    }

    @Override
    public GroupRouterBuilder<T> withRandomRouting() {
        return this.withRandomRouting(false);
    }

    @Override
    public GroupRouterBuilder<T> withRandomRouting(boolean preferLocalRoutees) {
        return this.copy(this.copy$default$1(), preferLocalRoutees, (Function1<ActorSystem, RoutingLogic> & Serializable)_$2 -> new RoutingLogics.RandomLogic());
    }

    @Override
    public GroupRouterBuilder<T> withRoundRobinRouting() {
        return this.withRoundRobinRouting(false);
    }

    @Override
    public GroupRouterBuilder<T> withRoundRobinRouting(boolean preferLocalRoutees) {
        return this.copy(this.copy$default$1(), preferLocalRoutees, (Function1<ActorSystem, RoutingLogic> & Serializable)_$3 -> new RoutingLogics.RoundRobinLogic());
    }

    @Override
    public GroupRouterBuilder<T> withConsistentHashingRouting(int virtualNodesFactor, Function<T, String> mapping) {
        return this.withConsistentHashingRouting(virtualNodesFactor, (Function1<Object, String> & Serializable)(T1 _$4) -> (String)mapping.apply(_$4));
    }

    @Override
    public GroupRouterBuilder<T> withConsistentHashingRouting(int virtualNodesFactor, Function1<T, String> mapping) {
        return this.copy(this.copy$default$1(), false, (Function1<ActorSystem, RoutingLogic> & Serializable)system -> new RoutingLogics.ConsistentHashingLogic(virtualNodesFactor, mapping, system.address()));
    }

    public <T> GroupRouterBuilder<T> copy(ServiceKey<T> key2, boolean preferLocalRoutees, Function1<ActorSystem<?>, RoutingLogic<T>> logicFactory) {
        return new GroupRouterBuilder<T>(key2, preferLocalRoutees, logicFactory);
    }

    public <T> ServiceKey<T> copy$default$1() {
        return this.key();
    }

    public boolean copy$default$2() {
        return this.preferLocalRoutees();
    }

    public <T> Function1<ActorSystem<?>, RoutingLogic<T>> copy$default$3() {
        return this.logicFactory();
    }

    public ServiceKey<T> _1() {
        return this.key();
    }

    public boolean _2() {
        return this.preferLocalRoutees();
    }

    public Function1<ActorSystem<?>, RoutingLogic<T>> _3() {
        return this.logicFactory();
    }
}

