/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal.pubsub;

import java.io.Serializable;
import org.apache.pekko.actor.Dropped$;
import org.apache.pekko.actor.InvalidMessageException$;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorRef$ActorRefOps$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.internal.pubsub.TopicImpl$GetTopicStats$;
import org.apache.pekko.actor.typed.internal.pubsub.TopicImpl$MessagePublished$;
import org.apache.pekko.actor.typed.internal.pubsub.TopicImpl$Publish$;
import org.apache.pekko.actor.typed.internal.pubsub.TopicImpl$Subscribe$;
import org.apache.pekko.actor.typed.internal.pubsub.TopicImpl$SubscriberTerminated$;
import org.apache.pekko.actor.typed.internal.pubsub.TopicImpl$TopicInstancesUpdated$;
import org.apache.pekko.actor.typed.internal.pubsub.TopicImpl$TopicStats$;
import org.apache.pekko.actor.typed.internal.pubsub.TopicImpl$Unsubscribe$;
import org.apache.pekko.actor.typed.pubsub.Topic;
import org.apache.pekko.actor.typed.receptionist.Receptionist;
import org.apache.pekko.actor.typed.receptionist.Receptionist$Deregister$;
import org.apache.pekko.actor.typed.receptionist.Receptionist$Register$;
import org.apache.pekko.actor.typed.receptionist.Receptionist$Subscribe$;
import org.apache.pekko.actor.typed.receptionist.ServiceKey;
import org.apache.pekko.actor.typed.receptionist.ServiceKey$;
import org.apache.pekko.actor.typed.scaladsl.AbstractBehavior;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$TypedActorRefOps$;
import org.apache.pekko.actor.typed.scaladsl.package$LoggerOps$;
import org.apache.pekko.annotation.InternalApi;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public final class TopicImpl<T>
extends AbstractBehavior<Command<T>> {
    private final ServiceKey<Command<T>> topicServiceKey;
    private Set<ActorRef<Command<T>>> topicInstances;
    private Set<ActorRef<T>> localSubscribers;
    private final ActorRef<Receptionist.Command> receptionist;

    public TopicImpl(String topicName, ActorContext<Command<T>> context, ClassTag<T> classTag) {
        super(context);
        this.topicServiceKey = ServiceKey$.MODULE$.apply(topicName, ClassTag$.MODULE$.apply(Command.class));
        package$LoggerOps$.MODULE$.debugN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(context.log()), "Starting up pub-sub topic [{}] for messages of type [{}]", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{topicName, classTag.runtimeClass().getName()}));
        this.topicInstances = Predef$.MODULE$.Set().empty();
        this.localSubscribers = Predef$.MODULE$.Set().empty();
        this.receptionist = context.system().receptionist();
        ActorRef<Receptionist.Listing> receptionistAdapter = context.messageAdapter((Function1<Receptionist.Listing, Command> & Serializable)x$1 -> {
            Option option;
            Receptionist.Listing listing = x$1;
            if (listing != null && !(option = this.topicServiceKey.Listing().unapply(listing)).isEmpty()) {
                Set set;
                Set topics = set = option.get();
                return TopicImpl$TopicInstancesUpdated$.MODULE$.apply(topics);
            }
            throw new IllegalArgumentException();
        }, ClassTag$.MODULE$.apply(Receptionist.Listing.class));
        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.receptionist);
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, Receptionist$Subscribe$.MODULE$.apply(this.topicServiceKey, receptionistAdapter));
    }

    private ActorContext<Command<T>> context$accessor() {
        return super.context();
    }

    @Override
    public Behavior<Command<T>> onMessage(Command<T> msg) {
        Command<T> command = msg;
        if (command instanceof Publish) {
            Object t;
            Publish publish = TopicImpl$Publish$.MODULE$.unapply((Publish)command);
            Object message = t = publish._1();
            if (this.topicInstances.isEmpty()) {
                if (this.localSubscribers.isEmpty()) {
                    this.context$accessor().log().trace("Publishing message of type [{}] but no subscribers, dropping", (Object)msg.getClass());
                    ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.context$accessor().system().deadLetters());
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, Dropped$.MODULE$.apply(message, "No topic subscribers known", package$TypedActorRefOps$.MODULE$.toClassic$extension(package$.MODULE$.TypedActorRefOps(this.context$accessor().self()))));
                } else {
                    this.context$accessor().log().trace("Publishing message of type [{}] to local subscribers only (topic listing not seen yet)", (Object)msg.getClass());
                    this.localSubscribers.foreach(_$1 -> {
                        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(_$1);
                        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, message);
                    });
                }
            } else {
                this.context$accessor().log().trace("Publishing message of type [{}]", (Object)msg.getClass());
                MessagePublished pub = TopicImpl$MessagePublished$.MODULE$.apply(message);
                this.topicInstances.foreach(_$2 -> {
                    ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(_$2);
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, pub);
                });
            }
            return this;
        }
        if (command instanceof MessagePublished) {
            Object t;
            MessagePublished messagePublished = TopicImpl$MessagePublished$.MODULE$.unapply((MessagePublished)command);
            Object msg2 = t = messagePublished._1();
            this.context$accessor().log().trace("Message of type [{}] published", (Object)msg2.getClass());
            this.localSubscribers.foreach(_$3 -> {
                ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(_$3);
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, msg2);
            });
            return this;
        }
        if (command instanceof Subscribe) {
            Subscribe subscribe = TopicImpl$Subscribe$.MODULE$.unapply((Subscribe)command);
            ActorRef actorRef = subscribe._1();
            ActorRef subscriber = actorRef;
            if (!this.localSubscribers.contains(subscriber)) {
                this.context$accessor().watchWith(subscriber, TopicImpl$SubscriberTerminated$.MODULE$.apply(subscriber));
                this.localSubscribers = (Set)this.localSubscribers.$plus(subscriber);
                if (this.localSubscribers.size() == 1) {
                    this.context$accessor().log().debug("Local subscriber [{}] added, went from no subscribers to one, subscribing to receptionist", (Object)subscriber);
                    ActorRef actorRef2 = ActorRef$.MODULE$.ActorRefOps(this.receptionist);
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef2, Receptionist$Register$.MODULE$.apply(this.topicServiceKey, this.context$accessor().self()));
                } else {
                    this.context$accessor().log().debug("Local subscriber [{}] added", (Object)subscriber);
                }
            } else {
                this.context$accessor().log().debug("Local subscriber [{}] already subscribed, ignoring Subscribe command");
            }
            return this;
        }
        if (command instanceof Unsubscribe) {
            ActorRef actorRef;
            Unsubscribe unsubscribe = TopicImpl$Unsubscribe$.MODULE$.unapply((Unsubscribe)command);
            ActorRef subscriber = actorRef = unsubscribe._1();
            this.context$accessor().unwatch(subscriber);
            this.localSubscribers = (Set)this.localSubscribers.filterNot((Function1<ActorRef, boolean> & Serializable)_$4 -> {
                ActorRef actorRef = _$4;
                ActorRef actorRef2 = subscriber;
                return !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null);
            });
            if (this.localSubscribers.isEmpty()) {
                this.context$accessor().log().debug("Last local subscriber [{}] unsubscribed, deregistering from receptionist", (Object)subscriber);
                ActorRef actorRef3 = ActorRef$.MODULE$.ActorRefOps(this.receptionist);
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef3, Receptionist$Deregister$.MODULE$.apply(this.topicServiceKey, this.context$accessor().self()));
            } else {
                this.context$accessor().log().debug("Local subscriber [{}] unsubscribed", (Object)subscriber);
            }
            return this;
        }
        if (command instanceof SubscriberTerminated) {
            ActorRef actorRef;
            SubscriberTerminated subscriberTerminated = TopicImpl$SubscriberTerminated$.MODULE$.unapply((SubscriberTerminated)command);
            ActorRef subscriber = actorRef = subscriberTerminated._1();
            this.localSubscribers = (Set)this.localSubscribers.$minus(subscriber);
            if (this.localSubscribers.isEmpty()) {
                this.context$accessor().log().debug("Last local subscriber [{}] terminated, deregistering from receptionist", (Object)subscriber);
                ActorRef actorRef4 = ActorRef$.MODULE$.ActorRefOps(this.receptionist);
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef4, Receptionist$Deregister$.MODULE$.apply(this.topicServiceKey, this.context$accessor().self()));
            } else {
                this.context$accessor().log().debug("Local subscriber [{}] terminated, removing from subscriber list", (Object)subscriber);
            }
            return this;
        }
        if (command instanceof TopicInstancesUpdated) {
            Set set;
            TopicInstancesUpdated topicInstancesUpdated = TopicImpl$TopicInstancesUpdated$.MODULE$.unapply((TopicInstancesUpdated)command);
            Set newTopics = set = topicInstancesUpdated._1();
            this.context$accessor().log().debug("Topic list updated [{}]", (Object)newTopics);
            this.topicInstances = newTopics;
            return this;
        }
        if (command instanceof GetTopicStats) {
            ActorRef<TopicStats> actorRef;
            GetTopicStats getTopicStats = TopicImpl$GetTopicStats$.MODULE$.unapply((GetTopicStats)command);
            ActorRef<TopicStats> replyTo = actorRef = getTopicStats._1();
            ActorRef actorRef5 = ActorRef$.MODULE$.ActorRefOps(replyTo);
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef5, TopicImpl$TopicStats$.MODULE$.apply(this.localSubscribers.size(), this.topicInstances.size()));
            return this;
        }
        Command<T> other = command;
        throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected command type ").append(other.getClass()).toString());
    }

    public static interface Command<T> {
    }

    public static final class GetTopicStats<T>
    implements Topic.Command<T>,
    Product,
    Serializable {
        private final ActorRef replyTo;

        public static <T> GetTopicStats<T> apply(ActorRef<TopicStats> actorRef) {
            return TopicImpl$GetTopicStats$.MODULE$.apply(actorRef);
        }

        public static GetTopicStats<?> fromProduct(Product product) {
            return TopicImpl$GetTopicStats$.MODULE$.fromProduct(product);
        }

        public static <T> GetTopicStats<T> unapply(GetTopicStats<T> getTopicStats) {
            return TopicImpl$GetTopicStats$.MODULE$.unapply(getTopicStats);
        }

        public GetTopicStats(ActorRef<TopicStats> replyTo) {
            this.replyTo = replyTo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GetTopicStats)) return false;
            GetTopicStats getTopicStats = (GetTopicStats)object;
            ActorRef<TopicStats> actorRef = this.replyTo();
            ActorRef<TopicStats> actorRef2 = getTopicStats.replyTo();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof GetTopicStats;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "GetTopicStats";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "replyTo";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<TopicStats> replyTo() {
            return this.replyTo;
        }

        public <T> GetTopicStats<T> copy(ActorRef<TopicStats> replyTo) {
            return new GetTopicStats<T>(replyTo);
        }

        public <T> ActorRef<TopicStats> copy$default$1() {
            return this.replyTo();
        }

        public ActorRef<TopicStats> _1() {
            return this.replyTo();
        }
    }

    public static final class MessagePublished<T>
    implements Command<T>,
    Product,
    Serializable {
        private final Object message;

        public static <T> MessagePublished<T> apply(T t) {
            return TopicImpl$MessagePublished$.MODULE$.apply(t);
        }

        public static MessagePublished<?> fromProduct(Product product) {
            return TopicImpl$MessagePublished$.MODULE$.fromProduct(product);
        }

        public static <T> MessagePublished<T> unapply(MessagePublished<T> messagePublished) {
            return TopicImpl$MessagePublished$.MODULE$.unapply(messagePublished);
        }

        public MessagePublished(T message) {
            this.message = message;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MessagePublished)) return false;
            MessagePublished messagePublished = (MessagePublished)object;
            if (!BoxesRunTime.equals(this.message(), messagePublished.message())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof MessagePublished;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "MessagePublished";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "message";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public T message() {
            return (T)this.message;
        }

        public <T> MessagePublished<T> copy(T message) {
            return new MessagePublished<T>(message);
        }

        public <T> T copy$default$1() {
            return this.message();
        }

        public T _1() {
            return this.message();
        }
    }

    public static final class Publish<T>
    implements Topic.Command<T>,
    Product,
    Serializable {
        private final Object message;

        public static <T> Publish<T> apply(T t) {
            return TopicImpl$Publish$.MODULE$.apply(t);
        }

        public static Publish<?> fromProduct(Product product) {
            return TopicImpl$Publish$.MODULE$.fromProduct(product);
        }

        public static <T> Publish<T> unapply(Publish<T> publish) {
            return TopicImpl$Publish$.MODULE$.unapply(publish);
        }

        public Publish(T message) {
            this.message = message;
            if (message == null) {
                throw InvalidMessageException$.MODULE$.apply("[null] is not an allowed message");
            }
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Publish)) return false;
            Publish publish = (Publish)object;
            if (!BoxesRunTime.equals(this.message(), publish.message())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Publish;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Publish";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "message";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public T message() {
            return (T)this.message;
        }

        public <T> Publish<T> copy(T message) {
            return new Publish<T>(message);
        }

        public <T> T copy$default$1() {
            return this.message();
        }

        public T _1() {
            return this.message();
        }
    }

    public static final class Subscribe<T>
    implements Topic.Command<T>,
    Product,
    Serializable {
        private final ActorRef subscriber;

        public static <T> Subscribe<T> apply(ActorRef<T> actorRef) {
            return TopicImpl$Subscribe$.MODULE$.apply(actorRef);
        }

        public static Subscribe<?> fromProduct(Product product) {
            return TopicImpl$Subscribe$.MODULE$.fromProduct(product);
        }

        public static <T> Subscribe<T> unapply(Subscribe<T> subscribe) {
            return TopicImpl$Subscribe$.MODULE$.unapply(subscribe);
        }

        public Subscribe(ActorRef<T> subscriber) {
            this.subscriber = subscriber;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Subscribe)) return false;
            Subscribe subscribe = (Subscribe)object;
            ActorRef<T> actorRef = this.subscriber();
            ActorRef<T> actorRef2 = subscribe.subscriber();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Subscribe;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Subscribe";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "subscriber";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<T> subscriber() {
            return this.subscriber;
        }

        public <T> Subscribe<T> copy(ActorRef<T> subscriber) {
            return new Subscribe<T>(subscriber);
        }

        public <T> ActorRef<T> copy$default$1() {
            return this.subscriber();
        }

        public ActorRef<T> _1() {
            return this.subscriber();
        }
    }

    public static final class SubscriberTerminated<T>
    implements Command<T>,
    Product,
    Serializable {
        private final ActorRef subscriber;

        public static <T> SubscriberTerminated<T> apply(ActorRef<T> actorRef) {
            return TopicImpl$SubscriberTerminated$.MODULE$.apply(actorRef);
        }

        public static SubscriberTerminated<?> fromProduct(Product product) {
            return TopicImpl$SubscriberTerminated$.MODULE$.fromProduct(product);
        }

        public static <T> SubscriberTerminated<T> unapply(SubscriberTerminated<T> subscriberTerminated) {
            return TopicImpl$SubscriberTerminated$.MODULE$.unapply(subscriberTerminated);
        }

        public SubscriberTerminated(ActorRef<T> subscriber) {
            this.subscriber = subscriber;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SubscriberTerminated)) return false;
            SubscriberTerminated subscriberTerminated = (SubscriberTerminated)object;
            ActorRef<T> actorRef = this.subscriber();
            ActorRef<T> actorRef2 = subscriberTerminated.subscriber();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof SubscriberTerminated;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "SubscriberTerminated";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "subscriber";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<T> subscriber() {
            return this.subscriber;
        }

        public <T> SubscriberTerminated<T> copy(ActorRef<T> subscriber) {
            return new SubscriberTerminated<T>(subscriber);
        }

        public <T> ActorRef<T> copy$default$1() {
            return this.subscriber();
        }

        public ActorRef<T> _1() {
            return this.subscriber();
        }
    }

    public static final class TopicInstancesUpdated<T>
    implements Command<T>,
    Product,
    Serializable {
        private final Set topics;

        public static <T> TopicInstancesUpdated<T> apply(Set<ActorRef<Command<T>>> set) {
            return TopicImpl$TopicInstancesUpdated$.MODULE$.apply(set);
        }

        public static TopicInstancesUpdated<?> fromProduct(Product product) {
            return TopicImpl$TopicInstancesUpdated$.MODULE$.fromProduct(product);
        }

        public static <T> TopicInstancesUpdated<T> unapply(TopicInstancesUpdated<T> topicInstancesUpdated) {
            return TopicImpl$TopicInstancesUpdated$.MODULE$.unapply(topicInstancesUpdated);
        }

        public TopicInstancesUpdated(Set<ActorRef<Command<T>>> topics) {
            this.topics = topics;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TopicInstancesUpdated)) return false;
            TopicInstancesUpdated topicInstancesUpdated = (TopicInstancesUpdated)object;
            Set<ActorRef<Command<T>>> set = this.topics();
            Set<ActorRef<Command<T>>> set2 = topicInstancesUpdated.topics();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof TopicInstancesUpdated;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "TopicInstancesUpdated";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "topics";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Set<ActorRef<Command<T>>> topics() {
            return this.topics;
        }

        public <T> TopicInstancesUpdated<T> copy(Set<ActorRef<Command<T>>> topics) {
            return new TopicInstancesUpdated<T>(topics);
        }

        public <T> Set<ActorRef<Command<T>>> copy$default$1() {
            return this.topics();
        }

        public Set<ActorRef<Command<T>>> _1() {
            return this.topics();
        }
    }

    public static final class TopicStats
    implements Topic.TopicStats,
    Product,
    Serializable {
        private final int localSubscriberCount;
        private final int topicInstanceCount;

        public static TopicStats apply(int n, int n2) {
            return TopicImpl$TopicStats$.MODULE$.apply(n, n2);
        }

        public static TopicStats fromProduct(Product product) {
            return TopicImpl$TopicStats$.MODULE$.fromProduct(product);
        }

        public static TopicStats unapply(TopicStats topicStats) {
            return TopicImpl$TopicStats$.MODULE$.unapply(topicStats);
        }

        public TopicStats(int localSubscriberCount, int topicInstanceCount) {
            this.localSubscriberCount = localSubscriberCount;
            this.topicInstanceCount = topicInstanceCount;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.localSubscriberCount());
            n = Statics.mix(n, this.topicInstanceCount());
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TopicStats)) return false;
            TopicStats topicStats = (TopicStats)object;
            if (this.localSubscriberCount() != topicStats.localSubscriberCount()) return false;
            if (this.topicInstanceCount() != topicStats.topicInstanceCount()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof TopicStats;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "TopicStats";
        }

        @Override
        public Object productElement(int n) {
            int n2;
            int n3 = n;
            if (0 == n3) {
                n2 = this._1();
            } else if (1 == n3) {
                n2 = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToInteger(n2);
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "localSubscriberCount";
            }
            if (1 == n2) {
                return "topicInstanceCount";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public int localSubscriberCount() {
            return this.localSubscriberCount;
        }

        @Override
        public int topicInstanceCount() {
            return this.topicInstanceCount;
        }

        public TopicStats copy(int localSubscriberCount, int topicInstanceCount) {
            return new TopicStats(localSubscriberCount, topicInstanceCount);
        }

        public int copy$default$1() {
            return this.localSubscriberCount();
        }

        public int copy$default$2() {
            return this.topicInstanceCount();
        }

        public int _1() {
            return this.localSubscriberCount();
        }

        public int _2() {
            return this.topicInstanceCount();
        }
    }

    public static final class Unsubscribe<T>
    implements Topic.Command<T>,
    Product,
    Serializable {
        private final ActorRef subscriber;

        public static <T> Unsubscribe<T> apply(ActorRef<T> actorRef) {
            return TopicImpl$Unsubscribe$.MODULE$.apply(actorRef);
        }

        public static Unsubscribe<?> fromProduct(Product product) {
            return TopicImpl$Unsubscribe$.MODULE$.fromProduct(product);
        }

        public static <T> Unsubscribe<T> unapply(Unsubscribe<T> unsubscribe) {
            return TopicImpl$Unsubscribe$.MODULE$.unapply(unsubscribe);
        }

        public Unsubscribe(ActorRef<T> subscriber) {
            this.subscriber = subscriber;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Unsubscribe)) return false;
            Unsubscribe unsubscribe = (Unsubscribe)object;
            ActorRef<T> actorRef = this.subscriber();
            ActorRef<T> actorRef2 = unsubscribe.subscriber();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Unsubscribe;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Unsubscribe";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "subscriber";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<T> subscriber() {
            return this.subscriber;
        }

        public <T> Unsubscribe<T> copy(ActorRef<T> subscriber) {
            return new Unsubscribe<T>(subscriber);
        }

        public <T> ActorRef<T> copy$default$1() {
            return this.subscriber();
        }

        public ActorRef<T> _1() {
            return this.subscriber();
        }
    }
}

