/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal.adapter;

import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.Behavior$;
import org.apache.pekko.actor.typed.ExtensibleBehavior;
import org.apache.pekko.actor.typed.PostStop$;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.internal.BehaviorImpl;
import org.apache.pekko.actor.typed.internal.BehaviorImpl$;
import org.apache.pekko.annotation.InternalApi;
import scala.runtime.BoxedUnit;

@InternalApi
public final class ComposedStoppingBehavior<T>
extends ExtensibleBehavior<T> {
    private final Behavior<T> lastBehavior;
    private final BehaviorImpl.StoppedBehavior<T> stopBehavior;

    public ComposedStoppingBehavior(Behavior<T> lastBehavior, BehaviorImpl.StoppedBehavior<T> stopBehavior) {
        this.lastBehavior = lastBehavior;
        this.stopBehavior = stopBehavior;
    }

    @Override
    public Behavior<T> receive(TypedActorContext<T> ctx, T msg) {
        throw new IllegalStateException("Stopping, should never receieve a message");
    }

    @Override
    public Behavior<T> receiveSignal(TypedActorContext<T> ctx, Signal msg) {
        Object object;
        Signal signal = msg;
        PostStop$ postStop$ = PostStop$.MODULE$;
        if (signal == null ? postStop$ != null : !signal.equals(postStop$)) {
            throw new IllegalArgumentException(new StringBuilder(86).append("The ComposedStoppingBehavior should only ever receive a PostStop signal, but received ").append(msg).toString());
        }
        Behavior<T> behavior = this.lastBehavior;
        if (behavior instanceof BehaviorImpl.DeferredBehavior) {
            object = BoxedUnit.UNIT;
        } else {
            Behavior<T> nonDeferred = behavior;
            object = Behavior$.MODULE$.interpretSignal(nonDeferred, ctx, PostStop$.MODULE$);
        }
        this.stopBehavior.onPostStop(ctx);
        return BehaviorImpl$.MODULE$.empty();
    }
}

