/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal.adapter;

import java.io.Serializable;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.FunctionRef;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.Props;
import org.apache.pekko.actor.typed.Props$;
import org.apache.pekko.actor.typed.internal.ActorContextImpl;
import org.apache.pekko.actor.typed.internal.AdaptMessage;
import org.apache.pekko.actor.typed.internal.AdaptMessage$;
import org.apache.pekko.actor.typed.internal.TimerSchedulerCrossDslSupport;
import org.apache.pekko.actor.typed.internal.adapter.ActorAdapter;
import org.apache.pekko.actor.typed.internal.adapter.ActorContextAdapter$;
import org.apache.pekko.actor.typed.internal.adapter.ActorRefAdapter$;
import org.apache.pekko.actor.typed.internal.adapter.ActorRefFactoryAdapter$;
import org.apache.pekko.actor.typed.internal.adapter.ActorSystemAdapter$;
import org.apache.pekko.annotation.InternalApi;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Nothing$;

@InternalApi
public final class ActorContextAdapter<T>
implements ActorContextImpl<T> {
    private ActorContextImpl.LoggingContext org$apache$pekko$actor$typed$internal$ActorContextImpl$$_logging;
    private ActorRef org$apache$pekko$actor$typed$internal$ActorContextImpl$$messageAdapterRef;
    private List org$apache$pekko$actor$typed$internal$ActorContextImpl$$_messageAdapters;
    private TimerSchedulerCrossDslSupport org$apache$pekko$actor$typed$internal$ActorContextImpl$$_timer;
    private Thread org$apache$pekko$actor$typed$internal$ActorContextImpl$$_currentActorThread;
    private final ActorContext classicContext;
    private final ActorAdapter<T> adapter;
    private final ActorRef self;
    private final ActorSystem system;
    private Object receiveTimeoutMsg;

    public static <U> ActorContext toClassic(org.apache.pekko.actor.typed.javadsl.ActorContext<?> actorContext) {
        return ActorContextAdapter$.MODULE$.toClassic(actorContext);
    }

    public static <U> ActorContext toClassic(org.apache.pekko.actor.typed.scaladsl.ActorContext<?> actorContext) {
        return ActorContextAdapter$.MODULE$.toClassic(actorContext);
    }

    public ActorContextAdapter(ActorContext classicContext, ActorAdapter<T> adapter) {
        this.classicContext = classicContext;
        this.adapter = adapter;
        ActorContextImpl.$init$(this);
        this.self = ActorRefAdapter$.MODULE$.apply(classicContext.self());
        this.system = ActorSystemAdapter$.MODULE$.apply(classicContext.system());
        this.receiveTimeoutMsg = null;
    }

    @Override
    public ActorContextImpl.LoggingContext org$apache$pekko$actor$typed$internal$ActorContextImpl$$_logging() {
        return this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_logging;
    }

    @Override
    public ActorRef org$apache$pekko$actor$typed$internal$ActorContextImpl$$messageAdapterRef() {
        return this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$messageAdapterRef;
    }

    @Override
    public List org$apache$pekko$actor$typed$internal$ActorContextImpl$$_messageAdapters() {
        return this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_messageAdapters;
    }

    @Override
    public TimerSchedulerCrossDslSupport org$apache$pekko$actor$typed$internal$ActorContextImpl$$_timer() {
        return this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_timer;
    }

    @Override
    public Thread org$apache$pekko$actor$typed$internal$ActorContextImpl$$_currentActorThread() {
        return this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_currentActorThread;
    }

    @Override
    public void org$apache$pekko$actor$typed$internal$ActorContextImpl$$_logging_$eq(ActorContextImpl.LoggingContext x$1) {
        this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_logging = x$1;
    }

    @Override
    public void org$apache$pekko$actor$typed$internal$ActorContextImpl$$messageAdapterRef_$eq(ActorRef x$1) {
        this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$messageAdapterRef = x$1;
    }

    @Override
    public void org$apache$pekko$actor$typed$internal$ActorContextImpl$$_messageAdapters_$eq(List x$1) {
        this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_messageAdapters = x$1;
    }

    @Override
    public void org$apache$pekko$actor$typed$internal$ActorContextImpl$$_timer_$eq(TimerSchedulerCrossDslSupport x$1) {
        this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_timer = x$1;
    }

    @Override
    public void org$apache$pekko$actor$typed$internal$ActorContextImpl$$_currentActorThread_$eq(Thread x$1) {
        this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_currentActorThread = x$1;
    }

    public ActorContext classicContext() {
        return this.classicContext;
    }

    @Override
    public Behavior<T> currentBehavior() {
        return this.adapter.currentBehavior();
    }

    @Override
    public final ActorRef<Object> self() {
        return this.self;
    }

    @Override
    public final ActorSystem<Nothing$> system() {
        return this.system;
    }

    @Override
    public ActorContext classicActorContext() {
        return this.classicContext();
    }

    @Override
    public Iterable<ActorRef<Nothing$>> children() {
        this.checkCurrentActorThread();
        return (Iterable)this.classicContext().children().map((Function1<org.apache.pekko.actor.ActorRef, ActorRef> & Serializable)_$1 -> ActorRefAdapter$.MODULE$.apply((org.apache.pekko.actor.ActorRef)_$1));
    }

    @Override
    public Option<ActorRef<Nothing$>> child(String name) {
        this.checkCurrentActorThread();
        return this.classicContext().child(name).map((Function1<org.apache.pekko.actor.ActorRef, ActorRef> & Serializable)_$2 -> ActorRefAdapter$.MODULE$.apply((org.apache.pekko.actor.ActorRef)_$2));
    }

    @Override
    public <U> ActorRef<U> spawnAnonymous(Behavior<U> behavior, Props props) {
        this.checkCurrentActorThread();
        return ActorRefFactoryAdapter$.MODULE$.spawnAnonymous(this.classicContext(), behavior, props, true);
    }

    @Override
    public <U> Props spawnAnonymous$default$2() {
        return Props$.MODULE$.empty();
    }

    @Override
    public <U> ActorRef<U> spawn(Behavior<U> behavior, String name, Props props) {
        this.checkCurrentActorThread();
        return ActorRefFactoryAdapter$.MODULE$.spawn(this.classicContext(), behavior, name, props, true);
    }

    @Override
    public <U> Props spawn$default$3() {
        return Props$.MODULE$.empty();
    }

    @Override
    public <U> void stop(ActorRef<U> child) {
        this.checkCurrentActorThread();
        ActorPath actorPath = child.path().parent();
        ActorPath actorPath2 = this.self().path();
        if (!(actorPath != null ? !actorPath.equals(actorPath2) : actorPath2 != null)) {
            InternalActorRef internalActorRef = ActorRefAdapter$.MODULE$.toClassic(child);
            if (internalActorRef instanceof FunctionRef) {
                FunctionRef f = (FunctionRef)internalActorRef;
                ActorCell cell = (ActorCell)this.classicContext();
                cell.removeFunctionRef(f);
                return;
            }
            InternalActorRef c = internalActorRef;
            Option<org.apache.pekko.actor.ActorRef> option = this.classicContext().child(child.path().name());
            if (option instanceof Some) {
                InternalActorRef internalActorRef2 = c;
                Object a = ((Some)option).value();
                if (!(internalActorRef2 != null ? !((Object)internalActorRef2).equals(a) : a != null)) {
                    this.classicContext().stop(c);
                    return;
                }
            }
            return;
        }
        ActorRef<Object> actorRef = this.self();
        ActorRef<U> actorRef2 = child;
        if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
            throw new IllegalArgumentException(new StringBuilder(174).append("Only direct children of an actor can be stopped through the actor context, ").append(new StringBuilder(71).append("but you tried to stop [").append(this.self()).append("] by passing its ActorRef to the `stop` method. ").toString()).append("Stopping self has to be expressed as explicitly returning a Stop Behavior ").append("with `Behaviors.stopped`.").toString());
        }
        throw new IllegalArgumentException(new StringBuilder(123).append("Only direct children of an actor can be stopped through the actor context, ").append(new StringBuilder(74).append("but [").append(child).append("] is not a child of [").append(this.self()).append("]. Stopping other actors has to be expressed as ").toString()).append("an explicit stop message that the actor accepts.").toString());
    }

    @Override
    public <U> void watch(ActorRef<U> other) {
        this.checkCurrentActorThread();
        this.classicContext().watch(ActorRefAdapter$.MODULE$.toClassic(other));
    }

    @Override
    public <U> void watchWith(ActorRef<U> other, T msg) {
        this.checkCurrentActorThread();
        this.classicContext().watchWith(ActorRefAdapter$.MODULE$.toClassic(other), msg);
    }

    @Override
    public <U> void unwatch(ActorRef<U> other) {
        this.checkCurrentActorThread();
        this.classicContext().unwatch(ActorRefAdapter$.MODULE$.toClassic(other));
    }

    public T receiveTimeoutMsg() {
        return (T)this.receiveTimeoutMsg;
    }

    public void receiveTimeoutMsg_$eq(T x$1) {
        this.receiveTimeoutMsg = x$1;
    }

    @Override
    public void setReceiveTimeout(FiniteDuration d, T msg) {
        this.checkCurrentActorThread();
        this.receiveTimeoutMsg_$eq(msg);
        this.classicContext().setReceiveTimeout(d);
    }

    @Override
    public void cancelReceiveTimeout() {
        this.checkCurrentActorThread();
        this.receiveTimeoutMsg_$eq(null);
        this.classicContext().setReceiveTimeout(Duration$.MODULE$.Undefined());
    }

    @Override
    public ExecutionContextExecutor executionContext() {
        return this.classicContext().dispatcher();
    }

    @Override
    public <U> Cancellable scheduleOnce(FiniteDuration delay, ActorRef<U> target, U msg) {
        Scheduler scheduler = this.classicContext().system().scheduler();
        InternalActorRef internalActorRef = ActorRefAdapter$.MODULE$.toClassic(target);
        return scheduler.scheduleOnce(delay, (org.apache.pekko.actor.ActorRef)internalActorRef, msg, (ExecutionContext)this.classicContext().dispatcher(), scheduler.scheduleOnce$default$5(delay, internalActorRef, msg));
    }

    @Override
    public <U> ActorRef<U> internalSpawnMessageAdapter(Function1<U, T> f, String _name) {
        ActorCell cell = (ActorCell)this.classicContext();
        FunctionRef ref = cell.addFunctionRef((_$3, msg) -> {
            org.apache.pekko.actor.ActorRef actorRef = this.classicContext().self();
            AdaptMessage adaptMessage = AdaptMessage$.MODULE$.apply(msg, f);
            actorRef.$bang(adaptMessage, actorRef.$bang$default$2(adaptMessage));
        }, _name);
        return ActorRefAdapter$.MODULE$.apply(ref);
    }

    @Override
    public void onUnhandled(T msg) {
        this.adapter.unhandled(msg);
    }
}

