/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal.adapter;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorInitializationException;
import org.apache.pekko.actor.ActorInitializationException$;
import org.apache.pekko.actor.ActorRefWithCell;
import org.apache.pekko.actor.OneForOneStrategy$;
import org.apache.pekko.actor.ReceiveTimeout$;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.SupervisorStrategy$Stop$;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.Behavior$;
import org.apache.pekko.actor.typed.ChildFailed$;
import org.apache.pekko.actor.typed.DeathPactException$;
import org.apache.pekko.actor.typed.MessageAdaptionFailure$;
import org.apache.pekko.actor.typed.PostStop$;
import org.apache.pekko.actor.typed.PreRestart$;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.Terminated;
import org.apache.pekko.actor.typed.Terminated$;
import org.apache.pekko.actor.typed.internal.AdaptMessage;
import org.apache.pekko.actor.typed.internal.AdaptWithRegisteredMessageAdapter;
import org.apache.pekko.actor.typed.internal.AdaptWithRegisteredMessageAdapter$;
import org.apache.pekko.actor.typed.internal.BehaviorImpl;
import org.apache.pekko.actor.typed.internal.BehaviorImpl$;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl;
import org.apache.pekko.actor.typed.internal.UnstashException;
import org.apache.pekko.actor.typed.internal.adapter.ActorAdapter$;
import org.apache.pekko.actor.typed.internal.adapter.ActorAdapter$TypedActorFailedException$;
import org.apache.pekko.actor.typed.internal.adapter.ActorContextAdapter;
import org.apache.pekko.actor.typed.internal.adapter.ActorRefAdapter$;
import org.apache.pekko.actor.typed.internal.adapter.ComposedStoppingBehavior;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@InternalApi
public final class ActorAdapter<T>
implements Actor {
    private ActorContext context;
    private org.apache.pekko.actor.ActorRef self;
    private final boolean rethrowTypedFailure;
    public Behavior<T> org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior;
    private ActorContextAdapter<T> _ctx;
    private Map<org.apache.pekko.actor.ActorRef, Throwable> failures;
    private final SupervisorStrategy supervisorStrategy;

    public ActorAdapter(Behavior<T> _initialBehavior, boolean rethrowTypedFailure) {
        this.rethrowTypedFailure = rethrowTypedFailure;
        Actor.$init$(this);
        this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior = _initialBehavior;
        this.failures = Predef$.MODULE$.Map().empty();
        this.supervisorStrategy = OneForOneStrategy$.MODULE$.apply(OneForOneStrategy$.MODULE$.$lessinit$greater$default$1(), OneForOneStrategy$.MODULE$.$lessinit$greater$default$2(), false, (PartialFunction<Throwable, SupervisorStrategy.Directive>)((Object)new Serializable(this){
            private final /* synthetic */ ActorAdapter $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                SupervisorStrategy.Directive directive;
                Throwable throwable;
                Throwable ex = throwable = x;
                this.$outer.ctx().setCurrentActorThread();
                try {
                    Throwable throwable2 = ex;
                    if (throwable2 instanceof TypedActorFailedException) {
                        Throwable throwable3;
                        TypedActorFailedException typedActorFailedException = ActorAdapter$TypedActorFailedException$.MODULE$.unapply((TypedActorFailedException)throwable2);
                        Throwable cause = throwable3 = typedActorFailedException._1();
                        this.$outer.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$recordChildFailure(cause);
                        directive = SupervisorStrategy$Stop$.MODULE$;
                    } else {
                        String string2;
                        ActorInitializationException e;
                        boolean bl;
                        org.apache.pekko.actor.ActorRef actorRef = this.$outer.sender();
                        if (actorRef instanceof ActorRefWithCell) {
                            ActorRefWithCell afwc = (ActorRefWithCell)actorRef;
                            Class<? extends Actor> clazz = afwc.underlying().props().producer().actorClass();
                            Class<ActorAdapter> clazz2 = ActorAdapter.class;
                            bl = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
                        } else {
                            bl = false;
                        }
                        boolean isTypedActor = bl;
                        this.$outer.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$recordChildFailure(ex);
                        Throwable throwable4 = ex;
                        if (throwable4 instanceof ActorInitializationException && (e = (ActorInitializationException)throwable4).getCause() != null) {
                            InvocationTargetException ex2;
                            Throwable throwable5 = e.getCause();
                            if (throwable5 instanceof InvocationTargetException && (ex2 = (InvocationTargetException)throwable5).getCause() != null) {
                                string2 = ex2.getCause().getMessage();
                            } else {
                                Throwable ex3 = throwable5;
                                string2 = ex3.getMessage();
                            }
                        } else {
                            Throwable e2 = throwable4;
                            string2 = e2.getMessage();
                        }
                        String logMessage = string2;
                        this.$outer.ctx().log().error(logMessage, ex);
                        directive = isTypedActor ? SupervisorStrategy$Stop$.MODULE$ : ActorAdapter$.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$$classicSupervisorDecider.apply(ex);
                    }
                }
                finally {
                    this.$outer.ctx().clearCurrentActorThread();
                }
                return directive;
            }
        }));
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final org.apache.pekko.actor.ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(org.apache.pekko.actor.ActorRef x$0) {
        this.self = x$0;
    }

    public Behavior<T> currentBehavior() {
        return this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior;
    }

    public ActorContextAdapter<T> ctx() {
        if (this._ctx == null) {
            this._ctx = new ActorContextAdapter(this.context(), this);
        }
        return this._ctx;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return ActorAdapter$.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$$DummyReceive;
    }

    @Override
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive, Object msg) {
        this.ctx().setCurrentActorThread();
        try {
            Object object = msg;
            if (object instanceof org.apache.pekko.actor.Terminated) {
                Terminated terminated;
                org.apache.pekko.actor.Terminated terminated2 = org.apache.pekko.actor.Terminated$.MODULE$.unapply((org.apache.pekko.actor.Terminated)object);
                org.apache.pekko.actor.ActorRef actorRef = terminated2._1();
                org.apache.pekko.actor.ActorRef ref = actorRef;
                if (this.failures.contains(ref)) {
                    Throwable ex = (Throwable)this.failures.apply(ref);
                    this.failures = (Map)this.failures.$minus(ref);
                    terminated = ChildFailed$.MODULE$.apply(ActorRefAdapter$.MODULE$.apply(ref), ex);
                } else {
                    terminated = Terminated$.MODULE$.apply(ActorRefAdapter$.MODULE$.apply(ref));
                }
                Terminated msg2 = terminated;
                this.handleSignal(msg2);
            } else if (ReceiveTimeout$.MODULE$.equals(object)) {
                this.handleMessage(this.ctx().receiveTimeoutMsg());
            } else if (object instanceof AdaptMessage) {
                AdaptMessage wrapped = (AdaptMessage)object;
                this.withSafelyAdapted((Function0<Object> & Serializable)() -> wrapped.adapt(), x$1 -> {
                    Object object = x$1;
                    if (object instanceof AdaptWithRegisteredMessageAdapter) {
                        Object u;
                        AdaptWithRegisteredMessageAdapter adaptWithRegisteredMessageAdapter = AdaptWithRegisteredMessageAdapter$.MODULE$.unapply((AdaptWithRegisteredMessageAdapter)object);
                        Object msg = u = adaptWithRegisteredMessageAdapter._1();
                        this.adaptAndHandle(msg);
                        return;
                    }
                    if (object instanceof Object) {
                        Object msg = object;
                        this.handleMessage(msg);
                        return;
                    }
                    throw new MatchError(object);
                });
            } else if (object instanceof AdaptWithRegisteredMessageAdapter) {
                Object u;
                AdaptWithRegisteredMessageAdapter adaptWithRegisteredMessageAdapter = AdaptWithRegisteredMessageAdapter$.MODULE$.unapply((AdaptWithRegisteredMessageAdapter)object);
                Object msg3 = u = adaptWithRegisteredMessageAdapter._1();
                this.adaptAndHandle(msg3);
            } else if (object instanceof Signal) {
                Signal signal = (Signal)object;
                this.handleSignal(signal);
            } else {
                Object msg4;
                Object t = msg4 = object;
                this.handleMessage(t);
            }
        }
        finally {
            this.ctx().clearCurrentActorThread();
            this.ctx().clearMdc();
        }
    }

    private void handleMessage(T msg) {
        try {
            ActorContextAdapter<T> c = this.ctx();
            if (c.hasTimer()) {
                T t = msg;
                if (t instanceof TimerSchedulerImpl.TimerMsg) {
                    TimerSchedulerImpl.TimerMsg timerMsg = (TimerSchedulerImpl.TimerMsg)t;
                    Object object = ((TimerSchedulerImpl)c.timer()).interceptTimerMsg(this.ctx().log(), timerMsg);
                    Object object2 = OptionVal$Some$.MODULE$.unapply(object);
                    if (!OptionVal$.MODULE$.isEmpty$extension(object2)) {
                        Object a;
                        Object m = a = OptionVal$.MODULE$.get$extension(object2);
                        this.next(Behavior$.MODULE$.interpretMessage(this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior, c, m), m);
                    }
                } else {
                    this.next(Behavior$.MODULE$.interpretMessage(this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior, c, msg), msg);
                }
            } else {
                this.next(Behavior$.MODULE$.interpretMessage(this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior, c, msg), msg);
            }
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $1$ = this.handleUnstashException();
            if ($1$.isDefinedAt(ex$)) {
                $1$.apply(ex$);
            }
            throw ex$;
        }
    }

    private void handleSignal(Signal sig) {
        try {
            this.next(Behavior$.MODULE$.interpretSignal(this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior, this.ctx(), sig), sig);
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $2$ = this.handleUnstashException();
            if ($2$.isDefinedAt(ex$)) {
                $2$.apply(ex$);
            }
            throw ex$;
        }
    }

    private PartialFunction<Throwable, BoxedUnit> handleUnstashException() {
        return new Serializable(this){
            private final /* synthetic */ ActorAdapter $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option<Tuple3<org.apache.pekko.actor.ActorRef, String, Throwable>> option;
                TypedActorFailedException typedActorFailedException;
                Throwable throwable;
                Throwable throwable2 = x;
                if (throwable2 instanceof UnstashException) {
                    UnstashException e = (UnstashException)throwable2;
                    return true;
                }
                if (throwable2 instanceof TypedActorFailedException && (throwable = (typedActorFailedException = ActorAdapter$TypedActorFailedException$.MODULE$.unapply((TypedActorFailedException)throwable2))._1()) instanceof UnstashException) {
                    UnstashException e = (UnstashException)throwable;
                    return true;
                }
                if (throwable2 instanceof ActorInitializationException && !(option = ActorInitializationException$.MODULE$.unapply((ActorInitializationException)throwable2)).isEmpty()) {
                    Tuple3<org.apache.pekko.actor.ActorRef, String, Throwable> tuple3 = option.get();
                    Throwable throwable3 = tuple3._3();
                    org.apache.pekko.actor.ActorRef actor = tuple3._1();
                    String message = tuple3._2();
                    if (throwable3 instanceof UnstashException) {
                        UnstashException e = (UnstashException)throwable3;
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option<Tuple3<org.apache.pekko.actor.ActorRef, String, Throwable>> option;
                TypedActorFailedException typedActorFailedException;
                Throwable throwable;
                Throwable throwable2 = x;
                if (throwable2 instanceof UnstashException) {
                    UnstashException e = (UnstashException)throwable2;
                    this.$outer.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior = e.behavior();
                    throw e.cause();
                }
                if (throwable2 instanceof TypedActorFailedException && (throwable = (typedActorFailedException = ActorAdapter$TypedActorFailedException$.MODULE$.unapply((TypedActorFailedException)throwable2))._1()) instanceof UnstashException) {
                    UnstashException e = (UnstashException)throwable;
                    this.$outer.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior = e.behavior();
                    throw ActorAdapter$TypedActorFailedException$.MODULE$.apply(e.cause());
                }
                if (throwable2 instanceof ActorInitializationException && !(option = ActorInitializationException$.MODULE$.unapply((ActorInitializationException)throwable2)).isEmpty()) {
                    Tuple3<org.apache.pekko.actor.ActorRef, String, Throwable> tuple3 = option.get();
                    Throwable throwable3 = tuple3._3();
                    org.apache.pekko.actor.ActorRef actor = tuple3._1();
                    String message = tuple3._2();
                    if (throwable3 instanceof UnstashException) {
                        UnstashException e = (UnstashException)throwable3;
                        this.$outer.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior = e.behavior();
                        throw ActorInitializationException$.MODULE$.apply(actor, message, e.cause());
                    }
                }
                return function1.apply(x);
            }
        };
    }

    private void next(Behavior<T> b, Object msg) {
        int n = b._tag();
        switch (n) {
            case 4: {
                this.unhandled(msg);
                return;
            }
            case 7: {
                BehaviorImpl.FailedBehavior f = (BehaviorImpl.FailedBehavior)b;
                if (this.rethrowTypedFailure) {
                    throw ActorAdapter$TypedActorFailedException$.MODULE$.apply(f.cause());
                }
                this.context().stop(this.self());
                return;
            }
            case 8: {
                BehaviorImpl.StoppedBehavior stopped = (BehaviorImpl.StoppedBehavior)b;
                this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior = new ComposedStoppingBehavior<T>(this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior, stopped);
                this.context().stop(this.self());
                return;
            }
        }
        this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior = Behavior$.MODULE$.canonicalize(b, this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior, this.ctx());
    }

    private void adaptAndHandle(Object msg) {
        this.handle$1(msg, this.ctx().messageAdapters());
    }

    private <U, V> void withSafelyAdapted(Function0<U> adapt, Function1<U, V> body) {
        U u;
        boolean failed = false;
        try {
            u = adapt.apply();
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = option.get();
                this.handleSignal(MessageAdaptionFailure$.MODULE$.apply(ex));
                failed = true;
                u = null;
            }
            throw throwable;
        }
        U adapted = u;
        if (!failed) {
            if (adapted != null) {
                body.apply(adapted);
                return;
            }
            this.ctx().log().warn("Adapter function returned null which is not valid as an actor message, ignoring. This can happen for example when using pipeToSelf and returning null from the adapt function. Null value is ignored and not passed on to actor.");
            return;
        }
    }

    @Override
    public void unhandled(Object msg) {
        Option<ActorRef<Nothing$>> option;
        Object object = msg;
        if (object instanceof Terminated && !(option = Terminated$.MODULE$.unapply((Terminated)object)).isEmpty()) {
            ActorRef<Nothing$> actorRef;
            ActorRef<Nothing$> ref = actorRef = option.get();
            throw DeathPactException$.MODULE$.apply(ref);
        }
        if (object instanceof Signal) {
            return;
        }
        Object other = object;
        Actor.unhandled$(this, other);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    public void org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$recordChildFailure(Throwable ex) {
        org.apache.pekko.actor.ActorRef ref = this.sender();
        if (((ActorCell)this.context()).isWatching(ref)) {
            this.failures = (Map)this.failures.updated(ref, ex);
            return;
        }
    }

    @Override
    public void aroundPreStart() {
        this.ctx().setCurrentActorThread();
        try {
            Actor.aroundPreStart$(this);
        }
        finally {
            this.ctx().clearCurrentActorThread();
        }
    }

    @Override
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        this.ctx().setCurrentActorThread();
        try {
            Actor.aroundPreRestart$(this, reason, message);
        }
        finally {
            this.ctx().clearCurrentActorThread();
        }
    }

    @Override
    public void aroundPostRestart(Throwable reason) {
        this.ctx().setCurrentActorThread();
        try {
            Actor.aroundPostRestart$(this, reason);
        }
        finally {
            this.ctx().clearCurrentActorThread();
        }
    }

    @Override
    public void aroundPostStop() {
        this.ctx().setCurrentActorThread();
        try {
            Actor.aroundPostStop$(this);
        }
        finally {
            this.ctx().clearCurrentActorThread();
        }
    }

    @Override
    public void preStart() {
        try {
            if (Behavior$.MODULE$.isAlive(this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior)) {
                this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior = Behavior$.MODULE$.validateAsInitial(Behavior$.MODULE$.start(this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior, this.ctx()));
            }
            if (!Behavior$.MODULE$.isAlive(this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior)) {
                this.context().stop(this.self());
            }
        }
        finally {
            this.ctx().clearMdc();
        }
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) {
        try {
            this.ctx().cancelAllTimers();
            Behavior$.MODULE$.interpretSignal(this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior, this.ctx(), PreRestart$.MODULE$);
            this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior = BehaviorImpl$.MODULE$.stopped();
        }
        finally {
            this.ctx().clearMdc();
        }
    }

    @Override
    public void postRestart(Throwable reason) {
        try {
            this.ctx().cancelAllTimers();
            this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior = Behavior$.MODULE$.validateAsInitial(Behavior$.MODULE$.start(this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior, this.ctx()));
            if (!Behavior$.MODULE$.isAlive(this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior)) {
                this.context().stop(this.self());
            }
        }
        finally {
            this.ctx().clearMdc();
        }
    }

    @Override
    public void postStop() {
        try {
            Object object;
            this.ctx().cancelAllTimers();
            Behavior<T> behavior = this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior;
            if (behavior instanceof BehaviorImpl.DeferredBehavior) {
                object = BoxedUnit.UNIT;
            } else {
                Behavior<T> b = behavior;
                object = Behavior$.MODULE$.interpretSignal(b, this.ctx(), PostStop$.MODULE$);
            }
            this.org$apache$pekko$actor$typed$internal$adapter$ActorAdapter$$behavior = BehaviorImpl$.MODULE$.stopped();
        }
        finally {
            this.ctx().clearMdc();
        }
    }

    private final void handle$1(Object msg$1, List adapters) {
        List list;
        while (true) {
            list = adapters;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null)) {
                this.unhandled(msg$1);
                return;
            }
            if (!(list instanceof $colon$colon)) break;
            $colon$colon $colon$colon = ($colon$colon)list;
            Tuple2 tuple2 = (Tuple2)$colon$colon.head();
            List list3 = $colon$colon.next$access$1();
            if (tuple2 == null) break;
            Class clazz = (Class)tuple2._1();
            Function1 f = (Function1)tuple2._2();
            List tail = list3;
            if (clazz.isAssignableFrom(msg$1.getClass())) {
                this.withSafelyAdapted((Function0<Object> & Serializable)() -> f.apply(msg$1), msg -> this.handleMessage(msg));
                return;
            }
            adapters = tail;
        }
        throw new MatchError(list);
    }

    public static final class TypedActorFailedException
    extends RuntimeException
    implements Product {
        private final Throwable cause;

        public static TypedActorFailedException apply(Throwable throwable) {
            return ActorAdapter$TypedActorFailedException$.MODULE$.apply(throwable);
        }

        public static TypedActorFailedException fromProduct(Product product) {
            return ActorAdapter$TypedActorFailedException$.MODULE$.fromProduct(product);
        }

        public static TypedActorFailedException unapply(TypedActorFailedException typedActorFailedException) {
            return ActorAdapter$TypedActorFailedException$.MODULE$.unapply(typedActorFailedException);
        }

        public TypedActorFailedException(Throwable cause) {
            this.cause = cause;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TypedActorFailedException)) return false;
            TypedActorFailedException typedActorFailedException = (TypedActorFailedException)object;
            Throwable throwable = this.cause();
            Throwable throwable2 = typedActorFailedException.cause();
            if (throwable != null) {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
            if (throwable2 == null) return true;
            return false;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof TypedActorFailedException;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "TypedActorFailedException";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Throwable cause() {
            return this.cause;
        }

        public TypedActorFailedException copy(Throwable cause) {
            return new TypedActorFailedException(cause);
        }

        public Throwable copy$default$1() {
            return this.cause();
        }

        public Throwable _1() {
            return this.cause();
        }
    }
}

