/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal;

import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.BehaviorInterceptor;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.internal.InterceptorImpl;
import org.apache.pekko.actor.typed.internal.WithMdcBehaviorInterceptor$;
import org.apache.pekko.annotation.InternalApi;
import org.slf4j.MDC;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;

@InternalApi
public final class WithMdcBehaviorInterceptor<T>
extends BehaviorInterceptor<T, T> {
    private final Map<String, String> staticMdc;
    private final Function1<T, Map<String, String>> mdcForMessage;

    public static <T> Behavior<T> apply(Map<String, String> map, Function1<T, Map<String, String>> function1, Behavior<T> behavior, ClassTag<T> classTag) {
        return WithMdcBehaviorInterceptor$.MODULE$.apply(map, function1, behavior, classTag);
    }

    public static Function1<Object, Map<String, String>> noMdcPerMessage() {
        return WithMdcBehaviorInterceptor$.MODULE$.noMdcPerMessage();
    }

    public WithMdcBehaviorInterceptor(Map<String, String> staticMdc, Function1<T, Map<String, String>> mdcForMessage, ClassTag<T> evidence$1) {
        this.staticMdc = staticMdc;
        this.mdcForMessage = mdcForMessage;
        super(evidence$1);
    }

    @Override
    public Behavior<T> aroundStart(TypedActorContext<T> ctx, BehaviorInterceptor.PreStartTarget<T> target) {
        Behavior behavior;
        try {
            this.setMdcValues((Map<String, String>)Predef$.MODULE$.Map().empty());
            behavior = this.loop$1(target.start(ctx));
        }
        finally {
            MDC.clear();
        }
        return behavior;
    }

    @Override
    public boolean isSame(BehaviorInterceptor<Object, Object> other) {
        BehaviorInterceptor<Object, Object> behaviorInterceptor = other;
        return behaviorInterceptor instanceof WithMdcBehaviorInterceptor;
    }

    @Override
    public Behavior<T> aroundReceive(TypedActorContext<T> ctx, T msg, BehaviorInterceptor.ReceiveTarget<T> target) {
        Behavior<T> behavior;
        try {
            this.setMdcValues(this.mdcForMessage.apply(msg));
            behavior = target.apply(ctx, msg);
        }
        finally {
            MDC.clear();
        }
        return behavior;
    }

    @Override
    public Behavior<T> aroundSignal(TypedActorContext<T> ctx, Signal signal, BehaviorInterceptor.SignalTarget<T> target) {
        Behavior<T> behavior;
        try {
            this.setMdcValues((Map<String, String>)Predef$.MODULE$.Map().empty());
            behavior = target.apply(ctx, signal);
        }
        finally {
            MDC.clear();
        }
        return behavior;
    }

    private void setMdcValues(Map<String, String> dynamicMdc) {
        if (this.staticMdc.nonEmpty()) {
            this.staticMdc.foreach(x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key2 = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    MDC.put(key2, value);
                    return;
                }
                throw new MatchError(tuple2);
            });
        }
        if (dynamicMdc.nonEmpty()) {
            dynamicMdc.foreach(x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key2 = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    MDC.put(key2, value);
                    return;
                }
                throw new MatchError(tuple2);
            });
            return;
        }
    }

    public String toString() {
        return new StringBuilder(9).append("WithMdc(").append(this.staticMdc).append(")").toString();
    }

    private final Behavior loop$1(Behavior next) {
        Behavior behavior;
        while ((behavior = next) instanceof InterceptorImpl) {
            InterceptorImpl interceptorImpl = (InterceptorImpl)behavior;
            InterceptorImpl i = interceptorImpl;
            if (i.interceptor().isSame(this)) {
                next = i.nestedBehavior();
                continue;
            }
            InterceptorImpl i2 = interceptorImpl;
            Behavior nested = i2.nestedBehavior();
            Behavior inner = this.loop$1(nested);
            if (inner == nested) {
                return i2;
            }
            return i2.replaceNested(inner);
        }
        Behavior b = behavior;
        return b;
    }
}

