/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal;

import java.io.Serializable;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.NotInfluenceReceiveTimeout;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorRef$ActorRefOps$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.internal.TimerSchedulerCrossDslSupport;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl$;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl$FixedDelayMode$;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl$FixedRateMode$;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl$SingleMode$;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl$Timer$;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.package$;
import org.apache.pekko.actor.typed.scaladsl.package$LoggerOps$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public class TimerSchedulerImpl<T>
implements TimerSchedulerCrossDslSupport<T> {
    private final ActorContext<T> ctx;
    private Map<Object, Timer<T>> timers;
    private final Iterator<Object> timerGen;

    public static <T> Behavior<T> withTimers(Function1<TimerSchedulerCrossDslSupport<T>, Behavior<T>> function1) {
        return TimerSchedulerImpl$.MODULE$.withTimers(function1);
    }

    public static <T> Behavior<T> wrapWithTimers(Function1<TimerSchedulerCrossDslSupport<T>, Behavior<T>> function1, ActorContext<T> actorContext) {
        return TimerSchedulerImpl$.MODULE$.wrapWithTimers(function1, actorContext);
    }

    public TimerSchedulerImpl(ActorContext<T> ctx) {
        this.ctx = ctx;
        this.timers = Predef$.MODULE$.Map().empty();
        this.timerGen = scala.package$.MODULE$.Iterator().from(1);
    }

    @Override
    public void startTimerAtFixedRate(Object key2, T msg, FiniteDuration interval) {
        this.startTimer(key2, msg, interval, TimerSchedulerImpl$FixedRateMode$.MODULE$.apply(interval));
    }

    @Override
    public void startTimerAtFixedRate(Object key2, T msg, FiniteDuration initialDelay, FiniteDuration interval) {
        this.startTimer(key2, msg, interval, TimerSchedulerImpl$FixedRateMode$.MODULE$.apply(initialDelay));
    }

    @Override
    public void startTimerWithFixedDelay(Object key2, T msg, FiniteDuration delay) {
        this.startTimer(key2, msg, delay, TimerSchedulerImpl$FixedDelayMode$.MODULE$.apply(delay));
    }

    @Override
    public void startTimerWithFixedDelay(Object key2, T msg, FiniteDuration initialDelay, FiniteDuration delay) {
        this.startTimer(key2, msg, delay, TimerSchedulerImpl$FixedDelayMode$.MODULE$.apply(initialDelay));
    }

    @Override
    public void startPeriodicTimer(Object key2, T msg, FiniteDuration interval) {
        this.startTimer(key2, msg, interval, TimerSchedulerImpl$FixedRateMode$.MODULE$.apply(interval));
    }

    @Override
    public void startSingleTimer(Object key2, T msg, FiniteDuration delay) {
        this.startTimer(key2, msg, delay, TimerSchedulerImpl$SingleMode$.MODULE$);
    }

    private void startTimer(Object key2, T msg, FiniteDuration delay, TimerMode mode) {
        Cancellable cancellable;
        Option option = this.timers.get(key2);
        if (option instanceof Some) {
            Timer t = (Timer)((Some)option).value();
            this.cancelTimer(t);
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        int nextGen = BoxesRunTime.unboxToInt(this.timerGen.next());
        Object timerMsg = msg instanceof NotInfluenceReceiveTimeout ? new NotInfluenceReceiveTimeout(key2, nextGen, this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(key$1, nextGen$1, $outer);
            }
        } : new TimerMsg(key2, nextGen, this);
        TimerMode timerMode = mode;
        if (TimerSchedulerImpl$SingleMode$.MODULE$.equals(timerMode)) {
            cancellable = this.ctx.system().scheduler().scheduleOnce(delay, () -> this.$anonfun$1((TimerMsg)timerMsg), ExecutionContexts$.MODULE$.parasitic());
        } else if (timerMode instanceof FixedDelayMode) {
            FixedDelayMode m = (FixedDelayMode)timerMode;
            cancellable = this.ctx.system().scheduler().scheduleWithFixedDelay(m.initialDelay(), delay, () -> this.$anonfun$2((TimerMsg)timerMsg), ExecutionContexts$.MODULE$.parasitic());
        } else if (timerMode instanceof FixedRateMode) {
            FixedRateMode m = (FixedRateMode)timerMode;
            cancellable = this.ctx.system().scheduler().scheduleAtFixedRate(m.initialDelay(), delay, () -> this.$anonfun$3((TimerMsg)timerMsg), ExecutionContexts$.MODULE$.parasitic());
        } else {
            throw new MatchError(timerMode);
        }
        Cancellable task = cancellable;
        Timer<T> nextTimer = TimerSchedulerImpl$Timer$.MODULE$.apply(key2, msg, mode.repeat(), nextGen, task);
        this.timers = (Map)this.timers.updated(key2, nextTimer);
    }

    @Override
    public boolean isTimerActive(Object key2) {
        return this.timers.contains(key2);
    }

    @Override
    public void cancel(Object key2) {
        Option option = this.timers.get(key2);
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some) {
            Timer t = (Timer)((Some)option).value();
            this.cancelTimer(t);
            return;
        }
        throw new MatchError(option);
    }

    private void cancelTimer(Timer<T> timer) {
        timer.task().cancel();
        this.timers = (Map)this.timers.$minus(timer.key());
    }

    @Override
    public void cancelAll() {
        this.timers.valuesIterator().foreach((Function1<Timer, boolean> & Serializable)timer -> timer.task().cancel());
        this.timers = Predef$.MODULE$.Map().empty();
    }

    public Object interceptTimerMsg(Logger log, TimerMsg timerMsg) {
        Option option = this.timers.get(timerMsg.key());
        if (None$.MODULE$.equals(option)) {
            log.debug("Received timer [{}] that has been removed, discarding", timerMsg.key());
            return OptionVal$.MODULE$.none();
        }
        if (option instanceof Some) {
            Timer t = (Timer)((Some)option).value();
            if (timerMsg.owner() != this) {
                log.debug("Received timer [{}] from old restarted instance, discarding", timerMsg.key());
                return OptionVal$.MODULE$.none();
            }
            if (timerMsg.generation() == t.generation()) {
                if (!t.repeat()) {
                    this.timers = (Map)this.timers.$minus(t.key());
                }
                return OptionVal$Some$.MODULE$.apply(t.msg());
            }
            if (log.isDebugEnabled()) {
                package$LoggerOps$.MODULE$.debugN$extension(package$.MODULE$.LoggerOps(log), "Received timer [{}] from old generation [{}], expected generation [{}], discarding", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{timerMsg.key(), BoxesRunTime.boxToInteger(timerMsg.generation()), BoxesRunTime.boxToInteger(t.generation())}));
            }
            return OptionVal$.MODULE$.none();
        }
        throw new MatchError(option);
    }

    private final /* synthetic */ void $anonfun$1(TimerMsg timerMsg$1) {
        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.ctx.self().unsafeUpcast());
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, timerMsg$1);
    }

    private final /* synthetic */ void $anonfun$2(TimerMsg timerMsg$2) {
        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.ctx.self().unsafeUpcast());
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, timerMsg$2);
    }

    private final /* synthetic */ void $anonfun$3(TimerMsg timerMsg$3) {
        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.ctx.self().unsafeUpcast());
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, timerMsg$3);
    }

    public static class FixedDelayMode
    implements TimerMode,
    Product,
    Serializable {
        private final FiniteDuration initialDelay;

        public static FixedDelayMode apply(FiniteDuration finiteDuration) {
            return TimerSchedulerImpl$FixedDelayMode$.MODULE$.apply(finiteDuration);
        }

        public static FixedDelayMode fromProduct(Product product) {
            return TimerSchedulerImpl$FixedDelayMode$.MODULE$.fromProduct(product);
        }

        public static FixedDelayMode unapply(FixedDelayMode fixedDelayMode) {
            return TimerSchedulerImpl$FixedDelayMode$.MODULE$.unapply(fixedDelayMode);
        }

        public FixedDelayMode(FiniteDuration initialDelay) {
            this.initialDelay = initialDelay;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FixedDelayMode)) return false;
            FixedDelayMode fixedDelayMode = (FixedDelayMode)object;
            FiniteDuration finiteDuration = this.initialDelay();
            FiniteDuration finiteDuration2 = fixedDelayMode.initialDelay();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!((Object)finiteDuration).equals(finiteDuration2)) return false;
            if (!fixedDelayMode.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof FixedDelayMode;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "FixedDelayMode";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "initialDelay";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public FiniteDuration initialDelay() {
            return this.initialDelay;
        }

        @Override
        public boolean repeat() {
            return true;
        }

        public FixedDelayMode copy(FiniteDuration initialDelay) {
            return new FixedDelayMode(initialDelay);
        }

        public FiniteDuration copy$default$1() {
            return this.initialDelay();
        }

        public FiniteDuration _1() {
            return this.initialDelay();
        }
    }

    public static class FixedRateMode
    implements TimerMode,
    Product,
    Serializable {
        private final FiniteDuration initialDelay;

        public static FixedRateMode apply(FiniteDuration finiteDuration) {
            return TimerSchedulerImpl$FixedRateMode$.MODULE$.apply(finiteDuration);
        }

        public static FixedRateMode fromProduct(Product product) {
            return TimerSchedulerImpl$FixedRateMode$.MODULE$.fromProduct(product);
        }

        public static FixedRateMode unapply(FixedRateMode fixedRateMode) {
            return TimerSchedulerImpl$FixedRateMode$.MODULE$.unapply(fixedRateMode);
        }

        public FixedRateMode(FiniteDuration initialDelay) {
            this.initialDelay = initialDelay;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FixedRateMode)) return false;
            FixedRateMode fixedRateMode = (FixedRateMode)object;
            FiniteDuration finiteDuration = this.initialDelay();
            FiniteDuration finiteDuration2 = fixedRateMode.initialDelay();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!((Object)finiteDuration).equals(finiteDuration2)) return false;
            if (!fixedRateMode.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof FixedRateMode;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "FixedRateMode";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "initialDelay";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public FiniteDuration initialDelay() {
            return this.initialDelay;
        }

        @Override
        public boolean repeat() {
            return true;
        }

        public FixedRateMode copy(FiniteDuration initialDelay) {
            return new FixedRateMode(initialDelay);
        }

        public FiniteDuration copy$default$1() {
            return this.initialDelay();
        }

        public FiniteDuration _1() {
            return this.initialDelay();
        }
    }

    public static final class Timer<T>
    implements Product,
    Serializable {
        private final Object key;
        private final Object msg;
        private final boolean repeat;
        private final int generation;
        private final Cancellable task;

        public static <T> Timer<T> apply(Object object, T t, boolean bl, int n, Cancellable cancellable) {
            return TimerSchedulerImpl$Timer$.MODULE$.apply(object, t, bl, n, cancellable);
        }

        public static Timer<?> fromProduct(Product product) {
            return TimerSchedulerImpl$Timer$.MODULE$.fromProduct(product);
        }

        public static <T> Timer<T> unapply(Timer<T> timer) {
            return TimerSchedulerImpl$Timer$.MODULE$.unapply(timer);
        }

        public Timer(Object key2, T msg, boolean repeat, int generation, Cancellable task) {
            this.key = key2;
            this.msg = msg;
            this.repeat = repeat;
            this.generation = generation;
            this.task = task;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.key()));
            n = Statics.mix(n, Statics.anyHash(this.msg()));
            n = Statics.mix(n, this.repeat() ? 1231 : 1237);
            n = Statics.mix(n, this.generation());
            n = Statics.mix(n, Statics.anyHash(this.task()));
            return Statics.finalizeHash(n, 5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Timer)) return false;
            Timer timer = (Timer)object;
            if (this.repeat() != timer.repeat()) return false;
            if (this.generation() != timer.generation()) return false;
            if (!BoxesRunTime.equals(this.key(), timer.key())) return false;
            if (!BoxesRunTime.equals(this.msg(), timer.msg())) return false;
            Cancellable cancellable = this.task();
            Cancellable cancellable2 = timer.task();
            if (cancellable != null) {
                if (!cancellable.equals(cancellable2)) return false;
                return true;
            }
            if (cancellable2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Timer;
        }

        @Override
        public int productArity() {
            return 5;
        }

        @Override
        public String productPrefix() {
            return "Timer";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean(this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger(this._4());
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "msg";
                }
                case 2: {
                    return "repeat";
                }
                case 3: {
                    return "generation";
                }
                case 4: {
                    return "task";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Object key() {
            return this.key;
        }

        public T msg() {
            return (T)this.msg;
        }

        public boolean repeat() {
            return this.repeat;
        }

        public int generation() {
            return this.generation;
        }

        public Cancellable task() {
            return this.task;
        }

        public <T> Timer<T> copy(Object key2, T msg, boolean repeat, int generation, Cancellable task) {
            return new Timer<T>(key2, msg, repeat, generation, task);
        }

        public <T> Object copy$default$1() {
            return this.key();
        }

        public <T> T copy$default$2() {
            return this.msg();
        }

        public boolean copy$default$3() {
            return this.repeat();
        }

        public int copy$default$4() {
            return this.generation();
        }

        public <T> Cancellable copy$default$5() {
            return this.task();
        }

        public Object _1() {
            return this.key();
        }

        public T _2() {
            return this.msg();
        }

        public boolean _3() {
            return this.repeat();
        }

        public int _4() {
            return this.generation();
        }

        public Cancellable _5() {
            return this.task();
        }
    }

    public static interface TimerMode {
        public boolean repeat();
    }

    public static class TimerMsg {
        private final Object key;
        private final int generation;
        private final Object owner;

        public TimerMsg(Object key2, int generation, Object owner) {
            this.key = key2;
            this.generation = generation;
            this.owner = owner;
        }

        public Object key() {
            return this.key;
        }

        public int generation() {
            return this.generation;
        }

        public Object owner() {
            return this.owner;
        }

        public String toString() {
            return new StringBuilder(35).append("TimerMsg(key=").append(this.key()).append(", generation=").append(this.generation()).append(", owner=").append(this.owner()).append(")").toString();
        }
    }
}

