/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.pekko.actor.DeadLetter$;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorRef$ActorRefOps$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.Behavior$;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.internal.BehaviorImpl$;
import org.apache.pekko.actor.typed.internal.StashBufferImpl$;
import org.apache.pekko.actor.typed.internal.UnstashException$;
import org.apache.pekko.actor.typed.javadsl.StashOverflowException;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.StashBuffer;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$TypedActorRefOps$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.japi.function.Procedure;
import org.apache.pekko.util.ConstantFun$;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@InternalApi
public final class StashBufferImpl<T>
implements org.apache.pekko.actor.typed.javadsl.StashBuffer<T>,
StashBuffer<T> {
    public final ActorContext<T> org$apache$pekko$actor$typed$internal$StashBufferImpl$$ctx;
    private final int capacity;
    private Node _first;
    private Node _last;
    private int _size;
    private Behavior currentBehaviorWhenUnstashInProgress;

    public static <T> StashBufferImpl<T> apply(ActorContext<T> actorContext, int n) {
        return StashBufferImpl$.MODULE$.apply(actorContext, n);
    }

    public StashBufferImpl(ActorContext<T> ctx, int capacity, Node<T> _first, Node<T> _last) {
        this.org$apache$pekko$actor$typed$internal$StashBufferImpl$$ctx = ctx;
        this.capacity = capacity;
        this._first = _first;
        this._last = _last;
        this._size = this._first() == null ? 0 : 1;
        OptionVal$.MODULE$.None();
        this.currentBehaviorWhenUnstashInProgress = null;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    private Node<T> _first() {
        return this._first;
    }

    private void _first_$eq(Node<T> x$0) {
        this._first = x$0;
    }

    private Node<T> _last() {
        return this._last;
    }

    private void _last_$eq(Node<T> x$0) {
        this._last = x$0;
    }

    @Override
    public boolean isEmpty() {
        return this._first() == null;
    }

    @Override
    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean isFull() {
        return this._size == this.capacity();
    }

    @Override
    public StashBufferImpl<T> stash(T message) {
        if (message == null) {
            throw new NullPointerException();
        }
        if (this.isFull()) {
            throw new StashOverflowException(new StringBuilder(16).append("Couldn't add [").append(message.getClass().getName()).append("] ").append(new StringBuilder(38).append("because stash with capacity [").append(this.capacity()).append("] is full").toString()).toString());
        }
        Node<T> node = this.createNode(message, this.org$apache$pekko$actor$typed$internal$StashBufferImpl$$ctx);
        if (this.isEmpty()) {
            this._first_$eq(node);
            this._last_$eq(node);
        } else {
            this._last().next_$eq(node);
            this._last_$eq(node);
        }
        ++this._size;
        return this;
    }

    @Override
    public void clear() {
        this._first_$eq(null);
        this._last_$eq(null);
        this._size = 0;
        this.stashCleared(this.org$apache$pekko$actor$typed$internal$StashBufferImpl$$ctx);
    }

    @InternalStableApi
    private Node<T> createNode(T message, ActorContext<T> ctx) {
        return new Node<T>(null, message);
    }

    @InternalStableApi
    public Node<T> org$apache$pekko$actor$typed$internal$StashBufferImpl$$dropHeadForUnstash() {
        Node<T> message = this.rawHead();
        this._first_$eq(this._first().next());
        --this._size;
        if (this.isEmpty()) {
            this._last_$eq(null);
        }
        return message;
    }

    @InternalStableApi
    private Behavior<T> interpretUnstashedMessage(Behavior<T> behavior, TypedActorContext<T> ctx, T wrappedMessage, Node<T> node) {
        return Behavior$.MODULE$.interpretMessage(behavior, ctx, wrappedMessage);
    }

    private Node<T> rawHead() {
        if (this.nonEmpty()) {
            return this._first();
        }
        throw new NoSuchElementException("head of empty buffer");
    }

    @Override
    public T head() {
        if (this.nonEmpty()) {
            return this._first().message();
        }
        throw new NoSuchElementException("head of empty buffer");
    }

    @Override
    public void foreach(Function1<T, BoxedUnit> f) {
        for (Node<T> node = this._first(); node != null; node = node.next()) {
            node.apply(f);
        }
    }

    @Override
    public void forEach(Procedure<T> f) {
        this.foreach(param2 -> f.apply(param2));
    }

    @Override
    public <U> boolean contains(U message) {
        return this.exists((Function1<Object, boolean> & Serializable)_$1 -> BoxesRunTime.equals(_$1, message));
    }

    @Override
    public boolean exists(Function1<T, Object> predicate) {
        boolean hasElement = false;
        for (Node<T> node = this._first(); node != null && !hasElement; node = node.next()) {
            hasElement = BoxesRunTime.unboxToBoolean(predicate.apply(node.message()));
        }
        return hasElement;
    }

    @Override
    public boolean anyMatch(Predicate<T> predicate) {
        return this.exists((Function1<Object, boolean> & Serializable)x$0 -> predicate.test(x$0));
    }

    @Override
    public Behavior<T> unstashAll(Behavior<T> behavior) {
        Behavior<T> behav = this.unstash(behavior, this.size(), ConstantFun$.MODULE$.scalaIdentityFunction());
        this.stashCleared(this.org$apache$pekko$actor$typed$internal$StashBufferImpl$$ctx);
        return behav;
    }

    @Override
    public Behavior<T> unstash(Behavior<T> behavior, int numberOfMessages, Function1<T, T> wrap) {
        Behavior<T> behavior2;
        if (this.isEmpty()) {
            return behavior;
        }
        Behavior behavior3 = this.currentBehaviorWhenUnstashInProgress;
        boolean unstashAlreadyInProgress = OptionVal$.MODULE$.isDefined$extension(behavior3);
        try {
            Iterator<Node<T>> iter = new Iterator<Node<T>>(this){
                private final /* synthetic */ StashBufferImpl $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    IterableOnce.$init$(this);
                    IterableOnceOps.$init$(this);
                    Iterator.$init$(this);
                }

                public boolean hasNext() {
                    return this.$outer.nonEmpty();
                }

                public Node next() {
                    Node<T> next = this.$outer.org$apache$pekko$actor$typed$internal$StashBufferImpl$$dropHeadForUnstash();
                    this.$outer.unstashed(this.$outer.org$apache$pekko$actor$typed$internal$StashBufferImpl$$ctx, next);
                    return next;
                }
            }.take(package$.MODULE$.min(numberOfMessages, this.size()));
            behavior2 = this.interpretUnstashedMessages(behavior, this.org$apache$pekko$actor$typed$internal$StashBufferImpl$$ctx, iter, wrap);
        }
        finally {
            if (!unstashAlreadyInProgress) {
                OptionVal$.MODULE$.None();
                this.currentBehaviorWhenUnstashInProgress = null;
            }
        }
        return behavior2;
    }

    private Behavior<T> interpretUnstashedMessages(Behavior<T> behavior, TypedActorContext<T> ctx, Iterator<Node<T>> messages, Function1<T, T> wrap) {
        Behavior actualInitialBehavior;
        Behavior behavior2;
        Behavior c;
        Behavior behavior3;
        Behavior behavior4;
        Behavior started = Behavior$.MODULE$.start(behavior, ctx);
        if (Behavior$.MODULE$.isUnhandled(started)) {
            throw new IllegalArgumentException("Cannot unstash with unhandled as starting behavior");
        }
        Behavior behavior5 = started;
        Behavior behavior6 = BehaviorImpl$.MODULE$.same();
        Behavior behavior7 = !(behavior5 != null ? !behavior5.equals(behavior6) : behavior6 != null) ? (!OptionVal$.MODULE$.isEmpty$extension(behavior4 = (Behavior)OptionVal$Some$.MODULE$.unapply(behavior3 = this.currentBehaviorWhenUnstashInProgress)) ? (c = (behavior2 = (Behavior)OptionVal$.MODULE$.get$extension(behavior4))) : ctx.asScala().currentBehavior()) : (actualInitialBehavior = started);
        if (Behavior$.MODULE$.isAlive(actualInitialBehavior)) {
            return this.interpretOne$1(ctx, messages, wrap, actualInitialBehavior);
        }
        this.unstashRestToDeadLetters(ctx, messages, wrap);
        return started;
    }

    private void unstashRestToDeadLetters(TypedActorContext<T> ctx, Iterator<Node<T>> messages, Function1<T, T> wrap) {
        ActorContext scalaCtx = ctx.asScala();
        org.apache.pekko.actor.ActorRef classicDeadLetters = package$TypedActorRefOps$.MODULE$.toClassic$extension(org.apache.pekko.actor.typed.scaladsl.adapter.package$.MODULE$.TypedActorRefOps(scalaCtx.system().deadLetters()));
        messages.foreach((A node) -> {
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(scalaCtx.system().deadLetters());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, DeadLetter$.MODULE$.apply(wrap.apply(node.message()), classicDeadLetters, package$TypedActorRefOps$.MODULE$.toClassic$extension(org.apache.pekko.actor.typed.scaladsl.adapter.package$.MODULE$.TypedActorRefOps(ctx.asScala().self()))));
        });
    }

    @Override
    public Behavior<T> unstash(Behavior<T> behavior, int numberOfMessages, Function<T, T> wrap) {
        return this.unstash(behavior, numberOfMessages, (Function1<Object, Object> & Serializable)(T x) -> wrap.apply(x));
    }

    public String toString() {
        return new StringBuilder(14).append("StashBuffer(").append(this.size()).append("/").append(this.capacity()).append(")").toString();
    }

    @InternalStableApi
    public void unstashed(ActorContext<T> ctx, Node<T> node) {
    }

    @InternalStableApi
    private void stashCleared(ActorContext<T> ctx) {
    }

    private final Behavior interpretOne$1(TypedActorContext ctx$1, Iterator messages$1, Function1 wrap$1, Behavior b) {
        Behavior actualNext;
        while (true) {
            Behavior behavior;
            Behavior interpretResult;
            Behavior behavior2;
            Behavior b2 = Behavior$.MODULE$.start(b, ctx$1);
            this.currentBehaviorWhenUnstashInProgress = (Behavior)OptionVal$Some$.MODULE$.apply(b2);
            if (!Behavior$.MODULE$.isAlive(b2) || !messages$1.hasNext()) {
                return b2;
            }
            Node node = (Node)messages$1.next();
            Object message = wrap$1.apply(node.message());
            try {
                Object r = message;
                if (r instanceof Signal) {
                    Signal sig = (Signal)r;
                    behavior2 = Behavior$.MODULE$.interpretSignal(b2, ctx$1, sig);
                } else {
                    Object msg = r;
                    behavior2 = this.interpretUnstashedMessage(b2, ctx$1, msg, node);
                }
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    throw UnstashException$.MODULE$.apply(e, b2);
                }
                throw throwable;
            }
            Behavior behavior3 = interpretResult = behavior2;
            Behavior behavior4 = BehaviorImpl$.MODULE$.same();
            if (!(behavior3 != null ? !behavior3.equals(behavior4) : behavior4 != null)) {
                behavior = b2;
            } else if (Behavior$.MODULE$.isUnhandled(interpretResult)) {
                ctx$1.asScala().onUnhandled(message);
                behavior = b2;
            } else {
                behavior = actualNext = interpretResult;
            }
            if (!Behavior$.MODULE$.isAlive(actualNext)) break;
            b = Behavior$.MODULE$.canonicalize(actualNext, b2, ctx$1);
        }
        this.unstashRestToDeadLetters(ctx$1, messages$1, wrap$1);
        return actualNext;
    }

    public static final class Node<T> {
        private Node next;
        private final Object message;

        public Node(Node<T> next, T message) {
            this.next = next;
            this.message = message;
        }

        public Node<T> next() {
            return this.next;
        }

        public void next_$eq(Node<T> x$1) {
            this.next = x$1;
        }

        public T message() {
            return (T)this.message;
        }

        public void apply(Function1<T, BoxedUnit> f) {
            f.apply(this.message());
        }
    }
}

