/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal;

import java.io.Serializable;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.Behavior$;
import org.apache.pekko.actor.typed.BehaviorInterceptor;
import org.apache.pekko.actor.typed.PreRestart$;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.SupervisorStrategy;
import org.apache.pekko.actor.typed.Terminated;
import org.apache.pekko.actor.typed.Terminated$;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.internal.AbstractSupervisor;
import org.apache.pekko.actor.typed.internal.BehaviorImpl$;
import org.apache.pekko.actor.typed.internal.RestartSupervisor$;
import org.apache.pekko.actor.typed.internal.RestartSupervisor$ResetRestartCount$;
import org.apache.pekko.actor.typed.internal.RestartSupervisor$ScheduledRestart$;
import org.apache.pekko.actor.typed.internal.UnstashException;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.actor.typed.scaladsl.StashBuffer;
import org.apache.pekko.actor.typed.scaladsl.StashBuffer$;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

public class RestartSupervisor<T, Thr extends Throwable>
extends AbstractSupervisor<T, Thr> {
    private final Behavior<T> initial;
    public final SupervisorStrategy.RestartOrBackoff org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy;
    private Tuple2 restartingInProgress;
    public int org$apache$pekko$actor$typed$internal$RestartSupervisor$$restartCount;
    private boolean gotScheduledRestart;
    private Deadline deadline;

    public static FiniteDuration calculateDelay(int n, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, double d) {
        return RestartSupervisor$.MODULE$.calculateDelay(n, finiteDuration, finiteDuration2, d);
    }

    public RestartSupervisor(Behavior<T> initial, SupervisorStrategy.RestartOrBackoff strategy, ClassTag<Thr> evidence$1) {
        this.initial = initial;
        this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy = strategy;
        super((SupervisorStrategy)((Object)strategy), evidence$1);
        OptionVal$.MODULE$.None();
        this.restartingInProgress = null;
        this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$restartCount = 0;
        this.gotScheduledRestart = true;
        OptionVal$.MODULE$.None();
        this.deadline = null;
    }

    public boolean org$apache$pekko$actor$typed$internal$RestartSupervisor$$deadlineHasTimeLeft() {
        Deadline deadline = this.deadline;
        Deadline deadline2 = (Deadline)OptionVal$Some$.MODULE$.unapply(deadline);
        if (!OptionVal$.MODULE$.isEmpty$extension(deadline2)) {
            Deadline deadline3;
            Deadline d = deadline3 = (Deadline)OptionVal$.MODULE$.get$extension(deadline2);
            return d.hasTimeLeft();
        }
        return true;
    }

    @Override
    public Behavior<T> aroundSignal(TypedActorContext<Object> ctx, Signal signal, BehaviorInterceptor.SignalTarget<T> target) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Signal signal2 = signal;
        if (signal2 instanceof ScheduledRestart) {
            ScheduledRestart scheduledRestart = RestartSupervisor$ScheduledRestart$.MODULE$.unapply((ScheduledRestart)signal2);
            RestartSupervisor<?, Throwable> restartSupervisor = scheduledRestart._1();
            RestartSupervisor<?, Throwable> owner = restartSupervisor;
            if (owner == this) {
                Tuple2 tuple23;
                Tuple2 tuple24;
                Tuple2 tuple25 = this.restartingInProgress;
                Tuple2 tuple26 = (Tuple2)OptionVal$Some$.MODULE$.unapply(tuple25);
                if (!OptionVal$.MODULE$.isEmpty$extension(tuple26) && (tuple24 = (tuple23 = (Tuple2)OptionVal$.MODULE$.get$extension(tuple26))) != null) {
                    Set children = (Set)tuple24._2();
                    if (this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy.stopChildren() && children.nonEmpty()) {
                        this.gotScheduledRestart = true;
                        return Behaviors$.MODULE$.same();
                    }
                    return this.restartCompleted(ctx);
                }
                throw new IllegalStateException("Unexpected ScheduledRestart when restart not in progress");
            }
            return super.aroundSignal(ctx, signal, target);
        }
        if (signal2 instanceof ResetRestartCount) {
            ResetRestartCount resetRestartCount = RestartSupervisor$ResetRestartCount$.MODULE$.unapply((ResetRestartCount)signal2);
            int n = resetRestartCount._1();
            RestartSupervisor<?, Throwable> restartSupervisor = resetRestartCount._2();
            int current = n;
            RestartSupervisor<?, Throwable> owner = restartSupervisor;
            if (owner == this) {
                if (current == this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$restartCount) {
                    this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$restartCount = 0;
                }
                return BehaviorImpl$.MODULE$.same();
            }
            return super.aroundSignal(ctx, signal, target);
        }
        Tuple2 tuple27 = this.restartingInProgress;
        Tuple2 tuple28 = (Tuple2)OptionVal$Some$.MODULE$.unapply(tuple27);
        if (!OptionVal$.MODULE$.isEmpty$extension(tuple28) && (tuple22 = (tuple2 = (Tuple2)OptionVal$.MODULE$.get$extension(tuple28))) != null) {
            Object object;
            Option<ActorRef<Nothing$>> option;
            StashBuffer stashBuffer = (StashBuffer)tuple22._1();
            Set children = (Set)tuple22._2();
            Signal signal3 = signal;
            if (signal3 instanceof Terminated && !(option = Terminated$.MODULE$.unapply((Terminated)signal3)).isEmpty()) {
                ActorRef<Nothing$> actorRef;
                ActorRef<Nothing$> ref = actorRef = option.get();
                if (this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy.stopChildren() && children.apply(ref)) {
                    Set remainingChildren = (Set)children.$minus(ref);
                    if (remainingChildren.isEmpty() && this.gotScheduledRestart) {
                        return this.restartCompleted(ctx);
                    }
                    this.restartingInProgress = (Tuple2)OptionVal$Some$.MODULE$.apply(Tuple2$.MODULE$.apply(stashBuffer, remainingChildren));
                    return Behaviors$.MODULE$.same();
                }
            }
            if (stashBuffer.isFull()) {
                this.dropped(ctx, signal);
                object = BoxedUnit.UNIT;
            } else {
                object = stashBuffer.stash(signal);
            }
            return Behaviors$.MODULE$.same();
        }
        return super.aroundSignal(ctx, signal, target);
    }

    @Override
    public Behavior<T> aroundReceive(TypedActorContext<Object> ctx, Object msg, BehaviorInterceptor.ReceiveTarget<T> target) {
        Behavior behavior;
        Tuple2 tuple2;
        Tuple2 tuple22;
        Object m = msg;
        Tuple2 tuple23 = this.restartingInProgress;
        Tuple2 tuple24 = (Tuple2)OptionVal$Some$.MODULE$.unapply(tuple23);
        if (!OptionVal$.MODULE$.isEmpty$extension(tuple24) && (tuple22 = (tuple2 = (Tuple2)OptionVal$.MODULE$.get$extension(tuple24))) != null) {
            Object object;
            StashBuffer stashBuffer = (StashBuffer)tuple22._1();
            if (stashBuffer.isFull()) {
                this.dropped(ctx, m);
                object = BoxedUnit.UNIT;
            } else {
                object = stashBuffer.stash(m);
            }
            return Behaviors$.MODULE$.same();
        }
        try {
            behavior = target.apply(ctx, m);
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, Behavior<T>> $4$ = this.handleReceiveException(ctx, target);
            if ($4$.isDefinedAt(ex$)) {
                behavior = (Behavior)$4$.apply(ex$);
            }
            throw ex$;
        }
        return behavior;
    }

    @Override
    public PartialFunction<Throwable, Behavior<T>> handleExceptionOnStart(TypedActorContext<Object> ctx, BehaviorInterceptor.PreStartTarget<T> target) {
        return new Serializable(ctx, this){
            private final TypedActorContext ctx$3;
            private final /* synthetic */ RestartSupervisor $outer;
            {
                this.ctx$3 = ctx$11;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable t;
                Option<Throwable> option;
                Throwable throwable2 = x;
                return throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty() && this.$outer.isInstanceOfTheThrowableClass(t = (throwable = option.get()));
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable t;
                Option<Throwable> option;
                Throwable throwable2 = x;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty() && this.$outer.isInstanceOfTheThrowableClass(t = (throwable = option.get()))) {
                    this.ctx$3.asScala().cancelAllTimers();
                    SupervisorStrategy.RestartOrBackoff restartOrBackoff = this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy;
                    if (restartOrBackoff instanceof SupervisorStrategy.Restart) {
                        if (this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy.unlimitedRestarts() || this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$restartCount + 1 >= this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy.maxRestarts() && this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$deadlineHasTimeLeft()) {
                            throw t;
                        }
                        return this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$prepareRestart(this.ctx$3, t);
                    }
                    if (restartOrBackoff instanceof SupervisorStrategy.Backoff) {
                        return this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$prepareRestart(this.ctx$3, t);
                    }
                    throw new MatchError(restartOrBackoff);
                }
                return function1.apply(x);
            }
        };
    }

    @Override
    public PartialFunction<Throwable, Behavior<T>> handleSignalException(TypedActorContext<Object> ctx, BehaviorInterceptor.SignalTarget<T> target) {
        return this.handleException(ctx, x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof UnstashException) {
                UnstashException e = (UnstashException)throwable;
                Behavior$.MODULE$.interpretSignal(e.behavior(), ctx, PreRestart$.MODULE$);
                return;
            }
            target.apply(ctx, PreRestart$.MODULE$);
        });
    }

    @Override
    public PartialFunction<Throwable, Behavior<T>> handleReceiveException(TypedActorContext<Object> ctx, BehaviorInterceptor.ReceiveTarget<T> target) {
        return this.handleException(ctx, x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof UnstashException) {
                UnstashException e = (UnstashException)throwable;
                Behavior$.MODULE$.interpretSignal(e.behavior(), ctx, PreRestart$.MODULE$);
                return;
            }
            target.signalRestart(ctx);
        });
    }

    private PartialFunction<Throwable, Behavior<T>> handleException(TypedActorContext<Object> ctx, Function1<Throwable, BoxedUnit> signalRestart) {
        return new Serializable(ctx, signalRestart, this){
            private final TypedActorContext ctx$6;
            private final Function1 signalRestart$1;
            private final /* synthetic */ RestartSupervisor $outer;
            {
                this.ctx$6 = ctx$12;
                this.signalRestart$1 = signalRestart$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable t;
                Option<Throwable> option;
                Throwable throwable2 = x;
                return throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty() && this.$outer.isInstanceOfTheThrowableClass(t = (throwable = option.get()));
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable t;
                Option<Throwable> option;
                Throwable throwable2 = x;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty() && this.$outer.isInstanceOfTheThrowableClass(t = (throwable = option.get()))) {
                    this.ctx$6.asScala().cancelAllTimers();
                    if (this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy.maxRestarts() != -1 && this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$restartCount >= this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy.maxRestarts() && this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$deadlineHasTimeLeft()) {
                        SupervisorStrategy.RestartOrBackoff restartOrBackoff = this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy;
                        if (restartOrBackoff instanceof SupervisorStrategy.Restart) {
                            throw t;
                        }
                        if (restartOrBackoff instanceof SupervisorStrategy.Backoff) {
                            this.$outer.log(this.ctx$6, t, this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$restartCount + 1);
                            return BehaviorImpl$.MODULE$.failed(t);
                        }
                        throw new MatchError(restartOrBackoff);
                    }
                    try {
                        this.signalRestart$1.apply(t);
                    }
                    catch (Throwable throwable3) {
                        Option<Throwable> option2;
                        Throwable throwable4 = throwable3;
                        if (throwable4 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                            Throwable throwable5;
                            Throwable ex = throwable5 = option2.get();
                            this.ctx$6.asScala().log().error("failure during PreRestart", ex);
                        }
                        throw throwable3;
                    }
                    return this.$outer.org$apache$pekko$actor$typed$internal$RestartSupervisor$$prepareRestart(this.ctx$6, t);
                }
                return function1.apply(x);
            }
        };
    }

    public Behavior<T> org$apache$pekko$actor$typed$internal$RestartSupervisor$$prepareRestart(TypedActorContext<Object> ctx, Throwable reason) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Tuple2 tuple23;
        SupervisorStrategy.RestartOrBackoff restartOrBackoff = this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy;
        if (restartOrBackoff instanceof SupervisorStrategy.Backoff) {
            this.log(ctx, reason, this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$restartCount + 1);
        } else if (restartOrBackoff instanceof SupervisorStrategy.Restart) {
            this.log(ctx, reason);
        } else {
            throw new MatchError(restartOrBackoff);
        }
        int currentRestartCount = this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$restartCount;
        this.updateRestartCount();
        Set<ActorRef<Nothing$>> childrenToStop = this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy.stopChildren() ? ctx.asScala().children().toSet() : Predef$.MODULE$.Set().empty();
        this.stopChildren(ctx, childrenToStop);
        int stashCapacity = this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy.stashCapacity() >= 0 ? this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy.stashCapacity() : ctx.asScala().system().settings().RestartStashCapacity();
        Tuple2 tuple24 = this.restartingInProgress;
        Tuple2 tuple25 = (Tuple2)OptionVal$Some$.MODULE$.unapply(tuple24);
        if (!OptionVal$.MODULE$.isEmpty$extension(tuple25) && (tuple23 = (tuple22 = (Tuple2)OptionVal$.MODULE$.get$extension(tuple25))) != null) {
            StashBuffer stashBuffer = (StashBuffer)tuple23._1();
            tuple2 = (Tuple2)OptionVal$Some$.MODULE$.apply(Tuple2$.MODULE$.apply(stashBuffer, childrenToStop));
        } else {
            tuple2 = (Tuple2)OptionVal$Some$.MODULE$.apply(Tuple2$.MODULE$.apply(StashBuffer$.MODULE$.apply(ctx.asScala(), stashCapacity), childrenToStop));
        }
        this.restartingInProgress = tuple2;
        SupervisorStrategy.RestartOrBackoff restartOrBackoff2 = this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy;
        if (restartOrBackoff2 instanceof SupervisorStrategy.Backoff) {
            SupervisorStrategy.Backoff backoff = (SupervisorStrategy.Backoff)restartOrBackoff2;
            FiniteDuration restartDelay = RestartSupervisor$.MODULE$.calculateDelay(currentRestartCount, backoff.minBackoff(), backoff.maxBackoff(), backoff.randomFactor());
            this.gotScheduledRestart = false;
            ctx.asScala().scheduleOnce(restartDelay, ctx.asScala().self(), RestartSupervisor$ScheduledRestart$.MODULE$.apply(this));
            return Behaviors$.MODULE$.empty();
        }
        if (restartOrBackoff2 instanceof SupervisorStrategy.Restart) {
            if (childrenToStop.isEmpty()) {
                return this.restartCompleted(ctx);
            }
            return Behaviors$.MODULE$.empty();
        }
        throw new MatchError(restartOrBackoff2);
    }

    private Behavior<T> restartCompleted(TypedActorContext<Object> ctx) {
        Behavior behavior;
        Object object;
        ctx.asScala().cancelAllTimers();
        SupervisorStrategy.RestartOrBackoff restartOrBackoff = this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy;
        if (restartOrBackoff instanceof SupervisorStrategy.Backoff) {
            SupervisorStrategy.Backoff backoff = (SupervisorStrategy.Backoff)restartOrBackoff;
            this.gotScheduledRestart = false;
            object = ctx.asScala().scheduleOnce(backoff.resetBackoffAfter(), ctx.asScala().self(), RestartSupervisor$ResetRestartCount$.MODULE$.apply(this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$restartCount, this));
        } else if (restartOrBackoff instanceof SupervisorStrategy.Restart) {
            object = BoxedUnit.UNIT;
        } else {
            throw new MatchError(restartOrBackoff);
        }
        try {
            Behavior<Object> behavior2;
            Tuple2 tuple2;
            Tuple2 tuple22;
            Behavior<Object> newBehavior = Behavior$.MODULE$.validateAsInitial(Behavior$.MODULE$.start(this.initial, ctx));
            Tuple2 tuple23 = this.restartingInProgress;
            Tuple2 tuple24 = (Tuple2)OptionVal$Some$.MODULE$.unapply(tuple23);
            if (!OptionVal$.MODULE$.isEmpty$extension(tuple24) && (tuple22 = (tuple2 = (Tuple2)OptionVal$.MODULE$.get$extension(tuple24))) != null) {
                StashBuffer stashBuffer = (StashBuffer)tuple22._1();
                Behavior behavior3 = stashBuffer.unstashAll(newBehavior.unsafeCast());
                OptionVal$.MODULE$.None();
                this.restartingInProgress = null;
                behavior2 = behavior3;
            } else {
                behavior2 = newBehavior;
            }
            Behavior<Object> nextBehavior = behavior2;
            behavior = nextBehavior.narrow();
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, Behavior<T>> $5$ = this.handleException(ctx, x$1 -> {
                Throwable throwable = x$1;
                if (throwable instanceof UnstashException) {
                    UnstashException e = (UnstashException)throwable;
                    Behavior$.MODULE$.interpretSignal(e.behavior(), ctx, PreRestart$.MODULE$);
                    return;
                }
            });
            if ($5$.isDefinedAt(ex$)) {
                behavior = (Behavior)$5$.apply(ex$);
            }
            throw ex$;
        }
        return behavior;
    }

    private void stopChildren(TypedActorContext<?> ctx, Set<ActorRef<Nothing$>> children) {
        children.foreach(child -> {
            ctx.asScala().unwatch(child);
            ctx.asScala().watch(child);
            ctx.asScala().stop(child);
        });
    }

    private void updateRestartCount() {
        SupervisorStrategy.RestartOrBackoff restartOrBackoff = this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$strategy;
        if (restartOrBackoff instanceof SupervisorStrategy.Restart) {
            SupervisorStrategy.Restart restart = (SupervisorStrategy.Restart)restartOrBackoff;
            boolean timeLeft = this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$deadlineHasTimeLeft();
            Deadline deadline = this.deadline;
            Deadline newDeadline = OptionVal$.MODULE$.isDefined$extension(deadline) && timeLeft ? this.deadline : (Deadline)OptionVal$Some$.MODULE$.apply(Deadline$.MODULE$.now().$plus(restart.withinTimeRange()));
            this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$restartCount = timeLeft ? this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$restartCount + 1 : 1;
            this.deadline = newDeadline;
            return;
        }
        if (restartOrBackoff instanceof SupervisorStrategy.Backoff) {
            ++this.org$apache$pekko$actor$typed$internal$RestartSupervisor$$restartCount;
            return;
        }
        throw new MatchError(restartOrBackoff);
    }

    public static final class ResetRestartCount
    implements Signal,
    DeadLetterSuppression,
    Product,
    Serializable {
        private final int current;
        private final RestartSupervisor owner;

        public static ResetRestartCount apply(int n, RestartSupervisor<?, ? extends Throwable> restartSupervisor) {
            return RestartSupervisor$ResetRestartCount$.MODULE$.apply(n, restartSupervisor);
        }

        public static ResetRestartCount fromProduct(Product product) {
            return RestartSupervisor$ResetRestartCount$.MODULE$.fromProduct(product);
        }

        public static ResetRestartCount unapply(ResetRestartCount resetRestartCount) {
            return RestartSupervisor$ResetRestartCount$.MODULE$.unapply(resetRestartCount);
        }

        public ResetRestartCount(int current, RestartSupervisor<?, ? extends Throwable> owner) {
            this.current = current;
            this.owner = owner;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.current());
            n = Statics.mix(n, Statics.anyHash(this.owner()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResetRestartCount)) return false;
            ResetRestartCount resetRestartCount = (ResetRestartCount)object;
            if (this.current() != resetRestartCount.current()) return false;
            RestartSupervisor<?, Throwable> restartSupervisor = this.owner();
            RestartSupervisor<?, ? extends Throwable> restartSupervisor2 = resetRestartCount.owner();
            if (restartSupervisor != null) {
                if (!restartSupervisor.equals(restartSupervisor2)) return false;
                return true;
            }
            if (restartSupervisor2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof ResetRestartCount;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "ResetRestartCount";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger(this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "current";
            }
            if (1 == n2) {
                return "owner";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public int current() {
            return this.current;
        }

        public RestartSupervisor<?, ? extends Throwable> owner() {
            return this.owner;
        }

        public ResetRestartCount copy(int current, RestartSupervisor<?, ? extends Throwable> owner) {
            return new ResetRestartCount(current, owner);
        }

        public int copy$default$1() {
            return this.current();
        }

        public RestartSupervisor<?, ? extends Throwable> copy$default$2() {
            return this.owner();
        }

        public int _1() {
            return this.current();
        }

        public RestartSupervisor<?, ? extends Throwable> _2() {
            return this.owner();
        }
    }

    public static final class ScheduledRestart
    implements Signal,
    DeadLetterSuppression,
    Product,
    Serializable {
        private final RestartSupervisor owner;

        public static ScheduledRestart apply(RestartSupervisor<?, ? extends Throwable> restartSupervisor) {
            return RestartSupervisor$ScheduledRestart$.MODULE$.apply(restartSupervisor);
        }

        public static ScheduledRestart fromProduct(Product product) {
            return RestartSupervisor$ScheduledRestart$.MODULE$.fromProduct(product);
        }

        public static ScheduledRestart unapply(ScheduledRestart scheduledRestart) {
            return RestartSupervisor$ScheduledRestart$.MODULE$.unapply(scheduledRestart);
        }

        public ScheduledRestart(RestartSupervisor<?, ? extends Throwable> owner) {
            this.owner = owner;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ScheduledRestart)) return false;
            ScheduledRestart scheduledRestart = (ScheduledRestart)object;
            RestartSupervisor<?, Throwable> restartSupervisor = this.owner();
            RestartSupervisor<?, ? extends Throwable> restartSupervisor2 = scheduledRestart.owner();
            if (restartSupervisor != null) {
                if (!restartSupervisor.equals(restartSupervisor2)) return false;
                return true;
            }
            if (restartSupervisor2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof ScheduledRestart;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "ScheduledRestart";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "owner";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public RestartSupervisor<?, ? extends Throwable> owner() {
            return this.owner;
        }

        public ScheduledRestart copy(RestartSupervisor<?, ? extends Throwable> owner) {
            return new ScheduledRestart(owner);
        }

        public RestartSupervisor<?, ? extends Throwable> copy$default$1() {
            return this.owner();
        }

        public RestartSupervisor<?, ? extends Throwable> _1() {
            return this.owner();
        }
    }
}

