/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal;

import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.BehaviorInterceptor;
import org.apache.pekko.actor.typed.LogOptions;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.internal.LogMessagesInterceptor$;
import org.apache.pekko.annotation.InternalApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import scala.MatchError;
import scala.reflect.ClassTag$;

@InternalApi
public final class LogMessagesInterceptor
extends BehaviorInterceptor<Object, Object> {
    private final LogOptions opts;
    private final Logger logger;

    public static <T> BehaviorInterceptor<T, T> apply(LogOptions logOptions) {
        return LogMessagesInterceptor$.MODULE$.apply(logOptions);
    }

    public LogMessagesInterceptor(LogOptions opts) {
        this.opts = opts;
        super(ClassTag$.MODULE$.Any());
        this.logger = opts.getLogger().orElse(LoggerFactory.getLogger(this.getClass()));
    }

    public LogOptions opts() {
        return this.opts;
    }

    @Override
    public Behavior<Object> aroundReceive(TypedActorContext<Object> ctx, Object msg, BehaviorInterceptor.ReceiveTarget<Object> target) {
        this.log(LogMessagesInterceptor$.org$apache$pekko$actor$typed$internal$LogMessagesInterceptor$$$LogMessageTemplate, msg, ctx);
        return target.apply(ctx, msg);
    }

    @Override
    public Behavior<Object> aroundSignal(TypedActorContext<Object> ctx, Signal signal, BehaviorInterceptor.SignalTarget<Object> target) {
        this.log(LogMessagesInterceptor$.org$apache$pekko$actor$typed$internal$LogMessagesInterceptor$$$LogSignalTemplate, signal, ctx);
        return target.apply(ctx, signal);
    }

    private void log(String template, Object messageOrSignal, TypedActorContext<Object> context) {
        if (this.opts().enabled()) {
            ActorPath selfPath = context.asScala().self().path();
            Level level = this.opts().level();
            Level level2 = Level.ERROR;
            Level level3 = level;
            if (!(level2 != null ? !((Object)((Object)level2)).equals((Object)level3) : level3 != null)) {
                this.logger.error(template, (Object)selfPath, messageOrSignal);
                return;
            }
            Level level4 = Level.WARN;
            Level level5 = level;
            if (!(level4 != null ? !((Object)((Object)level4)).equals((Object)level5) : level5 != null)) {
                this.logger.warn(template, (Object)selfPath, messageOrSignal);
                return;
            }
            Level level6 = Level.INFO;
            Level level7 = level;
            if (!(level6 != null ? !((Object)((Object)level6)).equals((Object)level7) : level7 != null)) {
                this.logger.info(template, (Object)selfPath, messageOrSignal);
                return;
            }
            Level level8 = Level.DEBUG;
            Level level9 = level;
            if (!(level8 != null ? !((Object)((Object)level8)).equals((Object)level9) : level9 != null)) {
                this.logger.debug(template, (Object)selfPath, messageOrSignal);
                return;
            }
            Level level10 = Level.TRACE;
            Level level11 = level;
            if (!(level10 != null ? !((Object)((Object)level10)).equals((Object)level11) : level11 != null)) {
                this.logger.trace(template, (Object)selfPath, messageOrSignal);
                return;
            }
            throw new MatchError((Object)level);
        }
    }

    @Override
    public boolean isSame(BehaviorInterceptor<Object, Object> other) {
        BehaviorInterceptor<Object, Object> behaviorInterceptor = other;
        if (behaviorInterceptor instanceof LogMessagesInterceptor) {
            LogMessagesInterceptor a = (LogMessagesInterceptor)behaviorInterceptor;
            LogOptions logOptions = a.opts();
            LogOptions logOptions2 = this.opts();
            return !(logOptions != null ? !logOptions.equals(logOptions2) : logOptions2 != null);
        }
        return false;
    }
}

