/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal;

import java.io.Serializable;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.Behavior$;
import org.apache.pekko.actor.typed.BehaviorInterceptor;
import org.apache.pekko.actor.typed.ExtensibleBehavior;
import org.apache.pekko.actor.typed.PreRestart$;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.internal.BehaviorImpl$SameBehavior$;
import org.apache.pekko.actor.typed.internal.BehaviorImpl$UnhandledBehavior$;
import org.apache.pekko.actor.typed.internal.InterceptorImpl$;
import org.apache.pekko.annotation.InternalApi;
import scala.Function0;
import scala.Function1;

@InternalApi
public final class InterceptorImpl<O, I>
extends ExtensibleBehavior<O> {
    private final BehaviorInterceptor interceptor;
    private final Behavior nestedBehavior;
    private final BehaviorInterceptor.PreStartTarget<I> preStartTarget;
    private final BehaviorInterceptor.ReceiveTarget<I> receiveTarget;
    private final BehaviorInterceptor.SignalTarget<I> signalTarget;

    public static <O, I> Behavior<O> apply(Function0<BehaviorInterceptor<O, I>> function0, Behavior<I> behavior) {
        return InterceptorImpl$.MODULE$.apply(function0, behavior);
    }

    public InterceptorImpl(BehaviorInterceptor<O, I> interceptor, Behavior<I> nestedBehavior) {
        this.interceptor = interceptor;
        this.nestedBehavior = nestedBehavior;
        this.preStartTarget = new BehaviorInterceptor.PreStartTarget<I>(this){
            private final /* synthetic */ InterceptorImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Behavior start(TypedActorContext ctx) {
                return Behavior$.MODULE$.start(this.$outer.nestedBehavior(), ctx);
            }

            public String toString() {
                return new StringBuilder(16).append("PreStartTarget(").append(this.$outer.nestedBehavior()).append(")").toString();
            }
        };
        this.receiveTarget = new BehaviorInterceptor.ReceiveTarget<I>(this){
            private final /* synthetic */ InterceptorImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Behavior apply(TypedActorContext ctx, Object msg) {
                return Behavior$.MODULE$.interpretMessage(this.$outer.nestedBehavior(), ctx, msg);
            }

            public void signalRestart(TypedActorContext ctx) {
                Behavior$.MODULE$.interpretSignal(this.$outer.nestedBehavior(), ctx, PreRestart$.MODULE$);
            }

            public String toString() {
                return new StringBuilder(15).append("ReceiveTarget(").append(this.$outer.nestedBehavior()).append(")").toString();
            }
        };
        this.signalTarget = new BehaviorInterceptor.SignalTarget<I>(this){
            private final /* synthetic */ InterceptorImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Behavior apply(TypedActorContext ctx, Signal signal) {
                return Behavior$.MODULE$.interpretSignal(this.$outer.nestedBehavior(), ctx, signal);
            }

            public String toString() {
                return new StringBuilder(14).append("SignalTarget(").append(this.$outer.nestedBehavior()).append(")").toString();
            }
        };
    }

    public BehaviorInterceptor<O, I> interceptor() {
        return this.interceptor;
    }

    public Behavior<I> nestedBehavior() {
        return this.nestedBehavior;
    }

    public Behavior<O> preStart(TypedActorContext<O> ctx) {
        Behavior<I> started = this.interceptor().aroundStart(ctx, this.preStartTarget);
        return this.deduplicate(started, ctx);
    }

    public Behavior<O> replaceNested(Behavior<I> newNested) {
        return new InterceptorImpl<O, I>(this.interceptor(), newNested);
    }

    @Override
    public Behavior<O> receive(TypedActorContext<O> ctx, O msg) {
        Class<O> interceptMessageClass = this.interceptor().interceptMessageClass();
        Behavior<I> result = interceptMessageClass != null && this.interceptor().interceptMessageClass().isAssignableFrom(msg.getClass()) ? this.interceptor().aroundReceive(ctx, msg, this.receiveTarget) : this.receiveTarget.apply(ctx, msg);
        return this.deduplicate(result, ctx);
    }

    @Override
    public Behavior<O> receiveSignal(TypedActorContext<O> ctx, Signal signal) {
        Behavior<I> interceptedResult = this.interceptor().aroundSignal(ctx, signal, this.signalTarget);
        return this.deduplicate(interceptedResult, ctx);
    }

    private Behavior<O> deduplicate(Behavior<I> interceptedResult, TypedActorContext<O> ctx) {
        Behavior<I> started;
        block5: {
            block4: {
                Behavior<I> behavior = started = Behavior$.MODULE$.start(interceptedResult, ctx);
                BehaviorImpl$UnhandledBehavior$ behaviorImpl$UnhandledBehavior$ = BehaviorImpl$UnhandledBehavior$.MODULE$;
                if (!(behavior == null ? behaviorImpl$UnhandledBehavior$ != null : !behavior.equals(behaviorImpl$UnhandledBehavior$))) break block4;
                Behavior<I> behavior2 = started;
                BehaviorImpl$SameBehavior$ behaviorImpl$SameBehavior$ = BehaviorImpl$SameBehavior$.MODULE$;
                if ((behavior2 == null ? behaviorImpl$SameBehavior$ != null : !behavior2.equals(behaviorImpl$SameBehavior$)) && Behavior$.MODULE$.isAlive(started)) break block5;
            }
            return started.unsafeCast();
        }
        boolean duplicateInterceptExists = Behavior$.MODULE$.existsInStack(started, (Function1<Behavior, boolean> & Serializable)x$1 -> {
            Behavior behavior = x$1;
            if (behavior instanceof InterceptorImpl) {
                InterceptorImpl i = (InterceptorImpl)behavior;
                if (this.interceptor().isSame(i.interceptor())) {
                    return true;
                }
            }
            return false;
        });
        if (duplicateInterceptExists) {
            return started.unsafeCast();
        }
        return new InterceptorImpl<O, I>(this.interceptor(), started);
    }

    public String toString() {
        return new StringBuilder(15).append("Interceptor(").append(this.interceptor()).append(", ").append(this.nestedBehavior()).append(")").toString();
    }
}

