/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.Extension;
import org.apache.pekko.actor.typed.ExtensionId;
import org.apache.pekko.actor.typed.ExtensionSetup;
import org.apache.pekko.actor.typed.Extensions;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@InternalApi
public interface ExtensionsImpl
extends Extensions {
    public static void $init$(ExtensionsImpl $this) {
        $this.org$apache$pekko$actor$typed$internal$ExtensionsImpl$_setter_$org$apache$pekko$actor$typed$internal$ExtensionsImpl$$extensions_$eq(new ConcurrentHashMap());
    }

    public ConcurrentHashMap<ExtensionId<?>, Object> org$apache$pekko$actor$typed$internal$ExtensionsImpl$$extensions();

    public void org$apache$pekko$actor$typed$internal$ExtensionsImpl$_setter_$org$apache$pekko$actor$typed$internal$ExtensionsImpl$$extensions_$eq(ConcurrentHashMap var1);

    public static void loadExtensions$(ExtensionsImpl $this) {
        $this.loadExtensions();
    }

    default public void loadExtensions() {
        this.loadExtensionsFor("pekko.actor.typed.library-extensions", true);
        this.loadExtensionsFor("pekko.actor.typed.extensions", false);
    }

    private void loadExtensionsFor(String key2, boolean throwOnLoadFail) {
        package$JavaConverters$.MODULE$.ListHasAsScala(((ActorSystem)((Object)this)).settings().config().getStringList(key2)).asScala().foreach((Function1<String, Object> & Serializable)extensionIdFQCN -> {
            Try<Object> idTry = ((ActorSystem)((Object)this)).dynamicAccess().getObjectFor((String)extensionIdFQCN, ClassTag$.MODULE$.apply(Object.class)).recoverWith(new Serializable((String)extensionIdFQCN, this){
                private final String extensionIdFQCN$1;
                private final /* synthetic */ ExtensionsImpl $outer;
                {
                    this.extensionIdFQCN$1 = extensionIdFQCN$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    return this.$outer.org$apache$pekko$actor$typed$internal$ExtensionsImpl$$idFromJavaSingletonAccessor(this.extensionIdFQCN$1);
                }
            });
            Try<Object> try_ = idTry;
            if (try_ instanceof Success) {
                Object t = ((Success)try_).value();
                if (t instanceof ExtensionId) {
                    ExtensionId id = (ExtensionId)t;
                    return this.registerExtension(id);
                }
                if (!throwOnLoadFail) {
                    ((ActorSystem)((Object)this)).log().error("[{}] is not an 'ExtensionId', skipping...", extensionIdFQCN);
                    return BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(26).append("[").append((String)extensionIdFQCN).append("] is not an 'ExtensionId'").toString());
            }
            if (try_ instanceof Failure) {
                Throwable problem = ((Failure)try_).exception();
                if (!throwOnLoadFail) {
                    ((ActorSystem)((Object)this)).log().error(new StringBuilder(44).append("While trying to load extension ").append((String)extensionIdFQCN).append(", skipping...").toString(), problem);
                    return BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(33).append("While trying to load extension [").append((String)extensionIdFQCN).append("]").toString(), problem);
            }
            throw new MatchError(try_);
        });
    }

    public static Try org$apache$pekko$actor$typed$internal$ExtensionsImpl$$idFromJavaSingletonAccessor$(ExtensionsImpl $this, String extensionIdFQCN) {
        return $this.org$apache$pekko$actor$typed$internal$ExtensionsImpl$$idFromJavaSingletonAccessor(extensionIdFQCN);
    }

    default public Try<ExtensionId<Extension>> org$apache$pekko$actor$typed$internal$ExtensionsImpl$$idFromJavaSingletonAccessor(String extensionIdFQCN) {
        return ((ActorSystem)((Object)this)).dynamicAccess().getClassFor(extensionIdFQCN, ClassTag$.MODULE$.apply(ExtensionId.class)).flatMap((Function1<Class, Try> & Serializable)clazz -> Try$.MODULE$.apply(() -> ExtensionsImpl.idFromJavaSingletonAccessor$$anonfun$1$$anonfun$1(clazz)));
    }

    public static boolean hasExtension$(ExtensionsImpl $this, ExtensionId ext) {
        return $this.hasExtension(ext);
    }

    @Override
    default public boolean hasExtension(ExtensionId<? extends Extension> ext) {
        return this.findExtension(ext) != null;
    }

    public static Extension extension$(ExtensionsImpl $this, ExtensionId ext) {
        return $this.extension(ext);
    }

    @Override
    default public <T extends Extension> T extension(ExtensionId<T> ext) {
        T t = this.findExtension(ext);
        if (t == null) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Trying to get non-registered extension [").append(ext).append("]").toString());
        }
        T some = t;
        return some;
    }

    public static Extension registerExtension$(ExtensionsImpl $this, ExtensionId ext) {
        return $this.registerExtension(ext);
    }

    @Override
    default public <T extends Extension> T registerExtension(ExtensionId<T> ext) {
        T t = this.findExtension(ext);
        if (t == null) {
            return this.createExtensionInstance(ext);
        }
        T existing = t;
        return existing;
    }

    private <T extends Extension> T createExtensionInstance(ExtensionId<T> ext) {
        CountDownLatch inProcessOfRegistration = new CountDownLatch(1);
        Object object = this.org$apache$pekko$actor$typed$internal$ExtensionsImpl$$extensions().putIfAbsent(ext, inProcessOfRegistration);
        if (object == null) {
            Extension extension;
            try {
                try {
                    Extension nonNull;
                    Extension instance;
                    Extension extension2 = instance = (Extension)((ActorSystem)((Object)this)).settings().setup().setups().collectFirst(new Serializable(ext, this){
                        private final ExtensionId ext$1;
                        private final /* synthetic */ ExtensionsImpl $outer;
                        {
                            this.ext$1 = ext$3;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Tuple2 x) {
                            T2 T2;
                            Tuple2 tuple2 = x;
                            if (tuple2 != null && (T2 = tuple2._2()) instanceof ExtensionSetup) {
                                ExtensionSetup extSetup = (ExtensionSetup)T2;
                                ExtensionId<T> extensionId = extSetup.extId();
                                ExtensionId extensionId2 = this.ext$1;
                                if (!(extensionId != null ? !((Object)extensionId).equals(extensionId2) : extensionId2 != null)) {
                                    return true;
                                }
                            }
                            return false;
                        }

                        public final Object applyOrElse(Tuple2 x, Function1 function1) {
                            T2 T2;
                            Tuple2 tuple2 = x;
                            if (tuple2 != null && (T2 = tuple2._2()) instanceof ExtensionSetup) {
                                ExtensionSetup extSetup = (ExtensionSetup)T2;
                                ExtensionId<T> extensionId = extSetup.extId();
                                ExtensionId extensionId2 = this.ext$1;
                                if (!(extensionId != null ? !((Object)extensionId).equals(extensionId2) : extensionId2 != null)) {
                                    return (Extension)extSetup.createExtension().apply((ActorSystem<?>)((Object)this.$outer));
                                }
                            }
                            return function1.apply(x);
                        }
                    }).getOrElse(() -> this.$anonfun$1(ext));
                    if (extension2 == null) {
                        throw new IllegalStateException(new StringBuilder(53).append("Extension instance created as 'null' for extension [").append(ext).append("]").toString());
                    }
                    Extension instance2 = nonNull = extension2;
                    this.org$apache$pekko$actor$typed$internal$ExtensionsImpl$$extensions().replace(ext, inProcessOfRegistration, instance2);
                    extension = instance2;
                }
                catch (Throwable t) {
                    this.org$apache$pekko$actor$typed$internal$ExtensionsImpl$$extensions().replace(ext, inProcessOfRegistration, t);
                    throw t;
                }
            }
            finally {
                inProcessOfRegistration.countDown();
            }
            return (T)extension;
        }
        return this.registerExtension(ext);
    }

    private <T extends Extension> T findExtension(ExtensionId<T> ext) {
        Object object;
        while ((object = this.org$apache$pekko$actor$typed$internal$ExtensionsImpl$$extensions().get(ext)) instanceof CountDownLatch) {
            CountDownLatch c = (CountDownLatch)object;
            c.await();
        }
        if (object instanceof Throwable) {
            Throwable t = (Throwable)object;
            throw t;
        }
        Object other = object;
        return (T)((Extension)other);
    }

    private static ExtensionId idFromJavaSingletonAccessor$$anonfun$1$$anonfun$1(Class clazz$1) {
        Method singletonAccessor = clazz$1.getDeclaredMethod("getInstance", new Class[0]);
        return (ExtensionId)singletonAccessor.invoke(null, new Object[0]);
    }

    private Extension $anonfun$1(ExtensionId ext$2) {
        return ext$2.createExtension((ActorSystem)((Object)this));
    }
}

