/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorRef$ActorRefOps$;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.Behavior$;
import org.apache.pekko.actor.typed.Props$;
import org.apache.pekko.actor.typed.RecipientRef;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.internal.ActorContextImpl$LoggingContext$;
import org.apache.pekko.actor.typed.internal.ActorMdc$;
import org.apache.pekko.actor.typed.internal.AdaptMessage$;
import org.apache.pekko.actor.typed.internal.AdaptWithRegisteredMessageAdapter$;
import org.apache.pekko.actor.typed.internal.LoggerClass$;
import org.apache.pekko.actor.typed.internal.TimerSchedulerCrossDslSupport;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl;
import org.apache.pekko.actor.typed.javadsl.AskPattern$;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.AskPattern$Askable$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.japi.function.Function;
import org.apache.pekko.japi.function.Function2;
import org.apache.pekko.pattern.StatusReply;
import org.apache.pekko.pattern.StatusReply$Error$;
import org.apache.pekko.pattern.StatusReply$Success$;
import org.apache.pekko.util.BoxedType$;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import org.apache.pekko.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;

@InternalApi
public interface ActorContextImpl<T>
extends org.apache.pekko.actor.typed.javadsl.ActorContext<T>,
ActorContext<T> {
    public static void $init$(ActorContextImpl $this) {
        OptionVal$.MODULE$.None();
        $this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_logging_$eq(null);
        OptionVal$.MODULE$.None();
        $this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$messageAdapterRef_$eq(null);
        $this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_messageAdapters_$eq(package$.MODULE$.Nil());
        OptionVal$.MODULE$.None();
        $this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_timer_$eq(null);
        OptionVal$.MODULE$.None();
        $this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_currentActorThread_$eq(null);
    }

    public LoggingContext org$apache$pekko$actor$typed$internal$ActorContextImpl$$_logging();

    public void org$apache$pekko$actor$typed$internal$ActorContextImpl$$_logging_$eq(LoggingContext var1);

    public ActorRef org$apache$pekko$actor$typed$internal$ActorContextImpl$$messageAdapterRef();

    public void org$apache$pekko$actor$typed$internal$ActorContextImpl$$messageAdapterRef_$eq(ActorRef var1);

    public List<Tuple2<Class<?>, Function1<Object, T>>> org$apache$pekko$actor$typed$internal$ActorContextImpl$$_messageAdapters();

    public void org$apache$pekko$actor$typed$internal$ActorContextImpl$$_messageAdapters_$eq(List<Tuple2<Class<?>, Function1<Object, T>>> var1);

    public TimerSchedulerCrossDslSupport org$apache$pekko$actor$typed$internal$ActorContextImpl$$_timer();

    public void org$apache$pekko$actor$typed$internal$ActorContextImpl$$_timer_$eq(TimerSchedulerCrossDslSupport var1);

    public Thread org$apache$pekko$actor$typed$internal$ActorContextImpl$$_currentActorThread();

    public void org$apache$pekko$actor$typed$internal$ActorContextImpl$$_currentActorThread_$eq(Thread var1);

    public static TimerSchedulerCrossDslSupport timer$(ActorContextImpl $this) {
        return $this.timer();
    }

    default public TimerSchedulerCrossDslSupport<T> timer() {
        TimerSchedulerCrossDslSupport timerSchedulerCrossDslSupport = this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_timer();
        TimerSchedulerCrossDslSupport timerSchedulerCrossDslSupport2 = (TimerSchedulerCrossDslSupport)OptionVal$Some$.MODULE$.unapply(timerSchedulerCrossDslSupport);
        if (!OptionVal$.MODULE$.isEmpty$extension(timerSchedulerCrossDslSupport2)) {
            TimerSchedulerCrossDslSupport timerSchedulerCrossDslSupport3;
            TimerSchedulerCrossDslSupport timer = timerSchedulerCrossDslSupport3 = (TimerSchedulerCrossDslSupport)OptionVal$.MODULE$.get$extension(timerSchedulerCrossDslSupport2);
            return timer;
        }
        this.checkCurrentActorThread();
        TimerSchedulerCrossDslSupport<T> timer = this.mkTimer();
        this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_timer_$eq((TimerSchedulerCrossDslSupport)OptionVal$Some$.MODULE$.apply(timer));
        return timer;
    }

    public static TimerSchedulerCrossDslSupport mkTimer$(ActorContextImpl $this) {
        return $this.mkTimer();
    }

    default public TimerSchedulerCrossDslSupport<T> mkTimer() {
        return new TimerSchedulerImpl(this);
    }

    public static boolean hasTimer$(ActorContextImpl $this) {
        return $this.hasTimer();
    }

    @Override
    default public boolean hasTimer() {
        TimerSchedulerCrossDslSupport timerSchedulerCrossDslSupport = this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_timer();
        return OptionVal$.MODULE$.isDefined$extension(timerSchedulerCrossDslSupport);
    }

    public static void cancelAllTimers$(ActorContextImpl $this) {
        $this.cancelAllTimers();
    }

    @Override
    default public void cancelAllTimers() {
        if (this.hasTimer()) {
            this.timer().cancelAll();
            return;
        }
    }

    public static org.apache.pekko.actor.typed.javadsl.ActorContext asJava$(ActorContextImpl $this) {
        return $this.asJava();
    }

    @Override
    default public org.apache.pekko.actor.typed.javadsl.ActorContext<T> asJava() {
        return this;
    }

    public static ActorContext asScala$(ActorContextImpl $this) {
        return $this.asScala();
    }

    @Override
    default public ActorContext<T> asScala() {
        return this;
    }

    public static Optional getChild$(ActorContextImpl $this, String name) {
        return $this.getChild(name);
    }

    @Override
    default public Optional<ActorRef<Void>> getChild(String name) {
        Option<ActorRef<Nothing$>> option = this.child(name);
        if (option instanceof Some) {
            ActorRef c = (ActorRef)((Some)option).value();
            return Optional.of(c.unsafeUpcast());
        }
        if (None$.MODULE$.equals(option)) {
            return Optional.empty();
        }
        throw new MatchError(option);
    }

    public static java.util.List getChildren$(ActorContextImpl $this) {
        return $this.getChildren();
    }

    @Override
    default public java.util.List<ActorRef<Void>> getChildren() {
        Iterable<ActorRef<Nothing$>> c = this.children();
        ArrayList<ActorRef<Void>> a = new ArrayList<ActorRef<Void>>(c.size());
        Iterator i = c.iterator();
        while (i.hasNext()) {
            a.add(((ActorRef)i.next()).unsafeUpcast());
        }
        return a;
    }

    public static ExecutionContextExecutor getExecutionContext$(ActorContextImpl $this) {
        return $this.getExecutionContext();
    }

    @Override
    default public ExecutionContextExecutor getExecutionContext() {
        return this.executionContext();
    }

    public static ActorRef getSelf$(ActorContextImpl $this) {
        return $this.getSelf();
    }

    @Override
    default public ActorRef<T> getSelf() {
        return this.self();
    }

    public static ActorSystem getSystem$(ActorContextImpl $this) {
        return $this.getSystem();
    }

    @Override
    default public ActorSystem<Void> getSystem() {
        return this.system();
    }

    private LoggingContext loggingContext() {
        LoggingContext loggingContext = this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_logging();
        LoggingContext loggingContext2 = (LoggingContext)OptionVal$Some$.MODULE$.unapply(loggingContext);
        if (!OptionVal$.MODULE$.isEmpty$extension(loggingContext2)) {
            LoggingContext loggingContext3;
            LoggingContext l = loggingContext3 = (LoggingContext)OptionVal$.MODULE$.get$extension(loggingContext2);
            return l;
        }
        Class<?> logClass = LoggerClass$.MODULE$.detectLoggerClassFromStack(Behavior.class, LoggerClass$.MODULE$.detectLoggerClassFromStack$default$2());
        Logger logger = LoggerFactory.getLogger(logClass.getName());
        LoggingContext l = ActorContextImpl$LoggingContext$.MODULE$.apply(logger, this.classicActorContext().props().deploy().tags(), this);
        this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_logging_$eq((LoggingContext)OptionVal$Some$.MODULE$.apply(l));
        return l;
    }

    public static Logger log$(ActorContextImpl $this) {
        return $this.log();
    }

    @Override
    default public Logger log() {
        this.checkCurrentActorThread();
        LoggingContext logging = this.loggingContext();
        ActorMdc$.MODULE$.setMdc(logging);
        return logging.logger();
    }

    public static Logger getLog$(ActorContextImpl $this) {
        return $this.getLog();
    }

    @Override
    default public Logger getLog() {
        return this.log();
    }

    public static void setLoggerName$(ActorContextImpl $this, String name) {
        $this.setLoggerName(name);
    }

    @Override
    default public void setLoggerName(String name) {
        this.checkCurrentActorThread();
        this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_logging_$eq((LoggingContext)OptionVal$Some$.MODULE$.apply(this.loggingContext().withLogger(LoggerFactory.getLogger(name))));
    }

    public static void setLoggerName$(ActorContextImpl $this, Class clazz) {
        $this.setLoggerName(clazz);
    }

    @Override
    default public void setLoggerName(Class<?> clazz) {
        this.setLoggerName(clazz.getName());
    }

    public static boolean hasCustomLoggerName$(ActorContextImpl $this) {
        return $this.hasCustomLoggerName();
    }

    default public boolean hasCustomLoggerName() {
        return this.loggingContext().hasCustomName();
    }

    public static void clearMdc$(ActorContextImpl $this) {
        $this.clearMdc();
    }

    @Override
    default public void clearMdc() {
        LoggingContext loggingContext;
        LoggingContext ctx;
        LoggingContext loggingContext2 = this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_logging();
        LoggingContext loggingContext3 = (LoggingContext)OptionVal$Some$.MODULE$.unapply(loggingContext2);
        if (!OptionVal$.MODULE$.isEmpty$extension(loggingContext3) && (ctx = (loggingContext = (LoggingContext)OptionVal$.MODULE$.get$extension(loggingContext3))).mdcUsed()) {
            ActorMdc$.MODULE$.clearMdc();
            ctx.mdcUsed_$eq(false);
            return;
        }
    }

    public static void setReceiveTimeout$(ActorContextImpl $this, Duration duration, Object msg) {
        $this.setReceiveTimeout(duration, msg);
    }

    @Override
    default public void setReceiveTimeout(Duration duration, T msg) {
        this.setReceiveTimeout(JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(duration)), msg);
    }

    public static Cancellable scheduleOnce$(ActorContextImpl $this, Duration delay, ActorRef target, Object msg) {
        return $this.scheduleOnce(delay, target, msg);
    }

    @Override
    default public <U> Cancellable scheduleOnce(Duration delay, ActorRef<U> target, U msg) {
        return this.scheduleOnce(JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(delay)), target, msg);
    }

    public static ActorRef spawn$(ActorContextImpl $this, Behavior behavior, String name) {
        return $this.spawn(behavior, name);
    }

    @Override
    default public <U> ActorRef<U> spawn(Behavior<U> behavior, String name) {
        return this.spawn(behavior, name, Props$.MODULE$.empty());
    }

    public static ActorRef spawnAnonymous$(ActorContextImpl $this, Behavior behavior) {
        return $this.spawnAnonymous(behavior);
    }

    @Override
    default public <U> ActorRef<U> spawnAnonymous(Behavior<U> behavior) {
        return this.spawnAnonymous(behavior, Props$.MODULE$.empty());
    }

    public static Behavior delegate$(ActorContextImpl $this, Behavior delegator, Object msg) {
        return $this.delegate(delegator, msg);
    }

    @Override
    default public Behavior<T> delegate(Behavior<T> delegator, T msg) {
        Behavior<T> behavior;
        Behavior<T> started = Behavior$.MODULE$.start(delegator, this);
        T t = msg;
        if (t instanceof Signal) {
            Signal signal = (Signal)t;
            behavior = Behavior$.MODULE$.interpretSignal(started, this, signal);
        } else {
            T message = t;
            behavior = Behavior$.MODULE$.interpretMessage(started, this, message);
        }
        Behavior<T> interpreted = behavior;
        int n = interpreted._tag();
        if (6 == n) {
            return started;
        }
        if (4 == n) {
            this.onUnhandled(msg);
            return started;
        }
        return interpreted;
    }

    public static void ask$(ActorContextImpl $this, RecipientRef target, Function1 createRequest, Function1 mapResponse, Timeout responseTimeout, ClassTag classTag) {
        $this.ask(target, createRequest, mapResponse, responseTimeout, classTag);
    }

    @Override
    default public <Req, Res> void ask(RecipientRef<Req> target, Function1<ActorRef<Res>, Req> createRequest, Function1<Try<Res>, T> mapResponse, Timeout responseTimeout, ClassTag<Res> classTag) {
        RecipientRef recipientRef = org.apache.pekko.actor.typed.scaladsl.AskPattern$.MODULE$.Askable(target);
        this.pipeToSelf(AskPattern$Askable$.MODULE$.ask$extension(recipientRef, createRequest, responseTimeout, this.system().scheduler()), mapResponse);
    }

    public static void askWithStatus$(ActorContextImpl $this, RecipientRef target, Function1 createRequest, Function1 mapResponse, Timeout responseTimeout, ClassTag classTag) {
        $this.askWithStatus(target, createRequest, mapResponse, responseTimeout, classTag);
    }

    @Override
    default public <Req, Res> void askWithStatus(RecipientRef<Req> target, Function1<ActorRef<StatusReply<Res>>, Req> createRequest, Function1<Try<Res>, T> mapResponse, Timeout responseTimeout, ClassTag<Res> classTag) {
        this.ask(target, createRequest, (Function1<Try, Object> & Serializable)(Try<Res> x$1) -> {
            StatusReply statusReply;
            Try try_ = x$1;
            if (try_ instanceof Success && (statusReply = (StatusReply)((Success)try_).value()) != null) {
                Option option;
                Object object;
                Object object2;
                Option<Object> option2 = StatusReply$Success$.MODULE$.unapply(statusReply);
                if (!option2.isEmpty() && (object2 = (object = option2.get())) != null && !(option = classTag.unapply(object2)).isEmpty()) {
                    Object t;
                    Object t2 = t = option.get();
                    return mapResponse.apply(Success$.MODULE$.apply(t2));
                }
                Option<Throwable> option3 = StatusReply$Error$.MODULE$.unapply(statusReply);
                if (!option3.isEmpty()) {
                    Throwable throwable;
                    Throwable why = throwable = option3.get();
                    return mapResponse.apply(Failure$.MODULE$.apply(why));
                }
            }
            if (try_ instanceof Failure) {
                Failure fail = (Failure)try_;
                return mapResponse.apply(fail);
            }
            throw new RuntimeException();
        }, responseTimeout, ClassTag$.MODULE$.apply(StatusReply.class));
    }

    public static void ask$(ActorContextImpl $this, Class resClass, RecipientRef target, Duration responseTimeout, Function createRequest, Function2 applyToResponse) {
        $this.ask(resClass, target, responseTimeout, createRequest, applyToResponse);
    }

    @Override
    default public <Req, Res> void ask(Class<Res> resClass, RecipientRef<Req> target, Duration responseTimeout, Function<ActorRef<Res>, Req> createRequest, Function2<Res, Throwable, T> applyToResponse) {
        this.pipeToSelf(AskPattern$.MODULE$.ask(target, ref -> createRequest.apply((ActorRef)ref), responseTimeout, this.system().scheduler()), applyToResponse);
    }

    public static void askWithStatus$(ActorContextImpl $this, Class resClass, RecipientRef target, Duration responseTimeout, Function createRequest, Function2 applyToResponse) {
        $this.askWithStatus(resClass, target, responseTimeout, createRequest, applyToResponse);
    }

    @Override
    default public <Req, Res> void askWithStatus(Class<Res> resClass, RecipientRef<Req> target, Duration responseTimeout, Function<ActorRef<StatusReply<Res>>, Req> createRequest, Function2<Res, Throwable, T> applyToResponse) {
        ClassTag classTag = ClassTag$.MODULE$.apply(resClass);
        this.ask(StatusReply.class, target, responseTimeout, createRequest, (Res ok, Throwable failure) -> {
            StatusReply statusReply = ok;
            if (statusReply != null) {
                Option option;
                Object object;
                Object object2;
                Option<Object> option2 = StatusReply$Success$.MODULE$.unapply(statusReply);
                if (!option2.isEmpty() && (object2 = (object = option2.get())) != null && !(option = classTag.unapply(object2)).isEmpty()) {
                    Object t;
                    Object value = t = option.get();
                    return applyToResponse.apply(value, null);
                }
                Option<Throwable> option3 = StatusReply$Error$.MODULE$.unapply(statusReply);
                if (!option3.isEmpty()) {
                    Throwable throwable;
                    Throwable why = throwable = option3.get();
                    return applyToResponse.apply(null, why);
                }
            }
            if (statusReply == null) {
                return applyToResponse.apply((Object)null, (Throwable)failure);
            }
            throw new RuntimeException();
        });
    }

    public static void pipeToSelf$(ActorContextImpl $this, Future future, Function1 mapResult) {
        $this.pipeToSelf(future, mapResult);
    }

    @Override
    default public <Value> void pipeToSelf(Future<Value> future, Function1<Try<Value>, T> mapResult) {
        future.onComplete(value -> {
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.self().unsafeUpcast());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, AdaptMessage$.MODULE$.apply(value, mapResult));
        }, ExecutionContexts$.MODULE$.parasitic());
    }

    public static void pipeToSelf$(ActorContextImpl $this, CompletionStage future, Function2 applyToResult) {
        $this.pipeToSelf(future, applyToResult);
    }

    @Override
    default public <Value> void pipeToSelf(CompletionStage<Value> future, Function2<Value, Throwable, T> applyToResult) {
        future.handle((value, ex) -> {
            this.pipeToSelf$$anonfun$2(applyToResult, value, (Throwable)ex);
            return BoxedUnit.UNIT;
        });
    }

    public static ActorRef spawnMessageAdapter$(ActorContextImpl $this, Function1 f, String name) {
        return $this.spawnMessageAdapter(f, name);
    }

    @Override
    default public <U> ActorRef<U> spawnMessageAdapter(Function1<U, T> f, String name) {
        return this.internalSpawnMessageAdapter(f, name);
    }

    public static ActorRef spawnMessageAdapter$(ActorContextImpl $this, Function1 f) {
        return $this.spawnMessageAdapter(f);
    }

    @Override
    default public <U> ActorRef<U> spawnMessageAdapter(Function1<U, T> f) {
        return this.internalSpawnMessageAdapter(f, "");
    }

    @InternalApi
    public <U> ActorRef<U> internalSpawnMessageAdapter(Function1<U, T> var1, String var2);

    public static ActorRef messageAdapter$(ActorContextImpl $this, Function1 f, ClassTag evidence$1) {
        return $this.messageAdapter(f, evidence$1);
    }

    @Override
    default public <U> ActorRef<U> messageAdapter(Function1<U, T> f, ClassTag<U> evidence$1) {
        Class<?> messageClass = Predef$.MODULE$.implicitly(evidence$1).runtimeClass();
        return this.internalMessageAdapter(messageClass, f);
    }

    public static ActorRef messageAdapter$(ActorContextImpl $this, Class messageClass, Function f) {
        return $this.messageAdapter(messageClass, f);
    }

    @Override
    default public <U> ActorRef<U> messageAdapter(Class<U> messageClass, Function<U, T> f) {
        return this.internalMessageAdapter(messageClass, (Function1<Object, Object> & Serializable)param2 -> f.apply(param2));
    }

    private <U> ActorRef<U> internalMessageAdapter(Class<U> messageClass, Function1<U, T> f) {
        ActorRef<U> actorRef;
        this.checkCurrentActorThread();
        Class<?> boxedMessageClass = BoxedType$.MODULE$.apply(messageClass);
        Tuple2<Class<?>, Function1<U, T>> tuple2 = Tuple2$.MODULE$.apply(boxedMessageClass, f);
        this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_messageAdapters_$eq(((List)this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_messageAdapters().filterNot((Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Class cls;
                Class clazz = cls = (Class)tuple2._1();
                Class clazz2 = boxedMessageClass;
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }
            throw new MatchError(tuple2);
        })).$colon$colon(tuple2));
        ActorRef actorRef2 = this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$messageAdapterRef();
        ActorRef actorRef3 = (ActorRef)OptionVal$Some$.MODULE$.unapply(actorRef2);
        if (!OptionVal$.MODULE$.isEmpty$extension(actorRef3)) {
            ActorRef<U> actorRef4;
            ActorRef<U> ref;
            actorRef = ref = (actorRef4 = (ActorRef<U>)OptionVal$.MODULE$.get$extension(actorRef3));
        } else {
            ActorRef<U> ref = this.internalSpawnMessageAdapter((Function1<Object, Object> & Serializable)msg -> AdaptWithRegisteredMessageAdapter$.MODULE$.apply(msg), "adapter");
            this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$messageAdapterRef_$eq((ActorRef)OptionVal$Some$.MODULE$.apply(ref));
            actorRef = ref;
        }
        ActorRef<U> ref = actorRef;
        return ref;
    }

    public static List messageAdapters$(ActorContextImpl $this) {
        return $this.messageAdapters();
    }

    @InternalApi
    default public List<Tuple2<Class<?>, Function1<Object, T>>> messageAdapters() {
        return this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_messageAdapters();
    }

    public static void setCurrentActorThread$(ActorContextImpl $this) {
        $this.setCurrentActorThread();
    }

    @Override
    @InternalApi
    default public void setCurrentActorThread() {
        Thread thread = this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_currentActorThread();
        Thread thread2 = (Thread)OptionVal$Some$.MODULE$.unapply(thread);
        if (!OptionVal$.MODULE$.isEmpty$extension(thread2)) {
            Thread thread3;
            Thread t = thread3 = (Thread)OptionVal$.MODULE$.get$extension(thread2);
            throw new IllegalStateException(new StringBuilder(47).append("Invalid access by thread from the outside of ").append(this.self()).append(". ").append(new StringBuilder(58).append("Current message is processed by ").append(t).append(", but also accessed from ").append(Thread.currentThread()).append(".").toString()).toString());
        }
        this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_currentActorThread_$eq((Thread)OptionVal$Some$.MODULE$.apply(Thread.currentThread()));
    }

    public static void clearCurrentActorThread$(ActorContextImpl $this) {
        $this.clearCurrentActorThread();
    }

    @Override
    @InternalApi
    default public void clearCurrentActorThread() {
        OptionVal$.MODULE$.None();
        this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_currentActorThread_$eq(null);
    }

    public static void checkCurrentActorThread$(ActorContextImpl $this) {
        $this.checkCurrentActorThread();
    }

    @Override
    @InternalApi
    default public void checkCurrentActorThread() {
        Thread callerThread = Thread.currentThread();
        Thread thread = this.org$apache$pekko$actor$typed$internal$ActorContextImpl$$_currentActorThread();
        Thread thread2 = (Thread)OptionVal$Some$.MODULE$.unapply(thread);
        if (!OptionVal$.MODULE$.isEmpty$extension(thread2)) {
            Thread thread3 = (Thread)OptionVal$.MODULE$.get$extension(thread2);
            Thread t = thread3;
            if (callerThread != t) {
                throw new UnsupportedOperationException(new StringBuilder(67).append("Unsupported access to ActorContext operation from the outside of ").append(this.self()).append(". ").append(new StringBuilder(68).append("Current message is processed by ").append(t).append(", but ActorContext was called from ").append(callerThread).append(".").toString()).toString());
            }
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder(57).append("Unsupported access to ActorContext from the outside of ").append(this.self()).append(". ").append(new StringBuilder(82).append("No message is currently processed by the actor, but ActorContext was called from ").append(callerThread).append(".").toString()).toString());
    }

    private /* synthetic */ void pipeToSelf$$anonfun$2(Function2 applyToResult$1, Object value, Throwable ex) {
        if (ex != null) {
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.self().unsafeUpcast());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, AdaptMessage$.MODULE$.apply(ex, (Function1<Throwable, Object> & Serializable)_$1 -> applyToResult$1.apply(null, _$1)));
            return;
        }
        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.self().unsafeUpcast());
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, AdaptMessage$.MODULE$.apply(value, (Function1<Object, Object> & Serializable)_$2 -> applyToResult$1.apply(_$2, null)));
    }

    public static final class LoggingContext
    implements Product,
    Serializable {
        private final Logger logger;
        private final String tagsString;
        private final String pekkoSource;
        private final String sourceActorSystem;
        private final String pekkoAddress;
        private final boolean hasCustomName;
        private boolean mdcUsed;

        public static LoggingContext apply(Logger logger, Set<String> set, ActorContextImpl<?> actorContextImpl) {
            return ActorContextImpl$LoggingContext$.MODULE$.apply(logger, set, actorContextImpl);
        }

        public static LoggingContext apply(Logger logger, String string2, String string3, String string4, String string5, boolean bl) {
            return ActorContextImpl$LoggingContext$.MODULE$.apply(logger, string2, string3, string4, string5, bl);
        }

        public static LoggingContext fromProduct(Product product) {
            return ActorContextImpl$LoggingContext$.MODULE$.fromProduct(product);
        }

        public static LoggingContext unapply(LoggingContext loggingContext) {
            return ActorContextImpl$LoggingContext$.MODULE$.unapply(loggingContext);
        }

        public LoggingContext(Logger logger, String tagsString, String pekkoSource, String sourceActorSystem, String pekkoAddress, boolean hasCustomName) {
            this.logger = logger;
            this.tagsString = tagsString;
            this.pekkoSource = pekkoSource;
            this.sourceActorSystem = sourceActorSystem;
            this.pekkoAddress = pekkoAddress;
            this.hasCustomName = hasCustomName;
            this.mdcUsed = false;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.logger()));
            n = Statics.mix(n, Statics.anyHash(this.tagsString()));
            n = Statics.mix(n, Statics.anyHash(this.pekkoSource()));
            n = Statics.mix(n, Statics.anyHash(this.sourceActorSystem()));
            n = Statics.mix(n, Statics.anyHash(this.pekkoAddress()));
            n = Statics.mix(n, this.hasCustomName() ? 1231 : 1237);
            return Statics.finalizeHash(n, 6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LoggingContext)) return false;
            LoggingContext loggingContext = (LoggingContext)object;
            if (this.hasCustomName() != loggingContext.hasCustomName()) return false;
            Logger logger = this.logger();
            Logger logger2 = loggingContext.logger();
            if (logger == null) {
                if (logger2 != null) {
                    return false;
                }
            } else if (!logger.equals(logger2)) return false;
            String string2 = this.tagsString();
            String string3 = loggingContext.tagsString();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            String string4 = this.pekkoSource();
            String string5 = loggingContext.pekkoSource();
            if (string4 == null) {
                if (string5 != null) {
                    return false;
                }
            } else if (!string4.equals(string5)) return false;
            String string6 = this.sourceActorSystem();
            String string7 = loggingContext.sourceActorSystem();
            if (string6 == null) {
                if (string7 != null) {
                    return false;
                }
            } else if (!string6.equals(string7)) return false;
            String string8 = this.pekkoAddress();
            String string9 = loggingContext.pekkoAddress();
            if (string8 == null) {
                if (string9 == null) return true;
                return false;
            } else {
                if (!string8.equals(string9)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof LoggingContext;
        }

        @Override
        public int productArity() {
            return 6;
        }

        @Override
        public String productPrefix() {
            return "LoggingContext";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return BoxesRunTime.boxToBoolean(this._6());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "logger";
                }
                case 1: {
                    return "tagsString";
                }
                case 2: {
                    return "pekkoSource";
                }
                case 3: {
                    return "sourceActorSystem";
                }
                case 4: {
                    return "pekkoAddress";
                }
                case 5: {
                    return "hasCustomName";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Logger logger() {
            return this.logger;
        }

        public String tagsString() {
            return this.tagsString;
        }

        public String pekkoSource() {
            return this.pekkoSource;
        }

        public String sourceActorSystem() {
            return this.sourceActorSystem;
        }

        public String pekkoAddress() {
            return this.pekkoAddress;
        }

        public boolean hasCustomName() {
            return this.hasCustomName;
        }

        public boolean mdcUsed() {
            return this.mdcUsed;
        }

        public void mdcUsed_$eq(boolean x$1) {
            this.mdcUsed = x$1;
        }

        public LoggingContext withLogger(Logger logger) {
            LoggingContext l = this.copy(logger, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), true);
            l.mdcUsed_$eq(this.mdcUsed());
            return l;
        }

        public LoggingContext copy(Logger logger, String tagsString, String pekkoSource, String sourceActorSystem, String pekkoAddress, boolean hasCustomName) {
            return new LoggingContext(logger, tagsString, pekkoSource, sourceActorSystem, pekkoAddress, hasCustomName);
        }

        public Logger copy$default$1() {
            return this.logger();
        }

        public String copy$default$2() {
            return this.tagsString();
        }

        public String copy$default$3() {
            return this.pekkoSource();
        }

        public String copy$default$4() {
            return this.sourceActorSystem();
        }

        public String copy$default$5() {
            return this.pekkoAddress();
        }

        public boolean copy$default$6() {
            return this.hasCustomName();
        }

        public Logger _1() {
            return this.logger();
        }

        public String _2() {
            return this.tagsString();
        }

        public String _3() {
            return this.pekkoSource();
        }

        public String _4() {
            return this.sourceActorSystem();
        }

        public String _5() {
            return this.pekkoAddress();
        }

        public boolean _6() {
            return this.hasCustomName();
        }
    }
}

